<?php
date_default_timezone_set("Africa/Lagos");

$today_date = date("Y-m-d");
$ppty = "Thrift";
$sttyu = "Active";

$countit = $db -> prepare('SELECT * FROM accounts WHERE product_type=? AND status=? AND id NOT IN (SELECT account_id FROM thrift_posted WHERE date=?)');
$countit -> bind_param('sss', $ppty, $sttyu, $today_date);
$countit -> execute();
$rcountit = $countit->get_result();

if ($rcountit->num_rows >0) {
$row_count = $rcountit->num_rows;

if ($row_count > 10000) {
    $break_limit = ceil($row_count/10000);
} else {
    $break_limit = 1;
}
for($i=0; $i<=$break_limit; $i++) {
$autr = $db -> prepare('SELECT * FROM accounts WHERE product_type=? AND status=? AND id NOT IN (SELECT account_id FROM thrift_posted WHERE date=?) ORDER BY id ASC LIMIT 10000');
$autr -> bind_param('sss', $ppty, $sttyu, $today_date);
$autr -> execute();
$rautr = $autr->get_result();


foreach($rautr as $lik):
    $tmpo_check = 0;
    
    $account_id = $lik['id'];
    $account_number = $lik['account_number'];
    $customer_id = $lik['customer_id'];
    $product_type = $lik['product_type'];
    $product = $lik['product'];
    //$opening_amount = $lik['opening_amount'];
    $plan_amount = $lik['plan_amount'];
    $cleared_balance = $lik['cleared_balance'];
    $customer_branch = $lik["secondary_branch"];
    $customer_rm = $lik["secondary_relationship_manager"];
    $cu_creation_date = date('d-m-Y', strtotime($lik['creation_date']));
    $creation_date = $lik["creation_date"];
    $account_status = $lik['status'];
    $total_debited_thrift_fee = $lik['total_debited_thrift_fee'];
    $approval_date = $lik["approval_date"];
    $currency = $lik["currency"];

   // $secondary_branch = $lik["secondary_branch"];
   // $approval_date = $lik["approval_date"];
   // $approval_date = $lik["approval_date"];
   // $approval_date = $lik["approval_date"];

   if ($total_debited_thrift_fee == "") {
       $total_debited_thrift_fee = 0;
   }

    $pod1 = $db -> prepare('SELECT fname, branch FROM customer WHERE customer_id=?');
    $pod1 -> bind_param('i', $customer_id);
    $pod1 -> execute();
    $rpod1 = $pod1->get_result();

     while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        //$customer_branch = $row1["branch"];
        $cu_character = strtoupper($customer_name[0]);
    }

    $product2 = str_replace("T","","$product");
        
    $sc = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
    $sc -> bind_param('i', $product2);
    $sc -> execute();
    $rsc = $sc->get_result();
        while($sc1 = mysqli_fetch_array($rsc) ){
            $saving_reference = $sc1['saving_reference'];
            $saving_control = $sc1['saving_control'];
            $deduct_charge_per_tenure = $sc1['deduct_charge_per_tenure'];
            $allow_premature_withdrawal = $sc1['allow_premature_withdrawal'];
            $plan_count = $sc1['plan_count'];
            $income_from_fees = $sc1['income_from_fees'];
        }

        if ($deduct_charge_per_tenure == "Yes") {
        //GET CLEARED BALANCE BY OMITTING DAYS/WEEKS/MONTHS THAT DEPOSIT DIDN'T TAKE PLACE

        $value_date = $today_date;
        $date1 = new DateTime($approval_date);
        $date2 = new DateTime($today_date);
        $total_days  = $date2->diff($date1)->format('%a');

        $amount_case = $cleared_balance / $plan_amount;

        if($total_debited_thrift_fee >0) {
            $debit_count = $total_debited_thrift_fee/$plan_amount;

            for($o=0; $o<$debit_count; $o++) {
                $total_days = $total_days - $plan_count;
            }
        } else {
            $debit_count = 0 ;
        }

            $charge_count = 0;
            $status_tr = "Approved";
            for ($i=0; $i <= $total_days; $i += $plan_count) {
                //$end_date = $approval_date + $plan_count;
                $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));

                $cdt = "Credit";
                $grec = $db -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                $grec -> bind_param('sssss', $account_number, $status_tr, $cdt, $approval_date, $end_date);
                $grec -> execute();
                $rgrec = $grec->get_result();

                while($gre_r = mysqli_fetch_array($rgrec) ){
                    $sum_amount = $gre_r['tram'];

                }
                if ($sum_amount > 0) {
                    $charge_count = $charge_count + 1;
                }

                $approval_date = $end_date;

            }

            if ($amount_case > $charge_count && $amount_case > $plan_count) {
                $charge_count = ceil($amount_case/$plan_count);
            }

            $balance_count = $charge_count - $debit_count;

        

            
            $charge_amount = $balance_count * $plan_amount;/* - $total_debited_thrift_fee;total_debited_thrift_fee was added in case its charge per tenure*/
            
            $reminder = $total_days % $plan_count;

            if($reminder == 0) {


                if ($charge_amount > 0 && $charge_amount >= $plan_amount && $charge_amount <= $cleared_balance) {
                
                //DO THE DEBIT AND UPDATE total_debited_thrift_fee
                $balance = $cleared_balance - $charge_amount;

                $withdraw_transaction_date_c = date("Y-m-d H:i:s");

                $num_c = mt_rand(100000, 999999);
                $stamp_c = date("Yhis");
                $orderId_c = $stamp_c . $num_c;
        
                $transaction_id_c = "D$cu_character" . "$orderId_c";
        
                $description_c = "Thrift Accrued Charge";
                $type_c = "Debit";
                $withdraw_comment_c = "Thrift accrued charge";

                //INSERT CHARGE AMOUNT INTO TRANSACTION TABLE
                $channel_log =4;
                $aid = 0;
                $xxx = "X";
                $w_c = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $w_c->bind_param("ssidddsssssiiiis", $transaction_id_c, $account_number, $customer_id, $cleared_balance, $balance, $charge_amount, $type_c, $description_c, $withdraw_transaction_date_c, $value_date, $withdraw_comment_c, $customer_branch, $customer_rm, $channel_log, $aid, $xxx);
                $w_c->execute();
                $last_id_c = mysqli_insert_id($db);

                $entity_id_c = "TRR$last_id_c";

                //INSERT NET AMOUNT INTO ACTIVITY TABLE
                $act_dsc_c = "Thrift Accrued Charge";
                $act_type_c = "Withdrawal";
                $w_cw = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                $w_cw->bind_param("sssiii", $act_dsc_c, $act_type_c, $entity_id_c, $aid, $customer_branch, $channel_log);
                $w_cw->execute();

                //INSERT INTO JOURNAL
                $crd_gl_c = -$charge_amount;
                $journal_date_c = $value_date;
                $journal_type_c = "Automatic";
                $journal_description_c = "Thrift accrued charge deduction from customer account";
                $jn_c = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                $jn_c->bind_param("iddiiiissss", $last_id_c, $crd_gl_c, $charge_amount, $income_from_fees, $saving_control, $aid, $customer_branch, $journal_type_c, $journal_description_c, $journal_date_c, $currency);
                $jn_c->execute();

                

                //UPDATE ACCOUNTS WITH CURRENT BALANCE
                $new_total_debited_thrift_fee = $total_debited_thrift_fee + $charge_amount;
                $pw = $db->prepare("UPDATE accounts SET cleared_balance=?, ledger_balance=?, total_debited_thrift_fee=? WHERE id=?");
                $pw->bind_param('dddi', $balance, $balance, $new_total_debited_thrift_fee, $account_id);
                $pw->execute();

                $tmpo_check = $tmpo_check + 1;
                
                    }          
                }
            
            }

            if ($tmpo_check >0) {
            $tdin = $db->prepare("INSERT INTO thrift_posted (account_id, date) VALUES (?,?)");
            $tdin->bind_param("is", $account_id, $today_date);
            $tdin->execute();
            }

        endforeach;
    }
}
