<?php

function recurCharge($db, $freq, $loan_id, $qr4, $charge_name, $triggertype, $transaction_date) {
    $aid = 0;
    $shlp = $db -> prepare("SELECT id, charge, shedule_id FROM recursive_penalty_charge WHERE frequency=? AND loan_id=? AND shedule_id NOT IN(SELECT id FROM loan_schedule WHERE settelled_principal_interest=expected_principal_interest) AND loan_id NOT IN(SELECT id FROM accounts WHERE status=?) AND id NOT IN(SELECT recursive_id FROM recursive_treated WHERE date=?) AND date_added <? ORDER BY id ASC");
    $shlp -> bind_param('sisss', $freq, $loan_id, $qr4, $today, $today);
    $shlp -> execute();
    $rshlp = $shlp->get_result();
    if($rshlp->num_rows > 0) {
        while($cgh = mysqli_fetch_array($rshlp) ){
            $rec_id = $cgh['id'];
            $charge = $cgh['charge'];
            $shedule_id = $cgh['shedule_id'];

            //DEDUCT CHARGE

            $bfb = $db -> prepare("SELECT id, product, account_number, cleared_balance, customer_id, linked_savings_account, sms_alert, email_alert, secondary_branch, secondary_relationship_manager, channel, currency FROM accounts WHERE id=?");
            $bfb->bind_param("i", $loan_id);
            $bfb -> execute();
            $rbfb = $bfb->get_result();

            while($mkz = mysqli_fetch_array($rbfb) ){
                $loan_id = $mkz['id'];
                $product = $mkz['product'];
                $account_number = $mkz['account_number'];
                $cleared_balance = $mkz['cleared_balance'];
                $customer_id = $mkz['customer_id'];
                $linked_savings_account = $mkz['linked_savings_account'];
                $sms_alert = $mkz["sms_alert"];
                $email_alert = $mkz["email_alert"];
                $customer_branch = $mkz["secondary_branch"];
                $customer_rm = $mkz['secondary_relationship_manager'];
                $customer_channel = $mkz['channel'];
                $currency = $mkz['currency'];

            }

            $trt = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
            $trt -> bind_param('i', $customer_id);
            $trt -> execute();
            $rtrt = $trt->get_result();
            
            while($tf = mysqli_fetch_assoc($rtrt) ){
                $customer_name = $tf["fname"];
                $fname = $tf["fname"];
                $mname = $tf["mname"];
                $lname = $tf["lname"];
                $cu_character = strtoupper($customer_name[0]);
            }

            $product2 = str_replace("L","","$product");
        
            $ttr = $db -> prepare("SELECT * FROM loanproduct WHERE id=?");
            $ttr -> bind_param('i', $product2);
            $ttr -> execute();
            $rttr = $ttr->get_result();
        
            while($ps = mysqli_fetch_assoc($rttr) ){
                $transactionProcessingStrategy = $ps["transactionProcessingStrategy"];
                $fund_source = $ps['fund_source'];
                $loan_portfolio = $ps['loan_portfolio'];
                $income_for_interest = $ps['income_from_recovery'];//deliberate because this is recovery, it should be income_from_interests
                $income_from_penalties = $ps['income_from_penalties'];
                $automaticallyAllocateOverpayments = $ps['automaticallyAllocateOverpayments'];
                $productGroup = $ps['productGroup'];
                $debitChargesFromLinkedSavings = $ps['debitChargesFromLinkedSavings'];
            }

            if ($debitChargesFromLinkedSavings == "Yes") {

                $lsa = $db -> prepare("SELECT * FROM accounts WHERE account_number IN (SELECT linked_savings_account FROM accounts WHERE id=?)");
                $lsa->bind_param("i", $loan_id);
                $lsa->execute();
                $rlsa = $lsa->get_result();
                while($wp = mysqli_fetch_array($rlsa) ){
                    $linked_savings_account_id = $wp["id"];
                    $linked_savings_cleared_balance = $wp["cleared_balance"];
                    $linked_savings_account = $wp["account_number"];
                    $linked_savings_account_customer_id = $wp["customer_id"];
                    $linked_savings_account_product = $wp["product"];
                }
                $linked_savings_account_product2 = str_replace("S","","$linked_savings_account_product");
        
                $sc_ln = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                $sc_ln -> bind_param('i', $linked_savings_account_product2);
                $sc_ln -> execute();
                $rsc_ln = $sc_ln->get_result();
                while($sc1_ln = mysqli_fetch_array($rsc_ln) ){
                    $linked_savings_saving_control = $sc1_ln['saving_control'];
                    $linked_savings_product_group = $sc1_ln['productGroup'];
                }
        
                if ($triggertype == "Per Transaction" && $charge >0) {
                $new_linked_savings = $linked_savings_cleared_balance - $charge;
                $num_ls = mt_rand(100000, 999999);
                $stamp_ln = date("Yhis");
                $orderId_ln = $stamp_ln . $num_ls;

                $transaction_id_ln = "D$cu_character" . "$orderId_ln";

                $description2 = "$charge_name";
                $type2 = "Debit";
                $charge_comment = "$charge_name";

                $rev = "X";
                $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $xln->bind_param("ssidddssssssiiii", $transaction_id_ln, $linked_savings_account, $linked_savings_account_customer_id, $linked_savings_cleared_balance, $new_linked_savings, $charge, $type2, $description2, $transaction_date, $today, $charge_comment, $rev, $$customer_branch, $customer_rm, $customer_channel, $aid);
                $xln->execute();
                $last_id_ln = mysqli_insert_id($db);
                $entity_id_ln = "TRR$last_id_ln";

                $crd_gl1 = -$charge;
                $journal_description = "$charge_name";
                $journal_date = $today;
                $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge, $income_from_penalties, $linked_savings_saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                $jn->execute();


                //INSERT INTO ACTIVITY TABLE
                $act_dsc = "$charge_name";
                $act_type = "Fee";
                $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $$customer_branch, $customer_channel);
                $xx->execute();

                $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                $upd_s->bind_param('ds', $new_linked_savings, $linked_savings_account);
                $upd_s->execute();
                } else {
                    //INSERT CHARGE INTO TEM CHARGES TABLE
                    if($charge>0) {
                        $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                        $inch->bind_param("sdss", $linked_savings_account, $charge, $charge_name, $triggertype);
                        $inch->execute();
                    }

                   $new_linked_savings = $linked_savings_cleared_balance;
                }

                //DO SMS INTEGRATION
                if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                    $biz_rule = "Charge Deducted";
                    $brn = $$customer_branch;
                    $rm = $customer_rm;
                    $pg = $linked_savings_product_group;
                    $account_id = $linked_savings_account_id;
                    $account_no = $linked_savings_account;
                    $vdate = $today;
                    $tdate = $transaction_date;
                    $tamount = $charge;
                    $cb = $new_linked_savings;

                    include_once("main/customer/sms_int.php");
                }
        
        } else {
                $set = $db -> prepare('SELECT penalty FROM loan_schedule WHERE id=?');
                $set -> bind_param('i', $shedule_id);
                $set -> execute();
                $rset = $set->get_result();

                while($nxz = mysqli_fetch_array($rset) ){
                    $penalty = $nxz['penalty'];
                }

                $nw_pl = $charge + $penalty;
                $uplsh = $db->prepare("UPDATE loan_schedule SET penalty=? WHERE id=?");
                $uplsh->bind_param('di', $nw_pl, $shedule_id);
                $uplsh->execute();
        }

            //INSERT INTO TREATED TABLE
            $lctt = $db->prepare("INSERT INTO recursive_treated (recursive_id, date) VALUES (?,?)");
            $lctt->bind_param("is", $rec_id, $today);
            $lctt->execute();
        }
    }
}
$shlp = $db -> prepare("SELECT * FROM recursive_penalty_charge WHERE shedule_id NOT IN(SELECT id FROM loan_schedule WHERE settlled_principal_interest=expected_principal_interest) AND loan_id NOT IN(SELECT id FROM accounts WHERE status=?) AND id NOT IN(SELECT recursive_id FROM recursive_treated WHERE date=?) AND date_added <?");
$shlp -> bind_param('sss', $qr4, $today, $today);
$shlp -> execute();
$rshlp = $shlp->get_result();

if($rshlp->num_rows > 0) {
    foreach($rshlp as $mn):

    $d1 = new DateTime($mn['date_added']);
    $d2 = new DateTime($today);
    $interval = $d1->diff($d2);
    $diff = $interval->i; //23.

    $loan_id = $mn['loan_id'];
    $charge_name = $mn['charge_name'];
    $triggertype = $mn['triggertype'];

    switch($mn['frequency']) {
        case "Daily":
            recurCharge($db, "Daily", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);

        break;

        case "Weekly":

            if($diff % 7 == 0) {
                recurCharge($db, "Weekly", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);
            }

        break;

        case "Monthly":

            if($diff % 30 == 0) {
                recurCharge($db, "Monthly", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);
            }
        break;

        case "Quarterly":

            if($diff % 90 == 0) {
                recurCharge($db, "Quarterly", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);
            }
        
        case "Biannually":

            if($diff % 180 == 0) {
                recurCharge($db, "Biannually", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);
            }
        break;

        case "Annually":

            if($diff % 360 == 0) {
                recurCharge($db, "Annually", $loan_id, $qr4, $today, $charge_name, $triggertype, $transaction_date);
            }
        break;
    }

    endforeach;
}
