<?php
$today_date = date("Y-m-d");
$value_date = date("Y-m-d", strtotime($today_date));
$repay_amount = $instruction_amount;
$withdraw_amount = $instruction_amount;
$withdraw_comment = $ins_comment;
$repay_comment = $ins_comment;
$don_id = $id;
$completed_date = $end_date;

$aid = 0;
$channel_log = 6;
$rev = "X";
$onee = 1;

if($repayment_account_type == "Own Account") {
    $repay_account = $beneficiary_loan_ins_own;
} else {
    $repay_account = $repayment_beneficiary_other;
}

$pod = $db -> prepare('SELECT * FROM accounts WHERE id=?');
$pod -> bind_param('i', $account_id);
$pod -> execute();
$rpod = $pod->get_result();

while($row = mysqli_fetch_assoc($rpod) ){
    //$account_id = $row['id'];
    $customer_id = $row['customer_id'];
    $account_number = $row['account_number'];
    $product_type = $row['product_type'];
    $product = $row['product'];
    //$opening_amount = $row['opening_amount'];
    $plan_amount = $row['plan_amount'];
    $cleared_balance = $row['cleared_balance'];
    $customer_branch = $row["secondary_branch"];
    $customer_rm = $row["secondary_relationship_manager"];
    $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
    $creation_date = $row["creation_date"];
    $approval_date = $row["approval_date"];
    $account_status = $row['status'];
    $total_debited_thrift_fee = $row['total_debited_thrift_fee'];
    $sms_alert = $row["sms_alert"];
    $email_alert = $row["email_alert"];
    $currency = $row["currency"];

}

//CHECK BRANCH STATUS
$active = "Active";
$bnst = $db -> prepare('SELECT * FROM branch WHERE id=? AND status=?');
$bnst -> bind_param('is', $customer_branch, $active);
$bnst -> execute();
$rbnst = $bnst->get_result();
if($rbnst->num_rows > 0) {
    $b_active = 1;
} else {
    $b_active = 0;
}

$pod_rp = $db -> prepare('SELECT * FROM accounts WHERE account_number=?');
$pod_rp -> bind_param('s', $repay_account);
$pod_rp -> execute();
$rpod_rp = $pod_rp->get_result();

while($row_rp = mysqli_fetch_assoc($rpod_rp) ){
    $account_id_rp = $row_rp['id'];
    $customer_id_rp = $row_rp['customer_id'];
    $account_number_rp = $row_rp['account_number'];
    $product_type_rp = $row_rp['product_type'];
    $cleared_balance_rp = $row_rp['cleared_balance'];
    $linked_savings_account_rp = $row_rp['linked_savings_account'];
    $product_rp = $row_rp['product'];
    $agreed_interest_rate_rp = $row_rp['agreed_interest_rate'];
    $customer_branch_rp = $row_rp["secondary_branch"];
    $customer_rm_rp = $row_rp["secondary_relationship_manager"];
    $cu_creation_date_rp = date('d-m-Y', strtotime($row_rp['application_date']));
    $account_status_rp = $row_rp['status'];
    $sms_alert_rp = $row_rp["sms_alert"];
    $email_alert_rp = $row_rp["email_alert"];
    $currency_rp = $row_rp['currency'];

}

//CHECK REPAYMENT BRANCH STATUS
$bnst_rp = $db -> prepare('SELECT * FROM branch WHERE id=? AND status=?');
$bnst_rp -> bind_param('is', $customer_branch_rp, $active);
$bnst_rp -> execute();
$rbnst_rp = $bnst_rp->get_result();
if($rbnst_rp->num_rows > 0) {
    $b_active_rp = 1;
} else {
    $b_active_rp = 0;
}

$product_rp2 = str_replace("L","","$product_rp");

$ttr = $db -> prepare("SELECT * FROM loanproduct WHERE id=?");
$ttr -> bind_param('i', $product_rp2);
$ttr -> execute();
$rttr = $ttr->get_result();

    while($ps = mysqli_fetch_assoc($rttr) ){
        $transactionProcessingStrategy = $ps["transactionProcessingStrategy"];
        $fund_source = $ps['fund_source'];
        $loan_portfolio = $ps['loan_portfolio'];
        $income_for_interest = $ps['income_for_interest'];
        $automaticallyAllocateOverpayments = $ps['automaticallyAllocateOverpayments'];
        $productGroup_rp = $ps['productGroup'];
        $debitChargesFromLinkedSavings = $ps['debitChargesFromLinkedSavings'];
}

//CHECK WAIVER POLICY
$active = "Active";
    

        $pty = "Loan Account";
        $tpd = $product_rp;
        $nm = "Interest Waiver";
    

   
    $crpnd = $db -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
    $crpnd->bind_param("sss", $pty, $active, $nm);
    $crpnd -> execute();
    $rcrpnd = $crpnd->get_result();
    if ($rcrpnd->num_rows > 0) {
        //$proceed = 0;
        while($jvx = mysqli_fetch_assoc($rcrpnd) ){ 
            $days_to_due= $jvx["days_to_due"];

            if(strpos($jvx['affected_products'], ' , ') !== false) {
                // explodable
                $productssarray = explode(' , ',$jvx['affected_products']);
    
              } else {
                // not explodable
                $productssarray = array($jvx['affected_products']);
    
              }

              if(strpos($jvx['channels'], ' , ') !== false) {
                // explodable
                $channelsarray = explode(' , ',$jvx['channels']);
    
              } else {
                // not explodable
                $channelsarray = array($jvx['channels']);
    
              }

              if(strpos($jvx['affected_branches'], ' , ') !== false) {
                // explodable
                $brancharray = explode(' , ',$jvx['affected_branches']);
    
              } else {
                // not explodable
                $brancharray = array($jvx['affected_branches']);
    
              }

                if (in_array($tpd, $productssarray) && in_array($channel_log, $channelsarray) && in_array($customer_branch, $brancharray)) {
                    
                   $waive = 1;
                 } else {
                     $waive = 0;
                 }
        }
    } else {
        $waive = 0;
    }

    $total_balance = round($cleared_balance_rp * -1);
    if ($waive == 1) {
        //CALCULATE WAIVE DATE
        if($days_to_due > 0) {
            $waive_date = date("Y-m-d", strtotime($value_date . "+ $days_to_due days"));
        } else {
            $waive_date = $value_date;
        }
    //SUM ALL OUTSTANDING PRINCIPAL
    $wvc = $db -> prepare("SELECT SUM(expected_principal) as p_expted FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_principal < expected_principal");
    $wvc -> bind_param('si', $account_number_rp, $customer_id_rp);
    $wvc -> execute();
    $rwvc = $wvc->get_result();
        while($wv1 = mysqli_fetch_assoc($rwvc) ){
            $p_expted = $wv1["p_expted"];
        }
    //GET DUE INTEREST
    $wvi = $db -> prepare("SELECT SUM(expected_interest) AS exp_inst FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_interest < expected_interest AND expected_date <? ORDER BY id ASC");
    $wvi -> bind_param('sis', $account_number_rp, $customer_id_rp, $waive_date);
    $wvi -> execute();
    $rwvi = $wvi->get_result();
        while($wv1 = mysqli_fetch_assoc($rwvi) ){
            $i_expted = $wv1["exp_inst"];
        }

        $t_expected_with_waiver = $p_expted + $i_expted;

        //overwrite total balance
        $total_balance = $t_expected_with_waiver;
    } else {
        $waive_date = $value_date;
    }
    

//CHECK IF PND IS SET FOR THIS ACCOUNT
$ppnd = $db -> prepare('SELECT * FROM pnd WHERE account_id=?');
$ppnd -> bind_param('i', $account_id);
$ppnd -> execute();
$rppnd = $ppnd->get_result();
if ($rppnd->num_rows > 0) {
    $is_pnd = 1;
} else {
    $is_pnd = 0;
}

//CHECK IF THERE'S LIEN FOR THIS ACCOUNT
$lln = $db -> prepare('SELECT * FROM lien WHERE account_id=?');
$lln -> bind_param('i', $account_id);
$lln -> execute();
$rlln = $lln->get_result();

if ($rlln->num_rows > 0) {
    while($jvx = mysqli_fetch_assoc($rlln) ){ 
        $lien= $jvx["amount"];
    }
} else {
    $lien = 0;
}

if($product_type == "Savings" || $product_type == "Current" || $product_type == "Float") {
    require_once("../main/customer/dorm_check.php");
} else {
    $a_dbt = 0;
    $a_cdt = 0;
    $a_ph = 0;
    $a_em = 0;
}

if($is_pnd == 1) {
    //echo "<p class='text-danger center'>Account does not currently allow debit transactions.</p>";
} else if ($b_active_rp == 0 || $b_active == 0) {
    //inactive branch found
} else if ($a_dbt == 1 && $account_status == "Dormant") {
    //echo "<p class='text-danger center'>This account is dormant and doesn't allow withdrawals.</p>";
} else if ($account_status == "Invalid" || $account_status == "Pending" || $account_status == "Closed" || $account_status == "Frozen") {
    //echo "<p class='text-danger center'>Withdrawal is not allowed for this account</p>";
} else if ($account_status_rp != "Active") {

} else if($instruction_amount > $total_balance && $automaticallyAllocateOverpayments == "No") {
    //echo "<p class='text-danger center'>Overpayment isn't allowed. Please repay the exact loan balance.</p>";
} else {

    if ($product_type == "Savings") {
        //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
        $yui = $db -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
        $yui -> bind_param('i', $account_id);
        $yui -> execute();
        $ryui = $yui->get_result();
    
        if ($ryui->num_rows > 0) {
            while($io = mysqli_fetch_array($ryui) ){
                $curr_locked = $io['curr_locked'];
        
            }
        } else {
            $curr_locked = 0;
        }
    
        $product2 = str_replace("S","","$product");
        $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $minAmount = $sc1['minAmount'];
    
            }
    
            $al_withdraw = 1;
    
        
        } else if ($product_type == "Thrift") {
    
        $product2 = str_replace("T","","$product");
            
        $sc = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $deduct_charge_per_tenure = $sc1['deduct_charge_per_tenure'];
                $allow_premature_withdrawal = $sc1['allow_premature_withdrawal'];
                $plan_count = $sc1['plan_count'];
                $productGroup = $sc1['productGroup'];
                $minAmount = $sc1['minAmount'];
            }
    
            if ($allow_premature_withdrawal == "Yes") {
            //GET CLEARED BALANCE BY OMITTING DAYS/WEEKS/MONTHS THAT DEPOSIT DIDN'T TAKE PLACE
            
            $today_date = date("Y-m-d");
            $date1 = new DateTime($approval_date);
            $date2 = new DateTime($today_date);
            $total_days  = $date2->diff($date1)->format('%a');
    
            $amount_case = $cleared_balance / $plan_amount;
    
            if($total_debited_thrift_fee >0) {
                $debit_count = $total_debited_thrift_fee/$plan_amount;
    
                for($o=0; $o<$debit_count; $o++) {
                    $total_days = $total_days - $plan_count;
                }
            } else {
                $debit_count = 0 ;
            }
    
                $charge_count = 0;
                $status_tr = "Approved";
                for ($i=0; $i < $total_days; $i += $plan_count) {
                    //$end_date = $creation_date + $plan_count;
                    $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
    
                    $cdt = "Credit";
                    $grec = $db -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                    $grec -> bind_param('sssss', $account_number, $status_tr, $cdt, $approval_date, $end_date);
                    $grec -> execute();
                    $rgrec = $grec->get_result();
    
                    while($gre_r = mysqli_fetch_array($rgrec) ){
                        $sum_amount = $gre_r['tram'];
    
                    }
                    if ($sum_amount > 0) {
                        $charge_count = $charge_count + 1;
                    }
    
                    $approval_date = $end_date;
    
                }
    
                if ($amount_case > $charge_count && $amount_case > $plan_count) {
                    $charge_count = ceil($amount_case/$plan_count);
                }
    
                $balance_count = $charge_count - $debit_count;
    
                $charge_amount_trt = $balance_count * $plan_amount;
                //$net = $cleared_balance - $charge_amount;
                $curr_locked = $charge_amount_trt;
                $al_withdraw = 1;
            } else {
                $al_withdraw = 0;
                $curr_locked = 0;
            }
    
    } else if ($product_type == "Current") {
    
        $product2 = str_replace("C","","$product");
        $sc = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $minAmount = $sc1['minAmount'];
    
            }
    
            $al_withdraw = 1;
            $curr_locked = 0;
        } else if ($product_type == "Term Deposit") {
        $product2 = str_replace("TD","","$product");
            
                $sc = $db -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                $sc -> bind_param('i', $product2);
                $sc -> execute();
                $rsc = $sc->get_result();
                    while($sc1 = mysqli_fetch_array($rsc) ){
                        $saving_reference = $sc1['saving_reference'];
                        $saving_control = $sc1['saving_control'];
                        $productGroup = $sc1['productGroup'];
                    }
                    $minAmount = 0; //SET ON PURPOSE FOR GENERAL USE
                    $curr_locked = 0;
                    $al_withdraw = 1;
    } else if ($product_type == "Float") {
    
        $product2 = str_replace("F","","$product");
        $sc = $db -> prepare('SELECT * FROM floatproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $minAmount = $sc1['minAmount'];
    
            }
    
            $al_withdraw = 1;
            $curr_locked = 0;
        } else {
        $curr_locked = 0;
        $al_withdraw = 1;
    }
    
            $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
            $pod1 -> bind_param('i', $customer_id);
            $pod1 -> execute();
            $rpod1 = $pod1->get_result();
    
            while($row1 = mysqli_fetch_assoc($rpod1) ){
            $customer_name = $row1["fname"];
            $fname = $row1["fname"];
            $mname = $row1["mname"];
            $lname = $row1["lname"];
            $cu_character = strtoupper($customer_name[0]);
        }
    
    date_default_timezone_set("Africa/Lagos");
    $withdraw_transaction_date = date("Y-m-d H:i:s");
    $transaction_date = date("Y-m-d H:i:s");
    
    $num = mt_rand(100000, 999999);
    $stamp = date("Yhis");
    $stamp_1 = date("Yhis");
    $orderId = $stamp . $num;
    
    $transaction_id = "D$cu_character" . "$orderId";
    
    $description = "Loan Repayment Standing Instruction";
    $type = "Debit";

    if($is_sms_active == 1 && $egis_transfers == 2) {

        $biz_rule = "Funds Withdrawn";
        $st_cmp = "Active";
        $trig = "Triggered";
    
        $xmxc = $db -> prepare('SELECT * FROM sms_campaign WHERE product_type=? AND business_rule=? AND status=? AND type=?');
        $xmxc -> bind_param('ssss', $product_type, $biz_rule, $st_cmp, $trig);
        $xmxc -> execute();
        $rxmxc = $xmxc->get_result();
    
    
    
    if($sms_alert =="Yes" && $rxmxc->num_rows >0) {
    
        while($xv = mysqli_fetch_array($rxmxc) ){
            $message = $xv['message'];
            $branches = explode(" , ", $xv['branches']);
            $relationship_officers = explode(" , ", $xv['relationship_officers']);
            $product_groups = explode(" , ", $xv['product_groups']);
        }
    
        if (!empty($branches)) {
    
            if (in_array($customer_branch, $branches)) {
                $brn_sms = 1;
            } else {
                $brn_sms = 0;
            }
    
        } else {
            $brn_sms = 1;
        }
        if (!empty($relationship_officers)) {
    
            if (in_array($customer_rm, $relationship_officers)) {
                $rm_sms = 1;
            } else {
                $rm_sms = 0;
            }
    
        } else {
            $rm_sms = 1;
        }
    
        if (!empty($product_groups)) {
    
            if (in_array($productGroup, $product_groups)) {
                $pg_sms = 1;
            } else {
                $pg_sms = 0;
            }
    
        } else {
            $pg_sms = 1;
        }
    
        if ($brn_sms == 1 || $rm_sms==1 || $pg_sms == 1) {
    
            $charge_sms = 1;
        } else {
            $charge_sms = 0;
        }
    
    
    } else {
        $charge_sms = 0;
    }
    
    } else {
    $charge_sms = 0;
    }
    
    //CHECK IF EMAIL ALERT IS ENABLED
    if($is_email == 1) {
    
        if($email_alert =="Yes") {
        
            $charge_email = 1;
        
            $yio = $db -> prepare('SELECT * FROM email_alert WHERE account_id=?');
            $yio -> bind_param('i', $account_id);
            $yio -> execute();
            $ryio = $yio->get_result();
            while($lk = mysqli_fetch_array($ryio) ){
                $alert_email = $lk['email'];
            }//THIS IS NOT YET READY. APPLY CHARGE ONCE IT'S READY
        } else {
            $charge_email = 0;
        }
        
        } else {
        $charge_email = 0;
        }
    
        //GET SUM OF ALL PENDING CHARGES
        $day_g = $db -> prepare('SELECT SUM(charge_amount) as chg FROM temp_charge WHERE account_number=?');
        $day_g -> bind_param('s', $account_number);
        $day_g -> execute();
        $rday_g = $day_g->get_result();
        while($ch = mysqli_fetch_assoc($rday_g) ){
            $pending_charges = $ch['chg'];
        }

        if($charge_sms == 1) {
            $charge_tl2 = "Single SMS Fee";
            //$charge_tl4 = "Email Fee";
            $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
            $incr -> bind_param('sss', $product, $charge_tl2, $yes);
            $incr -> execute();
            $rincr = $incr->get_result();

            if($rincr->num_rows > 0) {

                foreach ($rincr as $iid):
                
                $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                $de -> bind_param('i', $iid['cid']);
                $de -> execute();
                $rde = $de->get_result();
                while($dee = mysqli_fetch_array($rde) ){
                //Call Charge Amount
                $trnsss_amount = $withdraw_amount;
                $chid = $iid['cid'];
                include('../../charges.php');
                //End Call Charge Amount
                $charge_name = $dee['name'];
                $charge_option = $dee['charge_option'];
                // $triggertype = $dee['triggertype'];
                }

                if ($charge_option != "Flat") {
                    $charge_amount = $withdraw_amount * ($charge_amount/100);
                }
                    $charge_debit +=$charge_amount;
                    endforeach;

                    $total_debit = $withdraw_amount + $charge_debit + $curr_locked + $pending_charges + $lien + $minAmount;
                } else {
                    $total_debit = $withdraw_amount + $curr_locked + $pending_charges + $lien + $minAmount;
                }
        } else {
            $total_debit = $withdraw_amount + $curr_locked + $pending_charges + $lien + $minAmount;
        }

        if ($cleared_balance >= $total_debit && $al_withdraw == 1) {

            $new_amount = $cleared_balance - $withdraw_amount;
            $previous_balance = $cleared_balance;

            //UPDATE CUSTOMER ACCOUNT

            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
            $pw->execute();
            $pw->close();

            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $withdraw_amount, $type, $description, $withdraw_transaction_date, $value_date, $withdraw_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1);
            $w->execute();
            $last_id = mysqli_insert_id($db);

            $entity_id = "TRR$last_id";

            //INSERT INTO ACTIVITY TABLE
            $act_dsc = "Loan Repayment Standing Instrction withdrawal from customer account";
            $act_type = "Standing Instruction";
            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $customer_branch, $channel_log);
            $ww->execute();

            $crd_gl = -$withdraw_amount;
            $journal_date = $value_date;
            $journal_type = "Automatic";
            $journal_description = "Loan Repayment Standing Instrction withdrawal from customer account";
            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            $jn->bind_param("iddiiiissss", $last_id, $crd_gl, $withdraw_amount, $saving_reference, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
            $jn->execute();

            //DEDUCT ALL APPLICABLE CHARGES
            if($charge_sms == 1) {

                $yui = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                $yui -> bind_param('i', $account_id);
                $yui -> execute();
                $ryui = $yui->get_result();
                while($io = mysqli_fetch_array($ryui) ){
                    $alert_phone = $io['phone_no'];
                }

                //DO ALL SHORTCODE REPLACEMENTS
                $dst_account = "**".substr($account_number, -4);
                $message = str_replace("[accountNo]",$dst_account,$message);
                $message = str_replace("[fname]",$fname,$message);
                $message = str_replace("[lname]",$lname,$message);
                $message = str_replace("[mname]",$mname,$message);
                $message = str_replace("[vdate]",$value_date,$message);
                $message = str_replace("[adate]",$withdraw_transaction_date,$message);
                $message = str_replace("[amount]",number_format($withdraw_amount, 2, '.', ','),$message);
                $message = str_replace("[balance]",number_format($new_amount, 2, '.', ','),$message);
                $message = str_replace("[trbranch]",$customer_branch,$message);

                //SEND TO EGIS SERVICES FOR SENDING SMS HERE

                $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);

                $ch1 = curl_init();
                curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                curl_setopt($ch1, CURLOPT_POST, 1);
                curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);

                $headers1 = [
                'Content-Type: application/json'
                ];

                curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);

                $request1 = curl_exec ($ch1);

                curl_close ($ch1);
                if ($request1) {
                $result1 = json_decode($request1, true);
                }
                    
                $token = $result1['token'];

                $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone, 'message' => $message);

                $ch3 = curl_init();
                curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/sms.php");
                curl_setopt($ch3, CURLOPT_POST, 1);
                curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
                curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
                //Set your auth headers
                curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token
                ));

                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                $data1 = curl_exec($ch3);
                    $charge_tl2 = "Single SMS Fee";
                    //$charge_tl4 = "Email Fee";
                    $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                    $incr -> bind_param('sss', $product, $charge_tl2, $yes);
                    $incr -> execute();
                    $rincr = $incr->get_result();

                    if($rincr->num_rows > 0) {

                        foreach ($rincr as $iid):
                        
                        $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                        $de -> bind_param('i', $iid['cid']);
                        $de -> execute();
                        $rde = $de->get_result();
                        while($dee = mysqli_fetch_array($rde) ){
                        //Call Charge Amount
                        $trnsss_amount = $withdraw_amount;
                        $chid = $iid['cid'];
                        include('../../charges.php');
                        //End Call Charge Amount
                        $charge_name = $dee['name'];
                        $charge_option = $dee['charge_option'];
                        $triggertype = $dee['triggertype'];
                        $chargetype = $dee['chargetype'];
                        }

                        $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                        $set -> bind_param('ss', $product, $iid['cid']);
                        $set -> execute();
                        $rset = $set->get_result();
                        while($rrt = mysqli_fetch_array($rset) ){
                            $income_acc = $rrt['income_acc'];
                        }

                            $cb = $db -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                            $cb -> bind_param('s', $account_number);
                            $cb -> execute();
                            $rcb = $cb->get_result();
    
                            while($rbb = mysqli_fetch_assoc($rcb) ){
                            $cleared_bal = $rbb["cleared_balance"];
                            }

                        if ($charge_option != "Flat") {
                            $charge_amount = $withdraw_amount * ($charge_amount/100);
                        }
                        if ($triggertype == "Per Transaction" && $charge_amount >0) {

                            
                            //$value_date = date("Y-m-d H:i:s");
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;
    
                            $new_amount_c = $cleared_bal - $charge_amount;
    
                            $description_c = "$charge_name";
                            $type_c = "Debit";
        
                            $debit_comment = "$charge_name";
    
                            $transaction_id_c = "D$cu_character" . "$orderId";
    
                            //INSERT CHARGES INTO TRANSACTION TABLE
                            $wc = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $account_number, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                            $wc->execute();
                            $last_id_c = mysqli_insert_id($db);
    
                            $entity_id_c = "TRR$last_id_c";
    
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "$charge_name debit from customer account";
                            $act_type = "Debit";
                            $wwc = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $customer_branch, $channel_log);
                            $wwc->execute();
    
                            $crd_gl1 = -$charge_amount;
                            $journal_description = "$charge_name";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
    
                            $upd = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $upd->bind_param('ds', $new_amount_c, $account_number);
                            $upd->execute();
                            
                            } else {
                                //INSERT CHARGE INTO TEM CHARGES TABLE
                                if($charge_amount>0) {
                                $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                $inch->bind_param("sdss", $account_number, $charge_amount, $charge_name, $triggertype);
                                $inch->execute();
                                }

                                $new_amount_c = $new_amount;
                            }

                            //DO SMS INTEGRATION
                            if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                $biz_rule = "Charge Deducted";
                                $brn = $customer_branch;
                                $rm = $customer_rm;
                                $pg = $productGroup;
                                $account_id = $account_id;
                                $account_no = $account_number;
                                $vdate = $value_date;
                                $tdate = $withdraw_transaction_date;
                                $tamount = $charge_amount;
                                $cb = $new_amount_c;

                                include_once("../../main/customer/sms_int.php");
                            }
    
                            endforeach;
                        }

                    }


                    //REPAY THE LOAN HERE
                    $account_id = $account_id_rp;
                    $customer_id = $customer_id_rp;
                    $account_number = $account_number_rp;
                    $product_type = $product_type_rp;
                    $cleared_balance = $cleared_balance_rp;
                    $linked_savings_account = $linked_savings_account_rp;
                    $product = $product_rp;
                    $agreed_interest_rate = $agreed_interest_rate_rp;
                    $customer_branch = $customer_branch_rp;
                    $customer_rm = $customer_rm_rp;
                    $cu_creation_date = $cu_creation_date_rp;
                    $account_status = $account_status_rp;
                    $sms_alert = $sms_alert_rp;
                    $email_alert = $email_alert_rp;
                    $currency = $currency_rp;

                    $product2 = $product_rp2;
                    $productGroup = $productGroup_rp;


                    $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
                    $pod1 -> bind_param('i', $customer_id);
                    $pod1 -> execute();
                    $rpod1 = $pod1->get_result();

                    while($row1 = mysqli_fetch_assoc($rpod1) ){
                    $customer_name = $row1["fname"];
                    $fname = $row1["fname"];
                    $mname = $row1["mname"];
                    $lname = $row1["lname"];
                    $cu_character = strtoupper($customer_name[0]);
                    }

                    date_default_timezone_set("Africa/Lagos");
                    $repay_transaction_date = date("Y-m-d H:i:s");
                    $transaction_date = $repay_transaction_date;
                    $num = mt_rand(100000, 999999);
                    $stamp_all = date("Yhis");
                    $orderId = $stamp_all . $num;

                    $transaction_id = "R$cu_character" . "$orderId";

                    $description = "Repayment";
                    $type = "Credit";

                    $bal_credit = $repay_amount - $total_balance;
                        if($repay_amount > $total_balance && $total_balance > 0 && $bal_credit >0) {
                            
                            $sel = $db -> prepare("SELECT * FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();

                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                            
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }

                            $new_amount1 = $sav_cleared_bal + $bal_credit;
                            $previous_balance1 = $sav_cleared_bal;

                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();

                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;

                            $transaction_id1 = "C$cu_character" . "$orderId";

                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";

                            $rev = "X";
                            if($has_teller==1) { 
                            $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $x->bind_param("ssidddssssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                            $x->execute();
                            $last_id1 = mysqli_insert_id($db);

                            $dba = $tl_gl;
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddssssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $saving_reference;
                            }
                            $entity_id1 = "TRR$last_id1";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $customer_branch, $channel_log);
                            $xx->execute();

                            $crd_gl = -$bal_credit;
                            //INSERT INTO JOURNAL
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id1, $crd_gl, $bal_credit, $saving_control, $dba, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
                            
                            //UPDATE LOAN BALANCE
                            $new_amount = $cleared_balance + $total_balance;
                            $previous_balance = $cleared_balance;
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) {
                            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                            $w->execute();
                            $last_id = mysqli_insert_id($db);

                            $dba = $tl_gl;
                            } else {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                $dba = $saving_control;
                            }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                            $act_type = "Loan Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $customer_branch, $channel_log);
                            $ww->execute();

                            //INCLUDE SMS ALERT FOR OVERPAYMENT HERE IF ENABLED

                            $paing_amount = $total_balance;
                        } else if($repay_amount == $total_balance && $total_balance > 0) {

                            //UPDATE LOAN BALANCE
                            $new_amount = $cleared_balance + $total_balance;
                            $previous_balance = $cleared_balance;
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) { 
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $tl_gl;
                            } else {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $saving_reference;
                            }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                            $act_type = "Loan Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $customer_branch, $channel_log);
                            $ww->execute();
                            $paing_amount = $total_balance;
                         }
                          else if($repay_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) {

                            $sel = $db -> prepare("SELECT * FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();

                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                            
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }

                            $new_amount1 = $repay_amount + $sav_cleared_bal;
                            $previous_balance1 = $sav_cleared_bal;

                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();

                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;

                            $transaction_id1 = "C$cu_character" . "$orderId";

                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";

                            if($has_teller==1) { 
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddsssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $repay_amount, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $tl_gl;
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddsssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $repay_amount, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $saving_reference;
                            }
                            $entity_id1 = "TRR$last_id1";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $customer_branch, $channel_log);
                            $xx->execute();

                            //INSERT INTO JOURNAL
                            $crd_gl1 = -$repay_amount;
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id1, $crd_gl1, $repay_amount, $saving_control, $dba, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();

                            //INCLUDE SMS ALERT FOR OVERPAYMENT HERE IF ENABLED

                            $paing_amount = 0;
                            
                        } else if($repay_amount < $total_balance && $total_balance > 0){

                            //UPDATE CUSTOMER ACCOUNT
                            $new_amount = $cleared_balance + $repay_amount;
                            $previous_balance = $cleared_balance;

                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) { 
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $repay_amount, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $tl_gl;
                            } else {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $repay_amount, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $saving_reference;
                            }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $repay_amount for account number $account_number";
                            $act_type = "Loan Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $customer_branch, $channel_log);
                            $ww->execute();
                            
                            $paing_amount = $repay_amount;
                        }

                        //DO SMS INTEGRATION
                        $biz_rule = "Loan Repayed";
                        $brn = $customer_branch;
                        $rm = $customer_rm;
                        $pg = $productGroup;
                        $account_id = $account_id;
                        $account_no = $account_number;
                        $vdate = $value_date;
                        $tdate = $repay_transaction_date;
                        $tamount = $repay_amount;
                        $cb = $new_amount;

                        include("../../main/customer/sms_int.php");

                        if (($repay_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) || ($repay_amount > $total_balance && $total_balance > 0 && $bal_credit > 0)) {
                            if($sms_alert_r == "Yes") {
                                $yui_c = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                $yui_c -> bind_param('i', $account_id_r);
                                $yui_c -> execute();
                                $ryui_c = $yui_c->get_result();
                                while($io_c = mysqli_fetch_array($ryui_c) ){
                                    $alert_phone_r = $io_c['phone_no'];
                                }

                                if ($repay_amount > $total_balance && $total_balance == 0) {
                                    $bal_credit = $repay_amount;
                                }
                                $lonacc = substr($account_number, -4);
                                $dst_account = substr($linked_savings_account, -4);
                                $message = "Acct:**[accountNo]
                                CR:N[amount]
                                Desc:LOAN OVER PAYMENT DEPOSIT**$lonacc
                                DT:[vdate]
                                Bal:[balance]CR";
                                $message = str_replace("[accountNo]",$dst_account,$message);
                                $message = str_replace("[vdate]",$value_date,$message);
                                $message = str_replace("[adate]",$repay_transaction_date,$message);
                                $message = str_replace("[amount]",number_format($bal_credit, 2, '.', ','),$message);
                                $message = str_replace("[balance]",number_format($new_amount1, 2, '.', ','),$message);
                                $message = str_replace("[trbranch]",$customer_branch,$message);
                        
                                //SEND TO EGIS SERVICES FOR SENDING SMS HERE
                        
                                $postdata4 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone_r, 'message' => $message);
                        
                                $ch4 = curl_init();
                                curl_setopt($ch4, CURLOPT_URL,"$egis_api_root/sms.php");
                                curl_setopt($ch4, CURLOPT_POST, 1);
                                curl_setopt($ch4, CURLOPT_POSTFIELDS,json_encode($postdata4));  //Post Fields
                                curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
                                //Set your auth headers
                                curl_setopt($ch4, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $token
                                ));
                        
                                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                $data2 = curl_exec($ch4);
                        
                                //$decode2 = json_decode($data2);

                                //CHECK IF CHARGE IS CONFIGURED AND PROCESS
                                $charge_text = "Single SMS Fee";
                                $ruo = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                                $ruo -> bind_param('sss', $product_s, $charge_text, $yes);
                                $ruo -> execute();
                                $rruo = $ruo->get_result();
                                if($rruo->num_rows > 0) {

                                    while($yii = mysqli_fetch_array($rruo) ){
                                        $ch_id = $yii['cid'];
                                    }

                                    $yd = $db -> prepare('SELECT * FROM charges WHERE id=?');
                                    $yd -> bind_param('i', $ch_id);
                                    $yd -> execute();
                                    $ryd = $yd->get_result();
                                    while($ydd = mysqli_fetch_array($ryd) ){
                                    //Call Charge Amount
                                    $trnsss_amount = $bal_credit;
                                    $chid = $ch_id;
                                    include('../../charges.php');
                                    //End Call Charge Amount
                                    $charge_name_s = $ydd['name'];
                                    $charge_option_s = $ydd['charge_option'];
                                    $triggertype_s = $ydd['triggertype'];
                                    }
                                    $charge_amount_s = $charge_amount;//deliberate from charges.php
                                    if ($charge_option_s != "Flat") {
                                        $charge_amount_s = $bal_credit * ($charge_amount_s/100);
                                    }

                                    $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                    $set -> bind_param('ss', $product_s, $ch_id);
                                    $set -> execute();
                                    $rset = $set->get_result();
                                    if ($rset->num_rows > 0) {
                                        while($rrt = mysqli_fetch_array($rset) ){
                                            $income_acc_s = $rrt['income_acc'];
                                        }
                                    }

                                    ////////
                                        if ($triggertype_s == "Per Transaction") {
                                        $final_balance = $new_amount1 - $charge_amount_s;
                                        $num_ls = mt_rand(100000, 999999);
                                        $stamp_ln = date("Yhis");
                                        $orderId_ln = $stamp_ln . $num_ls;

                                        $transaction_id_ln = "D$cu_character_ben" . "$orderId_ln";

                                        $description2 = "$charge_name_s";
                                        $type2 = "Debit";
                                        $charge_comment = "$charge_name_s";

                                        $rev = "X";
                                        $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $account_id_r, $newamount1, $final_balance, $charge_amount_s, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                        $xln->execute();
                                        $last_id_ln = mysqli_insert_id($db);
                                        $entity_id_ln = "TRR$last_id_ln";

                                        $crd_gl1 = -$charge_amount_s;
                                        $journal_description = "$charge_name_s";
                                        $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                        $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount_s, $income_acc_s, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                        $jn->execute();


                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "$charge_name_s";
                                        $act_type = "Fee";
                                        $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $customer_branch, $channel_log);
                                        $xx->execute();

                                        $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                        $upd_s->bind_param('ds', $final_balance, $linked_savings_account);
                                        $upd_s->execute();
                                        } else {
                                            //INSERT CHARGE INTO TEM CHARGES TABLE
                                        $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                        $inch->bind_param("sdss", $linked_savings_account, $charge_amount_s, $charge_name_s, $triggertype_s);
                                        $inch->execute();
                                        }

                                }

                            }
                        }

                        //DEDUCT REPAYMENT CHARGES FROM LINKED SAVINGS ACCOUNT
                        //INSERT LOAN ACCOUNT CHARGES IF ANY

                        if($charge_sms == 1) {
                            //$charge_tl1 = "Repayment Fee";
                            $charge_tl2 = "Single SMS Fee";
                            //$charge_tl4 = "Email Fee";
                            $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                            $incr -> bind_param('sss', $product, $charge_tl2, $yes);
                            $incr -> execute();
                            $rincr = $incr->get_result();
                        
                         if($rincr->num_rows > 0) {
        
        
                             foreach ($rincr as $iid):
                             
                             $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                             $de -> bind_param('i', $iid['cid']);
                             $de -> execute();
                             $rde = $de->get_result();
                             while($dee = mysqli_fetch_array($rde) ){
                             $ch_id = $dee['id'];
                             //Call Charge Amount
                            $trnsss_amount = $paing_amount;
                            $chid = $ch_id;
                            include('../../charges.php');
                            //End Call Charge Amount
                             $charge_name = $dee['name'];
                             $charge_option = $dee['charge_option'];
                             $triggertype = $dee['triggertype'];
                             $chargetype = $dee['chargetype'];
                             }

                             $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                            $set -> bind_param('ss', $product, $ch_id);
                            $set -> execute();
                            $rset = $set->get_result();
                            if ($rset->num_rows > 0) {
                                while($rrt = mysqli_fetch_array($rset) ){
                                    $income_acc = $rrt['income_acc'];
                                }
                            } else {
                            $set1 = $db -> prepare('SELECT income_acc FROM income_account_map_fees_receivable WHERE product_id=? AND fee=?');
                            $set1 -> bind_param('ss', $product, $ch_id);
                            $set1 -> execute();
                            $rset1 = $set1->get_result();
                            if ($rset1->num_rows > 0) {
                                while($rtt1 = mysqli_fetch_array($rset1) ){
                                    $income_acc = $rtt1['income_acc'];
                                }
                            } else {
                                $set2 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties WHERE product_id=? AND fee=?');
                                $set2 -> bind_param('ss', $product, $ch_id);
                                $set2 -> execute();
                                $rset2 = $set2->get_result();
                                if ($rset2->num_rows > 0) {
                                    while($rtt2 = mysqli_fetch_array($rset2) ){
                                        $income_acc = $rtt2['income_acc'];
                                    }
                                } else {

                                    $set3 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_receivable WHERE product_id=? AND fee=?');
                                    $set3 -> bind_param('ss', $product, $ch_id);
                                    $set3 -> execute();
                                    $rset3 = $set3->get_result();
                                    if ($rset3->num_rows > 0) {
                                        while($rtt3 = mysqli_fetch_array($rset3) ){
                                            $income_acc = $rtt3['income_acc'];
                                        }
                                    } else {
                                        $set4 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended WHERE product_id=? AND fee=?');
                                        $set4 -> bind_param('ss', $product, $ch_id);
                                        $set4 -> execute();
                                        $rset4 = $set4->get_result();
                                        if ($rset4->num_rows > 0) {
                                            while($rtt4 = mysqli_fetch_array($rset4) ){
                                                $income_acc = $rtt4['income_acc'];
                                            }
                                        } else {
                                            $set5 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl WHERE product_id=? AND fee=?');
                                            $set5 -> bind_param('ss', $product, $ch_id);
                                            $set5 -> execute();
                                            $rset5 = $set5->get_result();
                                            if ($rset5->num_rows > 0) {
                                                while($rtt5 = mysqli_fetch_array($rset5) ){
                                                    $income_acc = $rtt5['income_acc'];
                                                }
                                            } else {
                                                $set6 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl_2 WHERE product_id=? AND fee=?');
                                                $set6 -> bind_param('ss', $product, $ch_id);
                                                $set6 -> execute();
                                                $rset6 = $set6->get_result();
                                                if ($rset6->num_rows > 0) {
                                                    while($rtt6 = mysqli_fetch_array($rset6) ){
                                                        $income_acc = $rtt6['income_acc'];
                                                    }
                                                } else {
                                                    $set7 = $db -> prepare('SELECT income_acc FROM income_account_map_suspended_fee WHERE product_id=? AND fee=?');
                                                    $set7 -> bind_param('ss', $product, $ch_id);
                                                    $set7 -> execute();
                                                    $rset7 = $set7->get_result();
                                                    if ($rset7->num_rows > 0) {
                                                        while($rtt7 = mysqli_fetch_array($rset7) ){
                                                            $income_acc = $rtt7['income_acc'];
                                                        }
                                                    } else {
                            
                                                    }
                                                }
                                            }
                                        }
            
                                    }
        
                                }
                            }
                        }

                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source = $fr['funding_source'];
                        }
        
                             if ($charge_option != "Flat") {
                                 $charge_amount = $paing_amount * ($charge_amount/100);
                             }

                             if ($debitChargesFromLinkedSavings == "Yes") {

                                //CHARGE LINKED SAVINGS ACCOUNT
                                 //FOR CHARGE DEDUCTION IF SET TO CHARGE FROM LINKED SAVINGS ACCOUNT
                                    $lsa = $db -> prepare("SELECT * FROM accounts WHERE account_number IN (SELECT linked_savings_account FROM accounts WHERE id=?)");
                                    $lsa->bind_param("i", $account_id);
                                    $lsa->execute();
                                    $rlsa = $lsa->get_result();
                                    while($wp = mysqli_fetch_array($rlsa) ){
                                        $linked_savings_account_id = $wp["id"];
                                        $linked_savings_cleared_balance = $wp["cleared_balance"];
                                        $linked_savings_account = $wp["account_number"];
                                        $linked_savings_account_customer_id = $wp["customer_id"];
                                        $linked_savings_account_product = $wp["product"];
                                    }
                                    $linked_savings_account_product2 = str_replace("S","","$linked_savings_account_product");

                                    $sc_ln = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                                    $sc_ln -> bind_param('i', $linked_savings_account_product2);
                                    $sc_ln -> execute();
                                    $rsc_ln = $sc_ln->get_result();
                                        while($sc1_ln = mysqli_fetch_array($rsc_ln) ){
                                            $linked_savings_saving_control = $sc1_ln['saving_control'];
                                            $linked_savings_product_group = $sc1_ln['productGroup'];
                                        }

                                    if ($triggertype == "Per Transaction" && $charge_amount >0) {
                                    $new_linked_savings = $linked_savings_cleared_balance - $charge_amount;
                                    $num_ls = mt_rand(100000, 999999);
                                    $stamp_ln = date("Yhis");
                                    $orderId_ln = $stamp_ln . $num_ls;

                                    $transaction_id_ln = "D$cu_character" . "$orderId_ln";

                                    $description2 = "$charge_name";
                                    $type2 = "Debit";
                                    $charge_comment = "$charge_name";

                                    $rev = "X";
                                    $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $linked_savings_account_customer_id, $linked_savings_cleared_balance, $new_linked_savings, $charge_amount, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                    $xln->execute();
                                    $last_id_ln = mysqli_insert_id($db);
                                    $entity_id_ln = "TRR$last_id_ln";

                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount, $income_acc, $linked_savings_saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();


                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "$charge_name";
                                    $act_type = "Fee";
                                    $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $customer_branch, $channel_log);
                                    $xx->execute();

                                    $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                    $upd_s->bind_param('ds', $new_linked_savings, $linked_savings_account);
                                    $upd_s->execute();
                                    } else {
                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                        if($charge_amount>0) {
                                       $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                       $inch->bind_param("sdss", $linked_savings_account, $charge_amount, $charge_name, $triggertype);
                                       $inch->execute();
                                        }

                                       $new_linked_savings = $linked_savings_cleared_balance;
                                    }

                                    //DO SMS INTEGRATION
                                    if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                        $biz_rule = "Charge Deducted";
                                        $brn = $customer_branch;
                                        $rm = $customer_rm;
                                        $pg = $linked_savings_product_group;
                                        $account_id = $linked_savings_account_id;
                                        $account_no = $linked_savings_account;
                                        $vdate = $value_date;
                                        $tdate = $transaction_date;
                                        $tamount = $charge_amount;
                                        $cb = $new_linked_savings;

                                        include_once("../../main/customer/sms_int.php");
                                    }
                            
                            } else {
                                
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id, $crd_gl1, $charge_amount, $income_acc, $funding_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();
                                             

                            }
                        endforeach;
                        }
                    }

                        $waive_amount = 0;
                        $update_principal_jornal = 0;
                        $update_interest_jornal = 0;
                        $update_principal_interest_jornal = 0;

                        $zero = 0;
                        $ggt = $db -> prepare("SELECT id FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_principal_interest != expected_principal_interest");
                        $ggt -> bind_param('si', $account_number, $customer_id);
                        $ggt -> execute();
                        $rggt = $ggt->get_result();
                        
                            foreach ($rggt as $ick):

                                $wv_amt = 0;
                                
                            $lsh = $db -> prepare("SELECT * FROM loan_schedule WHERE id=?");
                            $lsh -> bind_param('i', $ick["id"]);
                            $lsh -> execute();
                            $rlsh = $lsh->get_result();

                            while($lon = mysqli_fetch_assoc($rlsh) ){


                                $update_id = $lon["id"];
                                $expected_interest = $lon["expected_interest"];
                                $expected_principal = $lon["expected_principal"];
                                $expected_principal_interest = $lon["expected_principal_interest"];
                                $settlled_interest = $lon["settlled_interest"];
                                $settlled_principal = $lon["settlled_principal"];
                                $settlled_principal_interest = $lon["settlled_principal_interest"];
                                $due_interest = $lon["due_interest"];
                                $due_principal = $lon["due_principal"];
                                $due_principal_interest = $lon["due_principal_interest"];
                                $expected_date = $lon["expected_date"];
    
                                $sp2 = $lon["settlled_principal"];
                                $si2 = $lon["settlled_interest"];
                                $spi2 = $lon["settlled_principal_interest"];
    
                                }


                                    //APPLY TRANSACTION PROCESSING STRATEGY
                                    if ($paing_amount >0) {

                                        $principal_to_pay = $expected_principal - $settlled_principal;
                                        $interest_to_pay = $expected_interest - $settlled_interest;
                                        if ($transactionProcessingStrategy == "Penalties, Fees, Interest, Principal Order") {
                                            //
    
                                        } else if ($transactionProcessingStrategy == "Principal, Interest, Penalties, Fees  Order") {
    
                                            if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {
    
                                                $settlled_principal = $settlled_principal + $principal_to_pay;

                                                if ($due_principal >0) {
                                                    $due_principal = $due_principal - $settlled_principal;
                                                }
    
                                                $paing_amount = $paing_amount - $principal_to_pay;
                                                
                                                
                                            } else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                                    $settlled_principal = $settlled_principal + $paing_amount;
                                                    $paing_amount = $paing_amount - $paing_amount;
    
                                                    if ($due_principal >0) {
                                                        $due_principal = $due_principal - $settlled_principal;
                                                    }
                                                
                                            }
    
                                            if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                                    $settlled_interest = $settlled_interest + $interest_to_pay;
                                                    
                                                        if($waive == 1 && $expected_date > $waive_date) {
                                                            $paing_amount = $paing_amount;
                                                            $is_wave = 2;
                                                            $si2 = $si2 + $interest_to_pay;
                                                            $waive_amount = $waive_amount + $interest_to_pay;
                                                            $wv_amt = $wv_amt + $interest_to_pay;
                                                        } else {
                                                            $paing_amount = $paing_amount - $interest_to_pay;
                                                            $is_wave = NULL;
                                                        }

                                                if ($due_interest >0) {
                                                    $due_interest = $due_interest - $settlled_interest;
                                                }
                                                
                                            } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                               
                                                    $settlled_interest = $settlled_interest + $paing_amount;

                                                    if($waive == 1 && $expected_date > $waive_date) {
                                                        $paing_amount = $paing_amount;
                                                        $is_wave = 2;
                                                        $si2 = $si2 + $paing_amount;
                                                        $waive_amount = $waive_amount + $paing_amount;
                                                        $wv_amt = $wv_amt + $paing_amount;
                                                    } else {
                                                        $paing_amount = $paing_amount - $paing_amount;
                                                        $is_wave = NULL;
                                                    }

                                                    if ($due_interest >0) {
                                                        $due_interest = $due_interest - $settlled_interest;
                                                    }
                                            }
                                           // echo "$paing_amount - $settlled_principal-a</br>";
                                    
                                            } else if ($transactionProcessingStrategy == "Interest, Principal, Penalties, Fees  Order") {
                                                if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                                    $settlled_interest = $settlled_interest + $interest_to_pay;
                                                    
                                                        if($waive == 1 && $expected_date > $waive_date) {
                                                            $paing_amount = $paing_amount;
                                                            $is_wave = 2;
                                                            $si2 = $si2 + $interest_to_pay;
                                                            $waive_amount = $waive_amount + $interest_to_pay;
                                                            $wv_amt = $wv_amt + $interest_to_pay;
                                                        } else {
                                                            $paing_amount = $paing_amount - $interest_to_pay;
                                                            $is_wave = NULL;
                                                        }

                                                if ($due_interest >0) {
                                                    $due_interest = $due_interest - $settlled_interest;
                                                }
                                                
                                            } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                               
                                                    $settlled_interest = $settlled_interest + $paing_amount;

                                                    if($waive == 1 && $expected_date > $waive_date) {
                                                        $paing_amount = $paing_amount;
                                                        $is_wave = 2;
                                                        $si2 = $si2 + $paing_amount;
                                                        $waive_amount = $waive_amount + $paing_amount;
                                                        $wv_amt = $wv_amt + $paing_amount;
                                                    } else {
                                                        $paing_amount = $paing_amount - $paing_amount;
                                                        $is_wave = NULL;
                                                    }

                                                    if ($due_interest >0) {
                                                        $due_interest = $due_interest - $settlled_interest;
                                                    }
                                            }
    
                                            if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {
    
                                                $settlled_principal = $settlled_principal + $principal_to_pay;

                                                if ($due_principal >0) {
                                                    $due_principal = $due_principal - $settlled_principal;
                                                }
    
                                                $paing_amount = $paing_amount - $principal_to_pay;
                                                
                                                
                                            } else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                                    $settlled_principal = $settlled_principal + $paing_amount;
                                                    $paing_amount = $paing_amount - $paing_amount;
    
                                                    if ($due_principal >0) {
                                                        $due_principal = $due_principal - $settlled_principal;
                                                    }
                                                
                                            }

                                        }
                                          
                                          
    
                                            $settlled_principal_interest = $settlled_principal + $settlled_interest;

                                           
                                            //$due_principal_interest_act = $due_principal + $due_interest;

                                            
                                                $due_principal_interest = $due_principal + $due_interest;
                                            
    
                                            $update_principal_jornal += $settlled_principal - $sp2;
                                            $update_interest_jornal += $settlled_interest - $si2;
                                            $update_principal_interest_jornal += $settlled_principal_interest - $spi2;

                                            //echo "$paing_amount - $settlled_principal</br>";

                                            if($due_principal < 1) {
                                                $due_principal = 0;
                                            }
                                            if($due_interest < 1) {
                                                $due_interest = 0;
                                            }
                                            if($due_principal_interest < 1) {
                                                $due_principal_interest = 0;
                                            }

                                            //REMOVE ANY UNNECESSARY FRACTIONS
                                            $check_diff = $expected_principal_interest - $settlled_principal_interest;
                                           
                                            if ($check_diff <= 0.009) {
                                                $settlled_principal_interest = $expected_principal_interest;
                                                $settlled_principal = $expected_principal;
                                                $settlled_interest = $expected_interest;
                                                $due_principal_interest = 0;
                                                $due_principal= 0;
                                                $due_interest = 0;
                                            }
                
                                            
                                            $ls = $db->prepare("UPDATE loan_schedule SET settlled_principal=?, settlled_interest=?, settlled_principal_interest=?, due_principal=?, due_interest=?, due_principal_interest=?, transaction_id=?, interest_status=? WHERE id=?");
                                           // echo 'prepare error: ', $db->error, PHP_EOL;
                                            $ls->bind_param('ddddddiii', $settlled_principal, $settlled_interest, $settlled_principal_interest, $due_principal, $due_interest, $due_principal_interest, $last_id, $is_wave, $update_id);
                                            $ls->execute();


                                            $ch = $db->prepare("INSERT INTO loan_schedule_backup (schedule_id, last_paid_principal, last_paid_interest, last_paid_principal_interest, waived_interest) VALUES (?,?,?,?,?)");
                                            $ch->bind_param("idddd", $update_id, $settlled_principal, $settlled_interest, $settlled_principal_interest, $wv_amt);
                                            $ch->execute();
                                           //echo $settlled_principal;
                                        }

                        //}
                            endforeach;                  

                            if ($update_principal_jornal > 0) {

                                            $crd_gl2 = -$update_principal_jornal;
                                            $journal_date = $value_date;
                                            $journal_type = "Automatic";
                                            $journal_description = "Loan Repayment";
                                            $jn1 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                            $jn1->bind_param("iddiiiissss", $last_id, $crd_gl2, $update_principal_interest_jornal, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                            $jn1->execute();

                            }
                            if ($update_interest_jornal > 0) {
                                            $crd_gl3 = -$update_interest_jornal;
                                            $journal_date = $value_date;
                                            $journal_description = "Loan Interest";
                                            $fs = 0;
                                            $jn2 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                            $jn2->bind_param("iddiiiissss", $last_id, $crd_gl3, $fs, $income_for_interest, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                            $jn2->execute();
                            }

                            //CLOSE ACCOUNT IF BALANCE IS ZERO
                            $cld = $db -> prepare('SELECT * FROM accounts WHERE account_number=? AND customer_id=?');
                            $cld -> bind_param('si', $account_number, $customer_id);
                            $cld -> execute();
                            $rcld = $cld->get_result();

                            while($cl = mysqli_fetch_assoc($rcld) ){

                                $acc_balance = $cl['cleared_balance'];

                            }

                            if ($waive_amount > 0) {

                                $tmp_bal = $acc_balance * -1;
                                $tmp_bal2 = $tmp_bal - $waive_amount;
                                $acc_balance = $tmp_bal2 * -1;

                            }

                            if ($acc_balance *-1 < 1) {
                                $clooo = "Closed";
                                $zero = 0;
                                $io = $db->prepare("UPDATE accounts SET status=?, cleared_balance=?, closed_date=? WHERE customer_id=? AND account_number=?");
                                $io->bind_param('sdsis', $clooo, $zero, $today_date, $customer_id, $account_number);
                                $io->execute();
                                $io->close();
                                if ($io) {
                                $clo = $db->prepare("UPDATE loan_schedule SET due_principal=?, due_interest=?, due_principal_interest=? WHERE account_no=?");
                                $clo->bind_param('ddds', $zero, $zero, $zero, $account_number);
                                $clo->execute();
                                $clo->close();

                                $clo1 = $db->prepare("UPDATE loan_schedule SET settlled_principal=expected_principal, settlled_interest=expected_interest, settlled_principal_interest=expected_principal_interest WHERE account_no=? AND settlled_principal_interest<expected_principal_interest");
                                $clo1->bind_param('s', $account_number);
                                $clo1->execute();
                                $clo1->close();

                                //UPDATE LOCKED SAVINGS TO 0 IF ANY FOR THIS LOAN
    
                                $upd_sav = $db->prepare("UPDATE lock_funds SET locked_amount=? WHERE loan_id=?");
                                $upd_sav->bind_param('di', $zero, $account_id);
                                $upd_sav->execute();
                                $upd_sav->close();
                                }
                            } else {
                                $io = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                $io->bind_param('dis', $acc_balance, $customer_id, $account_number);
                                $io->execute();
                                $io->close();
                            }

                            $indon = $db->prepare("INSERT INTO instruction_processed (instruction_id, date) VALUES (?,?)");
                            $indon->bind_param("is", $don_id, $today_date);
                            $indon->execute();

                            if($indon) {
                                if($completed_date <= $today_date) {
                                    $sta = "Completed";
                
                                    $cmpi = $db->prepare("UPDATE standing_instruction SET status=? WHERE id=?");
                                    $cmpi->bind_param('ds', $sta, $don_id);
                                    $cmpi->execute();
                                    
                                }
                            }
        }
}
?>