<?php
include('../../serv/accsecu/confs/config.php');
include("access.php"); 
?>
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-capable" content="yes">
<title>Egis DFS | Groups </title>
<!-- Don't forget to update PWA version (must be same) in pwa.js & manifest.json -->
<link rel="manifest" href="_manifest.json" data-pwa-version="set_by_pwa.js">
<link href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i|Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="styles/style.css">
<link rel="stylesheet" type="text/css" href="styles/framework.css">
<link rel="stylesheet" type="text/css" href="fonts/css/fontawesome-all.min.css">    

<link rel="stylesheet" type="text/css" href="styles/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="styles/scroller.dataTables.min.css">
</head>  
    
<body class="theme-light" data-highlight="blue2">
    
<div id="page-preloader">
    <div class="loader-main"><div class="preload-spinner border-highlight"></div></div>
</div>
    
<div id="page">
	<div class="header header-fixed header-logo-app">
        <a href="#" class="header-title ultrabold back"><span class="color-highlight">Groups</a>
		<a href="#" class="header-icon header-icon-1 back"><i class="fas fa-arrow-left"></i></a>
        <a href="#" class="header-icon header-icon-3" id="reload"><span class="fa-fw select-all fas color-highlight"></span></a>
        <a href="#" class="header-icon header-icon-2" data-toggle-theme><i class="fas fa-moon"></i></a>
	</div>

        
	<div class="page-content header-clear">

        <div class="content bottom-0">
        <a href="#" id="create_success" data-menu="menu-success"></a>

                
        <div class="header-clear"></div>
        

        <div class="tab-controls tab-animated tabs-large tabs-rounded" data-tab-items="2" 
                 data-tab-active="bg-highlight">
                <a href="#" data-tab-active data-tab="tab-1">Live Groups<i class="fa fa-online"></i></a>
                <a href="#" data-tab="tab-2">Offline Groups<i class="fa fa-offline"></i></a>
            </div>
            <div class="clear bottom-15"></div>
            <div class="tab-content" id="tab-1">
                <div class="online">
                <table id="groupTb" class="display nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>Group Name</th>
								<th>Branch</th>
								<th>Relationship Manager</th>
								<th>Registration Date</th>
								<th>Min Members</th>
								<th>Max Members</th>
								<th>Meeting Day</th>
								<th>Meeting Frequency</th>
								<th>Union Address</th>
								<th>Created By</th>
								<th>View</th>
								<!--<th>Edit</th>-->
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
            </div>
            
            </div>
            <div class="tab-content" id="tab-2">
                <div class="offline">
                    <table id="offtb" class="display nowrap" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Group Name</th>
                                    <th>Address</th>
                                    <th>Meeting Day</th>
                                    <th>Meeting Frequency</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="tbody1">

                            </tbody>
                        </table>
                    
                    <a href="#" data-menu="menu-details" id="clik"></a>
                    <a href="#" data-menu="menu-group-details" id="clikm"></a>
                    <a href="#" data-menu="menu-group-update" id="cliku"></a>
                    
            </div>
            

            </div>       
                
            <div class="header-clear"></div>
            
        </div>

        <div id="menu-success" 
            class="menu menu-box-modal round-medium bg-green2-dark shadow-large" 
            data-menu-height="320" 
            data-menu-width="310" 
            data-menu-effect="menu-over">
            <h1 class="center-text top-30"><i class="fa fa-3x fa-check-circle color-white"></i></h1>
            <h3 class="center-text uppercase ultrabold top-30 color-white mess"></h3>
        </div>

        <div id="menu-group-details" 
            class="menu menu-box-modal round-medium bg-white shadow-large" 
            data-menu-height="100%" 
            data-menu-width="100%" 
            data-menu-effect="menu-over">

            <div class="header-clear"></div>

            <div class="group_response"></div>

            <a href="#" class="close-menu button button-center-medium button-s button-round-small bg-highlight color-white">Close</a>
        </div>

        <div id="menu-group-update" 
            class="menu menu-box-modal round-medium bg-white shadow-large" 
            data-menu-height="100%" 
            data-menu-width="100%" 
            data-menu-effect="menu-over">
            
            <div class="header-clear"></div>

            <div class="group_update_response"></div>

            <div class="content top-30 left-50 right-50">
                <div class="one-half">
                        <a href="#" id="submit_u" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Update</a>
                </div>
                <div class="one-half last-column">
                    <a href="#" class="close-menu button button-xs button-round-medium shadow-large bg-red2-dark button-full">Cancel</a>
                </div>
            </div>
            <div class="clear"></div>
        </div>

        <div class="menu-hider"></div>

        		
    </div>
    
    <div  id="footer-menu" class="footer-menu-1-icons">
                    <a href="#" data-menu="menu-details" class="button button-xs button-round-medium shadow-large bg-highlight color-white bold button-full">Add Group</a>
                </div>
    <div id="menu-details" class="menu menu-box-top" data-menu-height="100%" data-menu-effect="menu-over">
        <div class="boxed-text-huge top-30">
            <h3 class="center-text uppercase ultrabold top-20">Create Group</h3>
            <div class="content bottom-o">
                        <div class="input-style input-style-1 input-required">
                            
                            <span>Group Name</span>
                            <em>(required)</em>
                            <input type="text" placeholder="Enter Group Name" id="name">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            
                            <span>Address</span>
                            <em>(required)</em>
                            <input type="text" placeholder="Enter Address" id="address">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <em><i class="fa fa-angle-down"></i></em>
                            <select id="frequency">
                                <option value="">Select Meeting Frequency</option>
                                <option value="Once Every Week">Once Every Week</option>
						        <option value="Once Every Month">Once Every Month</option>
						        <option value="Once Every Year">Once Every Year</option>
                            </select>
                        </div>
                        

                        <div class="input-style input-style-1 input-required">
                            <span>Registration Date</span>
                            <em><i class="fa fa-angle-down"></i></em>
                            <input type="date" value="<?php echo date('Y-m-d'); ?>" id="reg_date">
                        </div>

                        <div class="input-style input-style-1 input-required">
                        <em><i class="fa fa-angle-down"></i></em>
                        <select id="meeting_day">
                        <option value="">Select Meeting Day</option>

                        <?php
                        $qb = $db -> prepare('SELECT * FROM workdays');
                        $qb->execute();
                        $retw = $qb->get_result();
                        ?>
                        <?php
                        while($rog = mysqli_fetch_array($retw) ){
                            //$bid = $rog['id'];
                            $mon = $rog['mon'];
                            $tue = $rog['tue'];
                            $wed = $rog['wed'];
                            $thu = $rog['thu'];
                            $fri = $rog['fri'];
                            $sat = $rog['sat'];
                            $sun = $rog['sun'];

                            if($mon ==2) {
                            
                        ?>
                            <option value="Monday">Monday</option>
                        <?php 
                            }
                        if($tue ==2) {					
                        ?>
                        <option value="Tuesday">Tuesday</option>
                        <?php 
                        }
                        if($wed ==2) {					
                            ?>
                                <option value="Wednesday">Wednesday</option>
                            <?php 
                                }
                        if($thu ==2) {					
                            ?>
                                <option value="Thursday">Thursday</option>
                            <?php 
                                }
                        if($fri ==2) {					
                            ?>
                                <option value="Friday">Friday</option>
                            <?php 
                                }

                        if($sat ==2) {					
                            ?>
                                <option value="Saturday">Saturday</option>
                            <?php 
                                }
                        if($sun ==2) {					
                            ?>
                                <option value="Sunday">Sunday</option>
                            <?php 
                                }
                            
                        } ?>
                        </div>

                        

            </div>
            <input type="hidden" id="i">


            <div class="content top-30 left-50 right-50">
                <div class="one-half">
                    <div id="sub1">
                        <a href="#" id="submit" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Create</a>
                    </div>
                    <div id="sub2" style="display:none">
                        <a href="#" id="submit_offline_g" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Update</a>
                    </div>
                </div>
                <div class="one-half last-column">
                    <a href="#" class="close-menu button button-xs button-round-medium shadow-large bg-red2-dark button-full">Cancel</a>
                </div>
            </div>
            <div class="clear"></div>
        </div>
    </div>

</div>

<!-- Keep these outside the div id page on the first page -->
<!-- your users land on, and it will appear on all pages -->



<script type="text/javascript" src="scripts/jquery.js"></script>
<script type="text/javascript" src="scripts/plugins.js"></script>
<script type="text/javascript" src="scripts/custom.js"></script>

<script type="text/javascript" src="scripts/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="scripts/dataTables.scroller.min.js"></script>
<script src="localForage-1.10.0/dist/localforage.js"></script>
<script>

$(document).ready(function() {
  var dataTable =  $('#groupTb').DataTable( {
        ajax:           "group/data_groups",
        scrollY: 350,
        scrollX: true,
        scrollCollapse: true,
        scroller:       true,
        initComplete: function () {
            this.api().row( 1000 ).scrollTo();
        }
    });

    var offlineTB =  $('#offtb').DataTable( {
        scrollY: 350,
        scrollX: true,
        scrollCollapse: true,
        scroller:       true,
        initComplete: function () {
            this.api().row( 1000 ).scrollTo();
        }
    });


    $("#groupTb").on('click', '.viewm', function(){
		var grid = $(this).attr("id");		
		var action = "groupView";
		//if(confirm("Are you sure you want to delete this group?")) {
			$.ajax({
				url:"group/action_gpdetails.php",
				method:"POST",
				data:{grid:grid, action:action},
				success:function(data) {					
					//alert("Group Successfully Deleted");
					//window.location.reload(true);
                    $("#clikm").click();
                    $(".group_response").html(data);
                    $(".footer-menu-1-icons").hide();
				}
			})
		//} else {
		//	return false;
		//}
	});
/*
    $("#groupTb").on('click', '.edit', function(){
		var grid1 = $(this).attr("id");		
		var action1 = "groupUPView";
		//if(confirm("Are you sure you want to delete this group?")) {
			$.ajax({
				url:"group/action_gpdetails.php",
				method:"POST",
				data:{grid:grid1, action:action1},
				success:function(data) {					
					//alert("Group Successfully Deleted");
					//window.location.reload(true);
                    document.getElementById("cliku").click();
                    $(".group_update_response").html(data);
                    $(".footer-menu-1-icons").hide();
				}
			})
		//} else {
		//	return false;
		//}
	});	
*/
});

let updateKey;

const groupTable = localforage.createInstance({
name: "fieldCollectionDSF",
storeName: "groupTable"
});

var online = window.navigator.onLine;
    if (navigator.onLine) {
    $(".online").show();
    $(".offline").hide();

    } else {
        //$(".online").hide();
        $(".offline").show();
        //GET ALL GROUPS FROM LOCAL STORE AND DISPLAY

    }


                const groupDetails = () => {
                const groupName = document.getElementById("name").value;
                const groupNameKey= groupName.replaceAll(' ', '_');
                const groupAddress = document.getElementById("address").value;
                const meeting_day = document.getElementById("meeting_day").value;
                const meeting_frequency = document.getElementById("frequency").value;
                const reg_date = document.getElementById("reg_date").value;
                
                //const picture = document.getElementById("picture");
                //var prev = picture.files[0];

                var min = 100000000;
                var max = 900000000;
                const group_offline_no = Math.floor(Math.random() * min) + max;

                return {
                    groupName: groupNameKey,
                    groupAddress: groupAddress,
                    meeting_day: meeting_day,
                    meeting_frequency: meeting_frequency,
                    group_offline_no: group_offline_no,
                    reg_date: reg_date,
                    
                    //picture: prev,
                }
            }

            const addInput = async () => {
            const inputValues = groupDetails();
            const dbLength = await groupTable.length();
            let id = dbLength === 0 ? 1 : dbLength + 1;
            try{
        let row = `<tr id="${id}">
                        <td>${inputValues.groupName}</td>
                        <td>${inputValues.groupAddress}</td>
                        <td>${inputValues.meeting_day}</td>
                        <td>${inputValues.meeting_frequency}</td>
                        <td>${inputValues.reg_date}</td>
                        
                        <td><button class="delete"><i class="fa fa-trash fa-2x"></i></button></td>
                    </tr>`
        document.querySelector('.tbody1').insertAdjacentHTML('afterbegin', row);
        await groupTable.setItem(id, inputValues);
        $(".mess").html("Group Added</br> Successfully");
        $("#create_success").click();
        setTimeout(function(){
            window.location.reload(true);
        },3000);
    }catch(e){
                console.log(err.message);
            }
        }


        //LOAD GROUPS FROM STORAGE
const loadGroupFromStorage = async () => {
    try {
        await groupTable.iterate((value, key, iterationNumber) => {
            
            let newGroup = `<tr id="${key}">
                                <td>${value.groupName}</td>
                                <td>${value.groupAddress}</td>
                                <td>${value.meeting_day}</td>
                                <td>${value.meeting_frequency}</td>
                                <td>${value.reg_date}</td>
                                <td><button type="button" class="delete" id="${key}"><i class="fa fa-trash fa-2x"></i></button></td>
                           </tr>`
            document.querySelector('.tbody1').insertAdjacentHTML('afterbegin', newGroup);
            if (navigator.onLine) {
                    var action = "Offline";
                    $.ajax({
                    url:"group/postgroup",
                    method:"POST",
                    dataType:"json",
                    data:{"name": value.groupName, "address": value.groupAddress, "md": value.meeting_day, "fq": value.meeting_frequency, "gtn": value.group_offline_no, "action": action, "reg_date": value.reg_date},
                    success:function(data){								
                        if(data == 1) {     
                        groupTable.removeItem(key);
                        //dataTable.ajax.reload();
                            }                                
                        }
                    })
                }
        })
    } catch (err) {
        console.log(err)
    }

}
/*
window.addEventListener('load', async() => {
    await loadGroupFromStorage();
})*/

//DELETE GROUP FROM STORAGE
const deleteGroup = async(e) => {
    const row = e.target.parentElement;
    const key = row.id;
    //var key = $(e).attr("id");
    //var key = document.getElementsByClassName("delete")[0].id;
    if(confirm("Are you sure you want to delete this?")) {
        row.remove();
        try{
            await groupTable.removeItem(key);
            //alert('Group deleted successfully');
            $(".mess").html("Group Deleted</br> Successfully");
            $("#create_success").click();
            setTimeout(function(){
                window.location.reload(true);
            },3000);
        }catch(err){
            console.log(err.message);
        } 
    } else {
        return false;
    }

}
/*
window.addEventListener('load', async() => {
     await loadGroupFromStorage();
     document.querySelectorAll('.delete').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await deleteGroup(e);
        })
    });
  })
*/
const viewGroup = async(e) => {
    updateKey =  e.target.parentElement.id;

    //updateKey = document.getElementsByClassName("edit")[0].id;
    //alert(updateKey);

    const editname = document.getElementById("name");
    const editaddress = document.getElementById("address");
    const edit_meeting_day = document.getElementById("meeting_day");
    const edit_meeting_frequency = document.getElementById("frequency");
    const edit_reg_date = document.getElementById("reg_date");
    

   

    try{
        const group = await groupTable.getItem(updateKey);


        editname.value = group.groupName;
        editaddress.value = group.groupAddress;
        edit_meeting_day.value = group.meeting_day;
        edit_meeting_frequency.value = group.meeting_frequency;
        edit_reg_date.value = group.reg_date;

        

        

        //document.getElementById("menu-1").style.display= "block";

            //$('.menu-hider').removeClass('menu-active');
            //$('.menu-1').addClass('menu-active');

    }catch(err){
        console.log(err.message);
    }
    document.getElementById("clik").click();
    document.getElementById("sub2").style.display= "block";
    document.getElementById("sub1").style.display= "none";
}
/*
window.addEventListener('load', async() => {
    await loadGroupFromStorage();
    document.querySelectorAll('.edit').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await viewGroup(e);
        })
    })
})
*/
const updateGroup = async() => {

try{
    const updatedClient ={
        editname: document.getElementById("name").value,
        editaddress: document.getElementById("address").value,
        edit_meeting_day: document.getElementById("meeting_day").value,
        edit_meeting_frequency: document.getElementById("frequency").value,
        edit_reg_date: document.getElementById("reg_date").value,
    }


    let updatedRow = `<tr id="${updateKey}">
                    <td>${updatedClient.editname}</td>
                    <td>${updatedClient.editaddress}</td>
                    <td>${updatedClient.edit_meeting_day}</td>
                    <td>${updatedClient.edit_meeting_frequency}</td>
                    <td>${updatedClient.edit_reg_date}</td>
                    <td><button class="delete"><i class="fa fa-trash fa-2x"></i></button></td>
                </tr>`
                
                
        document.getElementById(`${updateKey}`).remove();
        document.querySelector('.tbody1').insertAdjacentHTML('afterbegin', updatedRow);
    
        await groupTable.setItem(updateKey, updatedClient);

   // document.getElementById("menu-1").style.display= "none";

    //alert('Group Updated Successfully');
    $(".mess").html("Group Updated</br> Successfully");
    $("#create_success").click();
    setTimeout(function(){
        window.location.reload(true);
    },3000);
}catch(err){
    console.log(err.message);
}
}

document.getElementById('submit').addEventListener('click', async(e) => {
    e.preventDefault();

    if (navigator.onLine) {
                const groupName = document.getElementById("name").value;
                const groupNameKey= groupName.replaceAll(' ', '_');
                const groupAddress = document.getElementById("address").value;
                const meeting_day = document.getElementById("meeting_day").value;
                const meeting_frequency = document.getElementById("frequency").value;
                const reg_date = document.getElementById("reg_date").value;

        var action = "Online";
                $.ajax({
                url:"group/postgroup",
                method:"POST",
                dataType:"json",
                data:{"name": groupNameKey, "address": groupAddress, "md": meeting_day, "fq": meeting_frequency, "action": action, "reg_date": reg_date},
                success:function(data){								
                    if(data == 1) {     
                    
                        //alert('Group Added Successfully');
                        $(".mess").html("Group Added</br> Successfully");
                        $("#create_success").click();
                        setTimeout(function(){
                            window.location.reload(true);
                         },3000);
                        
                        }                                
                    }
                })
            } else {

            await addInput();

            }
})

document.getElementById('submit_offline_g').addEventListener('click', async(e) => {
    e.preventDefault();
    await loadGroupFromStorage();
})


/*
document.getElementById('updateG').addEventListener('click', async(e) => {
    e.preventDefault();
    await updateGroup();
})*/

window.addEventListener('load', async() => {
    await loadGroupFromStorage();
    document.querySelectorAll('.delete').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await deleteGroup(e);
        })
    });/*
    document.querySelectorAll('.edit').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await viewGroup(e);
        })
    })*/
})


$('.back').click(function(){
    location.href="dashboard";
})
$('.close-menu').click(function(){
    $(".footer-menu-1-icons").show();
})

</script>
</body>
