<?php
include('../../serv/accsecu/confs/config.php');
include("access.php"); 
?>
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-capable" content="yes">
<title>Egis DFS | Customers </title>
<!-- Don't forget to update PWA version (must be same) in pwa.js & manifest.json -->
<link rel="manifest" href="_manifest.json" data-pwa-version="set_by_pwa.js">
<link href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i|Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="styles/style.css">
<link rel="stylesheet" type="text/css" href="styles/framework.css">
<link rel="stylesheet" type="text/css" href="fonts/css/fontawesome-all.min.css">    
<link rel="stylesheet" type="text/css" href="styles/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="styles/scroller.dataTables.min.css">

<style>
#signature{
width: 100%;
height: auto;
border: 1px solid blue;
}

.noup, .up {
  display: block;
  margin-left: auto;
  margin-right: auto;
  width: 50%;
}
</style>
</head>  
    
<body class="theme-light" data-highlight="blue2">
    
<div id="page-preloader">
    <div class="loader-main"><div class="preload-spinner border-highlight"></div></div>
</div>
    
<div id="page">
	<div class="header header-fixed header-logo-app">
        <a href="#" class="header-title ultrabold back"><span class="color-highlight">Customers</a>
		<a href="#" class="header-icon header-icon-1 back"><i class="fas fa-arrow-left"></i></a>
        <a href="#" class="header-icon header-icon-3" id="reload"><span class="fa-fw select-all fas color-highlight"></span></a>
        <a href="#" class="header-icon header-icon-2" data-toggle-theme><i class="fas fa-moon"></i></a>
	</div>

        
	<div class="page-content header-clear">

        <div class="content bottom-0">
        <a href="#" id="create_success" data-menu="menu-success"></a>

                
        <div class="header-clear"></div>
        

        <div class="tab-controls tab-animated tabs-large tabs-rounded" data-tab-items="2" 
                 data-tab-active="bg-highlight">
                <a href="#" data-tab-active data-tab="tab-1">Live Customers<i class="fa fa-online"></i></a>
                <a href="#" data-tab="tab-2">Offline Customers<i class="fa fa-offline"></i></a>
            </div>
            <div class="clear bottom-15"></div>
            <div class="tab-content" id="tab-1">
                <div class="online">
                <table id="groupTb" class="display nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>Customer Type</th>
								<th>Name</th>
								<th>Branch</th>
								<th>Channel</th>
								<th>Creation Date</th>
								<th>Status</th>
								<th>View</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
            </div>
            
            </div>
            <div class="tab-content" id="tab-2">
            <div class="offline">
                        <table id="offtb" class="display nowrap" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Company Name</th>
                                    <th>Full Name</th>
                                    <th>Date of Birth</th>
                                    <th>Gender</th>
                                    <th>Marital Status</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="tbody1">

                            </tbody>
                        </table>
                    
                    <a href="#" data-menu="menu-details" id="clik"></a>
                    <a href="#" data-menu="menu-group-details" id="clikm"></a>
                    <a href="#" data-menu="menu-group-update" id="cliku"></a>
                    
            </div>
            

            </div>       
                
            <div class="header-clear"></div>
            
        </div>

        <div id="menu-success" 
            class="menu menu-box-modal round-medium bg-green2-dark shadow-large" 
            data-menu-height="320" 
            data-menu-width="310" 
            data-menu-effect="menu-over">
            <h1 class="center-text top-30"><i class="fa fa-3x fa-check-circle color-white"></i></h1>
            <h3 class="center-text uppercase ultrabold top-30 color-white mess"></h3>
        </div>

        <div id="menu-group-details" 
            class="menu menu-box-modal round-medium bg-white shadow-large" 
            data-menu-height="100%" 
            data-menu-width="100%" 
            data-menu-effect="menu-over">

            <div class="header-clear"></div>

            <div class="group_response"></div>

            <a href="#" class="close-menu button button-center-medium button-s button-round-small bg-highlight color-white">Close</a>
        </div>

        <div id="menu-group-update" 
            class="menu menu-box-modal round-medium bg-white shadow-large" 
            data-menu-height="100%" 
            data-menu-width="100%" 
            data-menu-effect="menu-over">
            
            <div class="header-clear"></div>

            <div class="group_update_response"></div>

            <div class="content top-30 left-50 right-50">
                <div class="one-half">
                        <a href="#" id="submit_u" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Update</a>
                </div>
                <div class="one-half last-column">
                    <a href="#" class="close-menu button button-xs button-round-medium shadow-large bg-red2-dark button-full">Cancel</a>
                </div>
            </div>
            <div class="clear"></div>
        </div>

        <div class="menu-hider"></div>

        		
    </div>
    
    <div  id="footer-menu" class="footer-menu-1-icons">
        <a href="#" data-menu="menu-details" class="button button-xs button-round-medium shadow-large bg-highlight color-white bold button-full">Create Customer</a>
    </div>
    <div id="menu-details" class="menu menu-box-top" data-menu-height="100%" data-menu-effect="menu-over">
        <div class="boxed-text-huge top-30">

        <h3 class="center-text uppercase ultrabold top-20">Create Customer</h3>
        <div class="content bottom-0">
            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="ctype">
                    <option value="">Select Customer Type</option>
                    <?php

                    $ctu = $db -> prepare('SELECT * FROM customertype');
                    $ctu -> execute();
                    $rctu = $ctu->get_result();
                    while($cgh = mysqli_fetch_array($rctu) ) { ?>

                    <option value="<?php echo $cgh["id"]; ?>"><?php echo $cgh["name"]; ?></option>


                    <?php
                        
                    }
                    ?>
                </select>
            </div>
            <div class="corp" style="display:none">
                <div class="input-style input-style-1 input-required">
                    
                    <span>Company Name</span>
                    <em>(required)</em>
                    <input type="text" placeholder="Enter Company Name" id="cname">
                </div>
                <div class="input-style input-style-1 input-required">
                    
                    <span>Registration Number</span>
                    <em>(required)</em>
                    <input type="text" placeholder="Enter Company Registration Number" id="cnum">
                </div>
            </div>
            <div class="input-style input-style-1 input-required">
                
                <span>First Name</span>
                <em>(required)</em>
                <input type="text" placeholder="Enter First Name" id="fname">
            </div>
            <div class="input-style input-style-1 input-required">
                
                <span>Middle Name</span>
                <em>(optional)</em>
                <input type="text" placeholder="Enter Middle Name" id="mname">
            </div>
            <div class="input-style input-style-1 input-required">
                
                <span>Last Name</span>
                <em>(required)</em>
                <input type="text" placeholder="Enter Last Name" id="lname">
            </div>

            <div class="input-style input-style-1 input-required">
                <!--<span class="cdob">Date of Birth</span>-->
                <em class="cdob">Date of Birth</em>
                <input type="date" id="dob">
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="gender">
                    <option value="">Select Gender</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                </select>
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="marital_status">
                    <option value="">Select Marital Status</option>
                    <option value="Single">Single</option>
                    <option value="Married">Married</option>
                    <option value="Divorced">Divorced</option>
                    <option value="Widowed">Widowed</option>
                    <option value="Widower">Widower</option>
                </select>
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="group">
                    <option value="">Select Group</option>
                    <?php

                    $de = $db -> prepare('SELECT * FROM groups');
                    $de -> execute();
                    $rde = $de->get_result();
                    while($row = mysqli_fetch_array($rde) ) { ?>

                    <option value="<?php echo $row["id"]; ?>"><?php echo $row["name"]; ?></option>


                    <?php
                        
                    }
                    ?>
                </select>
            </div>

            <div class="input-style input-style-1 input-required scl">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="social_class">
                    <option value="">Select Social Class</option>
                    <?php

                    $scl = $db -> prepare('SELECT * FROM social_class');
                    $scl -> execute();
                    $rscl = $scl->get_result();
                    while($row11 = mysqli_fetch_array($rscl) ) { ?>

                    <option value="<?php echo $row11["id"]; ?>"><?php echo $row11["name"]; ?></option>


                    <?php
                        
                    }
                    ?>
                </select>
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="sector">
                    <option value="">Select Sector</option>
                    <?php

                    $sck = $db -> prepare('SELECT * FROM sectors');
                    $sck -> execute();
                    $rsck = $sck->get_result();
                    while($row1 = mysqli_fetch_array($rsck) ) { ?>

                    <option value="<?php echo $row1["id"]; ?>"><?php echo $row1["name"]; ?></option>


                    <?php
                        
                    }
                    ?>
                </select>
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="sub_sector">
                    <option value="">Select Sub-sector</option>
                </select>
            </div>

            <div class="input-style input-style-1 input-required">
                <em><i class="fa fa-angle-down"></i></em>
                <select id="business_scale">
                    <option value="">Select Business Scale</option>
                    <?php

                    $bsk = $db -> prepare('SELECT * FROM business_scale');
                    $bsk -> execute();
                    $rbsk = $bsk->get_result();
                    while($row2 = mysqli_fetch_array($rbsk) ) { ?>

                    <option value="<?php echo $row2["id"]; ?>"><?php echo $row2["name"]; ?></option>


                    <?php
                        
                    }
                    ?>
                </select>
            </div>

            <a href="#" class="toggle-switch toggle-ios toggle-off"
            data-toggle-height="30"
            data-toggle-width="58"
            data-toggle-content="toggle-content-2"
            data-toggle-checkbox="toggle-checkbox-2"
            data-icons-size="8"
            data-bg-on="bg-green1-dark" 
            data-bg-off="bg-blue2-dark">
                <span class="color-theme regularbold font-14">Contact Info</span>
                <strong></strong>
                <i class="fa-t1 font-regular bold">ON</i>
                <i class="fa-t2 font-regular bold">OFF</i>
                <u></u>
            </a>

                <div class="toggle-content" id="toggle-content-2">

                        <div class="input-style input-style-1 input-required">
                            <span>Phone</span>
                            <em>(optional)</em>
                            <input type="number" id="phone_no" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" placeholder="Enter Primary Phone Number">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <span>Secondary Phone</span>
                            <em>(optional)</em>
                            <input type="number" id="phone_no_sec" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" placeholder="Enter Secondary Phone Number">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            
                            <span>Email</span>
                            <em>(optional)</em>
                            <input type="text" placeholder="Enter Address" id="email">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            
                            <span>Address</span>
                            <em>(required)</em>
                            <input type="text" placeholder="Enter Address" id="address">
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <em><i class="fa fa-angle-down"></i></em>
                            <select id="address_type">
                                <option value="">Select Address Type</option>
                                <option value="Home">Home</option>
                                <option value="Office">Office</option>
                            </select>
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <em><i class="fa fa-angle-down"></i></em>
                            <select id="country">
                                <option value="">Select Country</option>
                                <?php

                                $scc = $db -> prepare('SELECT * FROM country');
                                //$bsk -> bind_param('i', $aid);
                                $scc -> execute();
                                $rscc = $scc->get_result();
                                while($row3 = mysqli_fetch_array($rscc) ) { ?>

                                <option value="<?php echo $row3["id"]; ?>"><?php echo $row3["name"]; ?></option>


                                <?php
                                    
                                }
                                ?>
                            </select>
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <em><i class="fa fa-angle-down"></i></em>
                            <select id="state">
                                <option value="">Select State</option>
                            
                            </select>
                        </div>

                        <div class="input-style input-style-1 input-required">
                            <em><i class="fa fa-angle-down"></i></em>
                            <select id="city">
                                <option value="">Select City</option>
                            
                            </select>
                        </div>
                </div>

                <div class="divider top-20 bottom-20"></div>

                <a href="#" class="toggle-switch toggle-ios toggle-off"
                    data-toggle-height="30"
                    data-toggle-width="58"
                    data-toggle-content="toggle-content-3"
                    data-toggle-checkbox="toggle-checkbox-3"
                    data-icons-size="8"
                    data-bg-on="bg-green1-dark" 
                    data-bg-off="bg-blue2-dark">
                        <span class="color-theme regularbold font-14">Add Signature</span>
                        <strong></strong>
                        <i class="fa-t1 font-regular bold">ON</i>
                        <i class="fa-t2 font-regular bold">OFF</i>
                        <u></u>
                    </a>

                    <div class="toggle-content" id="toggle-content-3">
                            <div id="signature" style=''>
                                <canvas id="signature-pad" class="signature-pad" width="300px" height="150px"></canvas>
                            </div>
                           <a href='#' id='clear' style="text-align: right">Clear</a>
                        <input type="hidden" id='output'>

                        <!-- Preview image -->
                        <!--<img src='' id='sign_prev' style='display: none;'/>-->

                    </div>

                    <div class="divider top-20 bottom-20"></div>

                    <a href="#" class="toggle-switch toggle-ios toggle-off"
                    data-toggle-height="30"
                    data-toggle-width="58"
                    data-toggle-content="toggle-content-4"
                    data-toggle-checkbox="toggle-checkbox-4"
                    data-icons-size="8"
                    data-bg-on="bg-green1-dark" 
                    data-bg-off="bg-blue2-dark">
                        <span class="color-theme regularbold font-14">Add Passport</span>
                        <strong></strong>
                        <i class="fa-t1 font-regular bold">ON</i>
                        <i class="fa-t2 font-regular bold">OFF</i>
                        <u></u>
                    </a>
                    <div class="toggle-content" id="toggle-content-4">

                        <div class="input-style input-style-1">
                            <input type="file" accept="image/*" capture="camera" id="passport" onchange="loadFile(event)" style="display: none;" class="center-text prup">
                            <label for="passport" style="cursor: pointer;"><img src="customer/camera.png" class="avatar img-circle img-thumbnail noup" alt="avatar"><img class="up avatar img-circle img-thumbnail" style="display: none;" id="output_p" width="200" /></label>
                        </div>
                    </div>
                    <div class="divider top-20 bottom-20"></div>

            </div>

            <div class="content top-30 left-50 right-50">
                <div class="one-half">
                    <div id="sub1">
                        <a href="#" id="submit" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Create</a>
                    </div>
                    <div id="sub2" style="display:none">
                        <a href="#" id="submit_offline_c" class="button button-xs button-round-medium shadow-large bg-highlight button-full">Update</a>
                    </div>
                </div>
                <div class="one-half last-column">
                    <a href="#" class="close-menu button button-xs button-round-medium shadow-large bg-red2-dark button-full">Cancel</a>
                </div>
            </div>
            <div class="clear"></div>
           
        </div>
    </div>

</div>

<!-- Keep these outside the div id page on the first page -->
<!-- your users land on, and it will appear on all pages -->



<script type="text/javascript" src="scripts/jquery.js"></script>
<script type="text/javascript" src="scripts/plugins.js"></script>
<script type="text/javascript" src="scripts/custom.js"></script>
<script src="scripts/signature_pad.min.js"></script>


<script type="text/javascript" src="scripts/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="scripts/dataTables.scroller.min.js"></script>
<script src="localForage-1.10.0/dist/localforage.js"></script>
<script>

 // Initialize jSignature
 var signaturePad = new SignaturePad(document.getElementById('signature-pad'));
 
$(document).ready(function() {
  var dataTable =  $('#groupTb').DataTable( {
        ajax:           "customer/data_groups",
        scrollY: 350,
        scrollX: true,
        scrollCollapse: true,
        scroller:       true,
        initComplete: function () {
            this.api().row( 1000 ).scrollTo();
        }
    } );

    var offlineTB =  $('#offtb').DataTable( {
        scrollY: 350,
        scrollX: true,
        scrollCollapse: true,
        scroller:       true,
        initComplete: function () {
            this.api().row( 1000 ).scrollTo();
        }
    });
   

    /*
    $('#sclick').click(function(){
        var data = signaturePad.toDataURL('image/png');
        $('#output').val(data);

        $("#sign_prev").show();
        $("#sign_prev").attr("src",data);
        $("#sig_area").hide();
        
    });*/

    document.getElementById('clear').addEventListener('click', function () {
        signaturePad.clear();
    });

    $("#sector").change(function(){
    //$("#sub_sector").val("");
    var ms = $("#sector option:selected").val();

    
    $("#sub_sector").load("customer/get_subsectors.php?ms=" + ms);

});

$("#country").change(function(){
				//$("#state").val("");
				var ss = $("#country option:selected").val();
			
				$("#state").load("customer/get_states.php?ss=" + ss);
			});


            $("#state").change(function(){
				//$("#city").val("");
				var ci = $("#state option:selected").val();

				$("#city").load("customer/get_cities.php?ci=" + ci);
			});

            $("#groupTb").on('click', '.viewm', function(){
                    var ccid = $(this).attr("id");		 
                    location.href="customerdetails?customer_id=" + ccid+"&back=2";
                });	

//
$("#ctype").change(function(){
    //$("#sub_sector").val("");
    var cty = Number($("#ctype option:selected").val());

    if(cty == 3) {
        $(".corp").show();
        $(".cdob").html("Business Registration Date");
        $(".scl").hide();
    } else {
        $(".cdob").html("Date of Birth");
        $(".corp").hide();
        $(".scl").show();
    }
});

            /*
    $("#groupTb").on('click', '.viewm', function(){
		var grid = $(this).attr("id");		
		var action = "groupView";
		//if(confirm("Are you sure you want to delete this group?")) {
			$.ajax({
				url:"customer/action_gpdetails.php",
				method:"POST",
				data:{grid:grid, action:action},
				success:function(data) {					
					//alert("Customer Successfully Deleted");
					//window.location.reload(true);
                    document.getElementById("clikm").click();
                    $(".group_response").html(data);
                    $(".footer-menu-1-icons").hide();
				}
			})
		//} else {
		//	return false;
		//}
	});*/
/*
    $("#groupTb").on('click', '.edit', function(){
		var grid1 = $(this).attr("id");		
		var action1 = "groupUPView";
		//if(confirm("Are you sure you want to delete this group?")) {
			$.ajax({
				url:"group/action_gpdetails.php",
				method:"POST",
				data:{grid:grid1, action:action1},
				success:function(data) {					
					//alert("Customer Successfully Deleted");
					//window.location.reload(true);
                    document.getElementById("cliku").click();
                    $(".group_update_response").html(data);
                    $(".footer-menu-1-icons").hide();
				}
			})
		//} else {
		//	return false;
		//}
	});	
*/
});

let updateKey;

const customerTable = localforage.createInstance({
name: "fieldCollectionDSF",
storeName: "customerTable",
});

const groupTable = localforage.createInstance({
name: "fieldCollectionDSF",
storeName: "groupTable",
});

var online = window.navigator.onLine;
    if (navigator.onLine) {
    $(".online").show();
    $(".offline").hide();

    } else {
        //$(".online").hide();
        $(".offline").show();
        //GET ALL GROUPS FROM LOCAL STORE AND DISPLAY

    }


                const customerDetails = async () => {
                const ctype = document.getElementById("ctype").value;
                const cname = document.getElementById("cname").value;
                const cnum= document.getElementById("cnum").value;
                const fname = document.getElementById("fname").value;
                const mname = document.getElementById("mname").value;
                const lname = document.getElementById("lname").value;
                const dob = document.getElementById("dob").value;
                const gender = document.getElementById("gender").value;
                const marital_status = document.getElementById("marital_status").value;
                const group = document.getElementById("group").value;
                const social_class = document.getElementById("social_class").value;
                const sector = document.getElementById("sector").value;
                const sub_sector = document.getElementById("sub_sector").value;
                const business_scale = document.getElementById("business_scale").value;
                const phone_no = document.getElementById("phone_no").value;
                const phone_no_sec = document.getElementById("phone_no_sec").value;
                const email = document.getElementById("email").value;
                const address = document.getElementById("address").value;
                const address_type = document.getElementById("address_type").value;
                const country = document.getElementById("country").value;
                const state = document.getElementById("state").value;
                const city = document.getElementById("city").value;
                //const output = document.getElementById("output").value;
                //const passport = document.getElementById("passport");
                
                const output = signaturePad.toDataURL('image/png');
                //$('#output').val(data);
                const picture = document.getElementById("passport");
                var prev = picture.files[0];
                var min = 100000000;
                var max = 900000000;
                const customer_offline_no = Math.floor(Math.random() * min) + max;

                return {
                    ctype: ctype,
                    cname: cname,
                    cnum: cnum,
                    fname: fname,
                    mname: mname,
                    lname: lname,
                    dob: dob,
                    gender: gender,
                    marital_status: marital_status,
                    group: group,
                    social_class: social_class,
                    sector: sector,
                    sub_sector: sub_sector,
                    business_scale: business_scale,
                    phone_no: phone_no,
                    phone_no_sec: phone_no_sec,
                    email: email,
                    address: address,
                    address_type: address_type,
                    country: country,
                    state: state,
                    city: city,
                    output: output,
                    passport_sav: prev,
                    customer_offline_no: customer_offline_no,

                    
                    //picture: prev,
                    }
            }
           // customerDetails.onload = function () {
                const addInput = async () => {

                const inputValues = customerDetails();
                const dbLength = await customerTable.length();
                let id = dbLength === 0 ? 1 : dbLength + 1;
                try{
            
                        await customerTable.setItem(id, inputValues);
                        $(".mess").html("Customer Added</br> Successfully");
                        $("#create_success").click();
                        setTimeout(function(){
                            window.location.reload(true);
                        },3000);
                    } catch(e){
                        console.log(err.message);
                    }
                }
            //}


        //LOAD GROUPS FROM STORAGE
const loadCustomerFromStorage = async () => {
    try {
        await customerTable.iterate((value, key, iterationNumber) => {
            
            let newCustomer = `<tr id="${key}">
            <td>${value.cname} - ${value.cnum}</td>
            <td>${value.fname} ${value.mname} ${value.lname}</td>
        <td>${value.dob}</td>
        <td>${value.gender}</td>
        <td>${value.marital_status}</td>
        <td>${value.phone_no}</td>
        <td>${value.email}</td>
        <td>${value.address}</td>
         <td><button type="button" class="delete" id="${key}"><i class="fa fa-trash fa-2x"></i></button></td>
            </tr>`
            document.querySelector('.tbody1').insertAdjacentHTML('afterbegin', newCustomer);
            if (navigator.onLine) {
                var action = "Offline";
                    if(value.passport_sav !="") {
                        const reader = new FileReader();
                        reader.readAsDataURL(value.passport_sav);

                        reader.onload = function () {
                        const passport_sav = reader.result;

                        //console.log(passport_sav);
                        
                        $.ajax({
                        url:"customer/postgroup",
                        method:"POST",
                        dataType:"json",
                        //processData: false,
                        enctype: 'multipart/form-data',
                        data:{"ctype": value.ctype, "cname": value.cname, "cnum": value.cnum, "fname": value.fname, "mname": value.mname, "lname": value.lname, "gender": value.gender, "dob": value.dob, "marital_status": value.marital_status,
                            "group": value.group, "social_class": value.social_class, "sector": value.sector, "sub_sector": value.sub_sector, "business_scale": value.business_scale, "phone_no": value.phone_no,
                            "phone_no_sec": value.phone_no_sec, "email": value.email, "address": value.address, "address_type": value.address_type, "country": value.country, 
                            "state": value.state, "city": value.city, "passport": passport_sav, "signature": value.output, "customer_offline_no": value.customer_offline_no, "action": action},
                        success:function(data){								
                            if(data == 1) {     
                            customerTable.removeItem(key);
                            //dataTable.ajax.reload();
                                }                                
                            }
                        })


                        }
                    } else {
                        $.ajax({
                        url:"customer/postgroup",
                        method:"POST",
                        dataType:"json",
                        //processData: false,
                        enctype: 'multipart/form-data',
                        data:{"ctype": value.ctype, "cname": value.cname, "cnum": value.cnum, "fname": value.fname, "mname": value.mname, "lname": value.lname, "gender": value.gender, "dob": value.dob, "marital_status": value.marital_status,
                            "group": value.group, "social_class": value.social_class, "sector": value.sector, "sub_sector": value.sub_sector, "business_scale": value.business_scale, "phone_no": value.phone_no,
                            "phone_no_sec": value.phone_no_sec, "email": value.email, "address": value.address, "address_type": value.address_type, "country": value.country, 
                            "state": value.state, "city": value.city, "passport": value.passport_sav, "signature": value.output, "customer_offline_no": value.customer_offline_no, "action": action},
                        success:function(data){								
                            if(data == 1) {     
                            customerTable.removeItem(key);
                            //dataTable.ajax.reload();
                                }                                
                            }
                        })
                        }

                }
        })
    } catch (err) {
        console.log(err)
    }

}

//this is to load all offline groups in select group option
const loadOfflineGroup = async () => {
try {
    await groupTable.iterate((value, key, iterationNumber) => {
        if(key > 0) {
        $("#group").append($('<option>',{ value: value.group_offline_no, text: value.groupName+ ' (Offline)'}));
        }
    }) 
} catch (err) {
        console.log(err)
    }
}

window.addEventListener('load', async() => {
    await loadOfflineGroup ();
})

//DELETE GROUP FROM STORAGE
const deleteCustomer = async(e) => {
    const row = e.target.parentElement;
    const key = row.id;
    //var key = $(e).attr("id");
    //var key = document.getElementsByClassName("delete")[0].id;
    if(confirm("Are you sure you want to delete this?")) {
        row.remove();
        try{
            await customerTable.removeItem(key);
            //alert('Customer deleted successfully');
            $(".mess").html("Customer Deleted</br> Successfully");
            $("#create_success").click();
            setTimeout(function(){
                window.location.reload(true);
            },3000);
        }catch(err){
            console.log(err.message);
        } 
    } else {
        return false;
    }

}
/*
window.addEventListener('load', async() => {
     await loadCustomerFromStorage();
     document.querySelectorAll('.delete').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await deleteCustomer(e);
        })
    });
  })
*/
/*
const viewCustomer = async(e) => {
    updateKey =  e.target.parentElement.id;

    //updateKey = document.getElementsByClassName("edit")[0].id;
    //alert(updateKey);

    const editname = document.getElementById("name");
    const editaddress = document.getElementById("address");
    const edit_meeting_day = document.getElementById("meeting_day");
    const edit_meeting_frequency = document.getElementById("frequency");
    const edit_reg_date = document.getElementById("reg_date");
    

   

    try{
        const group = await groupTable.getItem(updateKey);


        editname.value = group.groupName;
        editaddress.value = group.groupAddress;
        edit_meeting_day.value = group.meeting_day;
        edit_meeting_frequency.value = group.meeting_frequency;
        edit_reg_date.value = group.reg_date;

        

        

        //document.getElementById("menu-1").style.display= "block";

            //$('.menu-hider').removeClass('menu-active');
            //$('.menu-1').addClass('menu-active');

    }catch(err){
        console.log(err.message);
    }
    document.getElementById("clik").click();
    document.getElementById("sub2").style.display= "block";
    document.getElementById("sub1").style.display= "none";
}

window.addEventListener('load', async() => {
    await loadCustomerFromStorage();
    document.querySelectorAll('.edit').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await viewCustomer(e);
        })
    })
})

const updateCustomer = async() => {

try{
    const updatedClient ={
        editname: document.getElementById("name").value,
        editaddress: document.getElementById("address").value,
        edit_meeting_day: document.getElementById("meeting_day").value,
        edit_meeting_frequency: document.getElementById("frequency").value,
        edit_reg_date: document.getElementById("reg_date").value,
    }


    let updatedRow = `<tr id="${updateKey}">
                    <td>${updatedClient.editname}</td>
                    <td>${updatedClient.editaddress}</td>
                    <td>${updatedClient.edit_meeting_day}</td>
                    <td>${updatedClient.edit_meeting_frequency}</td>
                    <td>${updatedClient.edit_reg_date}</td>
                    <td><button class="delete"><i class="fa fa-trash fa-2x"></i></button></td>
                </tr>`
                
                
        document.getElementById(`${updateKey}`).remove();
        document.querySelector('.tbody1').insertAdjacentHTML('afterbegin', updatedRow);
    
        await groupTable.setItem(updateKey, updatedClient);

   // document.getElementById("menu-1").style.display= "none";

    //alert('Customer Updated Successfully');
    $(".mess").html("Customer Updated</br> Successfully");
        $("#create_success").click();
    setTimeout(function(){
        window.location.reload(true);
    },3000);
}catch(err){
    console.log(err.message);
}
}
*/


document.getElementById('submit').addEventListener('click', async(e) => {
    e.preventDefault();
    

    if (navigator.onLine) {
        const ctype = document.getElementById("ctype").value;
        const cname = document.getElementById("cname").value;
        const cnum = document.getElementById("cnum").value;
        const fname = document.getElementById("fname").value;
                const mname = document.getElementById("mname").value;
                const lname = document.getElementById("lname").value;
                const dob = document.getElementById("dob").value;
                const gender = document.getElementById("gender").value;
                const marital_status = document.getElementById("marital_status").value;
                const group = document.getElementById("group").value;
                const social_class = document.getElementById("social_class").value;
                const sector = document.getElementById("sector").value;
                const sub_sector = document.getElementById("sub_sector").value;
                const business_scale = document.getElementById("business_scale").value;
                const phone_no = document.getElementById("phone_no").value;
                const phone_no_sec = document.getElementById("phone_no_sec").value;
                const email = document.getElementById("email").value;
                const address = document.getElementById("address").value;
                const address_type = document.getElementById("address_type").value;
                const country = document.getElementById("country").value;
                const state = document.getElementById("state").value;
                const city = document.getElementById("city").value;
                //const output = document.getElementById("output").value;
                //var passport = document.getElementById("passport");
                //const file = document.querySelector('#passport').files[0];
                //var passport = document.querySelector('#passport > input[type="file"]').files[0];
                
                const output = signaturePad.toDataURL('image/png');

                    if( document.getElementById("passport").files.length !=0){

                        const fileInput = document.getElementById('passport');

                        const reader = new FileReader();
                    reader.readAsDataURL(fileInput.files[0]);

                    reader.onload = function () {
                        const base64 = reader.result;//base64encoded string

                        var action = "Online";
                    $.ajax({
                    url:"customer/postgroup",
                    method:"POST",
                    dataType:"json",
                    //processData: false,
                    enctype: 'multipart/form-data',
                    data:{"ctype": ctype, "cname": cname, "cnum": cnum," fname": fname, "mname": mname, "lname": lname, "gender": gender, "dob": dob, "marital_status": marital_status,
                            "group": group, "social_class": social_class, "sector": sector, "sub_sector": sub_sector, "business_scale": business_scale, "phone_no": phone_no,
                            "phone_no_sec": phone_no_sec, "email": email, "address": address, "address_type": address_type, "country": country, 
                            "state": state, "city": city, "passport": base64, "signature": output, "action": action},
                    success:function(data){								
                        if(data == 1) {     
                        
                            //alert('Customer Added Successfully');
                            $(".mess").html("Customer Added</br> Successfully");
                            $("#create_success").click();
                            setTimeout(function(){
                                window.location.reload(true);
                            },3000);
                            
                            }                                
                        }
                    })
                    };
                } else {

                    var action = "Online";
                    $.ajax({
                    url:"customer/postgroup",
                    method:"POST",
                    dataType:"json",
                    //processData: false,
                    enctype: 'multipart/form-data',
                    data:{"ctype": ctype, "cname": cname, "cnum": cnum," fname": fname, "mname": mname, "lname": lname, "gender": gender, "dob": dob, "marital_status": marital_status,
                            "group": group, "social_class": social_class, "sector": sector, "sub_sector": sub_sector, "business_scale": business_scale, "phone_no": phone_no,
                            "phone_no_sec": phone_no_sec, "email": email, "address": address, "address_type": address_type, "country": country, 
                            "state": state, "city": city, "passport": "", "signature": output, "action": action},
                    success:function(data){								
                        if(data == 1) { 
                        
                            //alert('Customer Added Successfully');
                            $(".mess").html("Customer Added</br> Successfully");
                            $("#create_success").click();
                            setTimeout(function(){
                                window.location.reload(true);
                            },3000);
                            
                            }                                
                        }
                    })

                }
        
            } else {
            await addInput();

            }
})

document.getElementById('submit_offline_c').addEventListener('click', async(e) => {
    e.preventDefault();
    await loadCustomerFromStorage();
})


/*
document.getElementById('updateG').addEventListener('click', async(e) => {
    e.preventDefault();
    await updateCustomer();
})*/

window.addEventListener('load', async() => {
    await loadCustomerFromStorage();
    document.querySelectorAll('.delete').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await deleteCustomer(e);
        })
    });/*
    document.querySelectorAll('.edit').forEach(button =>{
        button.addEventListener('click', async(e) => {
          await viewCustomer(e);
        })
    })*/
})



$('.back').click(function(){
    location.href="dashboard";
})
$('.close-menu').click(function(){
    $(".footer-menu-1-icons").show();
})

var loadFile = function(event) {
            var image = document.getElementById('output_p');
            image.src = URL.createObjectURL(event.target.files[0]);
            $('.noup').hide();
            $('.up').show();
        };
</script>
</body>
