<?php
namespace Douglas;
include('../../serv/accsecu/confs/server-admin.php');
include('../welcome_user.php');

//$report_id = $_GET['r_id'];

/*
$report_id = 1;
if ($report_id ==1) {
    $tbname = "Deposit Report (Detail)";
} else if ($report_id ==2) {
  $tbname = "Trial Balance Report";
} else if ($report_id ==4) {
  $tbname = "Withdrawal Report (Detail)";
} else if ($report_id ==5) {
  $tbname = "Loan Repayment Report";
}  else if ($report_id ==6) {
  $tbname = "Daily Field Collection";
} */
require 'vendor/autoload.php';

use \Douglas\Request\Report as Report;
use \Douglas\Request\Asset as Asset;

// Add exception handling for invalid formats
$format = Report::getFormat($_GET['format']);
//$format = "html";

// I normally encrypt this and store it in the database and pass it around
$jasper_url = 'http://jasperadmin:jasperadmin@localhost:8080/jasperserver/';

// Create a new Report object that should point to a jasper report
$report = new Report(
    array(
        'jasper_url' => $jasper_url,
        // The report URL is the full resource path in Jasper
        'report_url' => '/reports/interactive/CustomersReport',
        // These parameters get passed automatically to your report, there 
        // are also some Jasper specific parameters you can pass as well
        'parameters' => array(
            'gender' => 'M',
            'year'   => 2014
        ),
        // This is the format you want the report to be returned as
        'format'     => $format,
    )
);

// This can be used for storing reports locally before giving them to the user
$file_name = "{$report->getPrettyUrl()}.{$format}";

// Make the request to Jasper
$report->send();

if ($report->getError()) {
    // Check to see if the request was successful or not
    // and do something nice with the error
}

if (Report::FORMAT_HTML === $format) {
    // This will request the HTML from jasper and run a callback on every
    // asset jasper returns.  This is REQUIRED because the urls that jasper
    // sends back are not web accessible and need to have the jsessionid 
    // cookie injected before being requested
    $html = $report->getHtml(
        function($asset_url, $jsessionid) use ($jasper_url) {

            // I like to request every asset from jasper, re-save them 
            // locally so I can do caching, reloading, etc and not have 
            // to rely on Jasper
            $asset = new Asset(
                array(
                    'jasper_url' => $jasper_url,
                    'jsessionid' => $jsessionid,
                    'asset_url'  => $asset_url,
                )
            );
            $asset->send();

            // I like to only save images, though Jasper will sometimes
            // send back javascript files like jquery
            if ($asset->getHeader('content-type') != 'image/png') {
                return false;
            }

            $asset_file_name = sprintf('jasper_report_asset_%s', uniqid());
            $full_asset_path = "../images/{$asset_file_name}";

            $asset_fh = fopen($full_asset_path, 'w');
            fwrite($asset_fh, $asset->getBody());
            fclose($asset_fh);
            return "/{$asset_file_name}.png";
        }
    );
} else {
    $body = $report->getBody();
    //header("Content-type: application/pdf");
    //header('Content-type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
    

    
    echo $body;
    // Output the PDF or Excel here
}
?>
