<?php
include('../serv/accsecu/confs/config.php');
include('welcome_user.php');


?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Loan Repayment</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
        <link rel="icon" type="image/x-icon" href="../favicon.ico">
		
		<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/datatables.min.css" />
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <style>
        .modal-body {
            max-height: calc(100vh - 210px);
            overflow-y: auto;
        }
        .modal-open {
            overflow: hidden;
            overflow-y: scroll;
            padding-right: 0 !important;
        }

        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de
        }

        .select2-hidden-accessible {
            border: 0 !important;
            clip: rect(0 0 0 0) !important;
            height: 1px !important;
            margin: -1px !important;
            overflow: hidden !important;
            padding: 0 !important;
            position: absolute !important;
            width: 1px !important
        }

        .form-control {
            display: block;
            width: 100%;
            height: 34px;
            padding: 6px 12px;
            font-size: 14px;
            line-height: 1.42857143;
            color: #555;
            background-color: #fff;
            background-image: none;
            border: 1px solid #ccc;
            border-radius: 4px;
            -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
            -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
            transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
        }

        .select2-container--default .select2-selection--single,
        .select2-selection .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 0;
            padding: 6px 12px;
            height: 34px
        }

        .select2-container--default .select2-selection--single {
            background-color: #fff;
            border: 1px solid #aaa;
            border-radius: 4px
        }

        .select2-container .select2-selection--single {
            box-sizing: border-box;
            cursor: pointer;
            display: block;
            height: 28px;
            user-select: none;
            -webkit-user-select: none
        }
        .select2-dropdown {
            z-index:99999;
        }

        .select2-container .select2-selection--single .select2-selection__rendered {
            padding-right: 10px
        }

        .select2-container .select2-selection--single .select2-selection__rendered {
            padding-left: 0;
            padding-right: 0;
            height: auto;
            margin-top: -3px
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: #444;
            line-height: 28px
        }

        .select2-container--default .select2-selection--single,
        .select2-selection .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 0 !important;
            padding: 6px 12px;
            height: 40px !important
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 26px;
            position: absolute;
            top: 6px !important;
            right: 1px;
            width: 20px
        }
        .select2-selection--multiple:before {
            content: "";
            position: absolute;
            right: 7px;
            top: 42%;
            border-top: 5px solid #888;
            border-left: 4px solid transparent;
            border-right: 4px solid transparent;
        }

        .tooltip-inner {
            max-width: 200px;
            padding: 3px 8px;
            color: #fff;
            text-align: center;
            background-color: #0000FF;
            border-radius: .25rem;
        }
        .tooltip.bs-tooltip-auto[x-placement^=top] .arrow::before, .tooltip.bs-tooltip-top .arrow::before {
            margin-left: -3px;
            content: "";
            border-width: 5px 5px 0;
            border-top-color: #0000FF;
        }
    </style>
	</head>
	<body>
		<div id="app">		
<?php include('include/sidebar.php');?>
			<div class="app-content">
				

					<?php include('include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
						<section id="page-title">
							<div class="row">
								<div class="col-sm-8">
									<h1 class="mainTitle"><?php echo $site_name; ?>  | Loan Repayment</h1>
								</div>
								<ol class="breadcrumb">
									<li>
										<span><?php echo $site_name; ?> </span>
									</li>
									<li class="active">
										<span>Loan Repayment</span>
									</li>
								</ol>
							</div>
						</section>
						<!-- end: PAGE TITLE -->
						<!-- start: BASIC EXAMPLE -->
						<div class="container-fluid container-fullw bg-white">
						

							<div class="row">
								<div class="col-md-12" id="repayment_field">

								<p class="color-red2-light center-text"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></p>
                                   
											
                                                <?php if ($allow_process == 1) { ?>
                                                <h4 class="text-center text-danger">Branch processing date is not set. Please set it to perform transactions</h4>
                                                <?php } else { ?>

                                                    <?php if ($user_role !=1) { ?>
                                                    <div class="form-group col-md-12">
                                                        <label for="sender_account">Account Number</label>
                                                            <input type="number" data-maxlength="10" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" class="form-control sender_account" name="sender_account" id="sender_account" placeholder="Enter Account Number"  onBlur="validateAccount1()">
                                                    </div>

                                                    <div id="response_account"></div>
                                                    <?php } else { ?>

                                                        <p>Please login with an account with lesser role than super administrator</p>

                                                    <?php } ?>

                                                <form method="post" id="repaymentForm">
                                                <div id="show_fields" style="display:none">
                                                    <div class="form-group col-md-6">
                                                        <label for="repay_amount">Amount</label>
                                                        <input type="number" min="0" step=".0000001" data-maxlength="3000" formnovalidate="formnovalidate" class="form-control repay_amount clr" name="repay_amount" id="repay_amount" placeholder="Enter Amount to Repay" value="0.00" onBlur="addDecimal4()" required oninput="validity.valid||(value='');">
                                                        <span class="op_amount_l text-danger"></span>
                                                    </div>
													
													<div class="form-group col-md-6">
                                                        <label for="repay_transaction_date" class="control-label">Value Date</label>
                                                            <input type="text" autocomplete="off" name="repay_transaction_date" class="form-control repay_transaction_date" id="repay_transaction_date" value="<?php echo $br_start_date; ?>" readonly>
                                                    </div>

                                                    <div class="form-group col-md-12">
														<label for="repay_comment" class="control-label">Comment</label>							
														<textarea class="form-control" rows="5" id="repay_comment" name="repay_comment"></textarea>							
													</div>
                                                    <div class="response_transaction  col-md-12"></div>	
                                                    <div class="form-group col-md-12">
                                                        <input type="hidden" name="customer_id" class="customer_id">
                                                        <input type="hidden" name="account_number" class="account_number">
                                                        <input type="submit" name="save_repay" id="save" class="btn btn-success pull-right save_repay" value="Repay" />
												    </div>
                                                </div>
                                                </form>
                                                <?php } ?>
								</div>
							</div>
							
					</div>

                    

								

								
						
						<!-- end: BASIC EXAMPLE -->
						<!-- end: SELECT BOXES -->
						
					</div>
				</div>
			</div>
			<!-- start: FOOTER -->
	<?php include('include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->


		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="vendor/autosize/autosize.min.js"></script>
		<script src="vendor/selectFx/classie.js"></script>
		<script src="vendor/selectFx/selectFx.js"></script>
		<script src="vendor/select2/select2.min.js"></script>
		<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
                FormElements.init();
			});
            //
		</script>

  <!-- Bootstrap core JavaScript -->
<script type="text/javascript" language="javascript">
    $(document).ready(function() {

        $("#repayment_field").on('submit','#repaymentForm', function(event){
		event.preventDefault();
		$('#save_repay').attr('disabled','disabled');
		var formData = $(this).serialize();
		$.ajax({
			url:"customer/repay_process.php",
			method:"POST",
			data:formData,
			success:function(data){				
				$('.response_transaction').html(data);
				//$('#customerForm')[0].reset();
				//$('#customerModal').modal('hide');				
				//$('#save').attr('disabled', false);
				//dataTable.ajax.reload();
				//alert("Request Successfully");
                if (data == "<p class='text-success center'>Repayment Successful</p>" || data == "You have previously completed all repayments. Funds have been moved to your attached savings account" || data == "<p class='text-success center'>Repayment Request Submited for Approval</p>"){
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }
			}
		})
	});

            $('.select2').select2({
			closeOnSelect: true
			});

            $(".clr").focus(function() {
            this.value = "";
            });

    });

    function validateAccount1() {
                var sender_account = $(".sender_account").val();
                var type = "Repayment";
               
                    $.ajax({
                            url:"get_account_details.php",
                            method:"POST",
                            data:{"type": type, "sender_account": sender_account},
                            //dataType:"json",
                            success:function(data){
                                $('#response_account').html(data); 
                                if (data != "<h4 class='text-center text-danger'>Invalid account number</h4>" && data != "<h4 class='text-center text-danger'>Please enter a loan account number</h4>" && data != "<h4 class='text-center text-danger'>This account is not active and cannot perform transactions</h4>" && data != "<h4 class='text-center text-danger'>You do not have the privilege to repay loans.</h4>") {
                                    $("#show_fields").show();

                                    $.ajax({
                                        url:"get_customer_id.php",
                                        method:"POST",
                                        data:{"sender_account": sender_account},
                                        //dataType:"json",
                                        success:function(response){
                                            $('.customer_id').val(response);
                                            $('.account_number').val(sender_account);
                                                                            
                                        }
                                    })

                                } else {
                                    $("#show_fields").hide();
                                }
                                                                                               
                            }
                        })
            }

//
//REPAYMENT LIMITS
function addDecimal4() {
        var dep_amt = Number($(".repay_amount").val());
        var prd_type = $(".product_type").val();

        var minLimitAm_r = Number($(".minLimitAm_r").val());
        var maxLimitAm_r = Number($(".maxLimitAm_r").val());
        minLimitAm_r = Number(minLimitAm_r);
        maxLimitAm_r = Number(maxLimitAm_r);
        

    if (prd_type == "Loan") {

        if (dep_amt == 0) {
        $('.op_amount_l').html("Repayment Amount must be greater than 0");
        $('.op_amount_l').show();
        $('.save_repay').attr('disabled','disabled');
        } else if (minLimitAm_r != 0 && dep_amt < minLimitAm_r) {
        $('.op_amount_l').html("Repayment Amount must be greater than or equal to " + minLimitAm_r);
        $('.op_amount_l').show();
        $('.save_repay').attr('disabled','disabled');
        } else if (maxLimitAm_r != 0 && dep_amt > maxLimitAm_r) {
        $('.op_amount_l').html("Repayment Amount must be less than or equal to " + maxLimitAm_r);
        $('.op_amount_l').show();
        $('.save_repay').attr('disabled','disabled');
        }
        else {
        $('.op_amount_l').hide();
        $('.save_repay').attr('disabled', false);
        }

    }

        if (dep_amt == "") {
            var finalDec1 =  0;
        }
        else {
            var finalDec1 =  dep_amt;
        }

        var addDec2 = parseFloat(finalDec1).toFixed(2);

        $(".repay_amount").val(addDec2);
        
        }
</script>
	</body>
</html>