<?php
include('../../serv/accsecu/confs/config.php');
include('../welcome_user.php');


$actionid_slv = 130;
$authorize_slv = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
$authorize_slv->bind_param("ii", $actionid_slv, $user_role);
$authorize_slv->execute();
$rauthorize_slv = $authorize_slv->get_result();
                
 if ($rauthorize_slv->num_rows == 0 && $user_role !=1) {
    //$customerView = 1;
	$_SESSION['msg1'] = "<h3 class='text-danger'>You are not authorized to view policies.</h3>";
    header("location: $site_domain/main");
    } else {
  while($gu_slv = mysqli_fetch_assoc($rauthorize_slv) ){
  $right_id_slv = $gu_slv['id'];
  $apply_to_branch_slv = $gu_slv['apply_to_branch'];
  $apply_to_channel_slv = $gu_slv['apply_to_channel'];
  $apply_to_customertype_slv = $gu_slv['apply_to_customertype'];
}

$actionid_sle = 131;
$authorize_sle = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
$authorize_sle->bind_param("ii", $actionid_sle, $user_role);
$authorize_sle->execute();
$rauthorize_sle = $authorize_sle->get_result();
                
    if ($rauthorize_sle->num_rows == 0) {
        $createPolicy = 1;
    } else {
		$createPolicy = 2;
	}
   

?>

<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Policies</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
		<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="../vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="../vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../vendor/themify-icons/themify-icons.min.css">
		<link href="../vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="../assets/css/styles.css">
		<link rel="stylesheet" href="../assets/css/plugins.css">
		<link rel="stylesheet" href="../assets/css/themes/theme-1.css" id="skin_color" />
		<link rel="icon" type="image/x-icon" href="../../favicon.ico">		
		<link rel="stylesheet" type="text/css" href="../vendor/bootstrap/css/datatables.min.css" />
		
		<link rel="stylesheet" href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap-theme.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.13/css/dataTables.bootstrap.min.css">

<style>
.table-striped td {
  text-align: center;
}

	.modal-body {
    max-height: calc(100vh - 210px);
    overflow-y: auto;
}
.modal-open {
    overflow: hidden;
    overflow-y: scroll;
    padding-right: 0 !important;
}
.expnd {
    width: 100%;
}
.form-control {
    border-radius: 0;
    box-shadow: none;
    border-color: #d2d6de
}

.select2-hidden-accessible {
    border: 0 !important;
    clip: rect(0 0 0 0) !important;
    height: 1px !important;
    margin: -1px !important;
    overflow: hidden !important;
    padding: 0 !important;
    position: absolute !important;
    width: 1px !important
}

.select2-selection--multiple:before {
    content: "";
    position: absolute;
    right: 7px;
    top: 42%;
    border-top: 5px solid #888;
    border-left: 4px solid transparent;
    border-right: 4px solid transparent;
}

.form-control {
    display: block;
    width: 100%;
    height: 34px;
    padding: 6px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0;
    padding: 6px 12px;
    height: 34px
}

.select2-container--default .select2-selection--single {
    background-color: #fff;
    border: 1px solid #aaa;
    border-radius: 4px
}

.select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 28px;
    user-select: none;
    -webkit-user-select: none
}
.select2-dropdown {
    z-index:99999;
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-right: 10px
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-left: 0;
    padding-right: 0;
    height: auto;
    margin-top: -3px
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 28px
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0 !important;
    padding: 6px 12px;
    height: 40px !important
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 6px !important;
    right: 1px;
    width: 20px
}
.select2-selection__clear{
   position: absolute;
   top: 6px !important;
   right: 15px;
   height: 26px;
   width: 20px;
   padding: 0 15px;
}
.divider { margin-top: 50px; }

.tooltip-inner {
    max-width: 200px;
    padding: 3px 8px;
    color: #fff;
    text-align: center;
    background-color: #0000FF;
    border-radius: .25rem;
}
.tooltip.bs-tooltip-auto[x-placement^=top] .arrow::before, .tooltip.bs-tooltip-top .arrow::before {
    margin-left: -3px;
    content: "";
    border-width: 5px 5px 0;
    border-top-color: #0000FF;
}
.select2-selection__rendered {
		height: 50px;
		overflow-y: auto !important;
	}
</style>
	</head>
	<body>
		<div id="app" class="white">		
<?php include('../include/sidebar.php');?>
			<div class="app-content white">
			
					<?php include('../include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
						<section id="page-title">
							<div class="row">
								<div class="col-sm-8">
									<h1 class="mainTitle"><?php echo $site_name; ?>  | Policies</h1>
								</div>
								<ol class="breadcrumb">
									<li>
										<span><?php echo $site_name; ?> </span>
									</li>
									<li class="active">
										<span>Policies</span>
									</li>
								</ol>
							</div>
						</section>
						<!-- end: PAGE TITLE -->
						<!-- start: BASIC EXAMPLE -->
						<div class="container-fluid container-fullw bg-white">
						

							<div class="row">
								<div class="col-md-12">

								<p class="color-red2-light center-text"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></p>
                                
								<div class = "form-inline pull-right">														
                                    <button type="button" id="add_policy" class = "add_policy btn btn-primary" <?php if($createPolicy == 1 && $user_role != 1) { echo "disabled"; } ?>>Add Policy</button>						
                                </div>
                                <div class="divider"></div>
                                <table id="pndt" class="table table-bordered table-striped pndt" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>Entity</th>
                                            <th>Rule Name</th>
                                            <th width="500">Rule Details</th>
                                            <th width="250">Branches</th>
                                            <th width="250">Affected Products</th>
                                            <th>Affected Channels</th>
                                            <th>Status</th>
                                            <th>Date Added</th>
                                            <th>Last Updated</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        $crpnd = $db -> prepare('SELECT * FROM policies ORDER BY id DESC');
                                        $crpnd -> execute();
                                        $rcrpnd = $crpnd->get_result();
                                        if ($rcrpnd->num_rows > 0) {


                                            while($qpn = mysqli_fetch_assoc($rcrpnd) ){
                                                $pndid = $qpn["id"];
                                                $name = $qpn["name"];
                                                $product_type = $qpn["product_type"];
                                                $affected_branches = $qpn["affected_branches"];
                                                $affected_products = $qpn["affected_products"];
                                                $overdue_count = $qpn["overdue_count"];
                                                $status = $qpn["status"];
                                                $datetime = $qpn["datetime"];
                                                $last_updated = $qpn["last_updated"];
                                                $channels = $qpn["channels"];
                                                $included_loan = $qpn["included_loan"];
                                                $side_loan = $qpn["side_loan"];
                                                
                                              
                                                if($included_loan !="") {
                                                    $includedarray = explode(' , ',$included_loan);
                                                } else {
                                                    $includedarray = [];  
                                                }

                                                if($side_loan !="") {
                                                    $sidearray = explode(' , ',$side_loan);
                                                } else {
                                                    $sidearray = [];  
                                                }

                                                if ($product_type == "Savings Account" && $name == "Account Opening") {
                                                    $details  = "Min Age: ". $qpn["min_age"]. ", Max Age: ". $qpn["max_age"];
                                                } else if ($product_type == "Account Documents") {
                                                    $details  = "Require Document Upload: ". $qpn["require_doc_upload"];
                                                } else if ($product_type == "Missing Identification") {
                                                    $details  = "ID Type: ". $qpn["name"]."</br> Restricted Events: ". $qpn["restrict_events"];
                                                } else if ($product_type == "Savings Account" && $name == "Interest on Savings") {
                                                    if ($qpn["rule_type"] == "No of Withdrawal Per Compounding Period") {
                                                        $details  = $qpn["rule_type"]. "| Maximum Withdrawal: ". $qpn["max_withdrawal"]. " | Min Daily Compounding Hours: ".$qpn["min_hours_daily_compounding"];
                                                    } else if ($qpn["rule_type"] == "No Rule") {
                                                        $details  = "No Rule | Min Daily Compounding Hours: ".$qpn["min_hours_daily_compounding"];
                                                    }  else if ($qpn["rule_type"] == "Deposit Age Rule") {
                                                        $details  = "Deposit Age Rule | Min Daily Compounding Hours: ".$qpn["min_hours_daily_compounding"];
                                                    }  else {
                                                        $details= "-";
                                                    }
                                                    
                                                } else if ($product_type == "Savings Account" && $name == "Dormancy") {
                                                    $details  = "Days of Inactivity: ". $qpn["days_of_inactivity"]. ", Restricted Events: ". $qpn["restrict_events"];
                                                } else if ($product_type == "Account Approvals") {
                                                    $details = "<button class='btn btn-warning viw' id='$pndid'>Edit/View Amount Range</button>";
                                                    ///continue from here
                                                } else if ($product_type == "Savings Account" && $name == "Escheat") {
                                                    $details  = "Days to Escheat: ". $qpn["days_to_escheat"];
                                                } else if ($product_type == "Maximum Group Per Relationship Officer") {
                                                    $details  = "Maximum Group: ". $qpn["name"];
                                                } else if ($product_type == "Maximum Individual Client Per Relationship Officer") {
                                                    $details  = "Maximum Individual Client: ". $qpn["name"];
                                                } else if ($product_type == "Savings Account" && $name == "Overdraft") {
                                                    $details  = "Maximum Overdraft Amount: ". $qpn["max_overdraft"];
                                                } else if ($product_type == "Loan Account" && $name == "Loan Disbursement") {
                                                    $details  = "Min Age: ". $qpn["min_age"]. ", Max Age: ". $qpn["max_age"];
                                                } else if ($product_type == "Loan Account" && $name == "Maximum Loan Accounts") {
                                                    $details  = "Maximum Loan: ". $qpn["max_products"]."</br>";
                                                    $in_name = "";
                                                    if(!empty($includedarray)) {
                                                        $details .="Included: ";
                                                        foreach ($includedarray as $ica):
                                                        
                                                        $ics = $db -> prepare('SELECT name FROM loanproduct WHERE id=?');
                                                        $ics -> bind_param('i', $ica);
                                                        $ics -> execute();
                                                        $rics = $ics->get_result();

                                                        while($iax = mysqli_fetch_assoc($rics) ){
                                                            $in_name = $iax["name"];
                                                        }

                                                        $details .= ",".$in_name;

                                                        endforeach;
                                                        $details = str_replace(": ,", "", $details);
                                                    }


                                                } else if ($product_type == "Loan Account" && $name == "Access Loan on Loan") {
                                                    $details  = "Minimum Paid %: ". $qpn["min_total_paid"]. ", Maximum Paid %: ". $qpn["max_total_paid"]."</br>";

                                                    $sd_name = "";
                                                    if(!empty($sidearray)) {
                                                        $details .="Side Loan Product: ";
                                                        foreach ($sidearray as $sdp):
                                                        
                                                        $isd = $db -> prepare('SELECT name FROM loanproduct WHERE id=?');
                                                        $isd -> bind_param('i', $sdp);
                                                        $isd -> execute();
                                                        $risd = $isd->get_result();

                                                        while($isx = mysqli_fetch_assoc($risd) ){
                                                            $sd_name = $isx["name"];
                                                        }

                                                        $details .= ",".$sd_name;

                                                        endforeach;
                                                        $details = str_replace(": ,", ": ", $details);
                                                    }
                                                } else if ($product_type == "Loan Account" && $name == "Interest Waiver") {
                                                    $details  = "Days to Due: ". $qpn["days_to_due"];
                                                } else if ($product_type == "Customer" && $name == "Age Policy") {
                                                    $details  = "Min Age: ". $qpn["min_age"]. ", Max Age: ". $qpn["max_age"];
                                                } else if ($product_type == "Customers in Union") {
                                                    $details  = "Min Customers: ". $qpn["min_age"]. ", Max Customers: ". $qpn["max_age"];
                                                } else if ($product_type == "Customer" && $name == "ID Validation") {
                                                    $details  = "Force ID Validation: ".$qpn["validate_identity"]. ", ID Type: ".$qpn["id_type"].", Multiple ID Usage: ".$qpn["duplicate_id"];
                                                } else if ($product_type == "Customer" && $name == "Require Profile Photo") {
                                                    $details  = "Require Profile Photo: Yes";
                                                } else if ($product_type == "Customer" && $name == "Require Address") {
                                                    $details  = "Require Address: Yes";
                                                } else if ($product_type == "Customer" && $name == "Require Phone") {
                                                    $details  = "Require Phone: Yes";
                                                } else if ($product_type == "Customer" && $name == "Require Email") {
                                                    $details  = "Require Email: Yes";
                                                } else if ($product_type == "Loan Account" && $name == "Guarantor") {
                                                    $details  = "Min Age: ". $qpn["min_age"]. ", Max Age: ". $qpn["max_age"]."</br> Maximum Existing Guaranteed Loan:". $qpn["max_existing_guaranteed_loans"]. ", Reject if Impaired:". $qpn["reject_if_impired"].", Force ID Validation:". $qpn["force_id_validation"].", Force Guarantor Upload:". $qpn["force_g_upload"];
                                                } else if ($product_type == "Customer" && $name == "Require Signature") {
                                                    $details  = "Require Signature: Yes";
                                                } else if ($product_type == "Disable Multiple Workflow Transactions") {
                                                    $details  = "Disable Multiple Workflow Transactions: Yes";
                                                } else if ($product_type == "Transaction Reversal") {
                                                    $details  = "Reversal Order: ". $qpn["trv_order"];
                                                } else if ($product_type == "Force Union Purse") {
                                                    $unsz = $db -> prepare('SELECT name FROM savingsproduct WHERE id =?');
                                                    $unsz->bind_param('i', $qpn["name"]);
                                                    $unsz->execute();
                                                    $runsz = $unsz->get_result();
                                                    if($runsz->num_rows >0) {
                                                        while($unzi = mysqli_fetch_array($runsz) ){
                                                            $product_name_uzn = $unzi['name'];
                                                        }
                                                    }

                                                    $details  = "Union Savings Product: <b>". $product_name_uzn."</b>";
                                                } else if ($product_type == "Current Account" && $name == "Account Reference") {
                                                    $details  = "Minimum Reference: ". $qpn["min_age"];
                                                } else if ($product_type == "Current Account" && $name == "Account Reference") {
                                                    $details  = "Minimum Reference: ". $qpn["min_age"];
                                                } else if ($product_type == "Daily Transaction Limit") {
                                                    $details  = "Limit: ". $qpn["t_limit"]. ", Event: ". $qpn["t_event"];
                                                }
                                                
                                                if($channels !="") {
                                                    $channelarray = explode(' , ',$channels);
                                                } else {
                                                    $channelarray = [];  
                                                }

                                                if($affected_branches !="") {
                                                    $brancharray = explode(' , ',$affected_branches);
                                                } else {
                                                    $brancharray = [];  
                                                }

                                                if($affected_products !="") {
                                                    $productssarray = explode(' , ',$affected_products);
                                                } else {
                                                    $productssarray = [];  
                                                }
                                            ?>

                                            <tr>
                                            <td class="center"><?php echo $product_type; ?></td>
                                            <td class="center"><?php 
                                                if ($product_type == "Force Union Purse" || $product_type == "Maximum Group Per Relationship Officer" || $product_type == "Maximum Individual Client Per Relationship Officer") {
                                                    echo "-";
                                                } else {
                                                    echo $name;
                                                }
                                            ?></td>
                                            <td class="center"><?php 
                                            
                                            if ($product_type == "Loan Account" && $name == "Loan Amount Increment") {
                                                $opp2 = $db -> prepare('SELECT name, increment_ami FROM loanproduct l, loan_amount_increment i WHERE l.id=i.product_id AND i.policy_id =?');
                                                $opp2->bind_param("i", $pndid);
                                                $opp2->execute();
                                                $ropp2 = $opp2->get_result();
                                                while($oik = mysqli_fetch_assoc($ropp2) ){
                                                    echo $oik["name"]." - ". $oik["increment_ami"]. "%</br>";
                                                }
                                            } else if ($product_type == "Loan Account" && $name == "Guarantor") {
                                                $opp2 = $db -> prepare('SELECT name, value FROM loanproduct l, loan_product_guarantor i WHERE l.id=i.product_id AND i.policy_id =?');
                                                $opp2->bind_param("i", $pndid);
                                                $opp2->execute();
                                                $ropp2 = $opp2->get_result();
                                                while($oik = mysqli_fetch_assoc($ropp2) ){
                                                    echo $oik["name"]." - ". $oik["value"]. " guarantor(s)</br>";
                                                }
                                            } else if ($product_type == "Loan Account" && $name == "Minimum Loan Amount") {
                                            
                                                $opp2 = $db -> prepare('SELECT name, min_amount, max_amount FROM loanproduct l, loan_minimum i WHERE l.id=i.product_id AND i.policy_id =?');
                                                $opp2->bind_param("i", $pndid);
                                                $opp2->execute();
                                                $ropp2 = $opp2->get_result();
                                                while($oik = mysqli_fetch_assoc($ropp2) ){
                                                    echo "<b>".$oik["name"].":</b>  Range: ". $oik["min_amount"] ." - ". $oik["max_amount"]."</br>";
                                                }
                                            
                                            } else {
                                                echo $details;
                                            }
                                             ?></td>
                                            <td>
                                                <?php
                                                $brn_name = "";
                                                if(!empty($brancharray)) {
                                                   foreach ($brancharray as $bra):
                                                    $bra = trim($bra);
                                                   $nmb = $db -> prepare('SELECT name FROM branch WHERE id=?');
                                                   $nmb -> bind_param('s', $bra);
                                                   $nmb -> execute();
                                                   $rnmb = $nmb->get_result();
                                                
                                                   while($qbr = mysqli_fetch_assoc($rnmb) ){
                                                       $brn_name = $qbr["name"];
                                                   }
                                                
                                                   echo ", ".$brn_name;
                                                
                                                   endforeach;
                                                } else {
                                                   echo "-";
                                                }
                                                ?>
                                            </td>
                                            <td>

                                            <?php
                                            $pr_name = "";
                                             if(!empty($productssarray)) {
                                                foreach ($productssarray as $pra):
                                                $rsn = $db -> prepare('SELECT name FROM globalproducts WHERE global_pid=?');
                                                $rsn -> bind_param('s', $pra);
                                                $rsn -> execute();
                                                $rrsn = $rsn->get_result();

                                                while($rar = mysqli_fetch_assoc($rrsn) ){
                                                    $pr_name = $rar["name"];
                                                }

                                                echo ", ".$pr_name;

                                                endforeach;
                                            } else {
                                                echo "-";
                                            }


                                            ?>

                                            </td>
                                            <td>

                                            <?php
                                            $ch_name = "";
                                            if(!empty($channelarray)) {
                                                foreach ($channelarray as $car):
                                                    $chr = $db -> prepare('SELECT name FROM channel WHERE id=?');
                                                    $chr -> bind_param('i', $car);
                                                    $chr -> execute();
                                                    $rchr = $chr->get_result();
    
                                                    while($tch = mysqli_fetch_assoc($rchr) ){
                                                        $ch_name = $tch["name"];
                                                    }
    
                                                    echo "-".$ch_name."</br>";
    
                                                    endforeach;
                                            } else {
                                                echo "-";
                                            }
                                                


                                            ?>

                                            </td>
                                            <td class="center"><?php echo $status; ?></td>
                                            <td class="center"><?php echo $datetime; ?></td>
                                            <td class="center"><?php echo $last_updated; ?></td>
                                            <td class="center"><button type="button" id="<?php echo $pndid; ?>" class="btn btn-default btn-s pupdate" <?php if($createPolicy == 1 && $user_role !=1) { echo "disabled"; } ?>>Update</button></td>
                                            </tr>

                                            <?php
                                                
                                            }
                                        }

                                        ?>
                                    </tbody>
                                </table>
								
																															
										
								</div>
							</div>
							
					</div>

                    <div id="policyModal" class="modal fade">
									<div class="modal-dialog white">
                                        <form id="policy_form" method="POST" action="add_policy">
											<div class="modal-content white">
												<div class="modal-body">

                                                <h3 class="text-center">Add Policy</h3>
                                                <div class="divider"></div>

                                                <div class="form-group col-md-12">
                                                    <label for="product_type">Entity</label>
                                                    <select name="product_type" class="form-control select2 select2-hidden-accessible product_type" id="product_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                    <option></option>
                                                    <option value="Customer">Customer</option>
                                                    <option value="Customers in Union">Customers in Union</option>
                                                    <option value="Account Documents">Account Documents</option>
                                                    <option value="Account Approvals">Account Approvals</option>
                                                    <option value="Savings Account">Savings Account</option>
                                                    <option value="Loan Account">Loan Account</option>
                                                    <option value="Thrift Account">Thrift Account</option>
                                                    <option value="Term Deposit Account">Term Deposit Account</option>
                                                    <option value="Current Account">Current Account</option>
                                                    <option value="Transaction Reversal">Transaction Reversal</option>
                                                    <option value="Disable Multiple Workflow Transactions">Disable Multiple Workflow Transactions</option>
                                                    <option value="Daily Transaction Limit">Daily Transaction Limit</option>
                                                    <option value="Missing Identification">Missing Identification</option>
                                                    <option value="Force Union Purse">Force Union Purse</option>
                                                    <option value="Maximum Group Per Relationship Officer">Maximum Group Per Relationship Officer</option>
                                                    <option value="Maximum Individual Client Per Relationship Officer">Maximum Individual Client Per Relationship Officer</option>
                                                    </select>
                                                </div>

                                                <div id="mgpcso" style="display:none">

                                                    <div class="form-group col-md-6">
                                                        <label for="maximum_group">Maximum Group</label>
                                                        <input type="number" class="form-control maximum_group rmzo" name="maximum_group" id="maximum_group" placeholder="Enter Maximum Group">
                                                    </div>

                                                </div>

                                                <div id="mcpcso" style="display:none">

                                                    <div class="form-group col-md-6">
                                                        <label for="maximum_client">Maximum Client</label>
                                                        <input type="number" class="form-control maximum_client rmzo" name="maximum_client" id="maximum_client" placeholder="Enter Maximum Client">
                                                    </div>

                                                </div>
                                                <div id="msid" style="display:none">
                                                            <div class="form-group col-md-12">
                                                                <label for="identity_type">ID Type</label>
                                                                <select name="identity_type" class="form-control select2 select2-hidden-accessible identity_type" id="identity_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="BVN">BVN</option>
                                                                    <!--<option value="NIN">NIN</option>
                                                                    <option value="Drivers License">Drivers License</option>
                                                                    <option value="Voters Card">Voters Card</option>
                                                                    <option value="International Passport">International Passport</option>
                                                                    <option value="ID Card">ID Card</option>-->
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="restrict_events_msid">Restrict Events (<span id="ctunchedked_r_msid"> Select All </span><input type="checkbox" id="ctselected_r_msid">)</label>
                                                                <select name="restrict_events_msid[]" class="form-control select2 select2-hidden-accessible restrict_events_msid" id="restrict_events_msid" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Events" multiple>
                                                                <option value="Credit Transactions">Credit Transactions</option>
                                                                <option value="Debit Transactions">Debit Transactions</option>
                                                                </select>
                                                            </div>
                                                </div>
                                                
                                                <div id="cos_in_u" style="display:none">  
                                                        <div class="form-group col-md-6">
                                                            <label for="min_customers">Minimum Customers <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the minimum customers allowed before a group can be opened"></i></label>
                                                            <input type="number" class="form-control min_customers rmzo" name="min_customers" id="min_customers" placeholder="Enter Minimum Customer">
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="max_customers">Maximum Customers <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum customers allowed in a group"></i></label>
                                                            <input type="number" class="form-control max_customers rmzo" name="max_customers" id="max_customers" placeholder="Enter Maximum Customer">
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                                <label for="exempt_branch" class="control-label">Exempt Branches</label>
                                                                <select name="exempt_branch[]" class="form-control select2 select2-hidden-accessible exempt_branch" id="exempt_branch" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Branches Exempt" multiple>
                                                                <?php
                                                                $active = "Active";
                                                                $one = 1;
                                                               if($org_structure == 1) {
                                                                $exbr = $db -> prepare('SELECT id, name FROM branch WHERE status =? AND id !=? AND (id NOT IN(SELECT id FROM branch WHERE parent=?) AND  id NOT IN(SELECT id FROM branch WHERE parent IN(SELECT id FROM branch WHERE parent=?)))');
                                                                $exbr->bind_param('siii', $active, $one, $one, $one);
                                                                $exbr->execute();
                                                                $rexbr = $exbr->get_result();
                                                               } else {
                                                                $exbr = $db -> prepare('SELECT id, name FROM branch WHERE status =? AND id !=?');
                                                                $exbr->bind_param('si', $active, $one);
                                                                $exbr->execute();
                                                                $rexbr = $exbr->get_result();
                                                               }
                                                            
                                                                    if($rexbr->num_rows >0) {
                                                                        while($ieb = mysqli_fetch_array($rexbr) ){
                                                                        $exbid = $ieb['id'];
                                                                        $exb_name = $ieb['name'];
                                                                        echo "<option value='$exbid'>" . $exb_name . "</option>";
                                                                        }
                                                                    }
                                                                ?>
                                                                </select>

                                                            </div>
                                                </div>

                                                <div id="unps" style="display:none">

                                                        <div class="form-group col-md-12">
                                                                <label for="union_savings" class="control-label">Union Savings Product</label>
                                                                <select name="union_savings" class="form-control select2 select2-hidden-accessible union_savings" id="union_savings" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Union Savings Products">
                                                                <?php
                                                                    $active = "Active";
                                                                
                                                                    $unsv = $db -> prepare('SELECT * FROM savingsproduct WHERE status =?');
                                                                    $unsv->bind_param('s', $active);
                                                                    $unsv->execute();
                                                                    $runsv = $unsv->get_result();
                                                                    if($runsv->num_rows >0) {
                                                                        while($unvi = mysqli_fetch_array($runsv) ){
                                                                            $product_id_uns = $unvi['id'];
                                                                            $product_name_uns = $unvi['name'];
                                                                        echo "<option value='$product_id_uns'>" . $product_name_uns . "</option>";
                                                                        }
                                                                    } ?>
                                                                </select>
                                                        </div>

                                                </div>

                                                <div id="cus" style="display:none">
                                                    <div class="form-group col-md-12">
                                                            <label for="type_cus">Type</label>
                                                            <select name="type_cus" class="form-control select2 select2-hidden-accessible type_cus" id="type_cus" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Type">
                                                            <option></option>
                                                            <option value="Age Policy">Age Policy</option>
                                                            <option value="ID Validation">ID Validation</option>
                                                            <option value="Require Profile Photo">Require Profile Photo</option>
                                                            <option value="Require Signature">Require Signature</option>
                                                            <option value="Require Address">Require Address</option>
                                                            <option value="Require Phone">Require Phone</option>
                                                            <option value="Require Email">Require Email</option>
                                                            </select>
                                                        </div>
                                                    <div id="age_policy" style="display:none">  
                                                        <div class="form-group col-md-6">
                                                            <label for="min_age_c">Minimum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the minimum age allowed be a customer"></i></label>
                                                            <input type="number" class="form-control min_age_c rmzo" name="min_age_c" id="min_age_c" placeholder="Enter Minimum Age">
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="max_age_c">Maximum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum age allowed to be a customer"></i></label>
                                                            <input type="number" class="form-control max_age_c rmzo" name="max_age_c" id="max_age_c" placeholder="Enter Maximum Age">
                                                        </div>
                                                    </div>
                                                    <div id="identity_policy" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <label for="validate_identity">Force Identity Validation</label>
                                                            <select name="validate_identity" class="form-control select2 select2-hidden-accessible validate_identity" id="validate_identity" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                            <option></option>
                                                            <option value="Yes">Yes</option>
                                                            <option value="No">No</option>
                                                            </select>
                                                        </div>

                                                        <div id="idv" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                <label for="id_type">ID type</label>
                                                                <select name="id_type" class="form-control select2 select2-hidden-accessible id_type" id="id_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                <option></option>
                                                                <option value="BVN">BVN</option>
                                                                <!--<option value="NIN">NIN</option>-->
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="duplicate_id">Can a single ID be used by multiple customers?</label>
                                                                <select name="duplicate_id" class="form-control select2 select2-hidden-accessible duplicate_id" id="duplicate_id" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                <option></option>
                                                                <option value="Yes">Yes</option>
                                                                <option value="No">No</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>
                                                <div id="trlimit" style="display:none">

                                                        <div class="form-group col-md-12">
                                                            <label for="tr_type">Type</label>
                                                            <select name="tr_type" class="form-control select2 select2-hidden-accessible tr_type" id="tr_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                            <option></option>
                                                            <option value="Global">Global</option>
                                                            <option value="Channel">Channel</option>
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label for="t_event">Event</label>
                                                            <select name="t_event" class="form-control select2 select2-hidden-accessible t_event" id="t_event" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                            <option></option>
                                                            <option value="Deposit">Deposit</option>
                                                            <option value="Withdrawal">Withdrawal</option>
                                                            <option value="Transfer">Transfer</option>
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label for="t_limit">Limit Amount</label>
                                                            <input type="number" class="form-control t_limit rmzo" name="t_limit" id="t_limit" placeholder="Enter Limit Amount">
                                                        </div>

                                                        <div class="form-group col-md-4 tchanel" style="display:none">
                                                            <label for="t_channel">Channel</label>
                                                            <select name="t_channel" class="form-control select2 select2-hidden-accessible t_channel" id="t_channel" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                            <option></option>
                                                            <?php
                                                                $status_all = "Active";
                                                                $cng = $db -> prepare('SELECT * FROM channel WHERE status=?');
                                                                $cng->bind_param("s", $status_all);
                                                                $cng->execute();
                                                                $rcng = $cng->get_result();
                                                                ?>
                                                                    <?php
                                                                    while($pke = mysqli_fetch_array($rcng) ){
                                                                        $cnlid = $pke['id'];
                                                                        $cnlname = $pke['name'];
                                                                    ?>
                                                                        <option value="<?php echo $cnlid; ?>"><?php echo $cnlname; ?></option>
                                                                    <?php } ?>
                                                            
                                                            </select>
                                                        </div>
                                                    
                                                </div>
                                                <div id="adc" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <label for="require_doc_upload">Require Document Upload</label>
                                                            <select name="require_doc_upload" class="form-control select2 select2-hidden-accessible require_doc_upload" id="require_doc_upload" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                <option></option>
                                                                <option value="Yes" selected>Yes</option>
                                                                <option value="No">No</option>
                                                            </select>
                                                        </div>
                                                </div>

                                                <div id="sav" style="display:none">

                                                    <div class="form-group col-md-12">
                                                            <label for="type_sav">Type</label>
                                                            <select name="type_sav" class="form-control select2 select2-hidden-accessible type_sav" id="type_sav" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Type">
                                                            <option></option>
                                                            <option value="Account Opening">Account Opening</option>
                                                            <option value="Interest on Savings">Interest on Savings</option>
                                                            <option value="Dormancy">Dormancy</option>
                                                            <option value="Escheat">Escheat</option>
                                                            <option value="Overdraft">Overdraft</option>
                                                            </select>
                                                        </div>
                                                    <div id="sav_trns" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <label for="rule_type">Rule</label>
                                                            <select name="rule_type" class="form-control select2 select2-hidden-accessible rule_type" id="rule_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Rule">
                                                            <option></option>
                                                            <option value="No Rule">No Rule</option>
                                                            <option value="No of Withdrawal Per Compounding Period">No of Withdrawal Per Compounding Period</option>
                                                            <option value="Deposit Age Rule">Deposit Age Rule</option>
                                                            </select>
                                                        </div>

                                                        <div class="panel panel-default col-md-12" id="info" style="display: none">
                                                            <div class="panel-heading bg-primary text-white">
                                                            <b>Details</b>
                                                            <p class="card-text info_mess"></p>
                                                            </div>
                                                            
                                                        </div>

                                                        <div id="withpc" style="display:none">

                                                            <div class="form-group col-md-12">
                                                            <label for="nowithdrawal">No of Withdrawal per Compounding Period</label>
                                                                <input type="number" class="form-control nowithdrawal rmzo" name="nowithdrawal" id="nowithdrawal" placeholder="Enter no of Withdrawal">
                                                            </div>

                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="min_hours_daily_compounding">Minimum Hours for Daily Interest Compounding <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter 0 to deactivate. Enter any value to activate. If activated, daily interest will only be compounded for deposits that fall within the specified hours"></i></label>
                                                            <input type="number" class="form-control min_hours_daily_compounding rmzo" name="min_hours_daily_compounding" id="min_hours_daily_compounding" value="0" placeholder="Enter Hours">
                                                        </div>
                                                    </div>

                                                    <div id="sav_ao" style="display:none">
                                                            <div class="form-group col-md-6">
                                                                <label for="min_age">Minimum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the minimum age allowed to access account for each selected products"></i></label>
                                                                <input type="number" class="form-control min_age rmzo" name="min_age" id="min_age" placeholder="Enter Minimum Age">
                                                            </div>

                                                            <div class="form-group col-md-6">
                                                                <label for="max_age">Maximum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum age allowed to access account for each selected products"></i></label>
                                                                <input type="number" class="form-control max_age rmzo" name="max_age" id="max_age" placeholder="Enter Maximum Age">
                                                            </div>

                                                    </div>
                                                    <div id="sav_dom" style="display:none">
                                                            <div class="form-group col-md-12">
                                                                <label for="days_of_inactivity_s">Days of Inactivity <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Note: this policy can only work if Track Dormancy is set to yes in product configuration. Enter the maximum days selected savings products can remain inactive before moving to dormant"></i></label>
                                                                <input type="number" class="form-control days_of_inactivity_s rmzo" name="days_of_inactivity_s" id="days_of_inactivity_s" placeholder="Enter Days of Inactivity">
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="restrict_events">Restrict Events (<span id="ctunchedked_r"> Select All </span><input type="checkbox" id="ctselected_r">)</label>
                                                                <select name="restrict_events[]" class="form-control select2 select2-hidden-accessible restrict_events" id="restrict_events" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Events" multiple>
                                                                <option value="Credit Transactions">Credit Transactions</option>
                                                                <option value="Debit Transactions">Debit Transactions</option>
                                                                <option value="Update alert phone number">Update alert phone number</option>
                                                                <option value="Update alert email">Update alert email</option>
                                                                <option value="Update customer profile">Update customer profile</option>
                                                                <option value="Update identification">Update identification</option>
                                                                <option value="Card request">Card request</option>
                                                                <option value="Cheque book request">Cheque book request</option>
                                                                </select>
                                                            </div>
                                                    </div>

                                                    <div id="sav_escht" style="display:none">
                                                            <div class="form-group col-md-12">
                                                                <label for="days_to_escheat">Days to Escheat <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the days selected savings products can remain inactive before moving to escheat"></i></label>
                                                                <input type="number" class="form-control days_to_escheat rmzo" name="days_to_escheat" id="days_to_escheat" placeholder="Enter Days to Escheat">
                                                            </div>

                                                    </div>

                                                    <div id="sav_ovd" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <label for="max_overdraft_s">Maximum Overdraft Amount <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Note: this policy can only work if Allow Overdraft is set to yes in product configuration. Enter the maximum amount selected savings products can have as overdraft"></i></label>
                                                            <input type="number" min="0" step=".01" data-maxlength="3000" formnovalidate="formnovalidate" class="form-control max_overdraft_s rmzo" name="max_overdraft_s" id="max_overdraft_s" placeholder="Enter Maximum Overdraft Amount">
                                                        </div>

                                                    </div>
                                                </div>

                                                <div id="lon" style="display:none">

                                                    <div class="form-group col-md-12">
                                                            <label for="type_lon">Type</label>
                                                            <select name="type_lon" class="form-control select2 select2-hidden-accessible type_lon" id="type_lon" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Type">
                                                            <option></option>
                                                            <option value="Maximum Loan Accounts">Maximum Loan Accounts</option>
                                                            <option value="Loan Disbursement">Loan Disbursement</option>
                                                            <option value="Guarantor">Guarantor</option>
                                                            <option value="Access Loan on Loan">Access Loan on Loan</option>
                                                            <option value="Loan Amount Increment">Loan Amount Increment</option>
                                                            <option value="Minimum Loan Amount">Minimum Loan Amount</option>
                                                            <option value="Overdue Rule">Overdue Rule</option>
                                                            <option value="Interest Waiver">Interest Waiver</option>
                                                            </select>
                                                        </div>

                                                    <div id="lon_ao" style="display:none">
                                                            <div class="form-group col-md-6">
                                                                <label for="min_age_l">Minimum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the minimum age allowed to access loan for each selected products. If Guarantor, enter the minimum age that can be accepted as guarantor"></i></label>
                                                                <input type="number" class="form-control min_age_l rmzo" name="min_age_l" id="min_age_l" placeholder="Enter Minimum Age">
                                                            </div>

                                                            <div class="form-group col-md-6">
                                                                <label for="max_age_l">Maximum Age <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum age allowed to access loan for each selected products. If Guarantor, enter the maximum age that can be accepted as guarantor"></i></label>
                                                                <input type="number" class="form-control max_age_l rmzo" name="max_age_l" id="max_age_l" placeholder="Enter Maximum Age">
                                                            </div>

                                                    </div>
                                                    <div id="lon_max" style="display:none">
                                                            <div class="form-group col-md-12">
                                                                <label for="max_products">Maximum Loans <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum number of active loans a customer is allowed to have. 1 means only 1 loan product can be active for a customer at a time."></i></label>
                                                                <input type="number" class="form-control max_products rmzo" name="max_products" id="max_products" placeholder="Enter Maximum Loans">
                                                            </div>
                                                            <div class="form-group col-md-12">
                                                                <label for="included_loan" class="control-label">Included</label>
                                                                <select name="included_loan[]" class="form-control select2 select2-hidden-accessible included_loan" id="included_loan" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Included Products" multiple>
                                                                <?php
                                                                    $active = "Active";
                                                                
                                                                    $incl = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                                    $incl->bind_param('s', $active);
                                                                    $incl->execute();
                                                                    $rincl = $incl->get_result();
                                                                    if($rincl->num_rows >0) {
                                                                        while($icnp = mysqli_fetch_array($rincl) ){
                                                                            $product_id_icl = $icnp['id'];
                                                                            $product_name_icl = $icnp['name'];
                                                                        echo "<option value='$product_id_icl'>" . $product_name_icl . "</option>";
                                                                        }
                                                                    } ?>
                                                                </select>

                                                            </div>

                                                    </div>
                                                    <div id="lon_alol" style="display:none">
                                                            <div class="form-group col-md-6">
                                                                <label for="min_total_paid">Total Paid Percentage <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="The customer can only access another loan if he has paid up to the minimum percentage or has not paid above the maximum percentage set here. "></i></label>
                                                                <input type="number" class="form-control min_total_paid rmzo" name="min_total_paid" id="min_total_paid" placeholder="Enter Minimum %">
                                                            </div>

                                                            <div class="form-group col-md-6">
                                                                <label for="max_total_paid"> </label>
                                                                <input type="number" class="form-control max_total_paid rmzo" name="max_total_paid" id="max_total_paid" placeholder="Enter Maximum %">
                                                            </div>
                                                            <div class="form-group col-md-12">
                                                                <label for="side_loan" class="control-label">Side Loan Product</label>
                                                                <select name="side_loan[]" class="form-control select2 select2-hidden-accessible side_loan" id="side_loan" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Side Products" multiple>
                                                                <?php
                                                                    $active = "Active";
                                                                
                                                                    $sncl = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                                    $sncl->bind_param('s', $active);
                                                                    $sncl->execute();
                                                                    $rsncl = $sncl->get_result();
                                                                    if($rsncl->num_rows >0) {
                                                                        while($scnp = mysqli_fetch_array($rsncl) ){
                                                                            $product_id_scl = $scnp['id'];
                                                                            $product_name_scl = $scnp['name'];
                                                                        echo "<option value='$product_id_scl'>" . $product_name_scl . "</option>";
                                                                        }
                                                                    } ?>
                                                                </select>
                                                            </div>
                                                    </div>

                                                    <div id="lon_amincp" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <table class="table table-bordered" style="width:100%">
                                                                <thead>
                                                                    <tr><td colspan="3"><a class="btn btn-info pull-right btn-sm add_col_ami">Add Product</a></td></tr>
                                                                    <tr>
                                                                        <th>Product</th>
                                                                        <th>% Increment</th>
                                                                        <th></th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody id="tbody_ami">
                                                                                            
                                                                    </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div id="lon_amincp_min" style="display:none">
                                                        <div class="form-group col-md-12">
                                                            <table class="table table-bordered" style="width:100%">
                                                                <thead>
                                                                    <tr><td colspan="3"><a class="btn btn-info pull-right btn-sm add_col_ami_min">Add Product</a></td></tr>
                                                                    <tr>
                                                                        <th>Product</th>
                                                                        <th>Range</th>
                                                                        <th></th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody id="tbody_ami_min">
                                                                                            
                                                                    </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    

                                                    <div id="lon_gua" style="display:none">

                                                            <div class="form-group col-md-6">
                                                                <label for="max_existing_guaranteed_loans">Maximum Existing Guaranteed Loans <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the maximum existing loans each guarantor can guarantee"></i></label>
                                                                <input type="number" class="form-control max_existing_guaranteed_loans rmzo" name="max_existing_guaranteed_loans" id="max_existing_guaranteed_loans" placeholder="Enter Maximum Existing Guaranteed Loans">
                                                            </div>
                                                            
                                                            <div class="form-group col-md-6">
                                                                <label for="reject_if_impired">Reject if Impaired</label>
                                                                <select name="reject_if_impired" class="form-control select2 select2-hidden-accessible reject_if_impired" id="reject_if_impired" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="Yes">Yes</option>
                                                                    <option value="No">No</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-6">
                                                                <label for="force_id_validation">Force Guarantor ID Validation</label>
                                                                <select name="force_id_validation" class="form-control select2 select2-hidden-accessible force_id_validation" id="force_id_validation" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="Yes">Yes</option>
                                                                    <option value="No">No</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-6">
                                                                <label for="force_g_upload">Force Guarantor Upload</label>
                                                                <select name="force_g_upload" class="form-control select2 select2-hidden-accessible force_g_upload" id="force_g_upload" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="Yes">Yes</option>
                                                                    <option value="No">No</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group col-md-6 flat_charge" style="display:none">
                                                                <label for="flat_guarantor_charge">Flat Guarantor Charge <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="If this is turned to yes, it means that the amount set as guarantor validation charge will always be charged regardless of the number of guarantors validated. Else, the charge will be based on the number of guarantors validated."></i></label>
                                                                <select name="flat_guarantor_charge" class="form-control select2 select2-hidden-accessible flat_guarantor_charge" id="flat_guarantor_charge" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="Yes">Yes</option>
                                                                    <option value="No" selected>No</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <table class="table table-bordered" style="width:100%">
                                                                    <thead>
                                                                        <tr><td colspan="3"><a class="btn btn-info pull-right btn-sm add_col_gua">Add Product</a></td></tr>
                                                                        <tr>
                                                                            <th>Product</th>
                                                                            <th>Guarantor</th>
                                                                            <th></th>
                                                                        </tr>
                                                                        </thead>
                                                                        <tbody id="tbody_gua">
                                                                                                
                                                                        </tbody>
                                                                </table>
                                                            </div>
                                                    </div>

                                                    <div id="lon_trns" style="display:none">


                                                    </div>

                                                    <div id="lon_intwv" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                <label for="days_to_due">Days to Due <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter number of days before the loan is due to qualify it for interest waiver. Enter 0 to disable check"></i></label>
                                                                <input type="number" class="form-control days_to_due rmzo" name="days_to_due" id="days_to_due" placeholder="Enter Days to Due">
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="affected_branches" class="control-label">Affected Branches (<span id="ctunchedked_ab"> Select All </span><input type="checkbox" id="ctselected_ab">)</label>
                                                                <select name="affected_branches[]" class="form-control select2 select2-hidden-accessible affected_branches" id="affected_branches" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Affected Branches" multiple>
                                                                <?php
                                                                $active = "Active";
                                                                $one = 1;
                                                                if($org_structure == 1) {
                                                                    $abfn = $db -> prepare('SELECT id, name FROM branch WHERE status =? AND id !=? AND (id NOT IN(SELECT id FROM branch WHERE parent=?) AND  id NOT IN(SELECT id FROM branch WHERE parent IN(SELECT id FROM branch WHERE parent=?)))');
                                                                    $abfn->bind_param('siii', $active, $one, $one, $one);
                                                                    $abfn->execute();
                                                                    $rabfn = $abfn->get_result();
                                                                } else {
                                                                    $abfn = $db -> prepare('SELECT id, name FROM branch WHERE status =? AND id !=?');
                                                                    $abfn->bind_param('si', $active, $one);
                                                                    $abfn->execute();
                                                                    $rabfn = $abfn->get_result();
                                                                }
                                                            
                                                                    if($rabfn->num_rows >0) {
                                                                        while($ibn = mysqli_fetch_array($rabfn) ){
                                                                        $brnid = $ibn['id'];
                                                                        $brn_name = $ibn['name'];
                                                                        echo "<option value='$brnid'>" . $brn_name . "</option>";
                                                                        }
                                                                    }
                                                                ?>
                                                                </select>

                                                            </div>
                                                    </div>

                                                    

                                                </div>

                                                <div id="thf" style="display:none">

                                                </div>

                                                <div id="tdf" style="display:none">

                                                </div>

                                                <div id="cur" style="display:none">
                                                    <div class="form-group col-md-12">
                                                        <label for="type_cur">Type</label>
                                                        <select name="type_cur" class="form-control select2 select2-hidden-accessible type_cur" id="type_cur" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Type">
                                                        <option></option>
                                                        <option value="Account Reference">Account Reference</option>
                                                        </select>
                                                    </div>

                                                    <div id="cur_aref" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                <label for="minimum_reference">Minimum Reference <i class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="right" title="Enter the minimum required reference to open a current account"></i></label>
                                                                <input type="number" class="form-control minimum_reference rmzo" name="minimum_reference" id="minimum_reference" placeholder="Minimum Reference">
                                                            </div>
                                                    </div>

                                                </div>

                                                <div id="trv" style="display:none">

                                                        <div class="form-group col-md-12">
                                                            <label for="trv_order">Reversal Order</label>
                                                            <select name="trv_order" class="form-control select2 select2-hidden-accessible trv_order" id="trv_order" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Order">
                                                            <option></option>
                                                            <option value="LIFO">LIFO</option>
                                                            </select>
                                                        </div>


                                                </div>

                                                <div id="afprd2" style="display:none">
													<div class="form-group col-md-12">
													    <label for="affected_products_all" class="control-label">Affected Products (<span id="ctunchedked_all"> Select All </span><input type="checkbox" id="ctselected_all">)</label>
														<select name="affected_products_all[]" class="form-control select2 select2-hidden-accessible affected_products_all" id="affected_products_all" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Affected Products" multiple>
                                                        <?php
                                                        $active = "Active";
                                                        $svp = $db -> prepare('SELECT * FROM savingsproduct WHERE status =?');
                                                        $svp->bind_param('s', $active);
                                                        $svp->execute();
                                                        $rsvp = $svp->get_result();
                                                    
                                                            if($rsvp->num_rows >0) {
                                                                while($i1 = mysqli_fetch_array($rsvp) ){
                                                                $product_id = $i1['id'];
                                                                $product_name = $i1['name'];
                                                                echo "<option value='S$product_id'>" . $product_name . "</option>";
                                                                }
                                                            }
                                                    
                                                        
                                                            $lpr = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                            $lpr->bind_param('s', $active);
                                                            $lpr->execute();
                                                            $rlpr = $lpr->get_result();
                                                            if($rlpr->num_rows >0) {
                                                                while($il1 = mysqli_fetch_array($rlpr) ){
                                                                    $product_id_l = $il1['id'];
                                                                    $product_name_l = $il1['name'];
                                                                echo "<option value='L$product_id_l'>" . $product_name_l . "</option>";
                                                                }
                                                            }
                                                        
                                                            $tft = $db -> prepare('SELECT * FROM thriftproduct WHERE status =?');
                                                            $tft->bind_param('s', $active);
                                                            $tft->execute();
                                                            $rtft = $tft->get_result();
                                                            if($rtft->num_rows >0) {
                                                                while($it1 = mysqli_fetch_array($rtft) ){
                                                                    $product_id_t = $it1['id'];
                                                                    $product_name_t = $it1['name'];
                                                                echo "<option value='T$product_id_t'>" . $product_name_t . "</option>";
                                                                }
                                                            }
                                                        
                                                            $tdp = $db -> prepare('SELECT * FROM term_deposit_product WHERE status =?');
                                                            $tdp->bind_param('s', $active);
                                                            $tdp->execute();
                                                            $rtdp = $tdp->get_result();
                                                            if($rtdp->num_rows >0) {
                                                                while($itd1 = mysqli_fetch_array($rtdp) ){
                                                                    $product_id_td = $itd1['id'];
                                                                    $product_name_td = $itd1['name'];
                                                                echo "<option value='TD$product_id_td'>" . $product_name_td . "</option>";
                                                                }
                                                            }
                                                    
                                                            $crr = $db -> prepare('SELECT * FROM currentproduct WHERE status =?');
                                                            $crr->bind_param('s', $active);
                                                            $crr->execute();
                                                            $rcrr = $crr->get_result();
                                                            if($rcrr->num_rows >0) {
                                                                while($ctr = mysqli_fetch_array($rcrr) ){
                                                                    $product_id_cr = $ctr['id'];
                                                                    $product_name_cr = $ctr['name'];
                                                                echo "<option value='C$product_id_cr'>" . $product_name_cr . "</option>";
                                                                }
                                                            }
                                                    
                                                            $flt = $db -> prepare('SELECT * FROM floatproduct WHERE status =?');
                                                            $flt->bind_param('s', $active);
                                                            $flt->execute();
                                                            $rflt = $flt->get_result();
                                                            if($rflt->num_rows >0) {
                                                                while($ftr = mysqli_fetch_array($rflt) ){
                                                                    $product_id_fl = $ftr['id'];
                                                                    $product_name_fl = $ftr['name'];
                                                                echo "<option value='F$product_id_fl'>" . $product_name_fl . "</option>";
                                                                }
                                                            }
                                                    
                                                        ?>
                                                        </select>

													</div>
                                                </div>

                                                <div id="afprd" style="display:none">
													<div class="form-group col-md-12">
													    <label for="affected_products" class="control-label">Affected Products (<span id="ctunchedked"> Select All </span><input type="checkbox" id="ctselected">)</label>
														<select name="affected_products[]" class="form-control select2 select2-hidden-accessible affected_products" id="affected_products" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Affected Products" multiple>

                                                        </select>

													</div>
                                                </div>
                                                <div id="afchnl" style="display:none">
                                                    <div class="form-group col-md-12">
                                                            <label for="channels" class="control-label">Affected Channels (<span id="ctunchedked1"> Select All </span><input type="checkbox" id="ctselected1">)</label>
                                                            <select name="channels[]" class="form-control select2 select2-hidden-accessible channels" id="channels" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Channels" multiple>
                                                                <?php
                                                                $status_all = "Active";
                                                                $qb2 = $db -> prepare('SELECT * FROM channel WHERE status=?');
                                                                $qb2->bind_param("s", $status_all);
                                                                $qb2->execute();
                                                                $retw2 = $qb2->get_result();
                                                                ?>
                                                                    <?php
                                                                    while($rog2 = mysqli_fetch_array($retw2) ){
                                                                        $chid = $rog2['id'];
                                                                        $chname = $rog2['name'];
                                                                    ?>
                                                                        <option value="<?php echo $chid; ?>"><?php echo $chname; ?></option>
                                                                    <?php } ?>
                                                            </select>

                                                        </div>
                                                    </div>

                                                    <div id="acap" style="display:none">

                                                        <div class="form-group col-md-12">
                                                            <label for="event">Type</label>
                                                            <select name="event" class="form-control select2 select2-hidden-accessible event" id="event" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Event">
                                                            <option></option>
                                                            <?php
                                                                $pty = "Account Approvals";
                                                                $sev = $db -> prepare('SELECT * FROM amount_policy_events WHERE name NOT IN(SELECT name FROM policies WHERE product_type=? AND status=?)');
                                                                $sev->bind_param("ss", $pty, $status_all);
                                                                $sev->execute();
                                                                $rsev = $sev->get_result();
                                                                ?>
                                                                    <?php
                                                                    while($svi = mysqli_fetch_array($rsev) ){
                                                                        $evname = $svi['name'];
                                                                    ?>
                                                                        <option value="<?php echo $evname; ?>"><?php echo $evname; ?></option>
                                                                    <?php } ?>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <table class="table table-bordered" style="width:100%">
                                                                <thead>
                                                                    <tr><td colspan="5"><a class="btn btn-info pull-right btn-sm add_col_vlt">Add Range</a></td></tr>
                                                                    <tr>
                                                                        <th width="400">Amount Range</th>
                                                                        <th>Validator</th>
                                                                        <th>Recommender</th>
                                                                        <th>Approver</th>
                                                                        <th></th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody id="tbody_vlt">
                                                                                            
                                                                    </tbody>
                                                            </table>
                                                        </div>

                                                </div>
                                                <input type="hidden" name="tpid" class="tpid" id="tpid">

                                                <div class="divider"></div>
                                                

                                                    

                                                    <h5 class="text-center text-danger errormessage_policy"></h5>
												</div>
												<div class="modal-footer">
                                                    <input type="submit" name="policy_submit" id="policy_submit" class="policy_submit btn btn-primary" value="Add" />
													<button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
                                        </form>
									</div>
								</div>

                                <div id="addcolModal_vlt" class="modal fade">
                                    <div class="modal-dialog white expnd">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Amounts & Authorizers</h4>
                                            </div>
                                            <div class="modal-body">

                                            <fieldset>
                                            <h4 class="col-md-12">Amount Range</h4>
                                            <div class="form-group col-md-6">
                                                <label for="minimum_amount">Minimum Amount</label>
                                                <input type="number" class="form-control minimum_amount chkamt rmzo" id="minimum_amount" placeholder="Enter Minimum Amount">
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="maximum_amount">Maximum Amount</label>
                                                <input type="number" class="form-control maximum_amount chkamt rmzo" id="maximum_amount" placeholder="Enter Maximum Amount">
                                            </div>
                                            <h4 class="col-md-12 range_result text-center"></h4>
                                            
                                            </fieldset>
                                            <fieldset>
                                            <h4 class="col-md-12">Authorizers</h4>
                                            <div class="form-group col-md-4">
                                                <label for="validate_type">Who to Validate?</label>
                                                <select name="validate_type" class="form-control select2 select2-hidden-accessible validate_type" id="validate_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <option></option>
                                                <option value="Role">Role</option>
                                                <option value="User">User</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="recommend_type">Who to Recommend?</label>
                                                <select name="recommend_type" class="form-control select2 select2-hidden-accessible recommend_type" id="recommend_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <option></option>
                                                <option value="Role">Role</option>
                                                <option value="User">User</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="approve_type">Who to Approve?</label>
                                                <select name="approve_type" class="form-control select2 select2-hidden-accessible approve_type" id="approve_type" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <option></option>
                                                <option value="Role">Role</option>
                                                <option value="User">User</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="validator">Validator</label>
                                                <select name="validator" class="form-control select2 select2-hidden-accessible validator" id="validator" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select" multiple>
                                                
                                                </select>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="recommender">Recommender</label>
                                                <select name="recommender" class="form-control select2 select2-hidden-accessible recommender" id="recommender" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select" multiple>
                                                
                                                </select>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="approver">Approver</label>
                                                <select name="approver" class="form-control select2 select2-hidden-accessible approver" id="approver" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select" multiple>
                                                
                                                </select>
                                            </div>
                                            </fieldset>
                                                           
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-info add-col_rng" style="display:none">Add</button>
                                                <button type="button" id="add-col_vlt" class="btn btn-primary add-col_vlt">Add</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="addcolModal_ami" class="modal fade">
                                    <div class="modal-dialog white">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Products Amount Increment</h4>
                                            </div>
                                            <div class="modal-body">

                                            <fieldset>
                                            <div class="form-group col-md-6">
                                                <label for="product_ami">Loan Product</label>
                                                <select name="product_ami" class="form-control select2 select2-hidden-accessible product_ami" id="product_ami" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <?php
                                                    $inpl = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                    $inpl->bind_param('s', $active);
                                                    $inpl->execute();
                                                    $rinpl = $inpl->get_result();
                                                    if($rinpl->num_rows >0) {
                                                        while($ica = mysqli_fetch_array($rinpl) ){
                                                            $product_id_inc = $ica['id'];
                                                            $product_name_inc = $ica['name'];
                                                        echo "<option value='$product_id_inc'>" . $product_name_inc . "</option>";
                                                        }
                                                    }
                                                ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="increment_ami">Percentage Increment</label>
                                                <input type="number" class="form-control increment_ami rmzo" id="increment_ami" placeholder="Enter % Increment">
                                            </div>
                                            
                                            </fieldset>           
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" id="add-col_ami" class="btn btn-primary add-col_ami">Add</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="addcolModal_gua" class="modal fade">
                                    <div class="modal-dialog white">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Products Guarantors</h4>
                                            </div>
                                            <div class="modal-body">

                                            <fieldset>
                                            <div class="form-group col-md-6">
                                                <label for="product_gua">Loan Product</label>
                                                <select name="product_gua" class="form-control select2 select2-hidden-accessible product_gua" id="product_gua" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <?php
                                                    $pgua = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                    $pgua->bind_param('s', $active);
                                                    $pgua->execute();
                                                    $rpgua = $pgua->get_result();
                                                    if($rpgua->num_rows >0) {
                                                        while($pfj = mysqli_fetch_array($rpgua) ){
                                                            $product_id_gua = $pfj['id'];
                                                            $product_name_gua = $pfj['name'];
                                                        echo "<option value='$product_id_gua'>" . $product_name_gua . "</option>";
                                                        }
                                                    }
                                                ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="value">No of Guarantors</label>
                                                <input type="number" class="form-control value rmzo" id="value" placeholder="Enter No of Guarantors">
                                            </div>
                                            
                                            </fieldset>           
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" id="add-col_gua" class="btn btn-primary add-col_gua">Add</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="addcolModal_ami_min" class="modal fade">
                                    <div class="modal-dialog white">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Minimum Loan Amount</h4>
                                            </div>
                                            <div class="modal-body">

                                            <fieldset>
                                            <div class="form-group col-md-12">
                                                <label for="product_ami_min">Loan Product</label>
                                                <select name="product_ami_min" class="form-control select2 select2-hidden-accessible product_ami_min" id="product_ami_min" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                <?php
                                                    $inpl_min = $db -> prepare('SELECT * FROM loanproduct WHERE status =?');
                                                    $inpl_min->bind_param('s', $active);
                                                    $inpl_min->execute();
                                                    $rinpl_min = $inpl_min->get_result();
                                                    if($rinpl_min->num_rows >0) {
                                                        while($ica_min = mysqli_fetch_array($rinpl_min) ){
                                                            $product_id_inc_min = $ica_min['id'];
                                                            $product_name_inc_min = $ica_min['name'];
                                                        echo "<option value='$product_id_inc_min'>" . $product_name_inc_min . "</option>";
                                                        }
                                                    }
                                                ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="lon_min_am">Min Amount</label>
                                                <input type="number" class="form-control lon_min_am rmzo" id="lon_min_am" placeholder="Enter Min Amount">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="lon_max_am">Max Amount</label>
                                                <input type="number" class="form-control lon_max_am rmzo" id="lon_max_am" placeholder="Enter Max Amount">
                                            </div>
                                            
                                            </fieldset>           
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" id="add-col_ami_min" class="btn btn-primary add-col_ami_min">Add</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="rangeModal" class="modal fade">
                                    <div class="modal-dialog white expnd">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close bcl" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Amounts & Authorizers</h4>
                                            </div>
                                            <div class="modal-body">

                                                <h4 class="col-md-12 range_response text-center"></h4>
                                                                
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default bcl" data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="editModal" class="modal fade">
                                    <div class="modal-dialog white">
                                        <div class="modal-content white">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title"><i class="fa fa-plus"></i>Update Policy</h4>
                                            </div>
                                            <div class="modal-body">

                                                <div class="response_edit"></div>
                                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
					
						<!-- end: BASIC EXAMPLE -->
						<!-- end: SELECT BOXES -->
						
					</div>
				</div>
			</div>
			<!-- start: FOOTER -->
	<?php include('../include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->
		<script src="../vendor/jquery/jquery.min.js"></script>
		<script src="../vendor/modernizr/modernizr.js"></script>
		<script src="../vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="../vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="../vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->


		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="../vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="../vendor/autosize/autosize.min.js"></script>
		<script src="../vendor/selectFx/classie.js"></script>
		<script src="../vendor/selectFx/selectFx.js"></script>
		
		<script src="../vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="../vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="../assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="../assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
				FormElements.init();
			});
		</script>

  <!-- Bootstrap core JavaScript -->
  <script type="text/javascript" src="../assets/js/datatables.min.js"></script>

<script type="text/javascript" language="javascript">
    $(document).ready(function() {

        var plctb =  $('#pndt').DataTable({
        scrollX: true,
        });

	  $('.select2').select2({
        closeOnSelect: true,
        allowClear: true
        });

      $('.add_col_vlt').click(function() {
        $(".add-col_rng").hide();
          $(".add-col_vlt").show();
        $('.add-col_vlt').attr('disabled','disabled');
       $('#addcolModal_vlt').modal('show');
       $(".validate_type").val("").trigger('change.select2');
	   $(".recommend_type").val("").trigger('change.select2');
       $(".approve_type").val("").trigger('change.select2');
       $(".validator").val("").trigger('change.select2');
       $(".recommender").val("").trigger('change.select2');
       $(".approver").val("").trigger('change.select2');
       $(".minimum_amount").val("");
       $(".maximum_amount").val("");
       $(".range_result").val("");
  	 });

       $('.add_col_ami').click(function() {
        //$('.add-col_ami').attr('disabled','disabled');
        $('#addcolModal_ami').modal('show');
        $(".product_ami").val("").trigger('change.select2');
        $(".increment_ami").val("");
        //$(".amiinc_result").val("");
  	    });

          $('.add_col_gua').click(function() {
        //$('.add-col_ami').attr('disabled','disabled');
        $('#addcolModal_gua').modal('show');
        $(".product_gua").val("").trigger('change.select2');
        $(".value").val("");
        //$(".amiinc_result").val("");
  	    });

        $('.add_col_ami_min').click(function() {
        //$('.add-col_ami').attr('disabled','disabled');
        $('#addcolModal_ami_min').modal('show');
        $(".product_ami_min").val("").trigger('change.select2');
        $(".lon_min_am").val("");
        $(".lon_max_am").val("");
  	    });

          $('.add-col_ami').on('click', function () {
            var product_ami = $(".product_ami").val();
            var increment_ami = Number($(".increment_ami").val());
            var product_ami_text = $( ".product_ami option:selected" ).text();

            if(product_ami != "" && increment_ami !="" && increment_ami > 0 && increment_ami <101) {

            $('#tbody_ami').append(`<tr id="${product_ami}-${product_ami_text}"> 
             <td class="row-index text-center"> 
             <p>${product_ami_text}<input type="hidden" name="product_ami[]" value="${product_ami}"></p> 
             </td>
             <td class="row-index text-center"> 
             <p>${increment_ami}%<input type="hidden" name="increment_ami[]" value="${increment_ami}"></p> 
             </td>
              <td class="text-center"> 
                <button class="btn btn-danger remove1"
                  type="button"><i class="ti-trash"></i></button> 
                </td> 
              </tr>`);

              $(".product_ami option[value="+product_ami+"]").remove().trigger('change.select2');
              $(".product_ami").val([]).trigger("change");
              $('#addcolModal_ami').modal('hide');

            }
            });


      // jQuery button click event to remove a row. 
      $('#tbody_ami').on('click', '.remove1', function () { 

        var confirmation1 = confirm("Are you sure you want to remove this?");
		if (confirmation1) {
        
            var trid = $(this).closest('tr').attr('id');
            var trid_main = trid.split('-')[0];
            var  trid_text = trid.split('-')[1].trim();

            $('.product_ami').append(`<option value="${trid_main}">${trid_text}</option>`).trigger('change.select2');

        // Getting all the rows next to the row 
        // containing the clicked button 
        var child = $(this).closest('tr').nextAll(); 
  
        // Iterating across all the rows  
        // obtained to change the index 
        child.each(function () { 
  
        });
  
        // Removing the current row.

        $(this).closest('tr').remove();
        }
		return confirmation1;
      });

      $('.add-col_gua').on('click', function () {
            var product_gua = $(".product_gua").val();
            var value = Number($(".value").val());
            var product_gua_text = $( ".product_gua option:selected" ).text();

            if(product_gua != "" && value !="" && value > 0) {

            $('#tbody_gua').append(`<tr id="${product_gua}-${product_gua_text}"> 
             <td class="row-index text-center"> 
             <p>${product_gua_text}<input type="hidden" name="product_gua[]" value="${product_gua}"></p> 
             </td>
             <td class="row-index text-center"> 
             <p>${value}<input type="hidden" name="value[]" value="${value}"></p> 
             </td>
              <td class="text-center"> 
                <button class="btn btn-danger remove1_gua"
                  type="button"><i class="ti-trash"></i></button> 
                </td> 
              </tr>`);

              $(".product_gua option[value="+product_gua+"]").remove().trigger('change.select2');
              $(".product_gua").val([]).trigger("change");
              $('#addcolModal_gua').modal('hide');

            }
            });


      // jQuery button click event to remove a row. 
      $('#tbody_gua').on('click', '.remove1_gua', function () { 

        var confirmation1 = confirm("Are you sure you want to remove this?");
		if (confirmation1) {
        
            var trid = $(this).closest('tr').attr('id');
            var trid_main = trid.split('-')[0];
            var  trid_text = trid.split('-')[1].trim();

            $('.product_gua').append(`<option value="${trid_main}">${trid_text}</option>`).trigger('change.select2');

        // Getting all the rows next to the row 
        // containing the clicked button 
        var child = $(this).closest('tr').nextAll(); 
  
        // Iterating across all the rows  
        // obtained to change the index 
        child.each(function () { 
  
        });
  
        // Removing the current row.

        $(this).closest('tr').remove();
        }
		return confirmation1;
      });

      
    $('.add-col_ami_min').on('click', function () {
	var product_ami_min = $(".product_ami_min").val();
	var lon_min_am = Number($(".lon_min_am").val());
	var lon_max_am = Number($(".lon_max_am").val());
	var product_ami_min_text = $( ".product_ami_min option:selected" ).text();

	if(product_ami_min != "" && lon_min_am !="" && lon_min_am > 0 && lon_max_am !="" && lon_max_am > 0) {

        if(lon_max_am < lon_min_am) {
            alert("Minimum amount cannot be greater than maximum amount");
        } else {

                $('#tbody_ami_min').append(`<tr id="${product_ami_min}-${product_ami_min_text}"> 
                <td class="row-index text-center"> 
                <p>${product_ami_min_text}<input type="hidden" name="product_ami_min[]" value="${product_ami_min}"></p> 
                </td>
                <td class="row-index text-center"> 
                <p>${lon_min_am} - ${lon_max_am} %<input type="hidden" name="lon_min_am[]" value="${lon_min_am}">
                <input type="hidden" name="lon_max_am[]" value="${lon_max_am}"></p> 
                </td>
                <td class="text-center"> 
                    <button class="btn btn-danger remove11_m"
                    type="button"><i class="ti-trash"></i></button> 
                    </td> 
                </tr>`);

                $(".product_ami_min option[value="+product_ami_min+"]").remove().trigger('change.select2');
                $(".product_ami_min").val([]).trigger("change");
                $('#addcolModal_ami_min').modal('hide');
            }
	    }
	});


    // jQuery button click event to remove a row. 
    $('#tbody_ami_min').on('click', '.remove11_m', function () { 

    var confirmation1 = confirm("Are you sure you want to remove this?");
    if (confirmation1) {

        var trid = $(this).closest('tr').attr('id');
        var trid_main = trid.split('-')[0];
        var  trid_text = trid.split('-')[1].trim();

        $('.product_ami_min').append(`<option value="${trid_main}">${trid_text}</option>`).trigger('change.select2');

    // Getting all the rows next to the row 
    // containing the clicked button 
    var child = $(this).closest('tr').nextAll(); 

    // Iterating across all the rows  
    // obtained to change the index 
    child.each(function () { 

    });

    // Removing the current row.

    $(this).closest('tr').remove();
    }
    return confirmation1;
    });

       $('.chkamt').blur(function() {
            var checkamount = Number($(this).val());
            var tpid = $(".tpid").val();
            if(checkamount > 0) {
                $.ajax({
                    type: "POST",
                    url: "check_amount_range",
                    data:{'amount': checkamount, 'tpid': tpid},
                    success: function(data){
                        if(data != "Good") {
                            alert(data);
                            $('.policy_submit').attr('disabled','disabled');
                            $('.add-col_vlt').attr('disabled','disabled');
                            $('.add-col_rng').attr('disabled','disabled');
                        } else {
                            $('.policy_submit').attr('disabled',false);
                            $('.add-col_vlt').attr('disabled',false);
                            $('.add-col_rng').attr('disabled',false);
                        }
                    }
                });
            }
        });

$('#add-col_vlt').click(function() { 
    var col_min_amount = Number($(".minimum_amount").val());
    var col_max_amount = Number($(".maximum_amount").val());
    var col_val_who = $(".validate_type").val();
    var col_val_who_text = ($(".validate_type option:selected").text().split(','));
    var col_rec_who = $(".recommend_type").val();
    var col_rec_who_text = ($(".recommend_type option:selected").text().split(','));
    var col_app_who = $(".approve_type").val();
    var col_app_who_text = ($(".approve_type option:selected").text().split(','));

    var col_validator = $(".validator").val();
    var col_validator_text = ($(".validator option:selected").text().split(','));
    var col_recommender = $(".recommender").val();
    var col_recommender_text = ($(".recommender option:selected").text().split(','));
    var col_approver = $(".approver").val();
    var col_approver_text = ($(".approver option:selected").text().split(','));

	//var save_name_vlt = role_text_vlt.replace(/\s+/g,'_');

    if (col_min_amount >0 && col_max_amount >0 && col_min_amount < col_max_amount && (col_validator !="" || col_recommender !="" && col_approver !="")) {

        //INSERT TO RANGE DB HERE
        var tpid = $(".tpid").val();
        var entity = $(".event").val();
        $.ajax({
            type: "POST",
            url: "insert_amount_range",
            data:{'min_amount': col_min_amount, 'max_amount': col_max_amount, 'tpid': tpid, 'validate_type': col_val_who, 'recommend_type': col_rec_who, 'approve_type': col_app_who, 'validator': col_validator, 'recommender': col_recommender, 'approver': col_approver, "entity": entity},
            success: function(data){
                if(data != "Failed" && data != "Validation workflow not set please set it and repeat this action"
                && data != "Recommendation workflow not set please set it and repeat this action" && data != "Approval workflow not set please set it and repeat this action"
                && data != "One or/all of the validators is not configured in workflow" && data != "One or/all of the recommenders is not configured in workflow"
                && data != "One or/all of the approvers is not configured in workflow") {
                    $('#tbody_vlt').append(`<tr id="${col_min_amount}" class="${col_max_amount}"> 
                    <td class="row-index"> 
                    <p>${col_min_amount} - ${col_max_amount}</p> 
                    </td>
                    <td class="row-index"> 
                    <p>${col_val_who_text} - ${col_validator_text}</p> 
                    </td>
                    <td class="row-index"> 
                    <p>${col_rec_who_text} - ${col_recommender_text}</p> 
                    </td>
                    <td class="row-index"> 
                    <p>${col_app_who_text} - ${col_approver_text}</p> 
                    </td>
                    <td width="20"> 
                        <button class="btn btn-danger remove_vlt" id="${data}"
                        type="button"><i class="ti-trash"></i></button> 
                        </td> 
                    </tr>`);
                    $('#addcolModal_vlt').modal('hide');
                } else {
                    alert(data);
                }
            }
        });
 }            
});
//DELETE RANGES
// jQuery button click event to remove a row. 
$('#tbody_vlt').on('click', '.remove_vlt', function () { 
var confirmation = confirm("Are you sure you want to delete this range?");
if (confirmation) {
    $(this).closest('tr').remove();
    var id = $(this).attr('id');
    $.ajax({
            type: "POST",
            url: "del_unused_ranges",
            data:{'tpid': id, "action": "used"},
            success: function(data){
            }
        });
}
return confirmation;
});
    $("select.tr_type").change(function(){
        $(".t_channel").val("").trigger('change.select2');
        var val = $(this).val();
        if(val == "Channel") {
            $(".tchanel").show();
        } else {
            $(".tchanel").hide();
        }
    });

    $("select.force_id_validation").change(function(){
        var vb = $(this).val();
        if(vb == "Yes") {
            $(".flat_charge").show();
        } else {
            $(".flat_charge").hide();
        }
    });


    $(".rmzo").keyup(function(){
        if($(this).val() < 0) {
            $(this).val(0);
        }
    });

    $("select.validate_type").change(function(){
        $(".validator").val("").trigger('change.select2');
        var vty = $(this).val();
        $(".validator").load("get_roles_users.php?type=" + vty);
    });
    $("select.recommend_type").change(function(){
        $(".recommender").val("").trigger('change.select2');
        var rct = $(this).val();
        $(".recommender").load("get_roles_users.php?type=" + rct);
    });
    $("select.approve_type").change(function(){
        $(".approver").val("").trigger('change.select2');
        var apr = $(this).val();
        $(".approver").load("get_roles_users.php?type=" + apr);
    });
    
     $("select.type_sav").change(function(){
    var tss = $(".type_sav option:selected").val();
    $('.errormessage_policy').html("");

    $(".affected_products").val("").trigger('change.select2');
        var ck = $(".product_type option:selected").val();
        var ck2 = ck.replace(/\s+/g,'_');
        var tss2 = tss.replace(/\s+/g,'_');
        $(".affected_products").load("get_products_sav.php?product_type=" + ck2+"&type="+tss2);
    if (tss == "Account Opening") {
        $("#sav_ao").show();
        $("#sav_trns").hide();
        $("#sav_dom").hide();
        $("#sav_ovd").hide();
        $("#sav_escht").hide();
    } else if (tss == "Interest on Savings") {
        $("#sav_ao").hide();
        $("#sav_trns").show();
        $("#sav_dom").hide();
        $("#sav_ovd").hide();
        $("#sav_escht").hide();
    } else if (tss == "Dormancy") {
        $("#sav_ao").hide();
        $("#sav_trns").hide();
        $("#sav_dom").show();
        $("#sav_ovd").hide();
        $("#sav_escht").hide();
    } else if (tss == "Overdraft") {
        $("#sav_ao").hide();
        $("#sav_trns").hide();
        $("#sav_dom").hide();
        $("#sav_ovd").show();
        $("#sav_escht").hide();
    }  else if (tss == "Escheat") {
        $("#sav_ao").hide();
        $("#sav_trns").hide();
        $("#sav_dom").hide();
        $("#sav_ovd").hide();
        $("#sav_escht").show();
    } else {
        $("#sav_ao").hide();
        $("#sav_trns").hide();
        $("#sav_dom").hide();
        $("#sav_ovd").hide();
        $("#sav_escht").hide();
    }
   
    });

    $("select.type_lon").change(function(){
    var tssl = $(".type_lon option:selected").val();
    $('.errormessage_policy').html("");

    $(".affected_products").val("").trigger('change.select2');
        var ckl = $(".product_type option:selected").val();
        var ck2l = ckl.replace(/\s+/g,'_');
        var tss2l = tssl.replace(/\s+/g,'_');
        $(".affected_products").load("get_products_lon.php?product_type=" + ck2l+"&type="+tss2l);
    if (tssl == "Loan Disbursement") {
        $("#lon_ao").show();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").show();
        $("#afprd").show();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Overdue Rule") {
        $("#lon_ao").hide();
        $("#lon_trns").show();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").show();
        $("#afprd").show();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Interest Waiver") {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").show();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").show();
        $("#afprd").show();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Guarantor") {
        $("#lon_ao").show();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").show();
        $("#lon_max").hide();
        $("#afchnl").show();
        $("#afprd").hide();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Maximum Loan Accounts") {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").show();
        $("#afchnl").hide();
        $("#afprd").hide();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Access Loan on Loan") {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").hide();
        $("#afprd").hide();
        $("#lon_alol").show();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Loan Amount Increment") {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").hide();
        $("#afprd").hide();
        $("#lon_alol").hide();
        $("#lon_amincp").show();
        $("#lon_amincp_min").hide();
    } else if (tssl == "Minimum Loan Amount") {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").hide();
        $("#afprd").hide();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").show();
    } else {
        $("#lon_ao").hide();
        $("#lon_trns").hide();
        $("#lon_intwv").hide();
        $("#lon_gua").hide();
        $("#lon_max").hide();
        $("#afchnl").hide();
        $("#afprd").hide();
        $("#lon_alol").hide();
        $("#lon_amincp").hide();
        $("#lon_amincp_min").hide();
    }
   
    });

    $("select.validate_identity").change(function(){
    var vld = $(".validate_identity option:selected").val();

    $(".id_type").val("").trigger('change.select2');
    if (vld == "Yes") {
        $("#idv").show();
    } else {
        $("#idv").hide();
    }
   
    });

    $("select.type_cus").change(function(){
    var csty = $(".type_cus option:selected").val();

    if (csty == "Age Policy") {
        $("#age_policy").show();
        $("#identity_policy").hide();
    } else if (csty == "ID Validation") {
        $("#age_policy").hide();
        $("#identity_policy").show();
    } else {
        $("#age_policy").hide();
        $("#identity_policy").hide();
    }
   
    });
    

    $('#add_policy').click(function(){
        $(".tpid").val("");
        $('#policyModal').modal('show');
    });

    $("#pndt").on('click', '.pupdate', function(){
            var pndid = $(this).attr('id');
            $.ajax({
            type: "POST",
            url: "get_edit_policy",
            data:{'pndid': pndid},
            success: function(data){
                $(".response_edit").html(data);
                $('#editModal').modal('show');
                }
            });
        });


    $("select.rule_type").change(function(){
    var ttt = $(".rule_type option:selected").val();
    $('.errormessage_policy').html("");
    if (ttt == "No Rule") {
        $("#info").show();
        $("#withpc").hide();
        $(".info_mess").html("Compounding Interest for all affected Savings Account products will not obey any rule but will compound based on the current balance of the account as at the time of compounding.")
    } else if (ttt == "No of Withdrawal Per Compounding Period") {
        $("#info").show();
        $("#withpc").show();
        $(".info_mess").html("Interest will only be compounded if the account withdrawals is not greater than the set number of withdrawals per compounding period");
    } else if (ttt == "Deposit Age Rule") {
        $("#info").show();
        $("#withpc").hide();
        $(".info_mess").html("Note: This method does not apply to Daily and Weekly coumpoundng periods.</br>Interest will only be compounded for balances that are not less than the compounding period set. This is done by checking all valid deposits against withdrawals within the compounding period and interest is compounded for the positive difference");
    } else {
        $(".info_mess").html("");
        $("#info").hide();
        $("#withpc").hide();
    }
   
    });

    $("select.type_cur").change(function(){
    var rpl = $(".type_cur option:selected").val();
    $('.errormessage_policy').html("");
    if (rpl == "Account Reference") {
        $("#cur_aref").show();
    } else {
        $("#cur_aref").hide();
    }
   
    });

    $(".product_type").change(function(){
        $(".affected_products").val("").trigger('change.select2');
        $('.errormessage_policy').html("");
        
        var ps = $(".product_type option:selected").val();

        if(ps == "Customer") {
            $("#cus").show();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Customers in Union") {
            $("#cos_in_u").show();
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Disable Multiple Workflow Transactions") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Daily Transaction Limit") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").show();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if (ps == "Account Documents") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#afprd2").show();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").show();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if (ps == "Account Approvals") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").show();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var tpid = Math.floor(100000 + Math.random() * 900000);
            $(".tpid").val(tpid);
        } else if(ps == "Savings Account") {
            $("#cus").hide();
            $("#sav").show();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").show();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var ps2 = ps.replace(/\s+/g,'_');
            $(".affected_products").load("get_products.php?product_type=" + ps2);
        } else if(ps == "Loan Account") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").show();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var ps2 = ps.replace(/\s+/g,'_');
            $(".affected_products").load("get_products.php?product_type=" + ps2);
        } else if(ps == "Thrift Account") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").show();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").show();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var ps2 = ps.replace(/\s+/g,'_');
            $(".affected_products").load("get_products.php?product_type=" + ps2);
        } else if(ps == "Term Deposit Account") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").show();
            $("#cur").hide();
            $("#afprd").show();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var ps2 = ps.replace(/\s+/g,'_');
            $(".affected_products").load("get_products.php?product_type=" + ps2);
        } else if(ps == "Current Account") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").show();
            $("#afprd").show();
            $("#trv").hide();
            $("#afchnl").show();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
            var ps2 = ps.replace(/\s+/g,'_');
            $(".affected_products").load("get_products.php?product_type=" + ps2);
        } else if(ps == "Transaction Reversal") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").show();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Force Union Purse") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").show();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Missing Identification") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").show();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        } else if(ps == "Maximum Individual Client Per Relationship Officer") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").show();
        } else if(ps == "Maximum Group Per Relationship Officer") {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#afchnl").hide();
            $("#acap").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").show();
            $("#mcpcso").hide();
        } else {
            $("#cus").hide();
            $("#sav").hide();
            $("#lon").hide();
            $("#thf").hide();
            $("#tdf").hide();
            $("#cur").hide();
            $("#afprd").hide();
            $("#trv").hide();
            $("#acap").hide();
            $("#afchnl").hide();
            $("#guar").hide();
            $("#adc").hide();
            $("#afprd2").hide();
            $("#trlimit").hide();
            $(".tchanel").hide();
            $("#msid").hide();
            $("#unps").hide();
            $("#mgpcso").hide();
            $("#mcpcso").hide();
        }
     });

     $("#ctselected").click(function(){
                if($("#ctselected").is(':checked') ){
                    $(".affected_products > option").prop("selected","selected");
                    $(".affected_products").trigger("change");
                    $("#ctunchedked").html(" Unselect All ");
                }else{
                    $(".affected_products > option").removeAttr("selected");
                    $(".affected_products").trigger("change");
                    $("#ctunchedked").html(" Select All ");
                }
            });

            $("#ctselected_all").click(function(){
                if($("#ctselected_all").is(':checked') ){
                    $(".affected_products_all > option").prop("selected","selected");
                    $(".affected_products_all").trigger("change");
                    $("#ctunchedked_all").html(" Unselect All ");
                }else{
                    $(".affected_products_all > option").removeAttr("selected");
                    $(".affected_products_all").trigger("change");
                    $("#ctunchedked_all").html(" Select All ");
                }
            });
            $("#ctselected_ab").click(function(){
                if($("#ctselected_ab").is(':checked') ){
                    $(".affected_branches > option").prop("selected","selected");
                    $(".affected_branches").trigger("change");
                    $("#ctunchedked_ab").html(" Unselect All ");
                }else{
                    $(".affected_branches > option").removeAttr("selected");
                    $(".affected_branches").trigger("change");
                    $("#ctunchedked_ab").html(" Select All ");
                }
            });
            $("#ctselected_r").click(function(){
                if($("#ctselected_r").is(':checked') ){
                    $(".restrict_events > option").prop("selected","selected");
                    $(".restrict_events").trigger("change");
                    $("#ctunchedked_r").html(" Unselect All ");
                }else{
                    $(".restrict_events > option").removeAttr("selected");
                    $(".restrict_events").trigger("change");
                    $("#ctunchedked_r").html(" Select All ");
                }
            });
            $("#ctselected_r_msid").click(function(){
                if($("#ctselected_r_msid").is(':checked') ){
                    $(".restrict_events_msid > option").prop("selected","selected");
                    $(".restrict_events_msid").trigger("change");
                    $("#ctunchedked_r_msid").html(" Unselect All ");
                }else{
                    $(".restrict_events_msid > option").removeAttr("selected");
                    $(".restrict_events_msid").trigger("change");
                    $("#ctunchedked_r_msid").html(" Select All ");
                }
            });

            
            
        $("#ctselected1").click(function(){
                if($("#ctselected1").is(':checked') ){
                    $(".channels > option").prop("selected","selected");
                    $(".channels").trigger("change");
                    $("#ctunchedked1").html(" Unselect All ");
                }else{
                    $(".channels > option").removeAttr("selected");
                    $(".channels").trigger("change");
                    $("#ctunchedked1").html(" Select All ");
                }
            });
    
    $('#policyModal').on('hidden.bs.modal', function (e) {
		var tpid = $(".tpid").val();
        $.ajax({
            type: "POST",
            url: "del_unused_ranges",
            data:{'tpid': tpid, "action": "new"},
            success: function(data){
            }
        });
	});
    $(".viw").click(function(){
     var amid = $(this).attr("id");
     $(".tpid").val(amid);
        $.ajax({
            type: "POST",
            url: "get_detail_range",
            data:{'pid': amid},
            success: function(data){
                $(".range_response").html(data);
                $('#rangeModal').modal('show');
            }
        });
    });

    $('.bcl').on('click', function (e) {
		location.reload();
	});
    
    /*
    window.onbeforeunload = function () {
        var tpid = $(".tpid").val();
        $.ajax({
            type: "POST",
            url: "del_unused_ranges",
            data:{'tpid': tpid, "action": "new"},
            success: function(data){
            }
        });
    return 'Are you really want to perform the action?';
    }*/

     $('#policy_form').submit(function(a) { 
        a.preventDefault();
        var product_type = $('.product_type').val();
        var type_sav = $('.type_sav').val();
        var min_age = $('.min_age').val();
        var rule_type = $('.rule_type').val();
        var nowithdrawal = $('.nowithdrawal').val();
        var type_lon = $('.type_lon').val();
        var type_cur = $('.type_cur').val();
        var minimum_reference = $('.minimum_reference').val();
        var min_age_l = $('.min_age_l').val();
        var min_age_c = $('.min_age_c').val();
        var max_age_c = $('.max_age_c').val();
        var validate_identity = $('.validate_identity').val();
        var id_type = $('.id_type').val();
        var duplicate_id = $('.duplicate_id').val();
        var trv_order = $('.trv_order').val();
        var days_to_due =  $('.days_to_due').val();
        var days_of_inactivity_s =  $('.days_of_inactivity_s').val();
        var max_overdraft_s =  $('.max_overdraft_s').val();

        var days_to_escheat =  $('.days_to_escheat').val();
        var type_cus = $('.type_cus').val();

        var max_existing_guaranteed_loans = $('.max_existing_guaranteed_loans').val();
        var reject_if_impired = $('.reject_if_impired').val();
        var force_id_validation = $('.force_id_validation').val();
        var require_doc_upload = $('.require_doc_upload').val();
        var force_g_upload = $('.force_g_upload').val();

        var t_limit = $('.t_limit').val();
        var t_event = $('.t_event').val();
        var t_channel = $('.t_channel').val();
        var tr_type = $('.tr_type').val();
        var max_products = $('.max_products').val();

        var min_total_paid = $('.min_total_paid').val();
        var max_total_paid = $('.max_total_paid').val();

        var min_customers = Number($('.min_customers').val());
        var max_customers = Number($('.max_customers').val());

        var identity_type = Number($('.identity_type').val());

        var union_savings = $('.union_savings').val();
        var maximum_client = $('.maximum_client').val();
        var maximum_group = $('.maximum_group').val();
        
        
        if (product_type == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Product Type</span>");
        } else if (product_type == "Savings Account" && type_sav == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Type</span>");
        } else if (product_type == "Account Documents" && require_doc_upload == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select if Upload is required or not</span>");
        } else if (product_type == "Account Documents" && $("select[name='affected_products_all[]'] option:selected").length ==0) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please at least one product</span>");
        } else if (product_type == "Missing Identification" && identity_type == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Identification Type</span>");
        } else if (product_type == "Maximum Individual Client Per Relationship Officer" && maximum_client == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Client</span>");
        } else if (product_type == "Maximum Group Per Relationship Officer" && maximum_group == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Group</span>");
        } else if (product_type == "Missing Identification" && $("select[name='restrict_events_msid[]'] option:selected").length ==0) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please at least one event to restrict</span>");
        } else if (type_sav == "Account Opening" && min_age == "") {

            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum Age</span>");
        } else if (type_sav == "Interest on Savings" && rule_type == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Rule Type</span>");
        } else if (rule_type == "No of Withdrawal Per Compounding Period" && nowithdrawal == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter No of Withdrawal per Compounding Period</span>");
        } else if (type_sav == "Escheat" && days_to_escheat == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Days to Escheat</span>");
        } else if (type_sav == "Dormancy" && days_of_inactivity_s == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Days of Inactivity</span>");
        } else if (type_sav == "Overdraft" && max_overdraft_s == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Overdraft Amount</span>");
        } else if (product_type == "Loan Account" && type_lon == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Type</span>");
        } else if (type_lon == "Loan Disbursement" && min_age_l == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum Age</span>");
        } else if (type_lon == "Maximum Loan Accounts" && (max_products == "" || max_products < 1)) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Loans</span>");
        } else if (type_lon == "Access Loan on Loan" && (min_total_paid == "" || min_total_paid < 1)) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum Total Paid Percentage</span>");
        } else if (type_lon == "Access Loan on Loan" && (max_total_paid == "" || max_total_paid < 1)) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Total Paid Percentage</span>");
        } else if (type_lon == "Interest Waiver" && days_to_due == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Days to Due. Enter 0 to disable check</span>");
        }else if (type_lon == "Guarantor" && min_age_l == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum Guarantor Age</span>");
        } else if (type_lon == "Guarantor" && max_age_l == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Guarantor Age</span>");
        } else if (type_lon == "Guarantor" && max_existing_guaranteed_loans == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum Existing Guaranteed Loans</span>");
        } else if (type_lon == "Guarantor" && reject_if_impired == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Select whether to reject if their are impired loans</span>");
        } else if (type_lon == "Guarantor" && force_id_validation == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Select whether to force Guarantor ID Validation</span>");
        } else if (type_lon == "Guarantor" && force_g_upload == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Select whether to force Guarantor Document Upload</span>");
        } else if (product_type == "Current Account" && type_cur == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Type</span>");
        } else if (type_cur == "Account Reference" && (minimum_reference == "" || Number(minimum_reference) <= 0)) {
            $('.errormessage_policy').html("<span class='text-danger'>Enter minimum reference</span>");
        } else if (product_type == "Customer" && type_cus == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select Type</span>");
        } else if (type_cus == "Age Policy" && min_age_c == "") {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum Age</span>");
        } else if (type_cus == "Age Policy" && max_age_c != "" && min_age_c > max_age_c) {
            
            $('.errormessage_policy').html("<span class='text-danger'>Minimum Age cannot be greater than Maximum Age</span>");
        } else if (product_type == "Customers in Union" && (min_customers == "" || min_customers <=0 )) {
                    
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Minimum customers</span>");
        } else if (product_type == "Customers in Union" && (max_customers == "" || max_customers <=0 )) {
                            
            $('.errormessage_policy').html("<span class='text-danger'>Please Enter Maximum customers</span>");
        } else if (product_type == "Customers in Union" && min_customers > max_customers) {
                            
            $('.errormessage_policy').html("<span class='text-danger'>Minimum customers cannot be more than maximum customers</span>");
        } else if (type_cus == "ID Validation" && validate_identity == "Yes" && id_type =="") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Select ID Type</span>");
        } else if (type_cus == "ID Validation" && validate_identity == "Yes" && duplicate_id =="") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Specify if The same ID should be used for different customers</span>");
        } else if (product_type == "Transaction Reversal" && trv_order == "") {
            
            $('.errormessage_policy').html("<span class='text-danger'>Please Reversal Order</span>");
        } 
        else if (product_type != "Customer" && product_type !="Maximum Group Per Relationship Officer" && product_type !="Maximum Individual Client Per Relationship Officer" && product_type != "Missing Identification" && product_type != "Customers in Union" && type_lon != "Maximum Loan Accounts" && type_lon != "Loan Amount Increment" && type_lon != "Minimum Loan Amount" && type_lon != "Access Loan on Loan" && type_lon != "Guarantor" && product_type != "Daily Transaction Limit" && product_type != "Account Approvals" && product_type != "Disable Multiple Workflow Transactions" && product_type != "Account Documents" && product_type !="Force Union Purse" && product_type !="Transaction Reversal" && $("select[name='affected_products[]'] option:selected").length ==0) {
            $('.errormessage_policy').html("<span class='text-danger'>Please select affected products</span>");
        } else if (product_type !="Transaction Reversal" && product_type !="Maximum Group Per Relationship Officer" && product_type !="Maximum Individual Client Per Relationship Officer" && product_type !="Force Union Purse" && product_type != "Missing Identification" && product_type != "Customers in Union" && type_lon != "Maximum Loan Accounts" && type_lon != "Access Loan on Loan" && type_lon != "Loan Amount Increment" && type_lon != "Minimum Loan Amount" && product_type != "Daily Transaction Limit" && product_type != "Account Approvals" && $("select[name='channels[]'] option:selected").length ==0) {
            $('.errormessage_policy').html("<span class='text-danger'>Please select affected channels</span>");
        } else if (product_type =="Daily Transaction Limit" && tr_type == "") {
            $('.errormessage_policy').html("<span class='text-danger'>Please select limit type</span>");
        } else if (product_type =="Force Union Purse" && union_savings == "") {
            $('.errormessage_policy').html("<span class='text-danger'>Please select union savings product type</span>");
        } else if (product_type =="Daily Transaction Limit" && (t_limit == "" || t_limit < 0)) {
            $('.errormessage_policy').html("<span class='text-danger'>Please enter limit amount</span>");
        }
          else if (product_type =="Daily Transaction Limit" && tr_type == "Channel" && t_channel == "") {
            $('.errormessage_policy').html("<span class='text-danger'>Please select channel</span>");
        } else if (product_type =="Daily Transaction Limit" && t_event == "") {
            $('.errormessage_policy').html("<span class='text-danger'>Please select Event</span>");
        } else {
            $('.policy_submit').attr('disabled','disabled');
            $('.errormessage_policy').html("");
            $(this).unbind('submit').submit();
        }
    });
     
});

//$.fn.dataTable.ext.errMode = 'none';
//$.fn.dataTableExt.sErrMode = 'throw';
</script>
<script src="../vendor/select2/select2.min.js"></script>
<script src="../vendor/bootstrap/js/bootstrap.min.js"></script>
		<!-- end: JavaScript Event Handlers for this page -->
		<!-- end: CLIP-TWO JAVASCRIPTS -->
	</body>
</html>
<?php } ?>