$(document).ready(function(){	
	var roleData = $('#addTemplate').click(function(){
		$('#templateModal').modal('show');
		$('#templateForm')[0].reset();
		$('.modal-title').html("<i class='fa fa-plus'></i> Create Product Group");
		$('#action').val('addTemplate');
		$('#save').val('Create');
	});		
	$("#user_info").on('click', '.edit', function(){
		var tid = $(this).attr("id");
		var action = 'getTemplate';
		$.ajax({
			url:'action.php',
			method:"POST",
			data:{tid:tid, action:action},
			dataType:"json",
			success:function(data){
				$('#templateModal').modal('show');
				$('#tid').val(tid);
				$('#templateName').val(data.name);
				$('#type').val(data.type);
				$('#parent').val(data.parent).trigger("change");;
				$('.modal-title').html("<i class='fa fa-plus'></i> Edit Product Group");
				$('#action').val('updateTemplate');
				$('#save').val('Save');
			}
		})
	});
	$("#templateModal").on('submit','#templateForm', function(event){
		event.preventDefault();
		$('#save').attr('disabled','disabled');
		var formData = $(this).serialize();
		$.ajax({
			url:"action.php",
			method:"POST",
			data:formData,
			success:function(data){				
				$('#templateForm')[0].reset();
				$('#templateModal').modal('hide');				
				$('#save').attr('disabled', false);
				dataTable.ajax.reload();
				//alert("Request Successfully");
					//window.location.reload(true);
			}
		})
	});		
	$("#user_info").on('click', '.delete', function(){
		var tid = $(this).attr("id");		
		var action = "templateDelete";
		if(confirm("Are you sure you want to delete this product group?")) {
			$.ajax({
				url:"action.php",
				method:"POST",
				data:{tid:tid, action:action},
				success:function(data) {					
					dataTable.ajax.reload();
					//alert("Role Successfully Deleted");
					//window.location.reload(true);
				}
			})
		} else {
			return false;
		}
	});	

	$('#roleModal').on('hidden.bs.modal', function () {
		//location.reload();
		$('#roleForm')[0].reset();
		$('.modal-body').scrollTop(0);
		//$('.reveal').hide();
		dataTable.ajax.reload();
		$(".select2").val([]).trigger("change");
	   })
});