<?php

/**
* Author : https://www.roytuts.com
*/

require_once 'db.php';
require_once 'jwt_utils.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

	$data = json_decode(file_get_contents("php://input", true));
	$channel = $data->channel;
	$username = $data->username;
    $pwd = $data->password;
	
	
    if($channel == 7) {
        $channel_name = "Mobile App";
    } else if($channel == 8) {
        $channel_name = "Internet Banking";
    } else if($channel == 5) {
        $channel_name = "USSD";
    }
    $query = $dbConn -> prepare('SELECT * FROM users WHERE username=?');
    $query -> bind_param('s', $username);
    $query -> execute();
    $result = $query->get_result();
    
    if ($result->num_rows > 0) {
      $row = $result->fetch_array(MYSQLI_ASSOC);
    
      if($allow_multisession == "Yes" && $row['role'] != 1) {
        $tti = $dbConn -> prepare('SELECT * FROM multisession_roles WHERE role_id =?');
        $tti->bind_param("i", $row['role']);
        $tti->execute();
        $rtti = $tti->get_result();
    
      $oc = $dbConn -> prepare('SELECT token FROM user_session WHERE user_id =?');
      $oc->bind_param("i", $row['id']);
      $oc->execute();
      $ocret = $oc->get_result();
      if($ocret->num_rows > 0) {
    
        $lpc = $ocret->fetch_array(MYSQLI_ASSOC);
    
        if($lpc['token'] == "1" || $rtti->num_rows >0) {
          $log_proceed = 2;
        } else {
          $log_proceed = 1;
        }
    
      } else {
        $log_proceed = 2;
      }
    } else if($allow_multisession == "No") {
      $oc = $dbConn -> prepare('SELECT token FROM user_session WHERE user_id =?');
      $oc->bind_param("i", $row['id']);
      $oc->execute();
      $ocret = $oc->get_result();
      if($ocret->num_rows > 0) {
    
        $lpc = $ocret->fetch_array(MYSQLI_ASSOC);
    
        if($lpc['token'] == "1") {
          $log_proceed = 2;
        } else {
          $log_proceed = 1;
        }
    }
    }
    
    if($allow_multisession == "Yes") {
    $log_proceed = 2;
    }
      $brst = "Active";
      $inb = $db -> prepare('SELECT * FROM branch WHERE id =? AND status=?');
      $inb->bind_param("is", $row['branch'], $brst);
      $inb->execute();
      $rinb = $inb->get_result();
      if($rinb->num_rows == 0) {
        echo json_encode(array('error' => 'Login not allowed. Branch is inactive'));
        
      } else if ($row['is_active'] == "Inactive") {
    
        echo json_encode(array('error' => 'Login not allowed. User is inactive'));
    
      } else if($row['is_locked'] == "Locked") {
    
      echo json_encode(array('error' => 'Login not allowed. User is locked'));
      } else if($log_proceed == 1) {
        echo json_encode(array('error' => 'Multisession not allowed. You are currently logged in on another device'));
    
        } else if (password_verify($pwd, $row['password']) && $row['is_active'] == "Active" && $row['is_locked'] == "Not Locked") {
        //FOR MULTI SESSION
        $token = openssl_random_pseudo_bytes(16);
        $token = bin2hex($token);
    
        $_SESSION['username'] = $username;
        $_SESSION['LAST_ACTIVITY'] = time();
        $_SESSION['success_admin'] = "logged";
        $_SESSION['log_token'] = $token;
    
    
        //INSERT OR UPDATE USER TOKEN
        $slt = $dbConn -> prepare('SELECT * FROM user_session WHERE user_id =?');
        $slt->bind_param("i", $row['id']);
        $slt->execute();
        $rslt = $slt->get_result();
    
        if ($rslt->num_rows > 0) {
    
            $mo = $dbConn->prepare("UPDATE user_session SET token=? WHERE user_id=?");
            $mo->bind_param('si', $token, $row['id']);
            $mo->execute();
            $mo->close();
    
        } else {
          $tnk = $dbConn->prepare("INSERT INTO user_session (user_id, token) VALUES (?,?)");
          $tnk->bind_param("is", $row['id'], $token);
          $tnk->execute();
        }
    
        date_default_timezone_set("Africa/Lagos");
        $curr_time = date("Y-m-d H:i:s");
    
        $pik = $dbConn -> prepare('SELECT * FROM user_login WHERE user_id =?');
        $pik->bind_param("i", $row['id']);
        $pik->execute();
        $rpik = $pik->get_result();
    
        if ($rpik->num_rows > 0) {
    
            $po = $dbConn->prepare("UPDATE user_login SET datetime=? WHERE user_id=?");
            $po->bind_param('si', $curr_time, $row['id']);
            $po->execute();
            $po->close();
    
        } else {
            $mju = $dbConn->prepare("INSERT INTO user_login (user_id, datetime) VALUES (?,?)");
            $mju->bind_param("is", $row['id'], $curr_time);
            $mju->execute();
        }
    
    
    
        $aid = $row['id'];
    
    
        //header('location: index');
        //INSERT LOGIN DETAILS INTO ACTIVITY TABLE
        $act_dsc = "User Login $channel_name";
        $act_type = "Login";
        $entity_id = "LG$channel";
        $channel = 6;
        $ww = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $row['id'], $row['branch'], $channel);
        $ww->execute();
    
        //UPDATE LOGIN ATTEMPT
        $zro = 0;
        $io = $dbConn->prepare("UPDATE login_attempts SET attempts=? WHERE user_id=?");
        $io->bind_param('ii', $zro, $aid);
        $io->execute();
        $io->close();
    
    
        if ($row['reset_browser']==1) {
    
          $tu = 2;
          $browser_agent = $_SERVER['HTTP_USER_AGENT'].$aid;
          $ubra = $dbConn->prepare("UPDATE users SET us_agent=?, reset_browser=? WHERE id=?");
          $ubra->bind_param('sii', $browser_agent, $tu, $aid);
          $ubra->execute();
          $ubra->close();
    
        } 
    
    
        if (($row['changepass_on_first_login']==1 && $row['ist_log']==1) || $row['updated_pwd']== 1) {
    
          $route = 1;//send to change password page
          
      } else {
        $route = 2; //send to dashboard
      }
    
      $message = "Success";
      $output = array(
          'message'   => $message,
          'route' => $route,
          //'organization_code' => $u_code,
          //'api_key' => $live_api,
          //'secret_key' => $live_key,
          //'status' => $status
          );
    
      echo json_encode($output);
      
      } else {
      //LOCK HERE IS SET $row['id']
      if($login_attempts_lock == "Yes") {
      $oc = $dbConn -> prepare('SELECT attempts FROM login_attempts WHERE user_id =?');
            $oc->bind_param("i", $row['id']);
      $oc->execute();
      $ocret = $oc->get_result();
    
        if ($ocret->num_rows == 0) {
          $attmt = 1;
          $w3 = $dbConn->prepare("INSERT INTO login_attempts (user_id, attempts) VALUES (?,?)");
          $w3->bind_param("ii", $row['id'], $attmt);
          $w3->execute();
          
        } else {
    
          while($occ = mysqli_fetch_array($ocret) ){
            $attmt = $occ['attempts'];
          }
          $new_attempt = $attmt + 1;
    
          $io = $dbConn->prepare("UPDATE login_attempts SET attempts=? WHERE user_id=?");
          $io->bind_param('ii', $new_attempt, $row['id']);
          $io->execute();
          $io->close();
    
        }
        $left_attempt = $login_attempts_lock_no - $attmt;
    
        if($left_attempt<=0) {
    
          //UPDATE USER STATUS TO LOCKED HERE
          $lok = "Locked";
          $lu = $dbConn->prepare("UPDATE users SET is_locked=? WHERE id=?");
          $lu->bind_param('si', $lok, $row['id']);
          $lu->execute();
          $lu->close();
    
          echo json_encode(array('error' => 'Wrong username/password combination. User locked. Contact Administrator'));
    
        } else {
          echo json_encode(array('error' => 'Wrong username/password combination. You have $left_attempt attempt(s) Left'));
    
        }
    
        } else {
        echo json_encode(array('error' => 'Wrong username/password combination'));
      }
      }
    } else {
    echo json_encode(array('error' => 'Wrong username'));
    }