<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//ob_start();
require_once 'db.php';
require_once 'jwt_utils.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	// get posted data
	$data = json_decode(file_get_contents("php://input", true));
	$api = $data->api;
	$secret = $data->secret;

	$active = "Active";
	$sql = $dbConn -> prepare("SELECT * FROM channel_access_check WHERE api_live=? AND secret_live=? AND status=? LIMIT 1");
    $sql->bind_param("sss", $api, $secret, $active);
    $sql->execute();
    $result = $sql->get_result();

	if ($result->num_rows < 1) {
		echo json_encode(array('error' => 'Unauthorized Access'));
	} else {
		while($row = mysqli_fetch_assoc($result) ){
			$api = $row['api_live'];

		$headers = array('alg'=>'HS256','typ'=>'JWT');
		$payload = array('api'=>$api, 'exp'=>(time() + 120));

		$jwt = generate_jwt($headers, $payload);
		
		echo json_encode(array('token' => $jwt));

		}
	}
}
//End of file
//ob_end_flush();