<?php

//branch status
function branStatus($dbConn, $usbrn) {
    $brst = "Active";
    $inb = $dbConn -> prepare('SELECT * FROM branch WHERE id =? AND status=?');
    $inb->bind_param("is", $usbrn, $brst);
    $inb->execute();
    $rinb = $inb->get_result();
    if($rinb->num_rows == 0) {
      $brn_inactive = 1;
    } else {
       $brn_inactive = 0;
    }
    return $brn_inactive;
}
//role status
function rolStatus($dbConn, $role) {
    $brst = "Active";
    $inb = $dbConn -> prepare('SELECT * FROM roles WHERE id =? AND status=?');
    $inb->bind_param("is", $role, $brst);
    $inb->execute();
    $rinb = $inb->get_result();
    if($rinb->num_rows == 0) {
      $role_inactive = 1;
    } else {
       $role_inactive = 0;
    }
    return $role_inactive;
}
//lookup account_number for user registration
function lookAccount($dbConn, $acc){
    $inv = "Invalid";
    $inv1 = "Closed";
    $inv2 = "Pending";
    $check = $dbConn->prepare("SELECT id FROM customer_user WHERE customer_id IN(SELECT customer_id FROM accounts WHERE account_number=? AND status !=? AND status !=? AND status !=?)");
    $check->bind_param("ssss", $acc, $inv, $inv1, $inv2);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows < 1){
        $row = $check_res->fetch_array(MYSQLI_ASSOC);

            $check1 = $dbConn->prepare("SELECT customer_id, ctype, company_name, fname, mname, lname, phone_no, email FROM customer WHERE customer_id IN(SELECT customer_id FROM accounts WHERE account_number=? AND status !=? AND status !=? AND status !=?)");
            $check1->bind_param("ssss", $acc, $inv, $inv1, $inv2);
            $check1->execute();
            $check_res1 = $check1->get_result();

                if ($check_res1->num_rows>0){
                    $data = array();
                    //echo "Phone Number available for registration";
                    $rown = $check_res1->fetch_array(MYSQLI_ASSOC);
                    $data = array (
                        "message" => "success",
                        "ctype" => $rown["ctype"],
                        "customer_id" => $rown["customer_id"],
                        "company_name" => $rown["company_name"],
                        "fname" => $rown["fname"],
                        "mname" => $rown["mname"],
                        "lname" => $rown["lname"],
                        "phone_no" => $rown["phone_no"],
                        "email" => $rown["email"],
                    );
                    echo json_encode($data);
                } else {

                    echo json_encode(array('message' => 'Customer not Found'));
                }
        
    } else {
        echo json_encode(array('message' => 'This Account Number is already in use. Please login with your username'));
    }
}

//check username
function checkUsername($dbConn, $usn) {

    $sql = $dbConn -> prepare('SELECT username FROM customer_user WHERE username=?');
    $sql -> bind_param('s', $usn);
    $sql -> execute();
    $count = $sql->get_result();

    if($count->num_rows > 0)
    {
        echo json_encode(array("message" => "<span style='color:red'>Username already exists. Please choose another</span>"));
    } else {
        echo json_encode(array("message" => "<span style='color:green'>Username available for Registration.</span>"));
    }
}
//dva account
function getDVA($dbConn, $account_id) {
    $check = $dbConn->prepare("SELECT dva_account, dva_bank, dv_account_name FROM accounts WHERE id=?");
    $check->bind_param("i", $account_id);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows>0){
        $row = $check_res->fetch_array(MYSQLI_ASSOC);
        $dva_account= $row["dva_account"];
        $dva_bank_id = $row["dva_bank"];
        $dva_account_name = $row["dv_account_name"];

        $mok = $dbConn->prepare("SELECT name FROM banks WHERE code=?");
        $mok->bind_param("s", $dva_bank_id);
        $mok->execute();
        $rmok = $mok->get_result();
        $nb = $rmok->fetch_array(MYSQLI_ASSOC);
        $dva_bank = $nb["name"];

        $data = array (
            "dva_account" => $dva_account,
            "dva_bank" => $dva_bank,
            "dva_account_name" => $dva_account_name,
        );

        echo json_encode($data);
    }
}
//send signup otp
function signUpOTP($dbConn, $stype, $to, $cuid, $usn, $egis_api, $egis_secret, $egis_api_root, $site_name, $org_code) {

    //delete all codes for this user
    $w1 = $dbConn->prepare("DELETE FROM otp_codes  WHERE receiver=? AND cuid=?");
    $w1->bind_param("si", $to, $cuid);
    $w1->execute();

    //get customer branch
    $check = $dbConn->prepare("SELECT fname, branch FROM customer WHERE customer_id=?");
    $check->bind_param("i", $cuid);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows>0){
        $row = $check_res->fetch_array(MYSQLI_ASSOC);
        $fname= $row["fname"];
        $branch = $row["branch"];
    }



    //GENERATE THE CODE
    $otp = mt_rand(1111,9999);
    //INSERT INTO OTP CODES
    $w = $dbConn->prepare("INSERT INTO otp_codes (cuid, receiver, username, stype, otp) VALUES (?,?,?,?,?)");
    $w->bind_param("issss", $cuid, $to, $usn, $stype, $otp);
    $w->execute();
    //$last_id = mysqli_insert_id($db);

    //SEND OTP

    $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
               
    $ch1 = curl_init();
    curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login");
    curl_setopt($ch1, CURLOPT_POST, 1);
    curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);

    $headers1 = [
    'Content-Type: application/json'
    ];

    curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);

    $request1 = curl_exec ($ch1);

    curl_close ($ch1);
    if ($request1) {
    $result1 = json_decode($request1, true);
    }
        
    $token = $result1['token'];

    switch($stype) {
        case "phone":
            $message = "Your Sign up OTP is $otp";
            $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $branch, 'recipient_phone' => $to, 'message' => $message);
            $ext = "sms";

        break;

        case "email":
            $message = "Hi, $fname, </br>Your Sign up OTP is <b>$otp</b>. </br> Kindly use it to authorize your sign up on the app. </br></br>$site_name Team.";
            $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $branch, 'email' => $to, 'message' => $message);
            $ext = "email";
        break;
    }
            $ch3 = curl_init();
            curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/$ext");
            curl_setopt($ch3, CURLOPT_POST, 1);
            curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
            curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
            //Set your auth headers
            curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
            ));
               
            // get stringified data/output. See CURLOPT_RETURNTRANSFER
            $data1 = curl_exec($ch3);
}

//verify signup and register user
function signUpVerify($dbConn, $fn, $ln, $cuid, $usn, $o, $ot, $egis_api, $egis_secret, $egis_api_root, $site_name, $org_code, $channel_log) {

    //VERIFY OTP
    $check = $dbConn->prepare("SELECT id FROM otp_codes WHERE username=? AND otp=?");
    $check->bind_param("ss", $usn, $ot);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows>0){

        $w1 = $dbConn->prepare("DELETE FROM otp_codes  WHERE username=? AND otp=?");
        $w1->bind_param("ss", $usn, $ot);
        $w1->execute();

        if($fn !="") {
            $cfn = $fn; 
        } else {
            $cfn = NULL;
        }
        if($ln !="") {
            $cln = $ln; 
        } else {
            $cln = NULL;
        }

        $hash = password_hash($o,PASSWORD_DEFAULT);
        $regdate = date("Y-m-d H:i:s");
        $role_now = 100; //this is the hardcoded role for all mobile banking customers
        $status = "Active";
        $aid = 0;

        $w = $dbConn->prepare("INSERT INTO customer_user (customer_id, username, role, fname, lname, password, status, last_updated_password, created_by, date_created) VALUES (?,?,?,?,?,?,?,?,?,?)");
        $w->bind_param("isisssssis", $cuid, $usn, $role_now, $cfn, $cln, $hash, $status, $regdate, $aid, $regdate);
        $w->execute();
        if($w) {
            $last_id = mysqli_insert_id($dbConn);
            $entity_id = "CUSSUP";

            $alla = $dbConn->prepare("SELECT branch FROM customer WHERE customer_id=?");
            $alla->bind_param("i", $cuid);
            $alla->execute();
            $ralla = $alla->get_result();

            if ($ralla->num_rows>0){
                $aio = $ralla->fetch_array(MYSQLI_ASSOC);
                $usbrn = $aio["branch"];
            }

            //INSERT NET AMOUNT INTO ACTIVITY TABLE
            $act_dsc = "New Customer User Signup - $last_id";
            $act_type = "Audit";
            $ww = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
            $ww->execute();
        
            echo json_encode(array('message' => 'Sign Up Successful'));
        }
    } else {
        echo json_encode(array('message' => 'Incorrect OTP'));
    }
}
 //register user
function registerUser($dbConn, $phone_no, $password, $confirm_password){
    $utype = "Customer";
    $is_active = "Inactive";
    $is_locked = "Not Locked";
    $cofl = 1;
    $pne = 2;
    $flg = 2;
    $created_by = 0;
    $date_joined = date("Y-m-d");

    $check = $dbConn->prepare("SELECT * FROM customer WHERE phone_no=?");
    $check->bind_param("s", $phone_no);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows>0){
        $row = $check_res->fetch_array(MYSQLI_ASSOC);
        $fname= $row["fname"];
        $lname = $row["lname"];
        $branch = $row["branch"];
        $email = $row["email"];
    

        $check1 = $dbConn->prepare("SELECT * FROM users WHERE username=?");
        $check1->bind_param("s", $phone_no);
        $check1->execute();
        $check_res1 = $check1->get_result();

        if ($check_res1->num_rows>0){
            echo "This user already exists";
        } else {
            $hash = password_hash($password,PASSWORD_DEFAULT);
            $ins = $dbConn->prepare("INSERT INTO users (utype, username, fname, lname, email, password, changepass_on_first_login,
            pass_never_expire, branch, is_active, is_locked, date_joined, ist_log, created_by)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $ins->bind_param("ssssssiiisssii", $utype, $phone_no, $fname, $lname, $email, $hash, $cofl, $pne, $branch, $is_active,
            $is_locked, $date_joined, $flg, $created_by);
            $ins->execute();

            if ($ins){
                 echo json_encode(array('message' => 'Sign Up Successful'));
     
             } else {
                 echo json_encode(array('message' => 'Error, Try again'));

             }
        }

    } else {
        echo json_encode(array('message' => 'Customer not Found'));

    }
        
}
// Call with function registerUser($dbConn, $phone_no, $password, $confirm_password);

//check phone
function checkPhone($dbConn, $phone_no){
    $check = $dbConn->prepare("SELECT * FROM users WHERE username=?");
    $check->bind_param("s", $phone_no);
    $check->execute();
    $check_res = $check->get_result();

    if ($check_res->num_rows==0){
        $row = $check_res->fetch_array(MYSQLI_ASSOC);

            $check1 = $dbConn->prepare("SELECT * FROM customer WHERE phone_no=?");
            $check1->bind_param("s", $phone_no);
            $check1->execute();
            $check_res1 = $check1->get_result();

                if ($check_res1->num_rows>0){
                    echo "Phone Number available for registration";
                    echo json_encode(array('message' => 'Phone Number available for registration'));
                } else {

                    echo json_encode(array('message' => 'Customer not Found'));
                }
        
    } else {
        echo json_encode(array('message' => 'This Phone Number is already in use. Please login with your username'));
    }
}
//Call with checkPhone($dbConn, $phone_no);

function customerId($dbConn){
    $check = $dbConn->prepare("SELECT customer_id FROM customer WHERE phone_no IN (SELECT username FROM users WHERE username=?)");
    $check->bind_param("s", $_SESSION["username"]);
    $check->execute();
    $check_res = $check->get_result();
    $cust = $check_res->fetch_array(MYSQLI_ASSOC);    
    echo json_encode(array('customer_id' => $cust['customer_id']));
}
//access with customerId($dbConn);

//accounts list
function accounts($dbConn, $customer_id){
    $clo = "Closed";
    $clo1 = "Invalid";
    $clo2 = "Escheated";
    $clo3 = "Pending";
    $check = $dbConn->prepare("SELECT * FROM accounts WHERE customer_id=? AND status!=? AND status!=? AND status!=? AND status!=?");
    $check->bind_param("issss", $customer_id, $clo, $clo1, $clo2, $clo3);
    $check->execute();
    $check_res = $check->get_result();
    $data = array();

    while ($accnt = $check_res->fetch_array(MYSQLI_ASSOC)){
        $data = array (
            "id" => $accnt["id"],
            "account_number" => $accnt["account_number"],
            "product_type" => $accnt["product_type"],
            "product" => $accnt["product"],
            "cleared_balance" => $accnt["cleared_balance"],
            "ledger_balance" => $accnt["ledger_balance"],
            "creation_date" => $accnt["creation_date"],
            "application_date" => $accnt["application_date"],
            "approved_date" => $accnt["approved_date"],
            "status" => $accnt["status"],
            "last_updated" => $accnt["last_updated"],
            "online_enabled" => $accnt["online_enabled"],

        );

    }
    echo json_encode ($data);
}
//call with accounts($dbConn, $customer_id)

//account details
function accountDetails($dbConn, $accid){
    $check = $dbConn->prepare("SELECT * FROM accounts WHERE id=?");
    $check->bind_param("i", $accid);
    $check->execute();
    $check_res = $check->get_result();
    $data = array();

    while ($accnt = $check_res->fetch_array(MYSQLI_ASSOC)){
        //get secondary branch name

        $bnk = $dbConn -> prepare('SELECT name FROM branch WHERE id=?');
        $bnk -> bind_param('i', $accnt["secondary_branch"]);
        $bnk -> execute();
        $rbnk = $bnk->get_result();

        while($lb = mysqli_fetch_assoc($rbnk) ){
            $branch_name = $lb["name"];
        }

        //get rm name

        $rmg = $dbConn -> prepare('SELECT fname, lname FROM users WHERE id=?');
        $rmg -> bind_param('i', $accnt["secondary_relationship_manager"]);
        $rmg -> execute();
        $rrmg = $rmg->get_result();

        while($rnm = mysqli_fetch_assoc($rrmg) ){
            $rm_name = $rnm["fname"]. " ". $rnm["lname"];
        }

        $data = array (
            "id" => $accnt["id"],
            "account_number" => $accnt["account_number"],
            "product_type" => $accnt["product_type"],
            "product" => $accnt["product"],
            "primary_branch" => $accnt["branch"],
            "secondary_branch" => $accnt["secondary_branch"],
            "branch_name" => $branch_name,
            "rm_name" => $rm_name,
            "primary_relationship_manager" => $accnt["primary_relationship_manager"],
            "secondary_relationship_manager" => $accnt["secondary_relationship_manager"],
            "opening_amount" => $accnt["opening_amount"],
            "creation_date" => $accnt["creation_date"],
            "loan_amount" => $accnt["loan_amount"],
            "plan_amount" => $accnt["plan_amount"],
            "linked_savings_account" => $accnt["linked_savings_account"],
            "origin_of_funding" => $accnt["origin_of_funding"],
            "loan_term" => $accnt["loan_term"],
            "term_type" => $accnt["term_type"],
            "application_date" => $accnt["application_date"],
            "payment_frequency" => $accnt["payment_frequency"],
            "plan_duration" => $accnt["plan_duration"],
            "term_duration" => $accnt["term_duration"],
            "term_duration_type" => $accnt["term_duration_type"],
            "agreed_interest_rate" => $accnt["agreed_interest_rate"],
            "maturity_roll_over" => $accnt["maturity_roll_over"],
            "beneficiary_account_type" => $accnt["beneficiary_account_type"],
            "beneficiary_account_own" => $accnt["beneficiary_account_own"],
            "beneficiary_acc_other" => $accnt["beneficiary_acc_other"],
            "customer_old" => $accnt["customer_old"],
            "beneficiary_acc_bank" => $accnt["beneficiary_acc_bank"],
            "beneficiary_acc_number" => $accnt["beneficiary_acc_number"],
            "rollover_duration" => $accnt["rollover_duration"],
            "status" => $accnt["status"],
            "cleared_balance" => $accnt["cleared_balance"],
            "ledger_balance" => $accnt["ledger_balance"],
            "interest_capitalization_period" => $accnt["interest_capitalization_period"],
            "planned_liquidation_date" => $accnt["planned_liquidation_date"],
            "last_interest_accrual_date" => $accnt["last_interest_accrual_date"],
            "disbursement_method" => $accnt["disbursement_method"],
            "disbursement_account_no" => $accnt["disbursement_account_no"],
            "total_debited_thrift_fee" => $accnt["total_debited_thrift_fee"],
            "sms_alert" => $accnt["sms_alert"],
            "email_alert" => $accnt["email_alert"],
            "currency" => $accnt["currency"],
            "approval_date" => $accnt["approval_date"],

        );

    }
    echo json_encode ($data);
}

//create pin
function createPin($dbConn, $accid, $pin, $usbrn){
    $hash1 = password_hash($pin,PASSWORD_DEFAULT);
    $ins = $dbConn->prepare("INSERT INTO account_pin (account_id, pin)VALUES(?,?)");
    $ins->bind_param("is", $accid, $hash1);
    $ins->execute();

    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {
        if ($ins){
            echo json_encode(array('message' => 'Yes'));
        } else {
            echo json_encode(array('message' => 'No'));
        }
    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
}

//call with createPin($dbConn, $accid, $pin)
//update pin
function updatePin ($dbConn, $acc_id, $old_pin, $pin, $usbrn){
    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {
        $check2 = $dbConn->prepare("SELECT * FROM account_pin WHERE account_id=?");
        $check2->bind_param("i", $acc_id);
        $check2->execute(); 
        $check_res2 = $check2->get_result();

        if ($check_res2->num_rows>0){
            $row2 = $check_res2->fetch_array(MYSQLI_ASSOC);
                if (password_verify($old_pin, $row2["pin"])){
                    $hash2 = password_hash($pin,PASSWORD_DEFAULT);
                    $update = $dbConn->prepare("UPDATE account_pin SET pin = ? WHERE account_id = ?");
                    $update->bind_param ("si", $hash2, $acc_id);
                    $update->execute();

                    if ($update){
                        echo json_encode(array('message' => 'PIN updated successfully'));
                    }
                    
                } else {
                    echo json_encode(array('message' => 'Old PIN incorrect'));
                }

        } else {
            echo json_encode(array('message' => 'You have not set a PIN'));
        }
    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
}

//call with updatePin ($dbConn, $acc_id, $old_pin, $pin)
// transaction list
function transactionList($dbConn, $account_number, $start, $end){
    $check2 = $dbConn->prepare("SELECT * FROM transactions WHERE account_number=? AND id >=? ORDER BY id DESC LIMIT ?");
    $check2->bind_param("sii", $account_number, $start, $end);
    $check2->execute(); 
    $check_res2 = $check2->get_result();

    if ($check_res2->num_rows>0){
    $data = array();

    while ($list = $check_res2->fetch_array(MYSQLI_ASSOC)){
        if ($list["to_account"] != ""){
            $check3 = $dbConn->prepare("SELECT * FROM egis_transfer_accounts WHERE account_no=?");
            $check3->bind_param("s", $list["to_account"]);
            $check3->execute(); 
            $check_res3 = $check3->get_result();
            while ($row3 = $check_res3->fetch_array(MYSQLI_ASSOC)){
                $account_name = $row3["account_name"];
                $account_name ="$account_name/";
            }
        } else {
            $account_name = "";
        }

        $data = array (
            "id" => $list["id"],
            "transaction_amount" => $list["transaction_amount"],
            "transaction_type" => $list["transaction_type"],
            "value_date" => $list["value_date"],
            "to_account" => $list["to_account"],
            "transaction_description" => $list["transaction_description"],
            "account_name" =>$account_name
        );

        }
    } else {
        $data=0;
    }
    echo json_encode ($data);
 
}
// call with transactionList($dbConn, $account_number, $start, $end)
//check pin
function checkPin($dbConn, $account_number){
    $check2 = $dbConn->prepare("SELECT * FROM account_pin WHERE account_id IN (SELECT id from accounts WHERE account_number=?)");
    $check2->bind_param("s", $account_number);
    $check2->execute(); 
    $check_res2 = $check2->get_result();

    if ($check_res2->num_rows>0){
        $data = "Yes";
    } else {
        $data = "No";
    }

    echo json_encode ($data);
}
//call with checkPin($dbConn, $account_number)
//validate account
function validateAccount($dbConn, $acc_no, $type, $usbrn){
    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {

        switch($type) {
            case "Inbound":
    
                $pod = $dbConn -> prepare('SELECT * FROM accounts WHERE account_number=?');
                $pod -> bind_param('s', $acc_no);
                $pod -> execute();
                $rpod = $pod->get_result();
    
                if ($rpod->num_rows == 0) {
                    echo json_encode(array('message' => 'This account number does not exist on our system.'));
                } else {
                    while($row = mysqli_fetch_assoc($rpod) ){
                        $customer_id = $row['customer_id'];
                        $cleared_balance = round($row['cleared_balance'], 2);
                        //$linked_savings_account = $row['linked_savings_account'];
                        $product_type = $row['product_type'];
                        $pr_id = $row['product'];
                        $account_status = $row['status'];
                        $account_branch = $row['secondary_branch'];
                        //$agreed_interest_rate = $row['agreed_interest_rate'];
                    }

                    $actus = "Active";
                    $chb = $dbConn -> prepare('SELECT * FROM branch WHERE id=? AND status=?');
                    $chb -> bind_param('is', $account_branch, $actus);
                    $chb -> execute();
                    $rchb = $chb->get_result();
                    if($rchb->num_rows > 0) {
                        $dsb = 1;
                    } else {
                        $dsb = 0;
                    }
    
                    if($product_type == "Savings") {
                        $active_d = "Active";
                        $pty_d = "Savings Account";
                        $nm_d = "Dormant";
                        
                        $credits1 = "Credit Transactions";
                            $crpnd1 = $dbConn -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
                            $crpnd1->bind_param("sss", $pty_d, $active_d, $nm_d);
                            $crpnd1 -> execute();
                            $rcrpnd1 = $crpnd1->get_result();
                            if ($rcrpnd1->num_rows > 0) {
                    
                                while($jvx1 = mysqli_fetch_assoc($rcrpnd1) ){  
                                    
                                    if(strpos($jvx1['affected_products'], ' , ') !== false) {
                                        // explodable
                                        $productssarray1 = explode(' , ',$jvx1['affected_products']);
                                        
                                    } else {
                                        // not explodable
                                        $productssarray11 = array($jvx1['affected_products']);
                                    }
                    
                                    if(strpos($jvx1['restrict_events'], ' , ') !== false) {
                                    // explodable
                                    $eventsarray1 = explode(' , ',$jvx1['restrict_events']);
                                    
                                    } else {
                                        // not explodable
                                        $eventsarray1 = array($jvx1['restrict_events']);
                                    }
                                }
                    
                                if (in_array($pr_id, $productssarray1)) {
                    
                                    $pvalid1 = 1;
                    
                                } else {
                                    $pvalid1 = 0;
                                }
                    
                                if (in_array($credits1, $eventsarray1)) {
                    
                                    $acdts1 = 1;
                    
                                } else {
                                    $acdts1 = 0;
                                }
                    
                                if($pvalid1 == 1 && $acdts1 == 1) {
                                    $a_cdt1 = 1;
                                } else {
                                    $a_cdt1 = 0;
                                }
                            } else {
                                $a_cdt1 = 0;
                            }
                            } else {
                                $a_cdt1 = 0;
                            }

                            if ($product_type == "Loan") {
                                echo json_encode(array('message' => 'Loan account number not accepted.'));
                            } else if ($dsb == 0) {
                                echo json_encode(array('message' => 'Destination branch unavailable'));
                            } else if ($a_cdt1 == 1 && $account_status == "Dormant") {
                                echo json_encode(array('message' => 'Destination account is dormant and cannot receive transfers.'));
                            } else if ($product_type == "Term Deposit") {
                                echo json_encode(array('message' => 'Term Deposit account number not accepted.'));
                            } else {
                                $prn = $dbConn -> prepare("SELECT name FROM globalproducts WHERE global_pid=?");
                                $prn -> bind_param('s', $pr_id);
                                $prn->execute();
                                $rprn = $prn->get_result();
    
                                while($tpn = mysqli_fetch_array($rprn) ){
                                    $pr_name = $tpn['name'];
                                }
    
                                $pod1 = $dbConn -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
                                $pod1 -> bind_param('i', $customer_id);
                                $pod1 -> execute();
                                $rpod1 = $pod1->get_result();
                                while($row1 = mysqli_fetch_assoc($rpod1) ){
                                    $customer_name = $row1['fname'] . " " . $row1['mname'] . " " . $row1['lname'];
                                }
                                echo json_encode(array("message" => "$pr_name account number $customer_old ($product_type) | Account Holder: $customer_name"));
                            }
                    }
    
            break;
            case "Outbound":
    
            break;
        }


    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }        
}

//save beneficiary
function saveBeneficiary($dbConn, $from_account, $to_account, $type, $bank_code, $egis_transfers, $egis_api, $egis_secret, $egis_api_root, $org_code, $usbrn){

    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {
        switch($type){
            case "Inbound":
    
                $check1 = $dbConn->prepare("SELECT id FROM accounts where account_number=?");
                $check1->bind_param("s", $from_account);
                $check1->execute(); 
                $check_res1 = $check1->get_result();
    
                $row1 = $check_res1->fetch_array(MYSQLI_ASSOC);
                $acid = $row1["id"];
    
                $ckav = $dbConn->prepare("SELECT * FROM beneficiary where ben_account_no=? AND account_id=?");
                $ckav->bind_param("si", $to_account, $acid);
                $ckav->execute(); 
                $rckav = $ckav->get_result();
    
                if($rckav->num_rows ==0) {
                    $ins = $dbConn->prepare("INSERT INTO beneficiary (account_id, ben_account_no)VALUES(?,?)");
                    $ins->bind_param("is", $aid, $to_account);
                    $ins->execute();
                }
    
            break;
    
            case "Outbound":
    
                $check1 = $dbConn->prepare("SELECT * FROM accounts where account_number=?");
                $check1->bind_param("s", $from_account);
                $check1->execute(); 
                $check_res1 = $check1->get_result();
    
                $row1 = $check_res1->fetch_array(MYSQLI_ASSOC);
                $acid = $row1["id"];
                $customer_id = $row1["customer_id"];
    
                if ($egis_transfers == 1) {
                    echo json_encode(array('message' => 'You are currently disabled from using this service'));
                }  else {
    
                    $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
            
                    $ch1 = curl_init();
                    curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                    curl_setopt($ch1, CURLOPT_POST, 1);
                    curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
            
                    $headers1 = [
                    'Content-Type: application/json'
                    ];
            
                    curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
            
                    $request1 = curl_exec ($ch1);
            
                    curl_close ($ch1);
                    if ($request1) {
                    $result1 = json_decode($request1, true);
                    }
                        
                    $token = $result1['token'];
            
                    $postdata2 =  array('organization_code' => $org_code, 'branch_id' => $usbrn, 'bank_code' => $bank_code, 'account_no' => $to_account, 'customer_id' => $customer_id);
            
                    $ch2 = curl_init();
                    curl_setopt($ch2, CURLOPT_URL,"$egis_api_root/create_transfer_recipient.php");
                    curl_setopt($ch2, CURLOPT_POST, 1);
                    curl_setopt($ch2, CURLOPT_POSTFIELDS,json_encode($postdata2));  //Post Fields
                    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                    //Set your auth headers
                    curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                    ));
            
                    // get stringified data/output. See CURLOPT_RETURNTRANSFER
                    $data = curl_exec($ch2);
            
                    $decode = json_decode($data);
            
                    //echo $decode;
            
                    if($decode == "Unable to verify account number") {
                       // echo $decode;
                        echo json_encode(array("message" => $decode));
                    } else {
                        //echo var_dump($decode);
                    if (is_array($decode)) {
                    foreach($decode as $decode): 
                    $recipient_code = $decode->recipient_code;
                    $paystack_id = $decode->paystack_id;
                    $updatedAt = $decode->updatedAt;
                    $account_name = $decode->account_name;
            
                    $hgi = $dbConn -> prepare('SELECT * FROM egis_transfer_accounts WHERE customer_id=? AND account_no =? AND bank_code=?');
                    $hgi -> bind_param('iss', $customer_id, $to_account, $bank_code);
                    $hgi -> execute();
                    $rhgi = $hgi->get_result();
            
                    if ($rhgi->num_rows == 0) {
            
            
                    $sto = $dbConn->prepare("INSERT INTO egis_transfer_accounts (customer_id, account_no, account_name, bank_code, egis_paystack_id, recipient_code, egis_paystack_date) VALUES (?,?,?,?,?,?,?)");
                    $sto->bind_param("issssss", $customer_id, $to_account, $account_name, $bank_code, $paystack_id, $recipient_code, $updatedAt);
                    $sto->execute();
            
                        if($sto) {
                            //echo $account_name;
                            echo json_encode(array("message" => $account_name));
                            }
                        } else {
                            //this is deliberate
                            //echo $account_name;
                            echo json_encode(array("message" => $account_name));
                        }
                    endforeach;
                        } else {
                            //echo "Unable to verify account number";
                            echo json_encode(array("message" => "Unable to verify account number"));
                        }
                    }
                }
    
            break;
        }


    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
}

//Confirm Transfer
function confirmTransfer($dbConn, $from_account, $to_account, $reference, $amount, $type, $status, $value_date, $egis_transfers, $is_sms_active, $is_email, $inbound, $outbound, $egis_api, $egis_secret, $egis_api_root, $org_code, $channel_log, $aid, $usbrn){
    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {

        $processed = 0;
    $transfer_comment = $reference;
    $thrift_test = 0;

            $check = $dbConn->prepare("SELECT * FROM accounts where account_number=?");
            $check->bind_param("s", $from_account);
            $check->execute(); 
            $check_res = $check->get_result();

            $row = $check_res->fetch_array(MYSQLI_ASSOC);

            $cleared_balance = $row["cleared_balance"];

            if (($type == "Inbound" && $inbound == "") || ($type == "Outbound" && $outbound == "")) {
                echo json_encode(array("message" => "System Unvailable. Try again later"));
            } else {

                if ($type == "Inbound") {
                    $maingl = $inbound;
                } else if ($type == "Outbound") {
                    $maingl = $outbound;
                }
                $onee = 1;
                $rev = "X";
                $value_date = date("Y-m-d");
                $today_date = date("Y-m-d");

                $charge_amount_trt_r = 0;
                if ($type == "Inbound" || $type == "Own Account") {
                    $beneficiary_acc_bank = "$site_name Bank";

                    if($type == "Inbound") {
                        $charge_text = "Inbound Transfer Fee";
                    } else {
                    $charge_text = "Egis Deliberately Set: No Charge";
                    }

                    $actionid_ftr = 41;
                    $entityid_ftr = 41;
                    $vr_type = "Internal Transfer";

                    $closed = "Closed";
                    $pod5 = $dbConn -> prepare('SELECT * FROM accounts WHERE account_number=? AND status !=?');
                    $pod5 -> bind_param('ss', $to_account, $closed);
                    $pod5 -> execute();
                    $rpod5 = $pod5->get_result();
                    if ($rpod5->num_rows > 0) {
                    while($row5 = mysqli_fetch_assoc($rpod5) ){
                        $account_id_r = $row5['id'];
                        $cleared_balance5 = $row5['cleared_balance'];
                        $receiver_id = $row5['customer_id'];
                        $product5 = $row5['product'];
                        $product_type5 = $row5['product_type'];
                        $receiver_branch = $row5["secondary_branch"];
                        $receiver_rm = $row5["secondary_relationship_manager"];
                        $sms_alert_r = $row5["sms_alert"];
                        $email_alert_r = $row5["email_alert"];
                        $receiver_status = $row5["status"];
                        $plan_amount = $row5['plan_amount'];
                        $cu_creation_date = date('d-m-Y', strtotime($row5['creation_date']));
                        $creation_date = $row5["creation_date"];
                        $approval_date = $row5["approval_date"];
                        $account_status5 = $row5['status'];
                        $total_debited_thrift_fee = $row5['total_debited_thrift_fee'];

                    }
                

                    if ($product_type5=="Savings") {
                        $product5_r = str_replace("S","","$product5");
                        $scx = $dbConn -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                        $scx -> bind_param('i', $product5_r);
                        $scx -> execute();
                        $rscx = $scx->get_result();
                            while($sc1x = mysqli_fetch_array($rscx) ){
                                $maxAmount = $sc1x['maxAmount'];
                            }
                    }  else if ($product_type5=="Thrift") {
                        if($amount % $plan_amount > 0) {
                            $thrift_test = 1;
                        }

                        $product5_r = str_replace("T","","$product5");
                        $scx = $dbConn -> prepare('SELECT * FROM thriftproduct WHERE id =?');
                        $scx -> bind_param('i', $product5_r);
                        $scx -> execute();
                        $rscx = $scx->get_result();
                            while($sc1x = mysqli_fetch_array($rscx) ){
                                $maxAmount = $sc1x['maxAmount'];
                                $deduct_charge_per_tenure = $sc1x['deduct_charge_per_tenure'];
                                $plan_count = $sc1x['plan_count'];
                            }

                            $today_date = date("Y-m-d");
                            $date1 = new DateTime($approval_date);
                            $date2 = new DateTime($today_date);
                            $total_days  = $date2->diff($date1)->format('%a');
                    
                            $amount_case = $cleared_balance5 / $plan_amount;
                    
                            if($total_debited_thrift_fee >0) {
                            $debit_count = $total_debited_thrift_fee/$plan_amount;
                                    
                                for($o=0; $o<$debit_count; $o++) {
                                    $total_days = $total_days - $plan_count;
                                }
                            } else {
                            $debit_count = 0 ;
                            }
                                
                            $charge_count = 0;
                            $status_tr = "Approved";
                            for ($i=0; $i < $total_days; $i += $plan_count) {
                                //$end_date = $creation_date + $plan_count;
                                $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
                                
                                $cdt = "Credit";
                                $grec = $dbConn -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                                $grec -> bind_param('sssss', $to_account, $status_tr, $cdt, $approval_date, $end_date);
                                $grec -> execute();
                                $rgrec = $grec->get_result();
                                
                                while($gre_r = mysqli_fetch_array($rgrec) ){
                                    $sum_amount = $gre_r['tram'];
                                
                                }
                                if ($sum_amount > 0) {
                                    $charge_count = $charge_count + 1;
                                }
                                
                                $approval_date = $end_date;
                                
                            }
                                
                            if ($amount_case > $charge_count && $amount_case > $plan_count) {
                                $charge_count = ceil($amount_case/$plan_count);
                            }
                                
                            $balance_count = $charge_count - $debit_count;
                            $charge_amount_trt_r = $balance_count * $plan_amount;
                        }

                        $proceed = 1;

                        if($product_type5 == "Savings") {

                        $active_d = "Active";
                        $pty_d = "Savings Account";
                        $nm_d = "Dormant";
                        
                        $credits1 = "Credit Transactions";
                            $crpnd1 = $dbConn -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
                            $crpnd1->bind_param("sss", $pty_d, $active_d, $nm_d);
                            $crpnd1 -> execute();
                            $rcrpnd1 = $crpnd1->get_result();
                            if ($rcrpnd1->num_rows > 0) {
                    
                                while($jvx1 = mysqli_fetch_assoc($rcrpnd1) ){  
                                    
                                    if(strpos($jvx1['affected_products'], ' , ') !== false) {
                                        // explodable
                                        $productssarray1 = explode(' , ',$jvx1['affected_products']);
                                        
                                    } else {
                                        // not explodable
                                        $productssarray11 = array($jvx1['affected_products']);
                                    }
                    
                                    if(strpos($jvx1['restrict_events'], ' , ') !== false) {
                                    // explodable
                                    $eventsarray1 = explode(' , ',$jvx1['restrict_events']);
                                    
                                    } else {
                                        // not explodable
                                        $eventsarray1 = array($jvx1['restrict_events']);
                                    }
                                }
                    
                                if (in_array($product5, $productssarray1)) {
                    
                                    $pvalid1 = 1;
                    
                                } else {
                                    $pvalid1 = 0;
                                }
                    
                                if (in_array($credits1, $eventsarray1)) {
                    
                                    $acdts1 = 1;
                    
                                } else {
                                    $acdts1 = 0;
                                }
                    
                                if($pvalid1 == 1 && $acdts1 == 1) {
                                    $a_cdt1 = 1;
                                } else {
                                    $a_cdt1 = 0;
                                }
                            } else {
                                $a_cdt1 = 0;
                            }
                            } else {
                                $a_cdt1 = 0;
                            }
                    } else {
                        $proceed = 2;
                        $maxAmount = 0;
                        $a_cdt1 = 0;
                    }

                } else {
                    $a_cdt1 = 0;
                    $maxAmount = 0;
                
                    $bji = $dbConn -> prepare("SELECT name FROM banks WHERE code IN (SELECT bank_code FROM egis_transfer_accounts WHERE customer_id=? AND account_no=?)");
                    $bji->bind_param("is", $customer_id, $to_account);
                    $bji->execute();
                    $rbji = $bji->get_result();
                    while($ji = mysqli_fetch_assoc($rbji) ){
                        $beneficiary_acc_bank = $ji['name'];
                    }
                
                    $dsm = $dbConn -> prepare("SELECT account_no FROM egis_transfer_accounts WHERE account_no=?");
                    $dsm->bind_param("s", $to_account);
                    $dsm->execute();
                    $rdsm = $dsm->get_result();
                    if ($rdsm->num_rows >0) {
                        $true_transfer = 1;
                    } else {
                        $true_transfer = 0;
                    }
                
                    
                    $proceed = 1;
                    $charge_text = "Outbound Transfer Fee";
                
                    $actionid_ftr = 42;
                    $entityid_ftr = 41;
                    $vr_type = "External Transfer";
                }

                $pod = $dbConn -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
                $pod -> bind_param('is', $customer_id, $from_account);
                $pod -> execute();
                $rpod = $pod->get_result();

                while($row = mysqli_fetch_assoc($rpod) ){
                    $account_id = $row['id'];
                    $product_type = $row['product_type'];
                    $product = $row['product'];
                    $opening_amount = $row['opening_amount'];
                    $loan_amount = $row['loan_amount'];
                    $cleared_balance = $row['cleared_balance'];
                    $customer_branch = $row["secondary_branch"];
                    $customer_rm = $row["secondary_relationship_manager"];
                    $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
                    $account_status = $row['status'];
                    $sms_alert = $row["sms_alert"];
                    $email_alert = $row["email_alert"];

                }

                if($product_type == "Savings") {
                    require_once("../../customer/dorm_check.php");

                     //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
                        $yui = $dbConn -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
                        $yui -> bind_param('i', $account_id);
                        $yui -> execute();
                        $ryui = $yui->get_result();
                    
                        if ($ryui->num_rows > 0) {
                            while($io = mysqli_fetch_array($ryui) ){
                                $curr_locked = $io['curr_locked'];
                        
                            }
                        } else {
                            $curr_locked = 0;
                        }
                } else {
                    $a_dbt = 0;
                    $a_cdt = 0;
                    $a_ph = 0;
                    $a_em = 0;
                    $curr_locked = 0;
                }
                
                //CHECK IF PND IS SET FOR THIS ACCOUNT
                $ppnd = $dbConn -> prepare('SELECT * FROM pnd WHERE account_id=?');
                $ppnd -> bind_param('i', $account_id);
                $ppnd -> execute();
                $rppnd = $ppnd->get_result();
                if ($rppnd->num_rows > 0) {
                    $is_pnd = 1;
                } else {
                    $is_pnd = 0;
                }
                //CHECK IF THERE'S LIEN FOR THIS ACCOUNT
                $lln = $dbConn -> prepare('SELECT * FROM lien WHERE account_id=?');
                $lln -> bind_param('i', $account_id);
                $lln -> execute();
                $rlln = $lln->get_result();
                
                if ($rlln->num_rows > 0) {
                    while($jvx = mysqli_fetch_assoc($rlln) ){ 
                        $lien= $jvx["amount"];
                    }
                } else {
                    $lien = 0;
                }

                if ($product_type=="Savings") {
                    $product2 = str_replace("S","","$product");
                    $sc = $dbConn -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                    $sc -> bind_param('i', $product2);
                    $sc -> execute();
                    $rsc = $sc->get_result();
                        while($sc1 = mysqli_fetch_array($rsc) ){
                            $saving_reference = $sc1['saving_reference'];
                            $saving_control = $sc1['saving_control'];
                            $productGroup = $sc1['productGroup'];
                            $minAmount = $sc1['minAmount'];
                        }
                }  else if ($product_type=="Thrift") {
                    $product2 = str_replace("T","","$product");
                
                    $sc = $dbConn -> prepare('SELECT * FROM thriftproduct WHERE id =?');
                    $sc -> bind_param('i', $product2);
                    $sc -> execute();
                    $rsc = $sc->get_result();
                        while($sc1 = mysqli_fetch_array($rsc) ){
                            $saving_reference = $sc1['saving_reference'];
                            $saving_control = $sc1['saving_control'];
                            $productGroup = $sc1['productGroup'];
                            $minAmount = $sc1['minAmount'];
                        }
                }

                $text5 = "Funds Transferred";
                include("../../customer/check_sms_email.php");
                //CHECK IF THERE ARE CHARGES AND ACCOUNT BALANCE IS SUFFICIENT TO HANDLE TRANSFER AND CHARGES
                                    $charge_debit = 0;
                                    if($charge_sms == 1) {
                                        $charge_tl1 = "$charge_text";
                                        $charge_tl2 = "Single SMS Fee";
                                        //$charge_tl4 = "Email Fee";
                                        $incr = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? OR chargetype =?)');
                                        $incr -> bind_param('sss', $product, $charge_tl1, $charge_tl2);
                                        $incr -> execute();
                                        $rincr = $incr->get_result();
                                        } else {
                                        $charge_tl1 = "$charge_text";
                                        //$charge_tl2 = "Single SMS Fee";
                                        //$charge_tl4 = "Email Fee";
                                        $incr = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =?)');
                                        $incr -> bind_param('ss', $product, $charge_tl1);
                                        $incr -> execute();
                                        $rincr = $incr->get_result();
                                        }
                
                                        if($rincr->num_rows > 0) {
                
                                        foreach ($rincr as $iid):
                                        
                                        $de = $dbConn -> prepare('SELECT * FROM charges WHERE id=?');
                                        $de -> bind_param('i', $iid['cid']);
                                        $de -> execute();
                                        $rde = $de->get_result();
                                        while($dee = mysqli_fetch_array($rde) ){
                                        //Call Charge Amount
                                        $trnsss_amount = $amount;
                                        $chid = $iid['cid'];
                                        include('../../../charges.php');
                                        //End Call Charge Amount
                                        $charge_name = $dee['name'];
                                        $charge_option = $dee['charge_option'];
                                        }
                
                                    if ($charge_option != "Flat") {
                                        $charge_amount = $amount * ($charge_amount/100);
                                    }
                                $charge_debit +=$charge_amount;
                                endforeach;
                
                                $total_debit = $amount + $charge_debit + $curr_locked + $pending_charges + $lien + $minAmount;
                                } else {
                                $total_debit = $amount + $curr_locked + $pending_charges + $lien + $minAmount;
                            }
                            if($type == "Inbound") {
                                $pn_g = $dbConn -> prepare('SELECT SUM(charge_amount) as rchg FROM temp_charge WHERE account_number=?');
                                $pn_g -> bind_param('s', $to_account);
                                $pn_g -> execute();
                                $rpn_g = $pn_g->get_result();
                                while($pn = mysqli_fetch_assoc($rpn_g) ){
                                $pending_charges_r = $pn['rchg'];
                            }
                            $receiver_prospective_balance = $cleared_balance5 + $amount;
                            $receiver_prospective_balance = $receiver_prospective_balance - $pending_charges_r - $charge_amount_trt_r;
                
                            if($receiver_prospective_balance > $maxAmount) {
                            $destination_limit = 1;
                            } else {
                            $destination_limit = 0;
                        }
                    } else {
                    $destination_limit = 0;
                }
                

                if ($cleared_balance < $total_debit){

                    echo json_encode(array("message" => "Insufficient Funds"));
                } else if ($a_dbt == 1 && $account_status == "Dormant") {
                    echo json_encode(array("message" => "Account is dormant and does not allow debit transactions"));
                } else if ($proceed == 2) {
                    echo json_encode(array("message" => "Destination Account not found"));
                } else if ($a_cdt1 == 1 && $account_status5 == "Dormant") {
                    echo json_encode(array("message" => "Destination account is dormant and does not receive transfers"));
                } else if ($thrift_test == 1) {
                    echo json_encode(array("message" => "Destination account can only accept $plan_amount and increment of $plan_amount."));
                } else if ($account_status == "Invalid" || $account_status == "Pending" || $account_status == "Closed" || $account_status == "Frozen") {
                    echo json_encode(array("message" => "Transfer is not allowed for this account"));
                } else if ($destination_limit == 1) {
            
                    echo json_encode(array("message" => "Destination Account limit of $maxAmount reached"));
                } else if ($true_transfer == 0 && $transfer_type == "Outbound") {
            
                    echo json_encode(array("message" => "Destination Account not found"));
                } else if ($from_account == $to_account) {
                    echo json_encode(array("message" => "You cannot transfer to the same Account"));
                } else if ($amount <= 0) {
                    echo json_encode(array("message" => "Please enter a valid amount"));
                }
                     
                else if ($cleared_balance >= $total_debit) {

                //CHECK IF IT'S OUTBOUND TRANSFER
                if ($type == "Outbound") {
            
                    if ($amount <= 5001) {
                        $transfer_fee = 20;
                    } else if ($amount > 5001 && $amount <= 20000) {
                        $transfer_fee = 40;
                    } else if ($amount > 20001 && $amount <= 50000) {
                        $transfer_fee = 60;
                    } else if ($amount > 50000) {
                        $transfer_fee = 80;
                    }
            
                        $total_deduct = $amount + $transfer_fee;
                    
                    //CHECK IF THE USER HAS SUFFICIENT BALANCE FOR THE DISBURSEMENT
                    if ($egis_transfers == 2) {
                        $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
                
                        $ch1 = curl_init();
                        curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                        curl_setopt($ch1, CURLOPT_POST, 1);
                        curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
            
                        $headers1 = [
                        'Content-Type: application/json'
                        ];
            
                        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
            
                        $request1 = curl_exec ($ch1);
            
                        curl_close ($ch1);
                        if ($request1) {
                        $result1 = json_decode($request1, true);
                        }
                            
                        $token = $result1['token'];
            
                        $postdata1 =  array('organization_code' => $org_code, 'branch' => $customer_branch);
            
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL,"$egis_api_root/branch_balance.php");
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata1));  //Post Fields
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        //Set your auth headers
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Authorization: Bearer ' . $token
                        ));
            
                        // get stringified data/output. See CURLOPT_RETURNTRANSFER
                        $data = curl_exec($ch);
            
                        //echo $data;
            
                        //$decode = json_decode($data);
                        $decode = json_decode($data, true);
            
                        $balance = $decode['balance'];
                        $globalbalance = $decode['gbalance'];
                        } else {
                            $balance = 0;
                            $globalbalance = 0;
                        }
            
                    if ($balance < $total_deduct) {
                        $proceed_disburse = 0;
                    } else {
                        $proceed_disburse = 1;
                    }
            
                    } else {
                        $proceed_disburse = 1;
                    }

                if ($proceed_disburse == 0) {
                    echo json_encode(array("message" => "Network Unavailable, Try again later"));
                 } else if ($type == "Outbound" && $globalbalance < 100) {
                    echo json_encode(array("message" => "Network Unavailable, Try again later"));
                } else if ($proceed_disburse == 1) {

                $ins = $dbConn->prepare("INSERT INTO pending_transactions_channels (from_account, to_account, type, amount, reference, status, value_date, processed, total_debit)VALUES(?,?,?,?,?,?,?,?,?)");
                $ins->bind_param("sssdsssid", $from_account, $to_account, $type, $amount, $reference, $status, $value_date, $processed, $total_debit);
                $ins->execute();

                if ($ins){

                    $pndtr = $dbConn->prepare("SELECT * FROM pending_transactions_channels WHERE from_account=?");
                    $pndtr->bind_param("s", $from_account);
                    $pndtr->execute(); 
                    $rpndtr = $pndtr->get_result();

                    if($rpndtr->num_rows > 0) {
                        foreach($rpndtr as $tr):
                            $pn_id = $tr["id"];
                            $from_account_s = $tr["from_account"];
                            $to_account_s = $tr["to_account"];
                            $type_s = $tr["type"];
                            $amount_s = $tr["amount"];
                            $reference_s = $tr["reference"];
                            $status_s = $tr["status"];
                            $value_date_s = $tr["value_date"];
                            $processed_s = $tr["processed"];
                            $total_debit_s = $tr["total_debit"];
                            

                            $pod1 = $dbConn -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
                            $pod1 -> bind_param('i', $customer_id);
                            $pod1 -> execute();
                            $rpod1 = $pod1->get_result();

                            while($row1 = mysqli_fetch_assoc($rpod1) ){
                                $customer_name = $row1["fname"];
                                $customer_mname = $row1["mname"];
                                $customer_lname = $row1["lname"];
                                $fname = $row1["fname"];
                                $mname = $row1["mname"];
                                $lname = $row1["lname"];
                                $cu_character = strtoupper($customer_name[0]);
                            }

                            date_default_timezone_set("Africa/Lagos");
                            $transfer_transaction_date = date("Y-m-d H:i:s");
                            $transaction_date = date("Y-m-d H:i:s");

                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;

                            $stamp_1 = date("Yhis");

                            $transaction_id = "T$cu_character" . "$orderId";

                            $description = "Transfer-out";
                            $ttype = "Debit";

                            //GET SENDER DETAILS

                            $pod_s = $dbConn -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
                            $pod_s -> bind_param('is', $customer_id, $from_account_s);
                            $pod_s -> execute();
                            $rpod_s = $pod_s->get_result();

                            while($row_s = mysqli_fetch_assoc($rpod_s) ){
                                $cleared_balance_s = $row_s['cleared_balance'];
                            }


                            //GET RECEIVER DETAILS
                            if($type_s == "Inbound" || $type_s == "Own account") {
                                $pod5_s = $dbConn -> prepare('SELECT * FROM accounts WHERE account_number=?');
                                $pod5_s -> bind_param('s', $to_account_s);
                                $pod5_s -> execute();
                                $rpod5_s = $pod5_s->get_result();
                                if ($rpod5_s->num_rows > 0) {
                                while($row5_s = mysqli_fetch_assoc($rpod5_s) ){
                                    $account_id_r_s = $row5_s['id'];
                                    $cleared_balance5_s = $row5_s['cleared_balance'];
                                    $receiver_id_s = $row5_s['customer_id'];
                                    $product5_s = $row5_s['product'];
                                    $product_type5_s = $row5_s['product_type'];
                                    $receiver_branch_s = $row5_s["secondary_branch"];
                                    $receiver_rm_s = $row5_s["secondary_relationship_manager"];
                                    $sms_alert_r_s = $row5_s["sms_alert"];
                                    $email_alert_r_s = $row5_s["email_alert"];
                                    $receiver_status_s = $row5_s["status"];
                                    $plan_amount_s = $row5_s['plan_amount'];
                                    $cu_creation_date_s = date('d-m-Y', strtotime($row5_s['creation_date']));
                                    $creation_date_s = $row5_s["creation_date"];
                                    $approval_date_s = $row5_s["approval_date"];
                                    $account_status5_s = $row5_s['status'];
                                    $total_debited_thrift_fee_s = $row5_s['total_debited_thrift_fee'];
                                    }

                                }
                            }

                            
                            if($cleared_balance_s >= $total_debit_s) {
                            if($processed_s == 0) {

                                $dpn = $dbConn->prepare("DELETE FROM pending_transactions_channels WHERE id=?");
                                $dpn->bind_param("i", $pn_id);
                                $dpn->execute();
                                
                                        $new_amount_sd = $cleared_balance_s - $amount_s;
                                        
                                        $previous_balance_sd = $cleared_balance_s;

                                    //UPDATE CUSTOMER ACCOUNT

                                        $pw = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                        $pw->bind_param('dis', $new_amount_sd, $customer_id, $from_account_s);
                                        $pw->execute();
                                        $pw->close();

                                        $w = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, to_account, bank, transfer_type, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w->bind_param("ssidddssssssssiiiis", $transaction_id, $from_account, $customer_id, $previous_balance_sd, $new_amount_sd, $amount_s, $ttype, $description, $transfer_transaction_date, $value_date, $transfer_comment, $to_account_s, $beneficiary_acc_bank, $type, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1);
                                        $w->execute();
                                        $last_id = mysqli_insert_id($dbConn);

                                        $entity_id = "TRR$last_id";

                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "Funds Transfer ($amount_s) from $from_account to $to_account_s";
                                        $act_type = "Transfer";
                                        $ww = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $customer_branch, $channel_log);
                                        $ww->execute();

                                            //INSERT INTO JOURNAL
                                            $crd_gl = -$amount_s;
                                            $journal_date = $value_date;
                                            $journal_type = "Automatic";
                                            $journal_description = "Funds Transfer  from $from_account to $to_account_s";
                                            $jn = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                                            $jn->bind_param("iddiiiisss", $last_id, $crd_gl, $amount_s, $maingl, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date);
                                            $jn->execute();
                                            

                                    
                                    //DEDUCT THE APPLICABLE TRANSFER CHARGES

                                    if($charge_sms == 1) {

                                        $yui = $dbConn -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                        $yui -> bind_param('i', $account_id);
                                        $yui -> execute();
                                        $ryui = $yui->get_result();
                                        while($io = mysqli_fetch_array($ryui) ){
                                            $alert_phone = $io['phone_no'];
                                        }
                                
                                        //DO ALL SHORTCODE REPLACEMENTS
                                        $dst_account = "**".substr($from_account, -4);
                                        $message = str_replace("[accountNo]",$dst_account,$message);
                                        $message = str_replace("[fname]",$fname,$message);
                                        $message = str_replace("[lname]",$lname,$message);
                                        $message = str_replace("[mname]",$mname,$message);
                                        $message = str_replace("[vdate]",$value_date,$message);
                                        $message = str_replace("[adate]",$transfer_transaction_date,$message);
                                        $message = str_replace("[amount]",$amount_s,$message);
                                        $message = str_replace("[balance]",$new_amount_sd,$message);
                                        $message = str_replace("[trbranch]",$customer_branch,$message);
                                
                                        //SEND TO EGIS SERVICES FOR SENDING SMS HERE
                                
                                        $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
                                
                                        $ch1 = curl_init();
                                        curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                                        curl_setopt($ch1, CURLOPT_POST, 1);
                                        curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                                        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
                                
                                        $headers1 = [
                                        'Content-Type: application/json'
                                        ];
                                
                                        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
                                
                                        $request1 = curl_exec ($ch1);
                                
                                        curl_close ($ch1);
                                        if ($request1) {
                                        $result1 = json_decode($request1, true);
                                        }
                                            
                                        $token = $result1['token'];
                                
                                        $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone, 'message' => $message);
                                
                                        $ch3 = curl_init();
                                        curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/sms.php");
                                        curl_setopt($ch3, CURLOPT_POST, 1);
                                        curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
                                        curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
                                        //Set your auth headers
                                        curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
                                        'Content-Type: application/json',
                                        'Authorization: Bearer ' . $token
                                        ));
                                
                                        // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                        $data1 = curl_exec($ch3);
                                
                                        //$decode1 = json_decode($data1);
                                
                                            $charge_tl1 = "$charge_text";
                                            $charge_tl2 = "Single SMS Fee";
                                            //$charge_tl4 = "Email Fee";
                                            $incr = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? OR chargetype =?)');
                                            $incr -> bind_param('sss', $product, $charge_tl1, $charge_tl2);
                                            $incr -> execute();
                                            $rincr = $incr->get_result();
                                            } else {
                                            $charge_tl1 = "$charge_text";
                                            //$charge_tl2 = "Single SMS Fee";
                                            //$charge_tl4 = "Email Fee";
                                            $incr = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =?)');
                                            $incr -> bind_param('ss', $product, $charge_tl1);
                                            $incr -> execute();
                                            $rincr = $incr->get_result();
                                            }

                                            if($rincr->num_rows > 0) {

                                                $fx = $dbConn -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                                                $fx -> bind_param('s', $product);
                                                $fx -> execute();
                                                $rfx = $fx->get_result();
                                                while($fr = mysqli_fetch_array($rfx) ){
                                                    $funding_source = $fr['funding_source'];
                                                }
                        
                                                foreach ($rincr as $iid):
                                                
                                                $de = $dbConn -> prepare('SELECT * FROM charges WHERE id=?');
                                                $de -> bind_param('i', $iid['cid']);
                                                $de -> execute();
                                                $rde = $de->get_result();
                                                while($dee = mysqli_fetch_array($rde) ){
                                                //Call Charge Amount
                                                $trnsss_amount = $amount_s;
                                                $chid = $iid['cid'];
                                                include('../../../charges.php');
                                                //End Call Charge Amount
                                                $charge_name = $dee['name'];
                                                $charge_option = $dee['charge_option'];
                                                $triggertype = $dee['triggertype'];
                                                $chargetype = $dee['chargetype'];
                                                }
                        
                                                $set = $dbConn -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                                $set -> bind_param('ss', $product, $iid['cid']);
                                                $set -> execute();
                                                $rset = $set->get_result();
                                                while($rrt = mysqli_fetch_array($rset) ){
                                                    $income_acc = $rrt['income_acc'];
                                                }
                        
                                                    $cb = $dbConn -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                                                    $cb -> bind_param('s', $from_account);
                                                    $cb -> execute();
                                                    $rcb = $cb->get_result();
                            
                                                    while($rbb = mysqli_fetch_assoc($rcb) ){
                                                    $cleared_bal = $rbb["cleared_balance"];
                                                    }
                        
                                                if ($charge_option != "Flat") {
                                                    $charge_amount = $amount_s * ($charge_amount/100);
                                                }
                                                if ($triggertype == "Per Transaction" && $charge_amount >0) {
                                                    
                                                    //$value_date = date("Y-m-d H:i:s");
                                                    $num = mt_rand(100000, 999999);
                                                    $stamp = date("Yhis");
                                                    $orderId = $stamp . $num;
                        
                            
                                                    $new_amount_c = $cleared_bal - $charge_amount;
                            
                                                    $description_c = "$charge_name";
                                                    $type_c = "Debit";
                                
                                                    $debit_comment = "$charge_name";
                            
                                                    $transaction_id_c = "D$cu_character" . "$orderId";
                            
                                                    //INSERT CHARGES INTO TRANSACTION TABLE
                                                    $wc = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                    $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $from_account, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                                                    $wc->execute();
                                                    $last_id_c = mysqli_insert_id($dbConn);
                            
                                                    $entity_id_c = "TRR$last_id_c";
                            
                                                    //INSERT INTO ACTIVITY TABLE
                                                    $act_dsc = "$charge_name debit from customer account";
                                                    $act_type = "Debit";
                                                    $wwc = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                    $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $customer_branch, $channel_log);
                                                    $wwc->execute();
                            
                                                    $crd_gl1 = -$charge_amount;
                                                    $journal_description = "$charge_name";
                                                    $jn = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                                                    $jn->bind_param("iddiiiisss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date);
                                                    $jn->execute();
                            
                                                    $upd = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                                    $upd->bind_param('ds', $new_amount_c, $from_account);
                                                    $upd->execute();
                                                    } else {
                                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                                        if($charge_amount>0) {
                                                        $inch = $dbConn->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                                        $inch->bind_param("sdss", $from_account, $charge_amount, $charge_name, $triggertype);
                                                        $inch->execute();
                                                        }
                        
                                                        $new_amount_c = $new_amount_sd;
                                                    }
                        
                                                     //DO SMS INTEGRATION
                                                     if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                                        $biz_rule = "Charge Deducted";
                                                        $brn = $customer_branch;
                                                        $rm = $customer_rm;
                                                        $pg = $productGroup;
                                                        $account_id = $account_id;
                                                        $account_no = $from_account;
                                                        $vdate = $value_date;
                                                        $tdate = $transaction_date;
                                                        $tamount = $charge_amount;
                                                        $cb = $new_amount_c;
                        
                                                        include_once("../../customer/sms_int.php");
                                                    }
                            
                                                    endforeach;
                                                }
                        
                                                if ($type_s == "Inbound" || $type_s == "Own Account") {
                                                    //INTERNAL TRANSFERS
                                                    $podt = $dbConn -> prepare('SELECT fname FROM customer WHERE customer_id=?');
                                                    $podt -> bind_param('i', $receiver_id_s);
                                                    $podt -> execute();
                                                    $rpodt = $podt->get_result();
                                                
                                                    while($rtt = mysqli_fetch_assoc($rpodt) ){
                                                        $receiver_name = $rtt["fname"];
                                                        $rc_character = strtoupper($receiver_name[0]);
                                                    }
                                                
                                                    $num1 = mt_rand(100000, 999999);
                                                    $stamp1 = date("Yhis");
                                                    $orderId1 = $stamp1 . $num1;
                                                
                                                    $transaction_id1 = "C$rc_character" . "$orderId1";
                                                
                                                    $description1 = "Transfer-in";
                                                    $type1 = "Credit";
                                                
                                                    $new_amount1 = $cleared_balance5_s + $amount_s;
                                                    $previous_balance1 = $cleared_balance5_s;
                                                
                                                    $crr = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                                    $crr->bind_param('dis', $new_amount1, $receiver_id_s, $to_account_s);
                                                    $crr->execute();
                                                    $crr->close();
                                                
                                                    $r_status="X";
                                                    $wi = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, to_account, bank, transfer_type, status, transfer_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                    $wi->bind_param("ssidddsssssssssiiiiis", $transaction_id1, $to_account_s, $receiver_id_s, $previous_balance1, $new_amount1, $amount_s, $type1, $description1, $transfer_transaction_date, $value_date, $transfer_comment, $to_account_s, $beneficiary_acc_bank, $type_s, $r_status, $last_id, $receiver_branch_s, $receiver_rm_s, $channel_log, $aid, $stamp_1);
                                                    $wi->execute();
                                                    $last_id1 = mysqli_insert_id($dbConn);
                                                
                                                    $entity_id1 = "TRR$last_id1";
                                                
                                                    //INSERT INTO ACTIVITY TABLE
                                                    $act_dsc1 = "Funds Transfer ($amount_s) from $from_account to $to_account_s";
                                                    $act_type1 = "Transfer";
                                                    $xx = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                    $xx->bind_param("sssiii", $act_dsc1, $act_type1, $entity_id1, $aid, $receiver_branch_s, $channel_log);
                                                    $xx->execute();
                                                
                                                    
                                                
                                                    if ($product_type5_s=="Savings") {
                                                        $product2_r_s = str_replace("S","","$product5_s");
                                                        $scr = $dbConn -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                                                        $scr -> bind_param('i', $product2_r_s);
                                                        $scr -> execute();
                                                        $rscr = $scr->get_result();
                                                            while($sc1r = mysqli_fetch_array($rscr) ){
                                                                $saving_reference_r = $sc1r['saving_reference'];
                                                                $saving_control_r = $sc1r['saving_control'];
                                                                $productGroup_r = $sc1r['productGroup'];
                                                            }
                                                    
                                                    } else if ($product_type5_s=="Current") {
                                                        $product2_r_s = str_replace("C","","$product5_s");
                                                    } else if ($product_type5_s=="Thrift") {
                                                        $product2_r_s = str_replace("T","","$product5_s");
                                                    
                                                        $scr = $dbConn -> prepare('SELECT * FROM thriftproduct WHERE id =?');
                                                        $scr -> bind_param('i', $product2_r_s);
                                                        $scr -> execute();
                                                        $rscr = $scr->get_result();
                                                            while($sc1r = mysqli_fetch_array($rscr) ){
                                                                $saving_reference_r = $sc1r['saving_reference'];
                                                                $saving_control_r = $sc1r['saving_control'];
                                                                $productGroup_r = $sc1r['productGroup'];
                                                            }
                                                    } else if ($product_type5_s=="Term Deposit") {
                                                        $product2_r_s = str_replace("TD","","$product5_s");
                                                    
                                                        /*
                                                        $scr = $dbConn -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                                                        $scr -> bind_param('i', $product2_r);
                                                        $scr -> execute();
                                                        $rscr = $scr->get_result();
                                                            while($sc1r = mysqli_fetch_array($rscr) ){
                                                                $saving_reference_r = $sc1r['saving_reference'];
                                                                $saving_control_r = $sc1r['saving_control'];
                                                                $productGroup_r = $sc1r['productGroup'];
                                                            }
                                                    */
                                                    
                                                        } else if ($product_type5_s=="Share") {
                                                            $product2_r_s = str_replace("SH","","$product5_s");
                                                        }
                                                
                                                        //INSERT INTO JOURNAL
                                                    $journal_date = $value_date;
                                                    $journal_type = "Automatic";
                                                    $journal_description = "Funds Transfer  from $from_account to $to_account_s";
                                                    $jnr = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                                                    $jnr->bind_param("iddiiiisss", $last_id1, $crd_gl, $amount_s, $saving_control_r, $maingl, $aid, $receiver_branch_s, $journal_type, $journal_description, $journal_date);
                                                    $jnr->execute();
                                                
                                                        //SEND SMS FOR RECEIVER IF ENABLED
                                                        if ($sms_alert_r_s == "Yes" && $charge_sms_s == 1) {
                                                
                                                            $yui_c = $dbConn -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                                            $yui_c -> bind_param('i', $account_id_r_s);
                                                            $yui_c -> execute();
                                                            $ryui_c = $yui_c->get_result();
                                                            while($io_c = mysqli_fetch_array($ryui_c) ){
                                                                $alert_phone_r = $io_c['phone_no'];
                                                            }
                                                    
                                                            //DO ALL SHORTCODE REPLACEMENTS
                                                            $dst_account = substr($to_account_s, -4);
                                                            $message = "Acct:**[accountNo]
                                                            CR:N[amount]
                                                            Desc:TRASFER FROM ". strtoupper($customer_name)." " . strtoupper($customer_mname)." " . strtoupper($customer_lname)."
                                                            DT:[vdate]
                                                            Bal:[balance]CR";
                                                            $message = str_replace("[accountNo]",$dst_account,$message);
                                                            $message = str_replace("[vdate]",$value_date,$message);
                                                            $message = str_replace("[adate]",$transaction_date,$message);
                                                            $message = str_replace("[amount]",$amount_s,$message);
                                                            $message = str_replace("[balance]",$new_amount1,$message);
                                                            $message = str_replace("[trbranch]",$receiver_branch_s,$message);
                                                    
                                                            //SEND TO EGIS SERVICES FOR SENDING SMS HERE
                                                    
                                                            $postdata4 =  array('organization_code' => $org_code, 'branch_id' => $receiver_branch_s, 'recipient_phone' => $alert_phone_r, 'message' => $message);
                                                    
                                                            $ch4 = curl_init();
                                                            curl_setopt($ch4, CURLOPT_URL,"$egis_api_root/sms.php");
                                                            curl_setopt($ch4, CURLOPT_POST, 1);
                                                            curl_setopt($ch4, CURLOPT_POSTFIELDS,json_encode($postdata4));  //Post Fields
                                                            curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
                                                            //Set your auth headers
                                                            curl_setopt($ch4, CURLOPT_HTTPHEADER, array(
                                                            'Content-Type: application/json',
                                                            'Authorization: Bearer ' . $token
                                                            ));
                                                    
                                                            // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                                            $data2 = curl_exec($ch4);
                                                    
                                                            //$decode2 = json_decode($data2);
                                                    
                                                    
                                                                
                                                                $charge_tl2 = "Single SMS Fee";
                                                                //$charge_tl4 = "Email Fee";
                                                                $incr_c = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =?)');
                                                                $incr_c -> bind_param('ss', $product5_s, $charge_tl2);
                                                                $incr_c -> execute();
                                                                $rincr_c = $incr_c->get_result();
                                                    
                                                                if($rincr_c->num_rows > 0) {
                                                    
                                                                $fx = $dbConn -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                                                                $fx -> bind_param('s', $product5_s);
                                                                $fx -> execute();
                                                                $rfx = $fx->get_result();
                                                                while($fr = mysqli_fetch_array($rfx) ){
                                                                    $funding_source_c = $fr['funding_source'];
                                                                }
                                                    
                                                                foreach ($rincr_c as $iid_c):
                                                    
                                                                $de_c = $dbConn -> prepare('SELECT * FROM charges WHERE id=?');
                                                                $de_c -> bind_param('i', $iid_c['cid']);
                                                                $de_c -> execute();
                                                                $rde_c = $de_c->get_result();
                                                                while($dee_c = mysqli_fetch_array($rde_c) ){
                                                                //Call Charge Amount
                                                                $trnsss_amount = $amount_s;
                                                                $chid = $iid_c['cid'];
                                                                include('../../../charges.php');
                                                                //End Call Charge Amount
                                                                $charge_name_c = $dee_c['name'];
                                                                $charge_option_c = $dee_c['charge_option'];
                                                                $triggertype_c = $dee_c['triggertype'];
                                                                }
                                                                $charge_amount_c = $charge_amount; //deliberate from charges.php
                                                
                                                                $set = $dbConn -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                                                $set -> bind_param('ss', $product5_s, $iid['cid']);
                                                                $set -> execute();
                                                                $rset = $set->get_result();
                                                                while($rrt = mysqli_fetch_array($rset) ){
                                                                    $income_acc_c = $rrt['income_acc'];
                                                                }
                                                    
                                                                    $cb_c = $dbConn -> prepare('SELECT * FROM accounts WHERE account_number=?');
                                                                    $cb_c -> bind_param('s', $to_account_s);
                                                                    $cb_c -> execute();
                                                                    $rcb_c = $cb_c->get_result();
                                                    
                                                                    while($rbb_c = mysqli_fetch_assoc($rcb_c) ){
                                                                    $cleared_bal_c = $rbb_c["cleared_balance"];
                                                                    }
                                                    
                                                                if ($charge_option_c != "Flat") {
                                                                    $charge_amount_c = $amount_s * ($charge_amount_c/100);
                                                                }
                                                
                                                                if ($triggertype_c == "Per Transaction") {
                                                    
                                                                    
                                                                    //$value_date_c = date("Y-m-d H:i:s");
                                                                    $num_c = mt_rand(100000, 999999);
                                                                    $stamp_c = date("Yhis");
                                                                    $orderId_c = $stamp_c . $num_c;
                                                    
                                                    
                                                                    $new_amount_c_c = $cleared_bal_c - $charge_amount_c;
                                                    
                                                                    $description_c_c = "$charge_name_c";
                                                                    $type_c_c = "Debit";
                                                    
                                                                    $debit_comment_c = "$charge_name";
                                                    
                                                                    $transaction_id_c_c = "D$rc_character" . "$orderId_c";
                                                    
                                                                    //INSERT CHARGES INTO TRANSACTION TABLE
                                                                    $wc = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                                    $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c_c, $to_account_s, $receiver_id_s, $cleared_bal_c, $new_amount_c_c, $charge_amount_c, $type_c_c, $description_c_c, $transaction_date, $value_date, $debit_comment_c, $onee, $receiver_branch_s, $receiver_rm_s, $channel_log, $aid, $stamp_c, $rev);
                                                                    $wc->execute();
                                                                    $last_id_c_c = mysqli_insert_id($dbConn);
                                                    
                                                                    $entity_id_c_c = "TRR$last_id_c_c";
                                                    
                                                                    //INSERT INTO ACTIVITY TABLE
                                                                    $act_dsc_c = "$charge_name_c debit from customer account";
                                                                    $act_type_c = "Debit";
                                                                    $wwc = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                                    $wwc->bind_param("sssiii", $act_dsc_c, $act_type_c, $entity_id_c_c, $aid, $receiver_branch_s, $channel_log);
                                                                    $wwc->execute();
                                                    
                                                                    $crd_gl1_c = -$charge_amount_c;
                                                                    $journal_description = "$charge_name_c";
                                                                    $jn = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                                                                    $jn->bind_param("iddiiiisss", $last_id_c_c, $crd_gl1_c, $charge_amount_c, $income_acc_c, $saving_control_r, $aid, $receiver_branch_s, $journal_type, $journal_description, $journal_date);
                                                                    $jn->execute();
                                                    
                                                                    $upd = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                                                    $upd->bind_param('ds', $new_amount_c_c, $to_account_s);
                                                                    $upd->execute();
                                                
                                                                    } else {
                                                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                                                        $inch = $dbConn->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                                                        $inch->bind_param("sdss", $to_account_s, $charge_amount_c, $charge_name_c, $triggertype_c);
                                                                        $inch->execute();
                                                                    }
                                                                     //DO SMS INTEGRATION
                                                                     if ($sms_alert_r_s == "Yes") {
                                                                        $biz_rule = "Charge Deducted";
                                                                        $brn = $receiver_branch_s;
                                                                        $rm = $receiver_rm_s;
                                                                        $pg = $productGroup_r;
                                                                        $account_id = $account_id_r_s;
                                                                        $account_no = $to_account_s;
                                                                        $vdate = $value_date;
                                                                        $tdate = $transaction_date;
                                                                        $tamount = $charge_amount_c;
                                                                        $cb = $new_amount_c_c;
                                                
                                                                        include_once("../../customer/sms_int.php");
                                                                    }
                                                    
                                                                    endforeach;
                                                                }
                                                            }
                                                        } else if ($type_s == "Outbound") {
                                                            //LIVE INTEGRATION HERE
                                                            $live_description = "Fund Transfer from $from_account to $beneficiary_acc_bank Account no: $to_account_s";
                                                            $pk_description = strtoupper($customer_name)." " . strtoupper($customer_mname)." " . strtoupper($customer_lname)."/".$transfer_comment;
                                                            $total_debit = $total_deduct;
                                                            $track_id = $transaction_id;
                                                            $type_tr = "Fund Transfer";
                                                            //$transfer_amount = $transfer_amount;
                                                            //$transfer_fee = $transfer_fee;

                                                            //GET PAYMENT RECIPIENT

                                                            $gac = $dbConn -> prepare("SELECT recipient_code FROM egis_transfer_accounts WHERE customer_id=? AND account_no=?");
                                                            $gac->bind_param("is", $customer_id, $to_account_s);
                                                            $gac->execute();
                                                            $rgac = $gac->get_result();
                                                            while($ri = mysqli_fetch_assoc($rgac) ){
                                                                $recipient_code = $ri['recipient_code'];
                                                            }

                                                            $postdata2 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_code' => $recipient_code, 'live_description' => $live_description, 'pk_description' => $pk_description, 'total_debit' => $total_debit_s, 'track_id' => $track_id, 'transfer_amount' => $amount_s, 'transfer_fee' => $transfer_fee, 'type' => $type_tr);

                                                            $ch2 = curl_init();
                                                            curl_setopt($ch2, CURLOPT_URL,"$egis_api_root/transfer.php");
                                                            curl_setopt($ch2, CURLOPT_POST, 1);
                                                            curl_setopt($ch2, CURLOPT_POSTFIELDS,json_encode($postdata2));  //Post Fields
                                                            curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                                                            //Set your auth headers
                                                            curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                                                            'Content-Type: application/json',
                                                            'Authorization: Bearer ' . $token
                                                            ));

                                                            // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                                            $data1 = curl_exec($ch2);

                                                            //$decode1 = json_decode($data1);

                                                        }

                            }
                        }
                        endforeach;

                        echo json_encode(array("message" => "Transfer Successful"));
                            }

                        } else {
                        echo json_encode(array("message" => "Transfer Failed. Try Again"));
                     }
                } 
            }
        }
    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
}

//repay loan
function repayLoan($dbConn, $amount, $savings_account_id) {

}

//airtime, bills, databundles and internet subscriptions
function airtimeBillPayments($dbConn, $egis_transfers, $egis_api, $egis_secret, $egis_api_root, $org_code, $usbrn) {

    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {

    $account_id = $_POST['account_id'];
    $action = $_POST['action'];
    $added_charge = 100;
    $a_dbt = 0;

    $error = 0;

    switch($action) {
        case "Buy Airtime":
            $network = $_POST['network_airtime'];
            $phone_no = $_POST['mobile_airtime'];
            $amount = $_POST['airtime_amount'];
            $added_charge = 0;
    
            if($network == "") {
                $error += 1;
            } else if($phone_no == "") {
                $error += 1;
            } else if($amount == "" || $amount < 1) {
                $error += 1;
            }
    
            $smart_card_no = 0;
            $plan = 0;
            $device_no = 0;
            $meter_no = 0;
            $meter_type = "";
            $code = 0;
            $product_name = "";
            $customer_name = "";
            $action_rb = "Airtime";
            $text = "$network Airtime Purchase";
            $text2 = "$network Airtime Purchase";
            $text3 = "$network Airtime Purchase";
            $text4 = "$network Airtime Purchase Successful";
            $text5 = "Airtime Purchase";
    
            $ph_sms = $phone_no;
            $nwt_sms = $network;
            $dvn_sms = "";
            
        break;
    
        case "Buy Data":
    
            $network = $_POST['network_data'];
            $phone_no = $_POST['mobile_data'];
            $amount = $_POST['amount_data'];
            $code = $_POST['code_data'];
            $product_name = $_POST['pname_data'];
            $plan = $_POST['plan_data'];
            $added_charge = 0;
    
            if($network == "") {
                $error += 1;
            } else if($phone_no == "") {
                $error += 1;
            } else if($amount == "" || $amount < 1) {
                $error += 1;
            }
    
            $smart_card_no = 0;
            $meter_no = 0;
            $meter_type = "";
            $device_no = 0;
            $customer_name = "";
            $action_rb = "Data";
            $text = "$network Data Purchase";
            $text2 = "$network Data Purchase";
            $text3 = "$network Data Purchase";
            $text4 = "$network Data Purchase Successful";
            $text5 = "Databundle Purchase";
    
            $ph_sms = $phone_no;
            $nwt_sms = $network;
            $dvn_sms = "";
    
        break;
    
        case "Buy Cable":
    
            $network = $_POST['network_cable'];
            $phone_no = $_POST['mobile_cable'];
            $amount = $_POST['amount_cable'];
            $code = $_POST['code_cable'];
            $product_name = $_POST['pname_cable'];
            $plan = $_POST['plan_cable'];
            $smart_card_no = $_POST['smart_card_noc'];
            $customer_name = $_POST['customer_name'];
    
            
    
            if($network == "") {
                $error += 1;
            } else if($phone_no == "") {
                $error += 1;
            } else if($plan == "") {
                $error += 1;
            } else if($smart_card_no == "" || $smart_card_no < 2) {
                $error += 1;
            }
    
            $device_no = 0;
            $meter_no = 0;
            $meter_type = '';
            $action_rb = "Cable";
            $text = "$network Subscription";
            $text2 = "$network Subscription";
            $text3 = "$network Subscription";
            $text4 = "$network Subscription Successful";
            $text5 = "Cable Subscription";
    
            $ph_sms = $phone_no;
            $nwt_sms = $network;
            $dvn_sms = $smart_card_no;
    
        break;
    
    
        case "Buy Internet":
            $network = $_POST['network_internet'];
            $amount = $_POST['amount_internet'];
            $code = $_POST['code_internet'];
            $product_name = $_POST['pname_internet'];
            $plan = $_POST['plan_internet'];
            $device_no = $_POST['device_no_i'];
            $customer_name = $_POST['customer_name'];
    
            if($network == "") {
                $error += 1;
            } else if($plan == "") {
                $error += 1;
            } else if($device_no == "" || $device_no < 2) {
                $error += 1;
            }
    
            $smart_card_no = 0;
            $meter_no = 0;
            $phone_no = 0;
            $meter_type = '';
            $action_rb = "Internet";
            $text = "$network Subscription";
            $text2 = "$network Subscription";
            $text3 = "$network Subscription";
            $text4 = "$network Subscription Successful";
            $text5 = "Internet Subscription";
    
            $ph_sms = "";
            $nwt_sms = $network;
            $dvn_sms = $device_no;
        break;
    
        case "Buy Electric":
            $network = $_POST['network_electric'];
            $phone_no = $_POST['mobile_electric'];
            $amount = $_POST['electric_amount'];
            $meter_type = $_POST['meter_type_i'];
            $meter_no = $_POST['meter_no_i'];
            $customer_name = $_POST['customer_name'];
    
            if($network == "") {
                $error += 1;
            } else if($phone_no == "") {
                $error += 1;
            } else if($meter_type == "") {
                $error += 1;
            } else if($meter_no == "" || $meter_no < 2) {
                $error += 1;
            }
    
            $smart_card_no = 0;
            $plan = 0;
            $device_no = 0;
            $code = 0;
            $action_rb = "Electric";
            $text = "$network Electricity Payment";
            $text2 = "$network Electricity Payment";
            $text3 = "$network Electricity Payment";
            $text4 = "$network Payment Successful";
            $text5 = "Electricity Purchase";
            $product_name = "";
    
            $ph_sms = $phone_no;
            $nwt_sms = $network;
            $dvn_sms = $meter_no;
        break;
    }
    
    $total_due_amount = $amount + $added_charge;

    //CHECK IF THE ORGANIZATION HAS SUFFICIENT BALANCE FOR THE ORDER
    if ($egis_transfers == 2) {
        $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);

        $ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
        curl_setopt($ch1, CURLOPT_POST, 1);
        curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);

        $headers1 = [
        'Content-Type: application/json'
        ];

        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);

        $request1 = curl_exec ($ch1);

        curl_close ($ch1);
        if ($request1) {
        $result1 = json_decode($request1, true);
        }
            
        $token = $result1['token'];

        $postdata1 =  array('organization_code' => $org_code, 'branch' => $usbrn);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,"$egis_api_root/branch_balance.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata1));  //Post Fields
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //Set your auth headers
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token
        ));

        // get stringified data/output. See CURLOPT_RETURNTRANSFER
        $data = curl_exec($ch);

        //echo $data;

        //$decode = json_decode($data);
        $decode = json_decode($data, true);

        $balance = $decode['balance'];
        $globalbalance = $decode['gbalance'];
        } else {
            $balance = 0;
            $globalbalance = 0;
        }

    if ($balance < $total_due_amount) {
        $proceed_disburse = 0;
    } else {
        $proceed_disburse = 1;
    }

    $pod = $dbConn -> prepare('SELECT * FROM accounts WHERE id=?');
    $pod -> bind_param('i', $account_id);
    $pod -> execute();
    $rpod = $pod->get_result();

    while($row = mysqli_fetch_assoc($rpod) ){
        $account_id = $row['id'];
        $customer_id = $row['customer_id'];
        $account_number = $row['account_number'];
        $product_type = $row['product_type'];
        $product = $row['product'];
        //$opening_amount = $row['opening_amount'];
        $plan_amount = $row['plan_amount'];
        $cleared_balance = $row['cleared_balance'];
        $customer_branch = $row["secondary_branch"];
        $customer_rm = $row["secondary_relationship_manager"];
        $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
        $creation_date = $row["creation_date"];
        $approval_date = $row["approval_date"];
        $account_status = $row['status'];
        $total_debited_thrift_fee = $row['total_debited_thrift_fee'];
        $sms_alert = $row["sms_alert"];
        $email_alert = $row["email_alert"];
        $currency = $row["currency"];
    }
    //CHECK IF PND IS SET FOR THIS ACCOUNT
    $ppnd = $dbConn -> prepare('SELECT * FROM pnd WHERE account_id=?');
    $ppnd -> bind_param('i', $account_id);
    $ppnd -> execute();
    $rppnd = $ppnd->get_result();
    if ($rppnd->num_rows > 0) {
        $is_pnd = 1;
    } else {
        $is_pnd = 0;
    }

    //CHECK IF THERE'S LIEN FOR THIS ACCOUNT
    $lln = $dbConn -> prepare('SELECT * FROM lien WHERE account_id=?');
    $lln -> bind_param('i', $account_id);
    $lln -> execute();
    $rlln = $lln->get_result();

    if ($rlln->num_rows > 0) {
        while($jvx = mysqli_fetch_assoc($rlln) ){ 
            $lien= $jvx["amount"];
        }
    } else {
        $lien = 0;
    }

    if($product_type == "Savings") {
        require_once("../../customer/dorm_check.php");
    } else {
        $a_dbt = 0;
        $a_cdt = 0;
        $a_ph = 0;
        $a_em = 0;
    }

    if($error > 0) {
        echo json_encode(array("message" => "Failed. Please make sure you fill in all fields."));
    } else if ($proceed_disburse == 0) {
        echo json_encode(array("message" => "Network Unavailable"));
    } else if ($globalbalance < 100) {
        echo json_encode(array("message" => "Network Unavailable"));
    } else if($is_pnd == 1) {
        echo json_encode(array("message" => "Account does not currently allow debit transactions."));
    } else if ($a_dbt == 1 && $account_status == "Dormant") {
        echo json_encode(array("message" => "This account is dormant and doesn't allow debits."));
    } else if ($account_status == "Invalid" || $account_status == "Pending" || $account_status == "Closed" || $account_status == "Frozen") {
        echo json_encode(array("message" => "Debit is not allowed for this account"));
    } else {

        if ($product_type == "Savings") {
            //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
            $yui = $dbConn -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
            $yui -> bind_param('i', $account_id);
            $yui -> execute();
            $ryui = $yui->get_result();
        
            if ($ryui->num_rows > 0) {
                while($io = mysqli_fetch_array($ryui) ){
                    $curr_locked = $io['curr_locked'];
            
                }
            } else {
                $curr_locked = 0;
            }
        
            $product2 = str_replace("S","","$product");
            $sc = $dbConn -> prepare('SELECT * FROM savingsproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
        
                }
        
                $al_withdraw = 1;
        
            
        } else if ($product_type == "Thrift") {
        
            $product2 = str_replace("T","","$product");
                
            $sc = $dbConn -> prepare('SELECT * FROM thriftproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $deduct_charge_per_tenure = $sc1['deduct_charge_per_tenure'];
                    $allow_premature_withdrawal = $sc1['allow_premature_withdrawal'];
                    $plan_count = $sc1['plan_count'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
                }
        
                if ($allow_premature_withdrawal == "Yes") {
                //GET CLEARED BALANCE BY OMITTING DAYS/WEEKS/MONTHS THAT DEPOSIT DIDN'T TAKE PLACE
                
                $today_date = date("Y-m-d");
                $date1 = new DateTime($approval_date);
                $date2 = new DateTime($today_date);
                $total_days  = $date2->diff($date1)->format('%a');
        
                $amount_case = $cleared_balance / $plan_amount;
        
                if($total_debited_thrift_fee >0) {
                    $debit_count = $total_debited_thrift_fee/$plan_amount;
        
                    for($o=0; $o<$debit_count; $o++) {
                        $total_days = $total_days - $plan_count;
                    }
                } else {
                    $debit_count = 0 ;
                }
        
                    $charge_count = 0;
                    $status_tr = "Approved";
                    for ($i=0; $i < $total_days; $i += $plan_count) {
                        //$end_date = $creation_date + $plan_count;
                        $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
        
                        $cdt = "Credit";
                        $grec = $dbConn -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                        $grec -> bind_param('sssss', $account_number, $status_tr, $cdt, $approval_date, $end_date);
                        $grec -> execute();
                        $rgrec = $grec->get_result();
        
                        while($gre_r = mysqli_fetch_array($rgrec) ){
                            $sum_amount = $gre_r['tram'];
        
                        }
                        if ($sum_amount > 0) {
                            $charge_count = $charge_count + 1;
                        }
        
                        $approval_date = $end_date;
        
                    }
        
                    if ($amount_case > $charge_count && $amount_case > $plan_count) {
                        $charge_count = ceil($amount_case/$plan_count);
                    }
        
                    $balance_count = $charge_count - $debit_count;
        
        
                    $charge_amount_trt = $balance_count * $plan_amount;
                    //$net = $cleared_balance - $charge_amount;
                    $curr_locked = $charge_amount_trt;
                    $al_withdraw = 1;
                } else {
                    $al_withdraw = 0;
                    $curr_locked = 0;
                }
        
        } else if ($product_type == "Term Deposit") {
            $product2 = str_replace("TD","","$product");
                
                    $sc = $dbConn -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                    $sc -> bind_param('i', $product2);
                    $sc -> execute();
                    $rsc = $sc->get_result();
                        while($sc1 = mysqli_fetch_array($rsc) ){
                            $saving_reference = $sc1['saving_reference'];
                            $saving_control = $sc1['saving_control'];
                            $productGroup = $sc1['productGroup'];
                        }
                        $minAmount = 0; //SET ON PURPOSE FOR GENERAL USE
                        $curr_locked = 0;
                        $al_withdraw = 1;
        } else {
            $curr_locked = 0;
            $al_withdraw = 1;
        }
        
                $pod1 = $dbConn -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
                $pod1 -> bind_param('i', $customer_id);
                $pod1 -> execute();
                $rpod1 = $pod1->get_result();
        
                while($row1 = mysqli_fetch_assoc($rpod1) ){
                $customer_name = $row1["fname"];
                $fname = $row1["fname"];
                $mname = $row1["mname"];
                $lname = $row1["lname"];
                $cu_character = strtoupper($customer_name[0]);
            }
        
        date_default_timezone_set("Africa/Lagos");
        $withdraw_transaction_date = date("Y-m-d H:i:s");
        $transaction_date = date("Y-m-d H:i:s");
        
        $num = mt_rand(100000, 999999);
        $stamp = date("Yhis");
        $stamp_1 = date("Yhis");
        $orderId = $stamp . $num;
        
        $transaction_id = "D$cu_character" . "$orderId";
        
        $description = "$text";
        $type = "Debit";
        
        include("../../customer/check_sms_email.php");

        $total_debit = $amount + $added_charge + $curr_locked + $pending_charges + $lien + $minAmount;

        if ($cleared_balance < $total_debit) {

            echo json_encode(array("message" => "Insufficient Funds"));

            } else if ($cleared_balance >= $total_debit && $al_withdraw == 1) {

                $processed = 0;
        $ins = $dbConn->prepare("INSERT INTO pending_transactions_channels_bills (account_id, action_rb, network, amount, code, product_name, device_no, 
        smart_card_no, meter_no, phone_no, meter_type, customer_name, processed, total_debit)VALUES(?,?,?,?,?,?,?,?,?)");
        $ins->bind_param("issdssssssssid", $account_id, $action_rb, $network, $amount, $code, $product_name, $device_no, $smart_card_no, $meter_no, $phone_no, $meter_type, $customer_name, $processed, $total_debit);
        $ins->execute();

        if ($ins){

            $pndtr = $dbConn->prepare("SELECT * FROM pending_transactions_channels WHERE account_id=?");
            $pndtr->bind_param("i", $account_id);
            $pndtr->execute(); 
            $rpndtr = $pndtr->get_result();
            if($rpndtr->num_rows > 0) {

                foreach($rpndtr as $tr):
                    $pn_id = $tr["id"];
                    $action_rb = $tr["action_rb"];
                    $network = $tr["network"];
                    $amount = $tr["amount"];
                    $code = $tr["code"];
                    $product_name = $tr["product_name"];
                    $device_no = $tr["device_no"];
                    $smart_card_no = $tr["smart_card_no"];
                    $meter_no = $tr["meter_no"];
                    $phone_no = $tr["phone_no"];
                    $meter_type = $tr["meter_type"];
                    $customer_name = $tr["customer_name"];
                    $processed = $tr["processed"];
                    $total_debit = $tr["total_debit"];

                    $pod_s = $dbConn -> prepare('SELECT * FROM accounts WHERE id=?');
                    $pod_s -> bind_param('i', $account_id);
                    $pod_s -> execute();
                    $rpod_s = $pod_s->get_result();

                    while($row_s = mysqli_fetch_assoc($rpod_s) ){
                        $cleared_balance = $row_s['cleared_balance'];
                    }

                    if($cleared_balance >= $total_debit) {

                        if($processed == 0) {

                            $dpn = $dbConn->prepare("DELETE FROM pending_transactions_channels_bills WHERE id=?");
                            $dpn->bind_param("i", $pn_id);
                            $dpn->execute();

                            date_default_timezone_set("Africa/Lagos");
                            $withdraw_transaction_date = date("Y-m-d H:i:s");
                            $transaction_date = date("Y-m-d H:i:s");
                            
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $stamp_1 = date("Yhis");
                            $orderId = $stamp . $num;
                            
                            $transaction_id = "D$cu_character" . "$orderId";
                            
                            $description = "$text";
                            $type = "Debit";

                            $new_amount = $cleared_balance - $total_due_amount;
                            $previous_balance = $cleared_balance;

                            $withdraw_comment = "$text";
                        //UPDATE CUSTOMER ACCOUNT

                            $pw = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE id=?");
                            $pw->bind_param('di', $new_amount, $account_id);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTION TABLE

                                $w = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_due_amount, $type, $description, $withdraw_transaction_date, $value_date, $withdraw_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1);
                                $w->execute();
                                $last_id = mysqli_insert_id($dbConn);

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "$text3 from customer account";
                            $act_type = "Airtime/Bill";
                            $ww = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                            $ww->execute();

                            //INSERT INTO JOURNAL
                            $crd_gl = -$total_due_amount;
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "$text3 from customer account";
                            $jn = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiisss", $last_id, $crd_gl, $total_due_amount, $saving_reference, $saving_control, $aid, $usbrn, $journal_type, $journal_description, $journal_date);
                            $jn->execute();

                            //SEND TO EGIS FOR PROCESSING
                            $sendlog =  array('api' => $egis_api, 'secret' => $egis_secret);

                            $b_a1 = curl_init();
                            curl_setopt($b_a1, CURLOPT_URL,"$egis_api_root/login.php");
                            curl_setopt($b_a1, CURLOPT_POST, 1);
                            curl_setopt($b_a1, CURLOPT_POSTFIELDS,json_encode($sendlog));  //Post Fields
                            curl_setopt($b_a1, CURLOPT_RETURNTRANSFER, true);

                            $headers1 = [
                            'Content-Type: application/json'
                            ];

                            curl_setopt($b_a1, CURLOPT_HTTPHEADER, $headers1);

                            $sendst1 = curl_exec ($b_a1);

                            curl_close ($b_a1);
                            if ($sendst1) {
                            $srst1 = json_decode($sendst1, true);
                            }
                                
                            $token_st = $srst1['token'];

                            $sendata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'action' => $action_rb, 'network' => $network, 'amount' => $amount, 'code' => $code, 'product_name' => $product_name, 'device_no' => $device_no, 'smart_card_no' => $smart_card_no, 'meter_no' => $meter_no, 'phone_no' => $phone_no, 'meter_type' => $meter_type, 'customer_name' => $customer_name, 'account_id' => $account_id);

                            $b_a3 = curl_init();
                            curl_setopt($b_a3, CURLOPT_URL,"$egis_api_root/redbiller_buy_actions.php");
                            curl_setopt($b_a3, CURLOPT_POST, 1);
                            curl_setopt($b_a3, CURLOPT_POSTFIELDS,json_encode($sendata3));  //Post Fields
                            curl_setopt($b_a3, CURLOPT_RETURNTRANSFER, true);
                            //Set your auth headers
                            curl_setopt($b_a3, CURLOPT_HTTPHEADER, array(
                            'Content-Type: application/json',
                            'Authorization: Bearer ' . $token_st
                            ));

                            // get stringified data/output. See CURLOPT_RETURNTRANSFER
                            $stst1 = curl_exec($b_a3);

                    

                            //DEDUCT ALL APPLICABLE CHARGES
                                if($charge_sms == 1) {

                                    $yui = $dbConn -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                    $yui -> bind_param('i', $account_id);
                                    $yui -> execute();
                                    $ryui = $yui->get_result();
                                    while($io = mysqli_fetch_array($ryui) ){
                                        $alert_phone = $io['phone_no'];
                                    }

                            //DO ALL SHORTCODE REPLACEMENTS
                            $dst_account = "**".substr($account_number, -4);
                            $message = str_replace("[accountNo]",$dst_account,$message);
                            $message = str_replace("[fname]",$fname,$message);
                            $message = str_replace("[lname]",$lname,$message);
                            $message = str_replace("[mname]",$mname,$message);
                            $message = str_replace("[vdate]",$value_date,$message);
                            $message = str_replace("[adate]",$withdraw_transaction_date,$message);
                            $message = str_replace("[amount]",$total_due_amount,$message);
                            $message = str_replace("[balance]",$new_amount,$message);
                            $message = str_replace("[trbranch]",$customer_branch,$message);

                            $message = str_replace("[phone_no]",$ph_sms,$message);
                            $message = str_replace("[network_provider]",$nwt_sms,$message);
                            $message = str_replace("[device_no]",$dvn_sms,$message);


                            //SEND TO EGIS SERVICES FOR SENDING SMS HERE

                            $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);

                            $ch1 = curl_init();
                            curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                            curl_setopt($ch1, CURLOPT_POST, 1);
                            curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                            curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);

                            $headers1 = [
                            'Content-Type: application/json'
                            ];

                            curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);

                            $request1 = curl_exec ($ch1);

                            curl_close ($ch1);
                            if ($request1) {
                            $result1 = json_decode($request1, true);
                            }
                                
                            $token = $result1['token'];

                            $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone, 'message' => $message);

                            $ch3 = curl_init();
                            curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/sms.php");
                            curl_setopt($ch3, CURLOPT_POST, 1);
                            curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
                            curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
                            //Set your auth headers
                            curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
                            'Content-Type: application/json',
                            'Authorization: Bearer ' . $token
                            ));

                            // get stringified data/output. See CURLOPT_RETURNTRANSFER
                            $data1 = curl_exec($ch3);

                            //$decode1 = json_decode($data1);

                                //$charge_tl1 = "Withdrawal Fee";
                                $charge_tl2 = "Single SMS Fee";
                                //$charge_tl4 = "Email Fee";
                                $incr = $dbConn -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =?)');
                                $incr -> bind_param('ss', $product, $charge_tl2);
                                $incr -> execute();
                                $rincr = $incr->get_result();

                                if($rincr->num_rows > 0) {

                                    foreach ($rincr as $iid):
                                    
                                    $de = $dbConn -> prepare('SELECT * FROM charges WHERE id=?');
                                    $de -> bind_param('i', $iid['cid']);
                                    $de -> execute();
                                    $rde = $de->get_result();
                                    while($dee = mysqli_fetch_array($rde) ){
                                    //Call Charge Amount
                                    $trnsss_amount = $total_due_amount;
                                    $chid = $iid['cid'];
                                    include('../../../charges.php');
                                    //End Call Charge Amount
                                    $charge_name = $dee['name'];
                                    $charge_option = $dee['charge_option'];
                                    $triggertype = $dee['triggertype'];
                                    $chargetype = $dee['chargetype'];
                                    }

                                    $set = $dbConn -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                    $set -> bind_param('ss', $product, $iid['cid']);
                                    $set -> execute();
                                    $rset = $set->get_result();
                                    while($rrt = mysqli_fetch_array($rset) ){
                                        $income_acc = $rrt['income_acc'];
                                    }

                                        $cb = $dbConn -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                                        $cb -> bind_param('s', $account_number);
                                        $cb -> execute();
                                        $rcb = $cb->get_result();

                                        while($rbb = mysqli_fetch_assoc($rcb) ){
                                        $cleared_bal = $rbb["cleared_balance"];
                                        }

                                    if ($charge_option != "Flat") {
                                        $charge_amount = $total_due_amount * ($charge_amount/100);
                                    }
                                    if ($triggertype == "Per Transaction" && $charge_amount >0) {

                                        
                                        //$value_date = date("Y-m-d H:i:s");
                                        $num = mt_rand(100000, 999999);
                                        $stamp = date("Yhis");
                                        $orderId = $stamp . $num;

                                        $new_amount_c = $cleared_bal - $charge_amount;

                                        $description_c = "$charge_name";
                                        $type_c = "Debit";

                                        $debit_comment = "$charge_name";

                                        $transaction_id_c = "D$cu_character" . "$orderId";

                                        //INSERT CHARGES INTO TRANSACTION TABLE
                                        $wc = $dbConn->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $account_number, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                                        $wc->execute();
                                        $last_id_c = mysqli_insert_id($dbConn);

                                        $entity_id_c = "TRR$last_id_c";

                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "$charge_name debit from customer account";
                                        $act_type = "Debit";
                                        $wwc = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $usbrn, $channel_log);
                                        $wwc->execute();

                                        $crd_gl1 = -$charge_amount;
                                        $journal_description = "$charge_name";
                                        $jn = $dbConn->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date) VALUES (?,?,?,?,?,?,?,?,?,?)");
                                        $jn->bind_param("iddiiiisss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date);
                                        $jn->execute();

                                        $upd = $dbConn->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                        $upd->bind_param('ds', $new_amount_c, $account_number);
                                        $upd->execute();
                                        
                                        } else {
                                            //INSERT CHARGE INTO TEM CHARGES TABLE
                                            if($charge_amount>0) {
                                            $inch = $dbConn->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                            $inch->bind_param("sdss", $account_number, $charge_amount, $charge_name, $triggertype);
                                            $inch->execute();
                                            }

                                            $new_amount_c = $new_amount;
                                        }

                                        //DO SMS INTEGRATION
                                        if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                            $biz_rule = "Charge Deducted";
                                            $brn = $customer_branch;
                                            $rm = $customer_rm;
                                            $pg = $productGroup;
                                            $account_id = $account_id;
                                            $account_no = $account_number;
                                            $vdate = $value_date;
                                            $tdate = $withdraw_transaction_date;
                                            $tamount = $charge_amount;
                                            $cb = $new_amount_c;

                                            include_once("../../customer/sms_int.php");
                                        }

                                        endforeach;
                                    }
                                }
                                        echo json_encode(array("message" => "$text4"));
                        }

                    }
                endforeach;

                }
            }

        }
    }


    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
   
}

//standing instruction
function standingInstruction($dbConn, $usbrn) {

    $isbranch_enabled = branStatus($dbConn, $usbrn);
    if ($isbranch_enabled == 0) {

        if (isset($_POST['instruction_type']) && $_POST['instruction_type'] != "") {

            if ($_POST['instruction_type']=="Loan Repayment Instruction" && $_POST['repayment_account_type'] == "") {
       
               echo json_encode(array('message' => 'Select Repayment Type'));
           } else if ($_POST['repayment_account_type']=="Own Account" && $_POST['beneficiary_loan_ins_own'] == "") {
       
               echo json_encode(array('message' => 'Select Beneficiary Loan Account'));     
           } else if ($_POST['repayment_account_type']=="Other Account" && $_POST['beneficiary_loan_ins'] == "") {
       
               echo json_encode(array('message' => 'Select Beneficiary Loan Account'));  
           } else if ($_POST['instruction_type']=="Loan Repayment Instruction" && ($_POST['instruction_amount'] == "" || $_POST['instruction_amount'] < 1)) {
       
               echo json_encode(array('message' => 'Enter Amount'));
           } else if ($_POST['instruction_type']=="Deposit Instruction" && $_POST['destination_type'] == "") {
       
               echo json_encode(array('message' => 'Select Destination Type'));     
           } else if ($_POST['instruction_type']=="Deposit Instruction" && ($_POST['instruction_amount'] == "" || $_POST['instruction_amount'] < 1)) {
       
               echo json_encode(array('message' => 'Enter Amount'));
           } else if ($_POST['destination_type']=="Inbound" && $_POST['beneficiary_inbound_ins'] == "") {
       
               echo json_encode(array('message' => 'Enter Beneficiary Account'));     
           } else if ($_POST['destination_type']=="Own Account" && $_POST['beneficiary_own_ins'] == "") {
       
               echo json_encode(array('message' => 'Enter Beneficiary Account'));   
           } else if ($_POST['destination_type']=="Outbound" && $_POST['beneficiary_old_ins'] == "") {
       
               echo json_encode(array('message' => 'Select Beneficiary'));
       
           } else if ($_POST['beneficiary_old_ins']=="New Beneficiary" && $_POST['beneficiary_acc_bank_ins'] == "") {
       
               echo json_encode(array('message' => 'Select Beneficiary Bank'));  
           } else if ($_POST['beneficiary_old_ins']=="New Beneficiary" && $_POST['disbursement_acc_number_ins'] == "") {
       
               echo json_encode(array('message' => 'Enter Beneficiary Account Number'));     
           } else if ($_POST['frequency']=="") {
       
               echo json_encode(array('message' => 'Select Frequency'));    
           } else if ($_POST['instruction_type']=="Airtime Instruction" && ($_POST['instruction_amount'] == "" || $_POST['instruction_amount'] < 1)) {
       
               echo json_encode(array('message' => 'Enter Amount'));
           } else if ($_POST['instruction_type']=="Airtime Instruction" && $_POST['airtime_provider'] == "") {
       
               echo json_encode(array('message' => 'Select Network Provider'));       
           } else if ($_POST['instruction_type']=="Airtime Instruction" && $_POST['airtime_mobile'] == "") {
       
               echo json_encode(array('message' => 'Enter Mobile Number'));     
           } else if ($_POST['instruction_type']=="Databundle Instruction" && $_POST['databundle_provider'] == "") {
       
               echo json_encode(array('message' => 'Select Network Provider'));        
           } else if ($_POST['instruction_type']=="Databundle Instruction" && $_POST['databundle_mobile'] == "") {
       
               echo json_encode(array('message' => 'Enter Mobile Number'));
           } else if ($_POST['instruction_type']=="Databundle Instruction" && $_POST['data_plan'] == "") {
       
               echo json_encode(array('message' => 'Select Data Plan'));
           } else if ($_POST['instruction_type']=="Cable Subscription Instruction" && $_POST['cable_provider'] == "") {
       
               echo json_encode(array('message' => 'Select Cable Provider'));    
           } else if ($_POST['instruction_type']=="Cable Subscription Instruction" && $_POST['cable_plan'] == "") {
       
               echo json_encode(array('message' => 'Select Cable Plan'));
           } else if ($_POST['instruction_type']=="Cable Subscription Instruction" && $_POST['decoder_number'] == "") {
       
               echo json_encode(array('message' => 'Enter Decoder Number'));   
           } else if ($_POST['instruction_type']=="Cable Subscription Instruction" && $_POST['cable_mobile'] == "") {
       
               echo json_encode(array('message' => 'Enter Mobile Number')); 
           } else if ($_POST['instruction_type']=="Internet Subscription Instruction" && $_POST['internet_provider'] == "") {
       
               echo json_encode(array('message' => 'Select Internet Provider'));    
           } else if ($_POST['instruction_type']=="Internet Subscription Instruction" && $_POST['internet_plan'] == "") {
           
               echo json_encode(array('message' => 'Select Internet Plan'));  
           } else if ($_POST['instruction_type']=="Internet Subscription Instruction" && ($_POST['device_number'] == "" || $_POST['device_number'] < 2)) {
           
               echo json_encode(array('message' => 'Enter Device Number'));  
           } else if ($_POST['instruction_type']=="Electricity Bill Instruction" && $_POST['electricity_provider'] == "") {
       
               echo json_encode(array('message' => 'Select Electricity Provider'));    
           } else if ($_POST['instruction_type']=="Electricity Bill Instruction" && $_POST['meter_type'] == "") {
           
               echo json_encode(array('message' => 'Select Meter Type'));
           } else if ($_POST['instruction_type']=="Electricity Bill Instruction" && ($_POST['meter_number'] == "" || $_POST['meter_number'] < 2)) {
           
               echo json_encode(array('message' => 'Enter Meter Number'));
           } else if ($_POST['instruction_type']=="Electricity Bill Instruction" && $_POST['electricity_mobile'] == "") {
           
               echo json_encode(array('message' => 'Mobile Number'));      
           } else if ($_POST['instruction_type']=="Electricity Bill Instruction" && ($_POST['instruction_amount'] == "" || $_POST['instruction_amount'] < 1)) {
              echo json_encode(array('message' => 'Enter Amount'));
           } else {
       
               
               $account_id = $_POST['account_id'];
               $instruction_type = $_POST['instruction_type'];
       
               if($instruction_type =="Deposit Instruction" || $instruction_type =="Loan Repayment Instruction" || $instruction_type =="Airtime Instruction" || $instruction_type =="Electricity Bill Instruction") {
                   $instruction_amount = $_POST['instruction_amount'];
                   $code = NULL;
                   $package_name = NULL;
               } else if ($instruction_type == "Databundle Instruction") {
                   $instruction_amount = $_POST['amount_data'];
                   $code = $_POST['code_data'];
                   $package_name = $_POST['pname_data'];
               }
               else if ($instruction_type == "Cable Subscription Instruction") {
                   $instruction_amount = $_POST['amount_data'];
                   $code = $_POST['code_cable'];
                   $package_name = $_POST['pname_cable'];
               }
               else if ($instruction_type == "Internet Subscription Instruction") {
                   $instruction_amount = $_POST['amount_internet'];
                   $code = $_POST['code_internet'];
                   $package_name = $_POST['pname_internet'];
               }
               else if ($instruction_type == "Electricity Bill Instruction") {
                   $instruction_amount = $_POST['instruction_amount'];
                   $code = NULL;
                   $package_name = NULL;
               }
               $start_date = date("Y-m-d", strtotime($_POST['start_date']));
               $frequency = $_POST['frequency'];
       
               $pod = $dbConn -> prepare('SELECT * FROM accounts WHERE id=?');
               $pod -> bind_param('i', $account_id);
               $pod -> execute();
               $rpod = $pod->get_result();
       
               while($row = mysqli_fetch_assoc($rpod) ){
                   $product_type = $row['product_type'];
                   $product = $row['product'];
               }
       
       
               if($product_type == "Savings") {
                   require_once("../../customer/dorm_check.php");
               } else {
                   $a_dbt = 0;
               }
       
               if($a_dbt == 1) {
                   echo json_encode(array('message' => 'Account is dormant and does not allow debit transactions'));
               } else {
       
               
               if (isset($_POST['destination_type']) && $_POST['destination_type'] != "") {
                   $destination_type = $_POST['destination_type'];
               } else {
                   $destination_type = NULL;
               }
               
               if (isset($_POST['beneficiary_inbound_ins']) && $_POST['beneficiary_inbound_ins'] != "") {
                   $beneficiary_inbound_ins = $_POST['beneficiary_inbound_ins'];
               } else {
                   $beneficiary_inbound_ins = NULL;
               }
               if (isset($_POST['beneficiary_old_ins']) && $_POST['beneficiary_old_ins'] != "") {
                   $beneficiary_old_ins = $_POST['beneficiary_old_ins'];
               } else {
                   $beneficiary_old_ins = NULL;
               }
       
               if (isset($_POST['beneficiary_acc_bank_ins']) && $_POST['beneficiary_acc_bank_ins'] != "") {
                   $beneficiary_acc_bank_ins = $_POST['beneficiary_acc_bank_ins'];
               } else {
                   $beneficiary_acc_bank_ins = NULL;
               }
       
               if (isset($_POST['disbursement_acc_number_ins']) && $_POST['disbursement_acc_number_ins'] != "") {
                   $disbursement_acc_number_ins = $_POST['disbursement_acc_number_ins'];
               } else {
                   $disbursement_acc_number_ins = NULL;
               }
               if (isset($_POST['beneficiary_own_ins']) && $_POST['beneficiary_own_ins'] != "") {
                   $beneficiary_own_ins = $_POST['beneficiary_own_ins'];
               } else {
                   $beneficiary_own_ins = NULL;
               }
               
               if (isset($_POST['repayment_account_type']) && $_POST['repayment_account_type'] != "") {
                   $repayment_account_type = $_POST['repayment_account_type'];
               } else {
                   $repayment_account_type = NULL;
               }
               if (isset($_POST['beneficiary_loan_ins_own']) && $_POST['beneficiary_loan_ins_own'] != "") {
                   $beneficiary_loan_ins_own = $_POST['beneficiary_loan_ins_own'];
               } else {
                   $beneficiary_loan_ins_own = NULL;
               }
               if (isset($_POST['beneficiary_loan_ins']) && $_POST['beneficiary_loan_ins'] != "") {
                   $beneficiary_loan_ins = $_POST['beneficiary_loan_ins'];
               } else {
                   $beneficiary_loan_ins = NULL;
               }
       
               if (isset($_POST['end_date']) && $_POST['end_date'] != "") {
                   $end_date = date("Y-m-d", strtotime($_POST['end_date']));
               } else {
                   $end_date = NULL;
               }
       
               if (isset($_POST['ins_comment']) && $_POST['ins_comment'] != "") {
                   $ins_comment = $_POST['ins_comment'];
               } else {
                   $ins_comment = NULL;
               }
       
               if (isset($_POST['electricity_provider']) && $_POST['electricity_provider'] != "") {
                   $electricity_provider = $_POST['electricity_provider'];
               } else {
                   $electricity_provider = NULL;
               }
               if (isset($_POST['meter_type']) && $_POST['meter_type'] != "") {
                   $meter_type = $_POST['meter_type'];
               } else {
                   $meter_type = NULL;
               }
               if (isset($_POST['meter_number']) && $_POST['meter_number'] != "") {
                   $meter_number = $_POST['meter_number'];
               } else {
                   $meter_number = NULL;
               }
               if (isset($_POST['electricity_mobile']) && $_POST['electricity_mobile'] != "") {
                   $electricity_mobile = $_POST['electricity_mobile'];
               } else {
                   $electricity_mobile = NULL;
               }
               if (isset($_POST['cable_provider']) && $_POST['cable_provider'] != "") {
                   $cable_provider = $_POST['cable_provider'];
               } else {
                   $cable_provider = NULL;
               }
               if (isset($_POST['cable_plan']) && $_POST['cable_plan'] != "") {
                   $cable_plan = $_POST['cable_plan'];
               } else {
                   $cable_plan = NULL;
               }
               if (isset($_POST['decoder_number']) && $_POST['decoder_number'] != "") {
                   $decoder_number = $_POST['decoder_number'];
               } else {
                   $decoder_number = NULL;
               }
               if (isset($_POST['cable_mobile']) && $_POST['cable_mobile'] != "") {
                   $cable_mobile = $_POST['cable_mobile'];
               } else {
                   $cable_mobile = NULL;
               }
               if (isset($_POST['databundle_provider']) && $_POST['databundle_provider'] != "") {
                   $databundle_provider = $_POST['databundle_provider'];
               } else {
                   $databundle_provider = NULL;
               }
               if (isset($_POST['databundle_mobile']) && $_POST['databundle_mobile'] != "") {
                   $databundle_mobile = $_POST['databundle_mobile'];
               } else {
                   $databundle_mobile = NULL;
               }
               if (isset($_POST['airtime_provider']) && $_POST['airtime_provider'] != "") {
                   $airtime_provider = $_POST['airtime_provider'];
               } else {
                   $airtime_provider = NULL;
               }
               if (isset($_POST['airtime_mobile']) && $_POST['airtime_mobile'] != "") {
                   $airtime_mobile = $_POST['airtime_mobile'];
               } else {
                   $airtime_mobile = NULL;
               }
       
               if (isset($_POST['customer_name']) && $_POST['customer_name'] != "") {
                   $customer_name = $_POST['customer_name'];
               } else {
                   $customer_name = NULL;
               }
               if (isset($_POST['device_number']) && $_POST['device_number'] != "") {
                   $device_number = $_POST['device_number'];
               } else {
                   $device_number = NULL;
               }
               if (isset($_POST['internet_provider']) && $_POST['internet_provider'] != "") {
                   $internet_provider = $_POST['internet_provider'];
               } else {
                   $internet_provider = NULL;
               }
       
               if($_POST['instruction_type'] == "Internet Subscription Instruction") {
                   $decoder_number = $device_number;
                   $cable_provider = $internet_provider;
               }
       
       
                   $status = "Active";
                   $date_added = date("Y-m-d H:i:s");
                   $w2 = $dbConn->prepare("INSERT INTO standing_instruction (account_id, instruction_amount, start_date, end_date, ins_comment, frequency, status, instruction_type, repayment_account_type, beneficiary_loan_ins_own, repayment_beneficiary_other, destination_type, beneficiary_inbound_ins, beneficiary_old_ins, beneficiary_acc_bank_ins, disbursement_acc_number_ins, beneficiary_own_ins, date_added, added_by, electricity_provider, meter_type, meter_number, electricity_mobile, cable_provider, cable_plan, decoder_number, cable_mobile, databundle_provider, databundle_mobile, airtime_provider, airtime_mobile, code, customer_name, package_name) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                   $w2->bind_param("idssssssssssssssssisssssssssssssss", $account_id, $instruction_amount, $start_date, $end_date, $ins_comment, $frequency, $status, $instruction_type, $repayment_account_type, $beneficiary_loan_ins_own, $repayment_beneficiary_other, $destination_type, $beneficiary_inbound_ins, $beneficiary_old_ins, $beneficiary_acc_bank_ins, $disbursement_acc_number_ins, $beneficiary_own_ins, $date_added, $aid, $electricity_provider, $meter_type, $meter_number, $electricity_mobile, $cable_provider, $cable_plan, $decoder_number, $cable_mobile, $databundle_provider, $databundle_mobile, $airtime_provider, $airtime_mobile, $code, $customer_name, $package_name);
                   $w2->execute();
       
                   if($w2) {
                       $entity_id = "STNDINS$account_id";
       
                       $usr = $dbConn -> prepare('SELECT account_number FROM accounts WHERE id=?');
                       $usr -> bind_param('i', $account_id);
                       $usr -> execute();
                       $rusr = $usr->get_result();
                       while($ur = mysqli_fetch_assoc($rusr) ){
                           $account_number = $ur["account_number"];
                       }
       
                       $act_dsc = "Standing Instruction Added for Account Number $account_number";
                       $act_type = "Audit";
                       $ww = $dbConn->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                       $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                       $ww->execute();
       
                       echo json_encode(array('message' => 'Standing Instruction Added Successfully'));
                   } else {
                       echo json_encode(array('message' => 'Error, try again'));
                   }
       
               }
           }
       } else {
           echo json_encode(array('message' => 'Select Instruction Type'));
       }     
    } else {
        echo json_encode(array('message' => 'System Unavailable'));
    }
}

//submit complaint
function complaint($dbConn, $account_id, $subject, $message) {

}

//reply complaint
function complaintR($dbConn, $complaint_id, $message) {

}

//check book
function checkBookRequest($dbConn, $account_id, $leaves) {

}

//ATM request
function atmRequest($dbConn, $account_id, $cardtype, $vendor) {

}