<?php

require_once 'db.php';
require_once 'jwt_utils.php';
include("functions.php");
$channel_log = 7;
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

$bearer_token = get_bearer_token();

#echo $bearer_token;

//REQUIRE ORG_CODE AND BRANCH

$is_jwt_valid = is_jwt_valid($bearer_token);

if($is_jwt_valid) {
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	// get posted data
	$data = json_decode(file_get_contents("php://input", true));
	$action = $data->action;

        switch($action) {
            case "look_account":
                $account_number = $data->account_number;
                lookAccount($dbConn, $account_number);
            break;

            case "look_username":
                $usn = $data->usn;
                checkUsername($dbConn, $usn);
            break;
            case "signup_otp":
                $stype = $data->stype;
                $to = $data->to;
                $cuid = $data->cuid;
                $usn = $data->usn;
                signUpOTP($dbConn, $stype, $to, $cuid, $usn, $egis_api, $egis_secret, $egis_api_root, $site_name, $org_code);
            break;
            case "signup_verify":
                $fn = $data->fn;
                $ln = $data->ln;
                $cuid = $data->cuid;
                $usn = $data->usn;
                $o = $data->o;
                $ot = $data->ot;
                signUpVerify($dbConn, $fn, $ln, $cuid, $usn, $o, $ot, $egis_api, $egis_secret, $egis_api_root, $site_name, $org_code, $channel_log);
            break;

            case "login":
                $usnm = $data->usnm;
                $uspw = $data->uspw;
                login($dbConn, $usnm, $uspw, $lock_user_app, $attempts_app);
            break;

            case "dva_acc":
                $account_id = $data->account_id;
                getDVA($dbConn, $account_id);
            break;
        }  
    }
} else {
    echo json_encode(array('error' => 'Access denied'));
}