<?php
include('../../serv/accsecu/confs/config.php');
include('../welcome_user.php');
$action = $_POST['action'];

switch($action) {
    case "getAsset":
        $id = $_POST['appid'];

        $asl = $db -> prepare('SELECT name FROM assets WHERE id=?');
        $asl->bind_param("i", $id);
        $asl->execute();
        $rasl = $asl->get_result();

        if($rasl->num_rows > 0) {
            while($row = mysqli_fetch_assoc($rasl) ){
            $name = $row["name"];

            echo $name;
            }
        }

    break;
    case "getDis":
        $id = $_POST['appid'];

        $asl = $db -> prepare('SELECT asset_value FROM assets WHERE id=?');
        $asl->bind_param("i", $id);
        $asl->execute();
        $rasl = $asl->get_result();

        if($rasl->num_rows > 0) {
            while($row = mysqli_fetch_assoc($rasl) ){
            $asset_value = $row["asset_value"];
            echo round($asset_value,2);
            }
        }

    break;

    case "updateAsset":
        $id = $_POST['appid'];
        $name = $_POST['name'];

        $rup = $db->prepare("UPDATE assets SET name=? WHERE id=?");
        $rup->bind_param('si', $name, $id);
        $rup->execute();
        $rup->close();

        $entity_id = "ASTUP-$id";
        
        //INSERT NET AMOUNT INTO ACTIVITY TABLE
        $act_dsc = "Fixed Asset Name Update";
        $act_type = "Fixed Asset";
        $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
        $ww->execute();

        echo "<h3 class='text-success'>Asset Name Updated Successfully</h3>";

    break;

    case "transferAsset":
        $id = $_POST['appid'];
        $destination_branch = $_POST['destination_branch'];

        $blok = $db -> prepare('SELECT * FROM assets WHERE id=?');
        $blok -> bind_param('i', $id);
        $blok -> execute();
        $rblok = $blok->get_result();

        while($row = mysqli_fetch_assoc($rblok) ){
            $name = $row["name"];
            $asset_value = $row["asset_value"];
            $asset_branch = $row["branch"];
            $asset_class = $row["class"];
            $currency = $row["currency"];
        }
        $fscg = $db -> prepare('SELECT * FROM fixed_asset_config');
        $fscg->execute();
        $rfscg = $fscg->get_result();
        while($cy1 = mysqli_fetch_array($rfscg) ){
            $minimum_asset_amount = $cy1['minimum_asset_amount'];
            $expensed_amount = $cy1['expensed_amount'];
            $useful_property = $cy1['useful_property'];
            $useful_equipment = $cy1['useful_equipment'];
            $useful_plant = $cy1['useful_plant'];
            $cash_gl = $cy1['cash_gl'];
            $property_gl = $cy1['property_gl'];
            $equipment_gl = $cy1['equipment_gl'];
            $plant_gl = $cy1['plant_gl'];
            $salvage_property = $cy1['salvage_property'];
            $salvage_amount_property = $cy1['salvage_amount_property'];
            $salvage_amount_type_property = $cy1['salvage_amount_type_property'];
            $salvage_equipment = $cy1['salvage_equipment'];
            $salvage_amount_equipment = $cy1['salvage_amount_equipment'];
            $salvage_amount_type_equipment = $cy1['salvage_amount_type_equipment'];
            $salvage_plant = $cy1['salvage_plant'];
            $salvage_amount_plant = $cy1['salvage_amount_plant'];
            $salvage_amount_type_plant = $cy1['salvage_amount_type_plant'];
            $depreciation_frequency = $cy1['depreciation_frequency'];
            $depreciation_frequency_type = $cy1['depreciation_frequency_type'];
            $accumulated_depreciation_credit_gl = $cy1['accumulated_depreciation_credit_gl'];
            $accumulated_depreciation_expense_debit_gl = $cy1['accumulated_depreciation_expense_debit_gl'];
            $inter_branch_asset_transfer = $cy1['inter_branch_asset_transfer'];
            $disposal_option = $cy1['disposal_option'];
            $disposal_profit_gl = $cy1['disposal_profit_gl'];
            $disposal_loss_gl = $cy1['disposal_loss_gl'];
        }

        if($asset_branch == $destination_branch) {
            echo "<h3 class='text-danger center'>Destination branch cannot be the same as current asset branch</h3>";
        } else {

            $value_date = date("Y-m-d", strtotime($br_start_date));
            $workd = date("D", strtotime($br_start_date));
            $workd_use = strtolower($workd);

            $not1 = $db -> prepare("SELECT $workd_use FROM workdays");
            $not1 -> execute();
            $ruga1 = $not1->get_result();
            while($hk1 = mysqli_fetch_assoc($ruga1) ){
                $wk_true = $hk1["$workd_use"];
            }

            $ggh3 = $db -> prepare("SELECT * FROM holiday WHERE (? BETWEEN start_date AND end_date) AND id IN (SELECT holiday_id FROM holiday_branches WHERE branch=?)");
            $ggh3 -> bind_param('si', $value_date, $usbrn);
            $ggh3 -> execute();
            $rggh3 = $ggh3->get_result();

            if($rggh3->num_rows > 0) {
                $hol=1;
            } else {
                $hol=2;
            }

            $bact = "Active";
            $curbn = $db -> prepare('SELECT name FROM branch WHERE id=? AND status =?');
            $curbn -> bind_param('is', $usbrn, $bact);
            $curbn -> execute();
            $rcurbn = $curbn->get_result();
            if ($rcurbn->num_rows > 0) {
                $currben = 0;
            } else {
                $currben = 1;
            }

            if ($currben== 1) {
                echo "<h3 class='text-danger center'>Failed. Your branch has been disabled.</h3>";
            } else if ($hol==1 || $wk_true == 1) {
                echo "<h3 class='text-danger center'>You are not allowed to do transactions on a holiday or none working day</h3>";
            } else if ($allow_process == 1) {
                echo "<h3 class='text-danger center'>You cannot process transactions. branch processing date not set</h3>";
            } else {

                if($asset_class == "Property") {
                    $debit_account = $property_gl;
                } else if($asset_class == "Equipment") {
                    $debit_account = $equipment_gl;
                } else if($asset_class == "Plant") {
                    $debit_account = $plant_gl;
                }

                date_default_timezone_set("Africa/Lagos");
                //$withdraw_transaction_date = date("Y-m-d H:i:s");
                $transaction_date = date("Y-m-d H:i:s");

                $ast = $db->prepare("INSERT INTO asset_transfer (asset_id, originating_branch, destination_branch, date_transferred, transferred_by, datetime) VALUES (?,?,?,?,?,?)");
                $ast->bind_param("iiisis", $id, $asset_branch, $destination_branch, $value_date, $aid, $transaction_date);
                $ast->execute();

                $rup = $db->prepare("UPDATE assets SET branch=? WHERE id=?");
                $rup->bind_param('ii', $destination_branch, $id);
                $rup->execute();
                $rup->close();

                //INSERT INTO JOURNAL
                $crd_gl = -$asset_value;
                $journal_date = $value_date;
                $journal_type = "Automatic";
                $journal_description = "Fixed Asset Transfer";
                $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                $jn->bind_param("iddiiiissssi", $last_id, $crd_gl, $asset_value, $debit_account, $inter_branch_asset_transfer, $aid, $asset_branch, $journal_type, $journal_description, $journal_date, $currency, $id);
                $jn->execute();

                $jn1 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                $jn1->bind_param("iddiiiissssi", $last_id, $crd_gl, $asset_value, $debit_account, $inter_branch_asset_transfer, $aid, $destination_branch, $journal_type, $journal_description, $journal_date, $currency, $id);
                $jn1->execute();
        
                $entity_id = "ASTTR-$id";
                
                //INSERT NET AMOUNT INTO ACTIVITY TABLE
                $act_dsc = "Fixed Asset Transfer";
                $act_type = "Fixed Asset";
                $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                $ww->execute();

                echo "<h3 class='text-success'>Asset Transferred Successfully</h3>";
            }
        }


    break;

    case "disposeAsset":
        $id = $_POST['appid'];
        $disposal_reason = $_POST['disposal_reason'];
        $disposal_amount = $_POST['disposal_amount'];
       
        $blok = $db -> prepare('SELECT * FROM assets WHERE id=?');
        $blok -> bind_param('i', $id);
        $blok -> execute();
        $rblok = $blok->get_result();
       
        while($row = mysqli_fetch_assoc($rblok) ){
            $name = $row["name"];
            $asset_value = $row["asset_value"];
            $asset_branch = $row["branch"];
            $asset_class = $row["class"];
            $currency = $row["currency"];
            $salvage_amount = $row["salvage_amount"];
        }
        $fscg = $db -> prepare('SELECT * FROM fixed_asset_config');
        $fscg->execute();
        $rfscg = $fscg->get_result();
        while($cy1 = mysqli_fetch_array($rfscg) ){
            $minimum_asset_amount = $cy1['minimum_asset_amount'];
            $expensed_amount = $cy1['expensed_amount'];
            $useful_property = $cy1['useful_property'];
            $useful_equipment = $cy1['useful_equipment'];
            $useful_plant = $cy1['useful_plant'];
            $cash_gl = $cy1['cash_gl'];
            $property_gl = $cy1['property_gl'];
            $equipment_gl = $cy1['equipment_gl'];
            $plant_gl = $cy1['plant_gl'];
            $salvage_property = $cy1['salvage_property'];
            $salvage_amount_property = $cy1['salvage_amount_property'];
            $salvage_amount_type_property = $cy1['salvage_amount_type_property'];
            $salvage_equipment = $cy1['salvage_equipment'];
            $salvage_amount_equipment = $cy1['salvage_amount_equipment'];
            $salvage_amount_type_equipment = $cy1['salvage_amount_type_equipment'];
            $salvage_plant = $cy1['salvage_plant'];
            $salvage_amount_plant = $cy1['salvage_amount_plant'];
            $salvage_amount_type_plant = $cy1['salvage_amount_type_plant'];
            $depreciation_frequency = $cy1['depreciation_frequency'];
            $depreciation_frequency_type = $cy1['depreciation_frequency_type'];
            $accumulated_depreciation_credit_gl = $cy1['accumulated_depreciation_credit_gl'];
            $accumulated_depreciation_expense_debit_gl = $cy1['accumulated_depreciation_expense_debit_gl'];
            $inter_branch_asset_transfer = $cy1['inter_branch_asset_transfer'];
            $disposal_option = $cy1['disposal_option'];
            $disposal_profit_gl = $cy1['disposal_profit_gl'];
            $disposal_loss_gl = $cy1['disposal_loss_gl'];
        }
       
            $value_date = date("Y-m-d", strtotime($br_start_date));
            $workd = date("D", strtotime($br_start_date));
            $workd_use = strtolower($workd);
       
            $not1 = $db -> prepare("SELECT $workd_use FROM workdays");
            $not1 -> execute();
            $ruga1 = $not1->get_result();
            while($hk1 = mysqli_fetch_assoc($ruga1) ){
                $wk_true = $hk1["$workd_use"];
            }
       
            $ggh3 = $db -> prepare("SELECT * FROM holiday WHERE (? BETWEEN start_date AND end_date) AND id IN (SELECT holiday_id FROM holiday_branches WHERE branch=?)");
            $ggh3 -> bind_param('si', $value_date, $usbrn);
            $ggh3 -> execute();
            $rggh3 = $ggh3->get_result();
       
            if($rggh3->num_rows > 0) {
                $hol=1;
            } else {
                $hol=2;
            }
       
             //CHECK IF USER HAS TELLER
             $tty="Teller";
             $seltl = $db -> prepare('SELECT * FROM teller_balances WHERE user_id=? AND type=? AND currency=?');
             $seltl->bind_param("iss", $aid, $tty, $currency);
             $seltl->execute();
             $rseltl = $seltl->get_result();
         
             if($rseltl->num_rows > 0) {
                 while($tlb = mysqli_fetch_assoc($rseltl) ){
                  $teller_id = $tlb["id"];
                  $tl_balance = $tlb["balance"];
                  $tl_gl = $tlb["gl"];
                  $tl_status = $tlb["status"];
              }
         
                  $fundteller_amount = $tl_balance + $disposal_amount;
                  $has_teller=1;
       
                   //Teller Limits
                   $ovl = $db -> prepare('SELECT olimit, slimit, tlimit FROM config_tellers WHERE gl=?');
                   $ovl -> bind_param('i', $tl_gl);
                   $ovl -> execute();
                   $rovl = $ovl->get_result();
       
                   while ($lu = $rovl->fetch_array()) {
                       $olimit = $lu['olimit'];
                       $slimit = $lu['slimit'];
                       $tlimit = $lu['tlimit'];
                   }
       
                   if ($fundteller_amount > $tlimit) {
                       $tl_exceed = 1;//do not proceed, exceeds limit
                   } else {
                       $tl_exceed = 0;//proceed within limits
                   }
              
             } else {
             $has_teller=0;
             $tl_balance = 0;
             $tl_status ="";
             $tl_gl ="";
             $fundteller_amount = 0;
             $tl_exceed = 0;
             }
         
             $tty1="Tellering";
             $seltl1 = $db -> prepare('SELECT * FROM branch WHERE operational_model=? AND id=?');
             $seltl1->bind_param("si", $tty1, $usbrn);
             $seltl1->execute();
             $rseltl1 = $seltl1->get_result();
         
             if($rseltl1->num_rows > 0) {
                 $tl_model=1;
                 
             } else {
             $tl_model=0;
             }
       
            $bact = "Active";
            $curbn = $db -> prepare('SELECT name FROM branch WHERE id=? AND status =?');
            $curbn -> bind_param('is', $usbrn, $bact);
            $curbn -> execute();
            $rcurbn = $curbn->get_result();
            if ($rcurbn->num_rows > 0) {
                $currben = 0;
            } else {
                $currben = 1;
            }
       
            if ($currben== 1) {
                echo "<h3 class='text-danger center'>Failed. Your branch has been disabled.</h3>";
            } else if ($hol==1 || $wk_true == 1) {
                echo "<h3 class='text-danger center'>You are not allowed to do transactions on a holiday or none working day</h3>";
            } else if ($allow_process == 1) {
                echo "<h3 class='text-danger center'>You cannot process transactions. branch processing date not set</h3>";
            } else if($tl_model == 1 && $has_teller == 0) {
               echo "<h3 class='text-danger center'>Branch is operating a teller model but user has no teller</h3>";
           } else if($tl_model == 1 && $has_teller == 1 && $tl_status !="Open") {
               echo "<h3 class='text-danger center'>Disposal not allowed. Teller is not Open.</h3>";
           } else if($tl_model == 1 && $has_teller == 1 && $tl_exceed ==1) {
               echo "<h3 class='text-danger center'>Disposal not allowed. Teller limit of $currency $tlimit exceeded.</h3>";
           } else {
       
                if($asset_class == "Property") {
                    $credit_account = $property_gl;
                } else if($asset_class == "Equipment") {
                    $credit_account = $equipment_gl;
                } else if($asset_class == "Plant") {
                    $credit_account = $plant_gl;
                }
       
                date_default_timezone_set("Africa/Lagos");
                //$withdraw_transaction_date = date("Y-m-d H:i:s");
                $transaction_date = date("Y-m-d H:i:s");
       
                $num = mt_rand(100000, 999999);
               $stamp = date("Yhis");
               $stamp_1 = date("Yhis");
               $orderId = $stamp . $num;
           
               $transaction_id = "C$fn" . "$orderId";
           
               $description = "Fixed Asset Disposal";
               $type1 = "Credit";
               $withdraw_comment = "Fixed Asset Disposal";
           
               $previous_balance = 0;
               $new_amount = 0;
       
               if($salvage_amount==$disposal_amount) {
                   $disposal_status = "Salvage Amount";
                   $p_l = 0;
               } else if($salvage_amount < $disposal_amount) {
                   $disposal_status = "Profit";
                   $p_l = $salvage_amount - $disposal_amount;
               } else if($salvage_amount > $disposal_amount) {
                   $disposal_status = "Loss";
                   $p_l = $salvage_amount - $disposal_amount;
               }
       
                $ast = $db->prepare("INSERT INTO asset_disposal (asset_id, disposal_option, disposal_reason, profit_loss, disposal_status, disposal_date, dispose_by, datetime, branch) VALUES (?,?,?,?,?,?,?,?,?)");
                $ast->bind_param("isidssisi", $id, $disposal_option, $disposal_reason, $p_l, $disposal_status, $value_date, $aid, $transaction_date, $asset_branch);
                $ast->execute();
                
       
                $dispo = "Disposed";
                $rup = $db->prepare("UPDATE assets SET status=? WHERE id=?");
                $rup->bind_param('si', $dispo, $id);
                $rup->execute();
                $rup->close();
       
                if($has_teller ==1) {
       
                   $rev = "X";
                   $fkrm = 0;
                   $w = $db->prepare("INSERT INTO transactions (transaction_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, status, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                   $w->bind_param("sdddsssssiiiisisi", $transaction_id, $previous_balance, $new_amount, $disposal_amount, $type1, $description, $transaction_date, $value_date, $withdraw_comment, $usbrn, $fkrm, $channel_log, $aid, $stamp_1, $teller_id, $rev, $id);
                   $w->execute();
                   $last_id = mysqli_insert_id($db);
       
                   $mkp = $db->prepare("UPDATE teller_balances SET balance=? WHERE id=?");
                   $mkp->bind_param('di', $fundteller_amount, $teller_id);
                   $mkp->execute();
                   $mkp->close();
       
                   $debit_account = $tl_gl;
               } else {
                   $debit_account = $cash_gl;
                   $last_id = NULL;
               }
                   //INSERT INTO JOURNAL
                   $crd_gl = -$salvage_amount;
                   $journal_date = $value_date;
                   $journal_type = "Automatic";
                   $journal_description = "Fixed Asset Disposal";
                   $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                   $jn->bind_param("iddiiiissssi", $last_id, $crd_gl, $disposal_amount, $credit_account, $debit_account, $aid, $asset_branch, $journal_type, $journal_description, $journal_date, $currency, $id);
                   $jn->execute();
          
                   if($p_l < 0) {
                   $journal_description = "Fixed Asset Profit";
                   $cdt = 0;
                  // $p_l = $p_l * -1;
                   $jn1 = $db->prepare("INSERT INTO journals (credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                   $jn1->bind_param("ddiiiissssi", $p_l, $cdt, $disposal_loss_gl, $debit_account, $aid, $asset_branch, $journal_type, $journal_description, $journal_date, $currency, $id);
                   $jn1->execute();
                   } else if($p_l > 0) {
                       $cdt = 0;
                       //$p_l = $p_l * -1;
                       $journal_description = "Fixed Asset Loss";
                       $jn1 = $db->prepare("INSERT INTO journals (credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, asset_id) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                       $jn1->bind_param("ddiiiissssi", $cdt, $p_l, $debit_account, $disposal_profit_gl, $aid, $asset_branch, $journal_type, $journal_description, $journal_date, $currency, $id);
                       $jn1->execute();
                   }
       
                $entity_id = "ASTDSP-$id";
                
                //INSERT NET AMOUNT INTO ACTIVITY TABLE
                $act_dsc = "Fixed Asset Disposal";
                $act_type = "Fixed Asset";
                $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                $ww->execute();
       
                echo "<h3 class='text-success'>Asset Disposed Successfully</h3>";
            }       

    break;

    case "Reverse":
        $id = $_POST['appid'];
        $value_date = date("Y-m-d", strtotime($br_start_date));
        $workd = date("D", strtotime($br_start_date));
        $workd_use = strtolower($workd);
       
        $not1 = $db -> prepare("SELECT $workd_use FROM workdays");
        $not1 -> execute();
        $ruga1 = $not1->get_result();
        while($hk1 = mysqli_fetch_assoc($ruga1) ){
            $wk_true = $hk1["$workd_use"];
        }
       
        $ggh3 = $db -> prepare("SELECT * FROM holiday WHERE (? BETWEEN start_date AND end_date) AND id IN (SELECT holiday_id FROM holiday_branches WHERE branch=?)");
        $ggh3 -> bind_param('si', $value_date, $usbrn);
        $ggh3 -> execute();
        $rggh3 = $ggh3->get_result();
       
        if($rggh3->num_rows > 0) {
            $hol=1;
        } else {
            $hol=2;
        }
        
        $bact = "Active";
        $curbn = $db -> prepare('SELECT name FROM branch WHERE id=? AND status =?');
        $curbn -> bind_param('is', $usbrn, $bact);
        $curbn -> execute();
        $rcurbn = $curbn->get_result();
        if ($rcurbn->num_rows > 0) {
            $currben = 0;
        } else {
            $currben = 1;
        }

        if ($currben== 1) {
            echo "Failed. Your branch has been disabled.";
        } else if ($hol==1 || $wk_true == 1) {
            echo "You are not allowed to do transactions on a holiday or none working day";
        } else if ($allow_process == 1) {
            echo "You cannot process transactions. branch processing date not set";
        } else {
            date_default_timezone_set("Africa/Lagos");
            $transaction_date = date("Y-m-d H:i:s");
            $dsc = "Fixed Asset Registration";

            $mber = $db -> prepare("SELECT * FROM journals WHERE asset_id=? AND description=?");
            $mber -> bind_param("is", $id, $dsc);
            $mber -> execute();
            $rmber = $mber->get_result();

                
            if($rmber->num_rows > 0) {
                $tl_ok =0;
                $global_status = "Reversed";
                $last_id = NULL;
                $bnm = $db -> prepare("SELECT * FROM journals WHERE asset_id=? AND transaction_id IS NOT NULL AND status!=? AND description=?");
                $bnm -> bind_param("iss", $id, $global_status, $dsc);
                $bnm -> execute();
                $rbnm = $bnm->get_result();
                if($rbnm->num_rows > 0) {
                    foreach($rbnm as $ml):
                        $currency = $ml['currency'];
                        $trid = $ml['transaction_id'];
                        $j_branch = $ml['branch'];

                        $lsa = $db -> prepare("SELECT * FROM transactions WHERE id=?");
                        $lsa->bind_param("i", $trid);
                        $lsa->execute();
                        $rlsa = $lsa->get_result();
                        while($wp = mysqli_fetch_array($rlsa) ){
                            $tramount = $wp["transaction_amount"];
                            $tlid = $wp["teller_id"];
                        }
                        $tty="Teller";
                        $mnf = $db -> prepare('SELECT * FROM teller_balances WHERE id=? AND type=? AND currency=?');
                        $mnf->bind_param("iss", $tlid, $tty, $currency);
                        $mnf->execute();
                        $rmnf = $mnf->get_result();

                        if($rmnf->num_rows > 0) {
                            while($mz = mysqli_fetch_assoc($rmnf) ){
                                $tl_bal = $mz["balance"];
                                $tl_sts = $mz["status"];
                            }

                            if($tl_bal < $tramount) {
                                $tl_ok = 1;
                            }
                            if($tl_sts != "Open") {
                                $tl_ok = 2;
                            }

                            if($tl_ok == 0) {

                                $tl_update = $tl_bal - $tramount;
                                $num = mt_rand(100000, 999999);
                                $stamp = date("Yhis");
                                $orderId = $stamp . $num;
                                $transaction_id_gp = "RV-$fn" . "$orderId";

                                $upjno = $db->prepare("UPDATE transactions SET status=? WHERE id=?");
                                $upjno->bind_param('si', $global_status, $trid);
                                $upjno->execute();
                                $upjno->close();

                                $type="Debit";
                                $description = "Reversal";
                                $comment = "Fixed Asset Reversal";
                                $pb = 0;

                                $r_status = "X";
                                $rs = $db->prepare("INSERT INTO transactions (transaction_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $rs->bind_param("sdddssssssiiiii", $transaction_id_gp, $pb, $tl_update, $tramount, $type, $description, $transaction_date, $value_date, $comment, $r_status, $j_branch, $pb, $channel_log, $aid, $tlid);
                                $rs->execute();
                                $last_id = mysqli_insert_id($db);

                                $rup = $db->prepare("UPDATE teller_balances SET balance=? WHERE id=?");
                                $rup->bind_param('di', $tl_update, $tlid);
                                $rup->execute();
                                $rup->close();
                            }
                        }
                    endforeach;
                }

                if($tl_ok == 1) {
                    echo "Teller has insufficient balance to handle this reversal";
                } else if($tl_ok == 2) {
                    echo "Teller is not open";
                } else {
                
                //do group reversal here
                foreach($rmber as $gb):
                    $jjid = $gb["id"];
                    $j_credit_amount = $gb['credit'];
                    $j_debit_amount = $gb['debit'];
                    $j_credit_account = $gb['credit_account'];
                    $j_debit_account = $gb['debit_account'];
                    $j_transaction_description = $gb['description'];
                    $j_branch = $gb['branch'];	
                    $j_currency = $gb['currency'];		 

                //
                $upjn = $db->prepare("UPDATE journals SET status=? WHERE id=?");
                $upjn->bind_param('si', $global_status, $jjid);
                $upjn->execute();
                $upjn->close();

                //INSERT INTO JOURNAL
                $journal_date = $value_date;
                $journal_type = "Automatic";
                $journal_description = "$j_transaction_description Reversal";
                $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                $jn->bind_param("iddiiiissss", $last_id, $j_credit_amount, $j_debit_amount, $j_debit_account, $j_credit_account, $aid, $j_branch, $journal_type, $journal_description, $journal_date, $j_currency);
                $jn->execute();

                endforeach;
                }

                $upjn = $db->prepare("UPDATE assets SET status=? WHERE id=?");
                $upjn->bind_param('si', $global_status, $id);
                $upjn->execute();
                $upjn->close();

                echo "Fixed Asset Reversed Successfully.";
            } else {
                echo "Reversal Not Allowed";
            }
        }

    break;
}