<?php
include('../serv/accsecu/confs/config.php');
include('welcome_user.php');

$actionid_vg = 158;
$authorize_vg = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
$authorize_vg->bind_param("ii", $actionid_vg, $user_role);
$authorize_vg->execute();
$rauthorize_vg = $authorize_vg->get_result();
                
    if ($rauthorize_vg->num_rows == 0) {
        $_SESSION['msg1'] = "<h3 class='text-danger'>You are not authorized to view digital services.</h3>";
    header("location: $site_domain/main");
    } else {
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Digital Services Order</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
        <link rel="icon" type="image/x-icon" href="../favicon.ico">
		
		<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/datatables.min.css" />
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <style>
        .modal-body {
            max-height: calc(100vh - 210px);
            overflow-y: auto;
        }
        .modal-open {
            overflow: hidden;
            overflow-y: scroll;
            padding-right: 0 !important;
        }

        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de
        }

        .select2-hidden-accessible {
            border: 0 !important;
            clip: rect(0 0 0 0) !important;
            height: 1px !important;
            margin: -1px !important;
            overflow: hidden !important;
            padding: 0 !important;
            position: absolute !important;
            width: 1px !important
        }

        .form-control {
            display: block;
            width: 100%;
            height: 34px;
            padding: 6px 12px;
            font-size: 14px;
            line-height: 1.42857143;
            color: #555;
            background-color: #fff;
            background-image: none;
            border: 1px solid #ccc;
            border-radius: 4px;
            -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
            -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
            transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
        }

        .select2-container--default .select2-selection--single,
        .select2-selection .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 0;
            padding: 6px 12px;
            height: 34px
        }

        .select2-container--default .select2-selection--single {
            background-color: #fff;
            border: 1px solid #aaa;
            border-radius: 4px
        }

        .select2-container .select2-selection--single {
            box-sizing: border-box;
            cursor: pointer;
            display: block;
            height: 28px;
            user-select: none;
            -webkit-user-select: none
        }
        .select2-dropdown {
            z-index:99999;
        }

        .select2-container .select2-selection--single .select2-selection__rendered {
            padding-right: 10px
        }

        .select2-container .select2-selection--single .select2-selection__rendered {
            padding-left: 0;
            padding-right: 0;
            height: auto;
            margin-top: -3px
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: #444;
            line-height: 28px
        }

        .select2-container--default .select2-selection--single,
        .select2-selection .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 0 !important;
            padding: 6px 12px;
            height: 40px !important
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 26px;
            position: absolute;
            top: 6px !important;
            right: 1px;
            width: 20px
        }
        .select2-selection--multiple:before {
            content: "";
            position: absolute;
            right: 7px;
            top: 42%;
            border-top: 5px solid #888;
            border-left: 4px solid transparent;
            border-right: 4px solid transparent;
        }

        .tooltip-inner {
            max-width: 200px;
            padding: 3px 8px;
            color: #fff;
            text-align: center;
            background-color: #0000FF;
            border-radius: .25rem;
        }
        .tooltip.bs-tooltip-auto[x-placement^=top] .arrow::before, .tooltip.bs-tooltip-top .arrow::before {
            margin-left: -3px;
            content: "";
            border-width: 5px 5px 0;
            border-top-color: #0000FF;
        }
    </style>
	</head>
	<body>
		<div id="app">		
<?php include('include/sidebar.php');?>
			<div class="app-content">
				

					<?php include('include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
						<section id="page-title">
							<div class="row">
								<div class="col-sm-8">
									<h1 class="mainTitle"><?php echo $site_name; ?>  | Digital Services Order</h1>
								</div>
								<ol class="breadcrumb">
									<li>
										<span><?php echo $site_name; ?> </span>
									</li>
									<li class="active">
										<span>Digital Services Order</span>
									</li>
								</ol>
							</div>
						</section>
						<!-- end: PAGE TITLE -->
						<!-- start: BASIC EXAMPLE -->
						<div class="container-fluid container-fullw bg-white">
						

							<div class="row">
								<div class="col-md-12" id="digi_services">

								<p class="color-red2-light center-text"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></p>
                                   
                                
                                                <?php if ($allow_process == 1) { ?>
                                                <h4 class="text-center text-danger">Branch processing date is not set. Please set it to perform transactions</h4>
                                                <?php } else if ($debit_gl_main == "") { ?>
                                                <h4 class="text-center text-danger">Service Debit GL not set. Contact System Administrator</h4>
                                                <?php } else { ?>
                                                    <?php if ($user_role!==1) { ?>
                                                <div class="after_hide">
                                                    <form id="InstructionForm">
                                                    <fieldset>
                                                        <div class="form-group col-md-12">
                                                            <label for="order_type">Order Type</label>
                                                                <select class="form-control select2 order_type" id="order_type" name="order_type" style="width: 100%;" data-placeholder="Select">
                                                                <option></option>
                                                                <option value="Airtime">Airtime</option>
                                                                <option value="Databundle">Databundle</option>
                                                                <option value="Cable Subscription">Cable Subscription</option>
                                                                <option value="Internet Subscription">Internet Subscription</option>
                                                                <option value="Electricity Bill">Electricity Bill</option>
                                                            </select>
                                                        </div>
                                                        <div id="airtime_instruction" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                    <label for="airtime_provider">Network provider</label>
                                                                    <select class="form-control select2 airtime_provider" id="airtime_provider" name="airtime_provider" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="MTN">MTN</option>
                                                                    <option value="GLO">GLO</option>
                                                                    <option value="AIRTEL">AIRTEL</option>
                                                                    <option value="9MOBILE">9MOBILE</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="airtime_mobile">Mobile Number</label>
                                                                <input type="number" min="0" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control airtime_mobile" name="airtime_mobile" id="airtime_mobile" placeholder="08090010001">
                                                            </div>

                                                        </div>

                                                        <div id="databundle_instruction" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                    <label for="databundle_provider">Network</label>
                                                                    <select class="form-control select2 databundle_provider" id="databundle_provider" name="databundle_provider" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="MTN">MTN</option>
                                                                    <option value="GLO">GLO</option>
                                                                    <option value="AIRTEL">AIRTEL</option>
                                                                    <option value="9MOBILE">9MOBILE</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="data_plan">Plan</label>
                                                                    <select name="data_plan" class="data_plan form-control select2 select2-hidden-accessible" id="data_plan" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                    </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="databundle_mobile">Mobile Number</label>
                                                                <input type="number" min="0" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control databundle_mobile" name="databundle_mobile" id="databundle_mobile" placeholder="08090010001">
                                                            </div>

                                                            <div class="text-center col-md-4"><h5 class="text-success">Amount: <span class="dt_amount">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-info">Charge: <span class="dt_charge">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-success">Total Due: <span class="data_total">0.00</span> <?php echo $currency; ?></h5></div>

                                                            <input type="hidden" name="amount_data" class="amount_data">
                                                            <input type="hidden" name="code_data" class="code_data">
                                                            <input type="hidden" name="pname_data" class="pname_data">

                                                        </div>

                                                        <div id="cable_instruction" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                    <label for="cable_provider">Provider</label>
                                                                    <select class="form-control select2 cable_provider" id="cable_provider" name="cable_provider" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="DSTV">DSTV</option>
                                                                    <option value="GOTV">GOTV</option>
                                                                    <option value="STARTIMES">STARTIMES</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="cable_plan">Plan</label>
                                                                    <select name="cable_plan" class="cable_plan form-control select2 select2-hidden-accessible" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                        
                                                                    </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="decoder_number">Smartcard Number</label>
                                                                <input type="number" min="0" data-maxlength="20" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control decoder_number" name="decoder_number" placeholder="Enter Smartcard No">
                                                                <span class="text-center bill_name_cable"></span>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="cable_mobile">Mobile Number</label>
                                                                <input type="number" min="0" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control cable_mobile" name="cable_mobile" id="cable_mobile" placeholder="08090010001">
                                                            </div>

                                                            <div class="text-center col-md-4"><h5 class="text-success">Amount: <span class="cbl_amount">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-info">Charge: <span class="cbl_charge">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-success">Total Due: <span class="cable_total">0.00</span> <?php echo $currency; ?></h5></div>
                                                            
                                                            <input type="hidden" name="amount_cable" class="amount_cable">
                                                            <input type="hidden" name="code_cable" class="code_cable">
                                                            <input type="hidden" name="pname_cable" class="pname_cable">
                                                            <input type="hidden" name="customer_name" class="customer_name_cb">

                                                        </div>

                                                        <div id="internet_instruction" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                    <label for="internet_provider">Provider</label>
                                                                    <select class="form-control select2 internet_provider" id="internet_provider" name="internet_provider" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="SMILE">SMILE</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="internet_plan">Plan</label>
                                                                    <select name="internet_plan" class="internet_plan form-control select2 select2-hidden-accessible" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
                                                                        
                                                                    </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="device_number">Device Number</label>
                                                                <input type="number" min="0" data-maxlength="20" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control device_number" name="device_number" placeholder="Enter Device No">
                                                                <span class="text-center bill_name_internet"></span>
                                                            </div>

                                                            <div class="text-center col-md-4"><h5 class="text-success">Amount: <span class="int_amount">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-info">Charge: <span class="int_charge">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-4"><h5 class="text-success">Total Due: <span class="internet_total">0.00</span> <?php echo $currency; ?></h5></div>

                                                            <input type="hidden" name="amount_internet" class="amount_internet">
                                                            <input type="hidden" name="code_internet" class="code_internet">
                                                            <input type="hidden" name="pname_internet" class="pname_internet">
                                                            <input type="hidden" name="customer_name" class="customer_name_it">

                                                        </div>

                                                        <div id="electricity_instruction" style="display:none">

                                                            <div class="form-group col-md-12">
                                                                    <label for="electricity_provider">Provider</label>
                                                                    <select class="form-control select2 electricity_provider" id="electricity_provider" name="electricity_provider" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="ABUJA">ABUJA ELECTRICITY</option>
                                                                    <option value="EKO">EKO ELECTRICITY</option>
                                                                    <option value="ENUGU">ENUGU ELECTRICITY</option>
                                                                    <option value="JOS">JOS ELECTRICITY</option>
                                                                    <option value="IBADAN">IBADAN ELECTRICITY</option>
                                                                    <option value="IKEJA">IKEJA ELECTRICITY</option>
                                                                    <option value="KADUNA">KADUNA ELECTRICITY</option>
                                                                    <option value="KANO">KANO ELECTRICITY</option>
                                                                    <option value="PORTHACOURT">PORTHACOURT ELECTRICITY</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="meter_type">Meter Type</label>
                                                                <select class="form-control select2 meter_type" id="meter_type" name="meter_type" style="width: 100%;" data-placeholder="Select">
                                                                    <option></option>
                                                                    <option value="PREPAID">PREPAID</option>
                                                                    <option value="POSTPAID">POSTPAID</option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="meter_number">Meter No</label>
                                                                <input type="number" min="0" data-maxlength="20" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control meter_number" name="meter_number" id="meter_number" placeholder="Enter Meter No">
                                                                <span class="text-center bill_name_electric"></span>
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="electricity_mobile">Mobile Number</label>
                                                                <input type="number" min="0" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" formnovalidate="formnovalidate" class="form-control electricity_mobile" name="electricity_mobile" id="electricity_mobile" placeholder="08090010001">
                                                            </div>

                                                            <div class="text-center col-md-6"><h5 class="text-info">Charge: <span class="elt_charge">0.00</span> <?php echo $currency; ?></h5></div>
                                                            <div class="text-center col-md-6"><h5 class="text-success">Total Due: <span class="electric_total">0.00</span> <?php echo $currency; ?></h5></div>

                                                            <input type="hidden" name="customer_name" class="customer_name_el">
                                                            <input type="hidden" name="account_id" value="<?php echo $account_id; ?>">
                                                        </div>
                                                            <div class="form-group col-md-12 hide_amount">
                                                                <label for="instruction_amount">Amount</label>
                                                                <input type="number" min="0" step="any" data-maxlength="3000" formnovalidate="formnovalidate" class="form-control instruction_amount clr" name="instruction_amount" id="instruction_amount" placeholder="Enter Amount" value="0.00" oninput="validity.valid||(value='');">
                                                                <span class="op_amount_t_ins text-danger"></span>
                                                            </div>
                                                        </fieldset>
                                                        <fieldset>
                                                            <input type="submit" class="btn btn-primary center add_ins_submit btn-lg btn-block" id="add_ins_submit" value="Buy Now">
                                                        </fieldset>
                                                        </form>
                                                    </div>
                                                    <div class="response_transaction text-center col-md-12"></div>

                                                    <?php } else { ?>

                                                    <p>Please login with an account with lesser role than super administrator</p>

                                                    <?php } ?>
                                                <?php } ?>

								</div>
							</div>
							
					</div>

                    

								

								
						
						<!-- end: BASIC EXAMPLE -->
						<!-- end: SELECT BOXES -->
						
					</div>
				</div>
			</div>
			<!-- start: FOOTER -->
	<?php include('include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->


		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="vendor/autosize/autosize.min.js"></script>
		<script src="vendor/selectFx/classie.js"></script>
		<script src="vendor/selectFx/selectFx.js"></script>
		<script src="vendor/select2/select2.min.js"></script>
		<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
                FormElements.init();
			});
            //
		</script>

  <!-- Bootstrap core JavaScript -->
<script type="text/javascript" language="javascript">
    $(document).ready(function() {

            $('.select2').select2({
			closeOnSelect: true
			});

            $(".clr").focus(function() {
            this.value = "";
            });


    //
    $("#digi_services").on('submit','#InstructionForm', function(event){
		event.preventDefault();
		$('#add_ins_submit').attr('disabled','disabled');
		var formData = $(this).serialize();
		$.ajax({
			url:"digital_services_process.php",
			method:"POST",
			data:formData,
			success:function(data){		
				$('.after_hide').html("");		
				$('.response_transaction').html(data);
					setTimeout(function(){
					    window.location.reload(true);
					}, 4000);
			}
		})
	});

    $('.add_ins_submit').attr('disabled', 'disabled');
    $(".hide_amount").hide();
    $("select.order_type").change(function(){
     $("#show_account_name_ins").html("");
     $("#show_account_name_insl").html("");

     
         var sin = $(".order_type option:selected").val();
         if (sin == "Airtime") {
             $("#electricity_instruction").hide();
             $("#cable_instruction").hide();
             $("#databundle_instruction").hide();
             $("#airtime_instruction").show();
             $(".hide_amount").show();
             $("#internet_instruction").hide();
             $('.add_ins_submit').attr('disabled', false);
         }
         else if (sin == "Cable Subscription") {
             $("#electricity_instruction").hide();
             $("#cable_instruction").show();
             $("#databundle_instruction").hide();
             $("#airtime_instruction").hide();
             $(".hide_amount").hide();
             $("#internet_instruction").hide();
             $('.add_ins_submit').attr('disabled', 'disabled');
         }
         else if (sin == "Electricity Bill") {
             $("#electricity_instruction").show();
             $("#cable_instruction").hide();
             $("#databundle_instruction").hide();
             $("#airtime_instruction").hide();
             $(".hide_amount").show();
             $("#internet_instruction").hide();
             $('.add_ins_submit').attr('disabled', 'disabled');
         }
         else if (sin == "Databundle") {
             $("#electricity_instruction").hide();
             $("#cable_instruction").hide();
             $("#databundle_instruction").show();
             $("#airtime_instruction").hide();
             $(".hide_amount").hide();
             $("#internet_instruction").hide();
             $('.add_ins_submit').attr('disabled', false);
         }else if (sin == "Internet Subscription") {
             $("#electricity_instruction").hide();
             $("#cable_instruction").hide();
             $("#databundle_instruction").hide();
             $("#internet_instruction").show();
             $("#airtime_instruction").hide();
             $(".hide_amount").hide();
             $('.add_ins_submit').attr('disabled', 'disabled');
         }
         else {
             $("#electricity_instruction").hide();
             $("#cable_instruction").hide();
             $("#databundle_instruction").hide();
             $("#airtime_instruction").hide();
             $(".hide_amount").hide();
             $("#internet_instruction").hide();
             $('.add_ins_submit').attr('disabled', 'disabled');
         }
     });
    $(".network_data, .databundle_provider").change(function(){
		$(".plan_data, .data_plan").val("").trigger('change.select2');
		$(".amount_data").val("");
        $(".pname_data").val("");
        $("#dt_amount, .dt_amount").html(0.00);
        $("#data_total, .data_total").html(0.00);

		var ndta = $(this).val();
		var ndta = ndta.replace(/\s+/g,'_');
        var act = "Data";
		$(".plan_data, .data_plan").load("customer/get_plans.php?parent=" + ndta+"&act=" + act);
    });

    $(".plan_data, .data_plan").change(function(){
		var pdta = $(this).val();
		var getcode_d = pdta.substring(0, pdta.indexOf('='));
        var getamount_d = Number(pdta.substring(pdta.indexOf('=') + 1));
		$(".code_data").val(getcode_d);
        $(".amount_data").val(getamount_d);
        var pkname_d = $(this).text();
        //pkname_d = pkname_d.substring(0, pkname_d.indexOf('-'));
        $(".pname_data").val(pkname_d);
        $("#dt_amount, .dt_amount").html(getamount_d);
        $("#dt_charge, .dt_charge").html(0.00);
        $("#data_total, .data_total").html(getamount_d);
    });
    $(".network_cable, .cable_provider").change(function(){
		$(".plan_cable, .cable_plan").val("").trigger('change.select2');
		$(".amount_cable").val("");
        $(".pname_cable").val("");
        $("#cbl_amount, .cbl_amount").html(0.00);
        $("#cbl_charge, .cbl_charge").html(0.00);
        $("#cable_total, .cable_total").html(0.00);
		var ndta = $(this).val();
		var ndta = ndta.replace(/\s+/g,'_');
        var act = "Cable";
		$(".plan_cable, .cable_plan").load("customer/get_plans.php?parent=" + ndta+"&act=" + act);
    });

    $(".plan_cable, .cable_plan").change(function(){
		var pdta = $(this).val();
		var getcode_c = pdta.substring(0, pdta.indexOf('='));
        var getamount_c = Number(pdta.substring(pdta.indexOf('=') + 1));
		$(".code_cable").val(getcode_c);
        $(".amount_cable").val(getamount_c);
        var pkname_c = $(this).text();
        //pkname_d = pkname_d.substring(0, pkname_d.indexOf('-'));
        $(".pname_cable").val(pkname_c);
        $("#cbl_amount, .cbl_amount").html(getamount_c);
        $("#cbl_charge, .cbl_charge").html(100);
        var ttl = getamount_c+100;
        $("#cable_total, .cable_total").html(ttl);
    });

    $(".smart_card_noc, .decoder_number").blur(function(){
		var scn = $(this).val();
        var ntw_t = $(".network_cable").val();
        var ntw_t1 = $(".cable_provider").val();
        if(ntw_t == "") {
            var ntw = ntw_t1;
        } else {
            var ntw = ntw_t;
        }

        var typ = "Cable";

        if(scn.length>1 && ntw !="") {
            $(".bill_name_cable").html("<span class='text-success text-center bold'>Validating. Please wait...</span>");
            jQuery.ajax({
            url: "customer/validate_bills",
            data:{"network": ntw, "smart_no": scn, "type": typ},
            type: "POST",
            success:function(data){
            if(data == "Unable to validate") {
                    $('.cable_submit, .add_ins_submit').attr('disabled','disabled');
                    $(".bill_name_cable").html("<span class='text-danger text-center bold'>"+data+"</span>");
                } else {
                    $(".bill_name_cable").html("<span class='text-success text-center bold'>"+data+"</span>");
                    $(".customer_name_cb").val(data);
                    $('.cable_submit, .add_ins_submit').attr('disabled',false);
                }
            },
            error:function (){}
            });
        }
    });

    $(".network_internet, .internet_provider").change(function(){
		$(".plan_internet, .internet_plan").val("").trigger('change.select2');
		$(".amount_internet").val("");
        $(".pname_internet").val("");
        $(".code_internet").val("");
        $("#int_amount, .int_amount").html(0.00);
        $("#int_charge, .int_charge").html(0.00);
        $("#internet_total, .internet_total").html(0.00);

		var ndta = $(this).val();
		var ndta = ndta.replace(/\s+/g,'_');
        var act = "Internet";
		$(".plan_internet, .internet_plan").load("customer/get_plans.php?parent=" + ndta+"&act=" + act);
    });

    $(".plan_internet, .internet_plan").change(function(){
		var pdta = $(this).val();
		var getcode_it = pdta.substring(0, pdta.indexOf('='));
        var getamount_it = Number(pdta.substring(pdta.indexOf('=') + 1));
		$(".code_internet").val(getcode_it);
        $(".amount_internet").val(getamount_it);
        var pkname_it = $(this).text();
        //pkname_d = pkname_d.substring(0, pkname_d.indexOf('-'));
        $(".pname_internet").val(pkname_it);
        $("#int_amount, .int_amount").html(getamount_it);
        $("#int_charge, .int_charge").html(100);
        var ttl = getamount_it+100;
        $("#internet_total, .internet_total").html(ttl);
    });
    
    $(".device_no_i, .device_number").blur(function(){
		var scn = $(this).val();
        var ntw_t = $(".network_internet").val();
        var ntw_t1 = $(".internet_provider").val();
        if(ntw_t == "") {
            var ntw = ntw_t1;
        } else {
            var ntw = ntw_t;
        }

        var typ = "Internet";

        if(scn.length>1 && ntw !="") {
            $("#bill_name_internet").html("<span class='text-success text-center bold'>Validating. Please wait...</span>");
            jQuery.ajax({
            url: "customer/validate_bills",
            data:{"network": ntw, "device_no": scn, "type": typ},
            type: "POST",
            success:function(data){
            if(data == "Unable to validate") {
                    $('.internet_submit, .add_ins_submit').attr('disabled','disabled');
                    $(".bill_name_internet").html("<span class='text-danger text-center bold'>"+data+"</span>");
                } else {
                    $(".bill_name_internet").html("<span class='text-success text-center bold'>"+data+"</span>");
                    $(".customer_name_it").val(data);
                    $('.internet_submit, .add_ins_submit').attr('disabled',false);
                }
            },
            error:function (){}
            });
        }
    });

    $(".electric_amount, .instruction_amount").blur(function(){
		var amt = Number($(this).val());
        if ($(".instruction_amount").val() != "" && $(".electricity_provider").val() != "") {
            $(".elt_charge").html(100);
            var ttl = amt+100;
            $(".electric_total").html(ttl);
        } else if($(".electric_amount").val() != "") {
            $("#elt_amount").html(amt);
            $("#elt_charge").html(100);
            var ttl = amt+100;
            $("#electric_total").html(ttl);
        }
    });
    
    $(".meter_no_i, .meter_number").blur(function(){
		var scn = $(this).val();
        var ntw_t = $(".network_electric").val();
        var ntw_t1 = $(".electricity_provider").val();
        var mt_t = $(".meter_type_i").val();
        var mt_t1 = $(".meter_type").val();

        if(ntw_t == "") {
            var ntw = ntw_t1;
            var mtt = mt_t1;
        } else {
            var ntw = ntw_t;
            var mtt = mt_t;
        }


        var typ = "Electric";

        if(scn.length>1 && ntw !="" && mtt !="") {
            $(".bill_name_electric").html("<span class='text-success text-center bold'>Validating. Please wait...</span>");
            jQuery.ajax({
            url: "customer/validate_bills",
            data:{"network": ntw, "meter_no": scn, "meter_type": mtt, "type": typ},
            type: "POST",
            success:function(data){
            if(data == "Unable to validate") {
                    $('.electric_submit, .add_ins_submit').attr('disabled','disabled');
                    $(".bill_name_electric").html("<span class='text-danger text-center bold'>"+data+"</span>");
                } else {
                    $(".bill_name_electric").html("<span class='text-success text-center bold'>"+data+"</span>");
                    $(".customer_name_el").val(data);
                    $('.electric_submit, .add_ins_submit').attr('disabled',false);
                }
            },
            error:function (){}
            });
        }
    });

    });

</script>
	</body>
</html>

<?php } ?>