<?php
include('../../serv/accsecu/confs/config.php');
include('../welcome_user.php');
$verify_id = $_GET["verify_id"];
$ggh3 = $db -> prepare("SELECT * FROM verify_transactions WHERE id=?");
$ggh3 -> bind_param('i', $verify_id);
$ggh3 -> execute();
$rggh3 = $ggh3->get_result();

if($rggh3->num_rows == 0) {
    $_SESSION['msg1'] = "This transaction does not exist";
    header("location: $site_domain/main/work_queue");
} else {

    while($row = mysqli_fetch_assoc($rggh3) ){
        $account_id1 = $row['account_id'];//be careful how you use. It clashes with verify_id
        $account_number = $row['account_number'];
        $customer_id = $row['customer_id'];
        $amount = $row['amount'];
        $comment = $row['comment'];
        $type = $row['type'];
        $status = $row['status'];
        $created_by = $row['created_by'];
        $creation_date = $row['creation_date'];
        $last_update = $row['last_update'];

        $to_account = $row['to_account'];
        $beneficiary_acc_bank = $row['beneficiary_acc_bank'];
        $transfer_type = $row['transfer_type'];

        $update_delinquent_amount = $row['update_delinquent_amount'];
        $recovery_type = $row['recovery_type'];
        $recovered_by = $row['recovered_by'];
        $proof = $row['proof'];

    }

    if($type == "Recovery") {

       if($recovery_type == "Internal") {

            $rcb = $db -> prepare('SELECT username FROM users WHERE id=?');
            $rcb -> bind_param('i', $recovered_by);
            $rcb -> execute();
            $rrcb = $rcb->get_result();

            while($ln = mysqli_fetch_assoc($rrcb) ){
                $recovered_by = $ln['username'];
            }

       } else {
            $rcb = $db -> prepare('SELECT name FROM recovery_organizations WHERE id=?');
            $rcb -> bind_param('i', $recovered_by);
            $rcb -> execute();
            $rrcb = $rcb->get_result();

            while($ln = mysqli_fetch_assoc($rrcb) ){
                $recovered_by = $ln['name'];
            }

       }

    } else {
        $recovered_by = "-";
    }

    if($proof != "") {
        $proof = ' <a href="'.$site_domain.'/main/customer/'.$proof.'" target="_blank"><i class="fa fa-file-image-o"></i></a>';
    }
    //get initiator name

    $nmm = $db -> prepare('SELECT username, fname, lname, branch FROM users WHERE id=?');
    $nmm->bind_param("i", $created_by);
    $nmm->execute();
    $rnmm = $nmm->get_result();
    while($nk = mysqli_fetch_assoc($rnmm) ){

            $bbrn = $db -> prepare("SELECT name FROM branch WHERE id=?");
            $bbrn->bind_param("i", $nk['branch']);
            $bbrn->execute();
            $rbbrn = $bbrn->get_result();
            while($bnf = mysqli_fetch_array($rbbrn) ){
                $cbranch = $bnf['name'];
            }

        $initiator = $nk['fname'] . " " . $nk['lname'] . " (" . $nk['username']. " - ". $cbranch. " Branch)";
    }

    //GET CUSTOMER DETAILS

    //GET ACCOUNT DETAILS
    $pod1 = $db -> prepare('SELECT fname, mname, lname, phone_no, ctype FROM customer WHERE customer_id=?');
    $pod1 -> bind_param('i', $customer_id);
    $pod1 -> execute();
    $rpod1 = $pod1->get_result();

    while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        $customer_full_name = $row1["fname"]. " ". $row1["mname"]. " ". $row1["lname"];
        $ctype = $row1["ctype"];
        $phone_no = $row1["phone_no"];
        //$customer_rm = $row1["secondary_relationship_manager"];
        $cu_character = strtoupper($customer_name[0]);
    }

    $pod2 = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
    $pod2 -> bind_param('is', $customer_id, $account_number);
    $pod2 -> execute();
    $rpod2 = $pod2->get_result();

    while($row2 = mysqli_fetch_assoc($rpod2) ){
        $product_type = $row2['product_type'];
        $product = $row2['product'];
        $cleared_balance = $row2['cleared_balance'];
        $customer_branch = $row2["branch"];
        $branch = $row2["secondary_branch"];
        $customer_rm = $row2['secondary_relationship_manager'];
        $cu_creation_date = date('d-m-Y', strtotime($row2['creation_date']));
        //$cu_application_date = date('d-m-Y', strtotime($row['application_date']));
        $account_status = $row2['status'];
    }
    $account_id = $verify_id;
    $channel = 6;
    include('account_authorization.php');
    $crdt = crdt($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trcrd_vl = $crdt->a_trcrd_vl;
    $a_trcrd_rc = $crdt->a_trcrd_rc;
    $a_trcrd_ap = $crdt->a_trcrd_ap;


    $crdbt = debt($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trdbt_vl = $crdbt->a_trdbt_vl;
    $a_trdbt_rc = $crdbt->a_trdbt_rc;
    $a_trdbt_ap = $crdbt->a_trdbt_ap;

    $trnss = trns($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trint_vl = $trnss->a_trint_vl;
    $a_trint_rc = $trnss->a_trint_rc;
    $a_trint_ap = $trnss->a_trint_ap;

    $extrnss = extrns($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trext_vl = $extrnss->a_trext_vl;
    $a_trext_rc = $extrnss->a_trext_rc;
    $a_trext_ap = $extrnss->a_trext_ap;

    $repln = repayln($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trlrp_vl = $repln->a_trlrp_vl;
    $a_trlrp_rc = $repln->a_trlrp_rc;
    $a_trlrp_ap = $repln->a_trlrp_ap;

    $recln = recovln($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trlrc_vl = $recln->a_trlrc_vl;
    $a_trlrc_rc = $recln->a_trlrc_rc;
    $a_trlrc_ap = $recln->a_trlrc_ap;

    $lbwr = lbwrt($db, $user_role, $branch, $channel, $ctype, $aid, $account_id, $usbrn, $amount, $type);
    $a_trlwrt_vl = $lbwr->a_trlwrt_vl;
    $a_trlwrt_rc = $lbwr->a_trlwrt_rc;
    $a_trlwrt_ap = $lbwr->a_trlwrt_ap;

    require_once("tran_hard_tok_check.php");

    //INCLUDE THRESHOLD BALANCE CHECK
    if ($egis_transfers == 2) {
        $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
    
        $ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login");
        curl_setopt($ch1, CURLOPT_POST, 1);
        curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
    
        $headers1 = [
        'Content-Type: application/json'
        ];
    
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
    
        $request1 = curl_exec ($ch1);
    
        curl_close ($ch1);
        if ($request1) {
        $result1 = json_decode($request1, true);
        }
            
        $token = $result1['token'];
    
        $postdata1 =  array('organization_code' => $org_code, 'branch' => $branch);
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,"$egis_api_root/branch_balance");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata1));  //Post Fields
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //Set your auth headers
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token
        ));
    
        // get stringified data/output. See CURLOPT_RETURNTRANSFER
        $data = curl_exec($ch);
    
        //echo $data;
    
        //$decode = json_decode($data);
        $decode = json_decode($data, true);
    
        $balance = $decode['balance'];
        $globalbalance = $decode['gbalance'];
    } else {
        $balance = 0;
        $globalbalance = 0;
    }

    if($phone_no !="") {
        $phone_no = " ($phone_no)";
    }
?>

<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Verify Transaction</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="../vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="../vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../vendor/themify-icons/themify-icons.min.css">
		<link href="../vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="../vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="../assets/css/styles.css">
		<link rel="stylesheet" href="../assets/css/plugins.css">
		<link rel="stylesheet" href="../assets/css/themes/theme-1.css" id="skin_color" />
        <link rel="icon" type="image/x-icon" href="../../favicon.ico">		
		<link rel="stylesheet" type="text/css" href="../vendor/bootstrap/css/datatables.min.css" />

<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap-theme.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>


<style>
.cnt td {
  text-align: center;
}
.checkbox input[type=checkbox],
.checkbox-inline input[type=checkbox],
.radio input[type=radio],
.radio-inline input[type=radio] {
  margin: 0;
}

.checkbox,
.radio {
  position: relative;
  display: block;
  margin-top: 10px;
  margin-bottom: 10px;
  display: table;
  width: 100%;
}

.checkbox input,
.radio input {
  vertical-align: middle;
  height: 100%;
}

	.modal-body {
    max-height: calc(100vh - 210px);
    overflow-y: auto;
}
.modal-open {
    overflow: hidden;
    overflow-y: scroll;
    padding-right: 0 !important;
}

.white {
    background: #ffffff;
}

.modal-content {
  border-radius: 0 !important;
  width: 95%;
}
.form-control {
    border-radius: 0;
    box-shadow: none;
    border-color: #d2d6de
}

.select2-hidden-accessible {
    border: 0 !important;
    clip: rect(0 0 0 0) !important;
    height: 1px !important;
    margin: -1px !important;
    overflow: hidden !important;
    padding: 0 !important;
    position: absolute !important;
    width: 1px !important
}

.form-control {
    display: block;
    width: 100%;
    height: 34px;
    padding: 6px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0;
    padding: 6px 12px;
    height: 34px
}

.select2-container--default .select2-selection--single {
    background-color: #fff;
    border: 1px solid #aaa;
    border-radius: 4px
}

.select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 28px;
    user-select: none;
    -webkit-user-select: none
}
.select2-dropdown {
    z-index:99999;
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-right: 10px
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-left: 0;
    padding-right: 0;
    height: auto;
    margin-top: -3px
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 28px
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0 !important;
    padding: 6px 12px;
    height: 40px !important
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 6px !important;
    right: 1px;
    width: 20px
}
.select2-selection__clear{
   position: absolute;
   top: 6px !important;
   right: 15px;
   height: 26px;
   width: 20px;
   padding: 0 15px;
}
</style>
	</head>
	<body>
		<div id="app">		
<?php include('../include/sidebar.php');?>
			<div class="app-content">
					<?php include('../include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- end: PAGE TITLE -->
						<!-- start: BASIC EXAMPLE -->
						<div class="container-fluid container-fullw bg-white">
                                <div class="form-inline">
                                <button class="btn btn-warning gotoworkqueue">Back to My Work Queue</button>
                                <button class="btn btn-info gotocustomerpage">Goto Customer Page</button>
                                </div>
                                <br><br>
                                <h2>Authorization for <?php echo $product_type; ?> Account Number: <?php echo $account_number; ?></h2>

								<p class="color-red2-light center-text"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></p>

							
	                                <table id="empTable" class="table empTable table-striped table-bordered dt-responsive nowrap no-footer" cellspacing="0" style="width:100%">
												<thead>
													<tr>
														<th>Amount</th>
                                                        <th>Comment</th>
                                                        <th>Account Balance</th>
                                                        <?php if ($type != "Internal Transfer" && $type != "External Transfer") { ?>
														<th>Type</th>
                                                        <?php } ?>
														<th>Account Holder</th>
                                                        <?php if ($type == "Internal Transfer") { ?>
                                                        <th>Transfer Type</th>
                                                        <th>Receiving Account</th>
                                                        <?php } ?>
                                                        <?php if ($type == "External Transfer") { ?>
                                                            <th>Transfer Type</th>
                                                            <th>Receiving Bank</th>
                                                            <th>Receiving Account</th>
                                                        <?php } ?>
                                                        <?php if ($type == "Recovery") { ?>
                                                            <th>Recovered By</th>
                                                        <?php } ?>
                                                        <th>Initiator</th>
                                                        <th>Date Intiated</th>
														<th>Last Updated</th>
                                                        <th>Status</th>
													</tr>
												</thead>
												<tbody>
                                                <tr>
                                                    <td><?php echo number_format($amount, 2, '.', ','); ?><?php echo $proof; ?></td>
                                                    <td><?php echo $comment; ?></td>
                                                    <td><?php echo number_format($cleared_balance, 2, '.', ',');; ?></td>
                                                    <?php if ($type != "Internal Transfer" && $type != "External Transfer") { ?>
                                                    <td><?php echo $type; ?></td>
                                                    <?php } ?>
                                                    <td><?php echo $customer_full_name; ?><?php echo $phone_no; ?></td>
                                                    <?php if ($type == "Internal Transfer") { ?>
                                                        <td><?php echo $transfer_type; ?></td>
                                                        <td><?php echo $to_account; ?></td>
                                                        <?php } ?>
                                                        <?php if ($type == "External Transfer") { ?>
                                                            <td><?php echo $transfer_type; ?></td>
                                                            <td><?php echo $beneficiary_acc_bank; ?></td>
                                                            <th><td><?php echo $to_account; ?></td></th>
                                                        <?php } ?>
                                                        <?php if ($type == "Recovery") { ?>
                                                            <td><?php echo $recovered_by; ?></td>
                                                        <?php } ?>
                                                    <td><?php echo $initiator; ?></td>
                                                    <td><?php echo $creation_date; ?></td>
                                                    <td><?php echo $last_update; ?></td>
                                                    <td><?php echo $status; ?></td>

                                                </tr>
													
												</tbody>
											</table>

                                            <!--Buttons Here-->
                                            <div class="form-inline pull-right">
                                                <?php if ($a_trcrd_vl == 1) { ?>
                                                <button type="button" id="validate_deposit" class = "btn btn-info">Validate Deposit</button>
                                                <?php } ?>
                                                <?php if ($a_trdbt_vl == 1) { ?>
                                                <button type="button" id="validate_withdraw" class = "btn btn-info">Validate Withdrawal</button>
                                                <?php } ?>
                                                <?php if ($a_trlrp_vl == 1) { ?>
                                                <button type="button" id="validate_repayment" class = "btn btn-info">Validate Repayment</button>
                                                <?php } ?>
                                                <?php if ($a_trlrc_vl == 1) { ?>
                                                <button type="button" id="validate_repayment" class = "btn btn-info">Validate Recovery</button>
                                                <?php } ?>
                                                <?php if ($a_trint_vl == 1) { ?>
                                                <button type="button" id="validate_transfer_internal" class = "btn btn-info">Validate Transfer</button>
                                                <?php } ?>
                                                <?php if ($a_trext_vl == 1) { ?>
                                                <button type="button" id="validate_transfer_external" class = "btn btn-info">Validate Transfer</button>
                                                <?php } ?>
                                                <?php if ($a_trcrd_rc == 1) { ?>

                                                <button type="button" id="recommend_deposit" class = "btn btn-warning">Recommend Deposit</button>
                                                <?php } ?>
                                                <?php if ($a_trdbt_rc == 1) { ?>
                                                <button type="button" id="recommend_withdraw" class = "btn btn-warning">Recommend Withdrawal</button>
                                                <?php } ?>
                                                <?php if ($a_trlrp_rc == 1) { ?>
                                                <button type="button" id="recommend_repayment" class = "btn btn-warning">Recommend Repayment</button>
                                                <?php } ?>
                                                <?php if ($a_trlrc_rc == 1) { ?>
                                                <button type="button" id="recommend_repayment" class = "btn btn-warning">Recommend Recovery</button>
                                                <?php } ?>
                                                <?php if ($a_trint_rc == 1) { ?>
                                                <button type="button" id="recommend_transfer_internal" class = "btn btn-warning">Recommend Transfer</button>
                                                <?php } ?>
                                                <?php if ($a_trext_rc == 1) { ?>
                                                <button type="button" id="recommend_transfer_external" class = "btn btn-info">Recommend Transfer</button>
                                                <?php } ?>
                                                <?php if ($a_trcrd_ap == 1) { ?>

                                                <button type="button" id="approve_deposit" class = "btn btn-success">Approve Deposit</button>
                                                <?php } ?>
                                                <?php if ($a_trdbt_ap == 1) { ?>
                                                <button type="button" id="approve_withdraw" class = "btn btn-success">Approve Withdrawal</button>
                                                <?php } ?>
                                                <?php if ($a_trlrp_ap == 1) { ?>
                                                <button type="button" id="approve_repayment" class = "btn btn-success">Approve Repayment</button>
                                                <?php } ?>
                                                <?php if ($a_trlrc_ap == 1) { ?>
                                                <button type="button" id="approve_repayment" class = "btn btn-success">Approve Recovery</button>
                                                <?php } ?>
                                                <?php if ($a_trint_ap == 1) { ?>
                                                <button type="button" id="approve_transfer_internal" class = "btn btn-success">Approve Transfer</button>
                                                <?php } ?>
                                                <?php if ($a_trext_ap == 1) { ?>
                                                <button type="button" id="approve_transfer_external" class = "btn btn-success">Approve Transfer</button>
                                                <?php } ?>
                                            </div>
                                            <br><br>
                                            <h3>Comments</h3>
                                            <?php
                                            $comment_type = "Transaction";
                                            $acm = $db -> prepare('SELECT * FROM account_comments WHERE area_id=? AND type=?');
                                            $acm->bind_param("is", $verify_id, $comment_type);
                                            $acm->execute();
                                            $racm = $acm->get_result();
                                            ?>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <th>Comment</th>
                                                    <th>Added By</th>
                                                </thead>
                                                <tbody>
                                                <?php
                                                if(!empty($racm)) {
                                                            
                                                    foreach ($racm as $rmc):

                                                        $nmm = $db -> prepare('SELECT username, fname, lname FROM users WHERE id=?');
                                                        $nmm->bind_param("i", $rmc['added_by']);
                                                        $nmm->execute();
                                                        $rnmm = $nmm->get_result();
                                                        while($nk = mysqli_fetch_assoc($rnmm) ){
                                                            $commenter = $nk['fname'] . " " . $nk['lname'] . " (" . $nk['lname']. ")";
                                                        }


                                                        ?>

                                                        <?php echo "<tr><td>". $rmc['comment']."</td><td>$commenter</td></tr>";

                                                    endforeach;
                                                }
                                                ?>
                                                </tbody>
                                            </table>
                                     </div>
    

                                 <div id="rModal_open" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
												<div class="modal-body white center">
                                                    <div class="close_response col-md-12"></div>
												</div>
												<div class="modal-footer">
													<button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_v_depo" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Validate Deposit</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_dpo_v" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_dpo_v" rows="5" id="add_coment_dpo_v"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center validate_dpo_p" id="validate_dpo_p">Proceed</button>
													<button type="button" class="btn btn-danger center validate_dpo_i" id="validate_dpo_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
                                        </div>
								</div>

                                <div id="rModal_r_depo" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Recommend Deposit</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_dpo_r" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_dpo_r" rows="5" id="add_coment_dpo_r"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center recommend_dpo_p" id="recommend_dpo_p">Recommend</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_a_depo" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Approve Deposit</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_dpo_a" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_dpo_a" rows="5" id="add_coment_dpo_a"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center approve_dpo_p" id="approve_dpo_p">Approve</button>
													<button type="button" class="btn btn-danger center approve_dpo_i" id="approve_dpo_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_v_widt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Validate Withdraw</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_wdt_v" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_wdt_v" rows="5" id="add_coment_wdt_v"></textarea>							
                                                    </div>
                                                    <?php if($withdraw_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="wit_tok_val" type="password" class="form-control wit_tok_val" name="wit_tok_val" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center validate_wdt_p" id="validate_wdt_p">Proceed</button>
													<button type="button" class="btn btn-danger center validate_wdt_i" id="validate_wdt_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_r_widt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Recommend Withdraw</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_wdt_r" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_wdt_r" rows="5" id="add_coment_wdt_r"></textarea>							
                                                    </div>
                                                    <?php if($withdraw_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="wit_tok_rec" type="password" class="form-control wit_tok_rec" name="wit_tok_rec" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center recommend_wdt_p" id="recommend_wdt_p">Recommend</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_a_widt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Approve Withdraw</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_wdt_a" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_wdt_a" rows="5" id="add_coment_wdt_a"></textarea>							
                                                    </div>
                                                    <?php if($withdraw_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="wit_tok_app" type="password" class="form-control wit_tok_app" name="wit_tok_app" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center approve_wdt_p" id="approve_wdt_p">Approve</button>
													<button type="button" class="btn btn-danger center approve_wdt_i" id="approve_wdt_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_v_rpyt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Validate <?php echo $type; ?></h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_rpt_v" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_rpt_v" rows="5" id="add_coment_rpt_v"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center validate_rpt_p" id="validate_rpt_p">Proceed</button>
													<button type="button" class="btn btn-danger center validate_rpt_i" id="validate_rpt_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_r_rpyt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Recommend <?php echo $type; ?></h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_rpt_r" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_rpt_r" rows="5" id="add_coment_rpt_r"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center recommend_rpt_p" id="recommend_rpt_p">Recommend</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_a_rpyt" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Approve <?php echo $type; ?></h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_rpt_a" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_rpt_a" rows="5" id="add_coment_rpt_a"></textarea>							
                                                    </div>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center approve_rpt_p" id="approve_rpt_p">Approve</button>
													<button type="button" class="btn btn-danger center approve_rpt_i" id="approve_rpt_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_v_trans" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Validate Transfer</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_trns_v" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_trns_v" rows="5" id="add_coment_trns_v"></textarea>							
                                                    </div>
                                                    <?php if($transfer_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="trn_tok_val" type="password" class="form-control trn_tok_val" name="trn_tok_val" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center validate_trns_p" id="validate_trns_p">Proceed</button>
													<button type="button" class="btn btn-danger center validate_trns_i" id="validate_trns_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_r_trans" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Recommend Transfer</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_trns_r" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_trns_r" rows="5" id="add_coment_trns_r"></textarea>							
                                                    </div>
                                                    <?php if($transfer_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="trn_tok_rec" type="password" class="form-control trn_tok_rec" name="trn_tok_rec" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center recommend_trns_p" id="recommend_trns_p">Recommend</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>

                                <div id="rModal_a_trans" class="modal fade">
									<div class="modal-dialog white">
											<div class="modal-content white">
                                            <div class="modal-body white center">
                                                    <h1>Approve Transfer</h2>
                                                    <br>
                                                    <div class="form-group">
                                                        <label for="add_coment_trns_a" class="control-label">Add Comment</label>							
                                                            <textarea class="form-control add_coment_trns_a" rows="5" id="add_coment_trns_a"></textarea>							
                                                    </div>
                                                    <?php if($transfer_ht == 1) { ?>
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                                                            <input id="trn_tok_app" type="password" class="form-control trn_tok_app" name="trn_tok_app" placeholder="Enter Hard Token">
                                                        </div>
                                                    <?php } ?>
                                                    <br>
												</div>
												<div class="modal-footer center">
                                                    <button type="button" class="btn btn-success center approve_trns_p" id="approve_trns_p">Approve</button>
													<button type="button" class="btn btn-danger center approve_trns_i" id="approve_trns_i">Reject</button>
                                                    <button type="button" class="btn btn-default center" data-dismiss="modal">Close</button>
												</div>
											</div>
									</div>
								</div>
                            </div>
						</div>
					</div>
								

								
						
						<!-- end: BASIC EXAMPLE -->
						<!-- end: SELECT BOXES -->

			<!-- start: FOOTER -->
            
	<?php //include('../include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->

		<script src="../vendor/jquery/jquery.min.js"></script>
		<script src="../vendor/modernizr/modernizr.js"></script>
		<script src="../vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="../vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="../vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->

		<script>
		$(function(){
                $('.datepicker').datepicker({
                    //startDate: '-0m',
                    format: 'dd-mm-yyyy'
                    //endDate: '+2d'
                }).on('changeDate', function(ev){
                    $('.datepicker').text($('.datepicker').data('date'));
                    $('.datepicker').datepicker('hide');
                });

            });
		</script>
		


		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="../vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="../vendor/autosize/autosize.min.js"></script>
		<script src="../vendor/selectFx/classie.js"></script>
		<script src="../vendor/selectFx/selectFx.js"></script>

		
		
		
		
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="../assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="../assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
				FormElements.init();
			});
		</script>


<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="../assets/js/datatables.min.js"></script>

<script type="text/javascript" language="javascript">

$(document).ready(function() { 


    $('.select2').select2({
			closeOnSelect: true,
            allowClear: true
	});

    $('.gotoworkqueue').click(function(){

    var url = "<?php echo $site_domain."/main/work_queue"?>";

        window.location = url;
    });

    $('.gotocustomerpage').click(function(){

    var url = "<?php echo $site_domain."/main/customer/customerdetails?customer_id=$customer_id"?>";

        window.location = url;
    });

    

    $('#validate_deposit').click(function(){

    $('#rModal_v_depo').modal('show');

    });
    $('#recommend_deposit').click(function(){

    $('#rModal_r_depo').modal('show');

    });
    $('#approve_deposit').click(function(){

    $('#rModal_a_depo').modal('show');

    });

    $('#validate_dpo_p').click(function(){
    $('#validate_dpo_p').attr('disabled','disabled');
    var verify_id = <?php echo $verify_id; ?>;
    var action = "Validate Deposit";
    var add_coment = $('#add_coment_dpo_v').val();

    if(confirm("Are you sure you want to validate this deposit?")) {
        $.ajax({
            url:'transaction_auth.php',
            method:"POST",
            data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
            success:function(data){
                    $('.close_response').html(data);
                    $('#rModal_v_depo').modal('hide');
                    $('#rModal_open').modal('show');
                    //location.reload();
            }
        })
    } else {
        return false;
        $('#validate_dpo_p').attr('disabled',false);
    }
    });


    $('#validate_dpo_i').click(function(){
        $('#validate_dpo_i').attr('disabled','disabled');
    var verify_id = <?php echo $verify_id; ?>;
    var action = "Validate Deposit Invalid";
    var add_coment = $('#add_coment_dpo_v').val();

    if(confirm("Are you sure you want to reject this deposit transaction?")) {
        $.ajax({
            url:'transaction_auth.php',
            method:"POST",
            data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
            success:function(data){
                    $('.close_response').html(data);
                    $('#rModal_v_depo').modal('hide');
                    $('#rModal_open').modal('show');
                    //location.reload();
            }
        })
    } else {
        return false;
        $('#validate_dpo_i').attr('disabled',false);
    }
    });

    //RECOMMEND DEPOSIT

    $('#recommend_dpo_p').click(function(){
        $('#recommend_dpo_p').attr('disabled','disabled');
    var verify_id = <?php echo $verify_id; ?>;
    var action = "Recommend Deposit";
    var add_coment = $('#add_coment_dpo_r').val();

    if(confirm("Are you sure you want to recommend this deposit?")) {
        $.ajax({
            url:'transaction_auth.php',
            method:"POST",
            data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
            success:function(data){
                    $('.close_response').html(data);
                    $('#rModal_r_depo').modal('hide');
                    $('#rModal_open').modal('show');
                    //location.reload();
            }
        })
    } else {
        return false;
        $('#recommend_dpo_p').attr('disabled',false);
    }
    });

    //APPROVE DEPOSIT
    $('#approve_dpo_p').click(function(){
        $('#approve_dpo_p').attr('disabled','disabled');
    var verify_id = <?php echo $verify_id; ?>;
    var action = "Approve Deposit";
    var add_coment = $('#add_coment_dpo_a').val();

    if(confirm("Are you sure you want to approve this deposit?")) {
        $.ajax({
            url:'transaction_auth.php',
            method:"POST",
            data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
            success:function(data){
                    $('.close_response').html(data);
                    $('#rModal_a_depo').modal('hide');
                    $('#rModal_open').modal('show');
                    //location.reload();
            }
        })
    } else {
        return false;
        $('#approve_dpo_p').attr('disabled',false);
    }
    });


    $('#approve_dpo_i').click(function(){
    var verify_id = <?php echo $verify_id; ?>;
    $('#approve_dpo_i').attr('disabled','disabled');
    var action = "Approve Deposit Invalid";
    var add_coment = $('#add_coment_dpo_a').val();

    if(confirm("Are you sure you want to reject this deposit transaction?")) {
        $.ajax({
            url:'transaction_auth.php',
            method:"POST",
            data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
            success:function(data){
                    $('.close_response').html(data);
                    $('#rModal_a_depo').modal('hide');
                    $('#rModal_open').modal('show');
                    //location.reload();
            }
        })
    } else {
        return false;
        $('#approve_dpo_i').attr('disabled',false);
    }
    });

    //DEPOSIT ENDS

    $('#validate_withdraw').click(function(){

$('#rModal_v_widt').modal('show');

});
$('#recommend_withdraw').click(function(){

$('#rModal_r_widt').modal('show');

});
$('#approve_withdraw').click(function(){

$('#rModal_a_widt').modal('show');

});

$('#validate_wdt_p').click(function(){
    $('#validate_wdt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Withdraw";
var add_coment = $('#add_coment_wdt_v').val();
var tok = ""
 <?php
    if($withdraw_ht == 1) { ?>
    tok = $(".wit_tok_val").val();
<?php
    }
?>

if(confirm("Are you sure you want to validate this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_widt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_wdt_p').attr('disabled',false);
}
});


$('#validate_wdt_i').click(function(){
    $('#validate_wdt_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Withdraw Invalid";
var add_coment = $('#add_coment_wdt_v').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_widt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_wdt_i').attr('disabled',false);
}
});

//RECOMMEND WITHDRAWAL

$('#recommend_wdt_p').click(function(){
    $('#recommend_wdt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Recommend Withdraw";
var add_coment = $('#add_coment_wdt_r').val();
var tok = ""
 <?php
    if($withdraw_ht == 1) { ?>
    tok = $(".wit_tok_rec").val();
<?php
    }
?>
if(confirm("Are you sure you want to recommend this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_r_widt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#recommend_wdt_p').attr('disabled',false);
}
});

//APPROVE WITHDRAWAL
$('#approve_wdt_p').click(function(){
    $('#approve_wdt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Withdraw";
var add_coment = $('#add_coment_wdt_a').val();
var tok = ""
 <?php
    if($withdraw_ht == 1) { ?>
    tok = $(".wit_tok_app").val();
<?php
    }
?>


if(confirm("Are you sure you want to approve this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_widt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_wdt_p').attr('disabled',false);
}
});


$('#approve_wdt_i').click(function(){
    $('#approve_wdt_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Withdraw Invalid";
var add_coment = $('#add_coment_wdt_a').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_widt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_wdt_i').attr('disabled',false);
}
});

    //WITHDRAW ENDS

    $('#validate_repayment').click(function(){

$('#rModal_v_rpyt').modal('show');

});
$('#recommend_repayment').click(function(){

$('#rModal_r_rpyt').modal('show');

});
$('#approve_repayment').click(function(){

$('#rModal_a_rpyt').modal('show');

});

$('#validate_rpt_p').click(function(){
    $('#validate_rpt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Repayment";
var add_coment = $('#add_coment_rpt_v').val();

if(confirm("Are you sure you want to validate this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_rpyt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_rpt_p').attr('disabled',false);
}
});


$('#validate_rpt_i').click(function(){
    $('#validate_rpt_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Repayment Invalid";
var add_coment = $('#add_coment_rpt_v').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_rpyt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_rpt_i').attr('disabled',false);
}
});

//RECOMMEND REPAYMENT

$('#recommend_rpt_p').click(function(){
    $('#recommend_rpt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Recommend Repayment";
var add_coment = $('#add_coment_rpt_r').val();

if(confirm("Are you sure you want to recommend this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_r_rpyt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#recommend_rpt_p').attr('disabled',false);
}
});

//APPROVE REPAYMENT
$('#approve_rpt_p').click(function(){
    $('#approve_rpt_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Repayment";
var add_coment = $('#add_coment_rpt_a').val();
if(confirm("Are you sure you want to approve this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_rpyt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_rpt_p').attr('disabled',false);
}
});


$('#approve_rpt_i').click(function(){
    $('#approve_rpt_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Repayment Invalid";
var add_coment = $('#add_coment_rpt_a').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_rpyt').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_rpt_i').attr('disabled',false);
}
});

    //REPAYMENT ENDS

    //internal transfer
    $('#validate_transfer_internal').click(function(){

$('#rModal_v_trans').modal('show');

});
$('#recommend_transfer_internal').click(function(){

$('#rModal_r_trans').modal('show');

});
$('#approve_transfer_internal').click(function(){

$('#rModal_a_trans').modal('show');

});

$('#validate_trns_p').click(function(){
    $('#validate_trns_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Transfer";
var add_coment = $('#add_coment_trns_v').val();
var tok = ""
 <?php
    if($transfer_ht == 1) { ?>
    tok = $(".trn_tok_val").val();
<?php
    }
?>


if(confirm("Are you sure you want to validate this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_trans').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_trns_p').attr('disabled',false);
}
});


$('#validate_trns_i').click(function(){
    $('#validate_trns_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Validate Transfer Invalid";
var add_coment = $('#add_coment_trns_v').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_v_trans').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#validate_trns_i').attr('disabled',false);
}
});

//RECOMMEND DEPOSIT

$('#recommend_trns_p').click(function(){
    $('#recommend_trns_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Recommend Transfer";
var add_coment = $('#add_coment_trns_r').val();
var tok = ""
 <?php
    if($transfer_ht == 1) { ?>
    tok = $(".trn_tok_rec").val();
<?php
    }
?>

if(confirm("Are you sure you want to recommend this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_r_trans').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#recommend_trns_p').attr('disabled',false);
}
});

//APPROVE TRANSFER
$('#approve_trns_p').click(function(){
    $('#approve_trns_p').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Transfer";
var add_coment = $('#add_coment_trns_a').val();
var tok = ""
 <?php
    if($transfer_ht == 1) { ?>
    tok = $(".trn_tok_app").val();
<?php
    }
?>


if(confirm("Are you sure you want to approve this?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, "action": action, "add_coment": add_coment, "tok": tok},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_trans').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_trns_p').attr('disabled',false);
}
});


$('#approve_trns_i').click(function(){
    $('#approve_trns_i').attr('disabled','disabled');
var verify_id = <?php echo $verify_id; ?>;
var action = "Approve Transfer Invalid";
var add_coment = $('#add_coment_trns_a').val();

if(confirm("Are you sure you want to reject this transaction?")) {
    $.ajax({
        url:'transaction_auth.php',
        method:"POST",
        data:{'verify_id':verify_id, 'action':action, "add_coment": add_coment},
        success:function(data){
                $('.close_response').html(data);
                $('#rModal_a_trans').modal('hide');
                $('#rModal_open').modal('show');
                //location.reload();
        }
    })
} else {
    return false;
    $('#approve_trns_i').attr('disabled',false);
}
});


    //external transfer
    $('#validate_transfer_external').click(function(){

$('#rModal_v_trans').modal('show');

});
$('#recommend_transfer_external').click(function(){

$('#rModal_r_trans').modal('show');

});
$('#approve_transfer_external').click(function(){

$('#rModal_a_trans').modal('show');

});




    //TRANSFER ENDS

$('#rModal_open').on('hidden.bs.modal', function (e) {
    var url = "<?php echo $site_domain."/main/work_queue"?>";

    window.location = url;
		
})

});
</script>

<script src="../vendor/bootstrap/js/bootstrap.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.23/js/dataTables.bootstrap.min.js"></script>
<script src="../vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="../vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="../vendor/select2/select2.min.js"></script>
		<!-- end: JavaScript Event Handlers for this page -->
		<!-- end: CLIP-TWO JAVASCRIPTS -->
	</body>
</html>
<?php } ?>