<?php
//DEPOSIT TRANSACTION FUNCTION
    function approveDeposit($by, $verify_id, $br_start_date, $action, $db, $deposit_amount, $deposit_comment, $customer_id, $account_number, $value_date, $maintenance, $login_session_expiry, $org_code, $egis_api, $egis_secret, $egis_transfers, $site_name, $egis_api_root, $is_sms_active, $is_email, $offline_id, $site_domain) {
    include('../welcome_user.php');
    $onee = 1;
    $rev = "X";
    $yes = "Yes";
    $_SESSION['msg1'] = "";

    $pod = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
    $pod -> bind_param('is', $customer_id, $account_number);
    $pod -> execute();
    $rpod = $pod->get_result();

    while($row = mysqli_fetch_assoc($rpod) ){
        $account_id = $row['id'];
        $product_type = $row['product_type'];
        $product = $row['product'];
        $cleared_balance = $row['cleared_balance'];
        //$customer_branch = $row["secondary_branch"];
        $customer_rm = $row['secondary_relationship_manager'];
        $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
        $creation_date = $row["creation_date"];
        //$cu_application_date = date('d-m-Y', strtotime($row['application_date']));
        $account_status = $row['status'];
        $sms_alert = $row["sms_alert"];
        $email_alert = $row["email_alert"];
        $currency = $row["currency"];
        $total_debited_thrift_fee = $row['total_debited_thrift_fee'];
        $approval_date = $row["approval_date"];
        $plan_amount = $row['plan_amount'];
    }

    //GET INITIATOR BRANCH
    $ovr = $db -> prepare('SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?)');
    $ovr -> bind_param('i', $verify_id);
    $ovr -> execute();
    $rovr = $ovr->get_result();

    while($iov = mysqli_fetch_assoc($rovr) ){
        $customer_branch = $iov['branch'];
    }

    if($product_type == "Savings" || $product_type == "Current" || $product_type == "Float") {
        $cnl = $channel_log;
        require_once("dorm_check.php");
    } else {
        $a_dbt = 0;
        $a_cdt = 0;
        $a_ph = 0;
        $a_em = 0;
    }

    

    //CHECK IF USER HAS TELLER

    $tty="Teller";
    $seltl = $db -> prepare('SELECT * FROM teller_balances WHERE user_id IN(SELECT created_by FROM verify_transactions WHERE id=?) AND type=? AND currency=?');
    $seltl->bind_param("iss", $verify_id, $tty, $currency);
    $seltl->execute();
    $rseltl = $seltl->get_result();

    if($rseltl->num_rows > 0) {
        while($tlb = mysqli_fetch_assoc($rseltl) ){
            $teller_id = $tlb["id"];
            $tl_balance = $tlb["balance"];
            $tl_gl = $tlb["gl"];
            $tl_status = $tlb["status"];
        }

            $fundteller_amount = $tl_balance + $deposit_amount;
            $has_teller=1;

            //Teller Limits
            $ovl = $db -> prepare('SELECT olimit, slimit, tlimit FROM config_tellers WHERE gl=?');
            $ovl -> bind_param('i', $tl_gl);
            $ovl -> execute();
            $rovl = $ovl->get_result();

            while ($lu = $rovl->fetch_array()) {
                $olimit = $lu['olimit'];
                $slimit = $lu['slimit'];
                $tlimit = $lu['tlimit'];
            }

            if ($fundteller_amount > $tlimit) {
                $tl_exceed = 1;//do not proceed, exceeds limit
            } else {
                $tl_exceed = 0;//proceed within limits
            }
        
    }  else {
        $has_teller=0;
        $tl_balance = 0;
        $tl_status ="";
        $tl_gl ="";
        $tl_exceed = 0;
    }

    $tty1="Tellering";
    $seltl1 = $db -> prepare('SELECT * FROM branch WHERE operational_model=? AND id IN(SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?))');
    $seltl1->bind_param("si", $tty1, $verify_id);
    $seltl1->execute();
    $rseltl1 = $seltl1->get_result();

    if($rseltl1->num_rows > 0) {
        $tl_model=1;
        
    } else {
    $tl_model=0;
    }

    if ($product_type=="Savings") {
        $product2 = str_replace("S","","$product");
        $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $maxAmount = $sc1['maxAmount'];
            }
      
      } else if ($product_type=="Current") {
        $product2 = str_replace("C","","$product");
        $sc = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $maxAmount = $sc1['maxAmount'];
            }
      } else if ($product_type=="Thrift") {
        $product2 = str_replace("T","","$product");
      
        $sc = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
                $maxAmount = $sc1['maxAmount'];
                $deduct_charge_per_tenure = $sc1['deduct_charge_per_tenure'];
                $plan_count = $sc1['plan_count'];
            }
      } else if ($product_type=="Term Deposit") {
        $product2 = str_replace("TD","","$product");
      
        $sc = $db -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
        $sc -> bind_param('i', $product2);
        $sc -> execute();
        $rsc = $sc->get_result();
            while($sc1 = mysqli_fetch_array($rsc) ){
                $saving_reference = $sc1['saving_reference'];
                $saving_control = $sc1['saving_control'];
                $productGroup = $sc1['productGroup'];
            }
            $maxAmount = 0;
      
        } else if ($product_type=="Share") {
            $product2 = str_replace("SH","","$product");
        } else if ($product_type=="Float") {
            $product2 = str_replace("F","","$product");
            $sc = $db -> prepare('SELECT * FROM floatproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $productGroup = $sc1['productGroup'];
                    $maxAmount = $sc1['maxAmount'];
                }
          }
      
        $curr_locked = 0;
        $charge_amount_trt = 0;
      
        //GET LOCKED SAVINGS FUNDS
        if ($product_type == "Savings") {
            //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
            $yui = $db -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
            $yui -> bind_param('i', $account_id);
            $yui -> execute();
            $ryui = $yui->get_result();
        
            if ($ryui->num_rows > 0) {
                while($io = mysqli_fetch_array($ryui) ){
                    $curr_locked = $io['curr_locked'];
                }
            } else {
                $curr_locked = 0;
            }
        } else if ($product_type == "Thrift") {
          
                //GET CLEARED BALANCE BY OMITTING DAYS/WEEKS/MONTHS THAT DEPOSIT DIDN'T TAKE PLACE
                
                $today_date = date("Y-m-d");
                $date1 = new DateTime($approval_date);
                $date2 = new DateTime($today_date);
                $total_days  = $date2->diff($date1)->format('%a');
          
                $amount_case = $cleared_balance / $plan_amount;
          
                if($total_debited_thrift_fee >0) {
                    $debit_count = $total_debited_thrift_fee/$plan_amount;
          
                    for($o=0; $o<$debit_count; $o++) {
                        $total_days = $total_days - $plan_count;
                    }
                } else {
                    $debit_count = 0 ;
                }
          
                    $charge_count = 0;
                    $status_tr = "Approved";
                    for ($i=0; $i < $total_days; $i += $plan_count) {
                        //$end_date = $creation_date + $plan_count;
                        $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
          
                        $cdt = "Credit";
                        $grec = $db -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                        $grec -> bind_param('sssss', $account_number, $status_tr, $cdt, $approval_date, $end_date);
                        $grec -> execute();
                        $rgrec = $grec->get_result();
          
                        while($gre_r = mysqli_fetch_array($rgrec) ){
                            $sum_amount = $gre_r['tram'];
          
                        }
                        if ($sum_amount > 0) {
                            $charge_count = $charge_count + 1;
                        }
          
                        $approval_date = $end_date;
          
                    }
          
                    if ($amount_case > $charge_count && $amount_case > $plan_count) {
                        $charge_count = ceil($amount_case/$plan_count);
                    }
          
                    $balance_count = $charge_count - $debit_count;
                    $charge_amount_trt = $balance_count * $plan_amount;
                    $curr_locked = $charge_amount_trt;
              } else {
            $curr_locked = 0;
        }
      
         //GET SUM OF ALL PENDING CHARGES
         $day_g = $db -> prepare('SELECT SUM(charge_amount) as chg FROM temp_charge WHERE account_number=?');
         $day_g -> bind_param('s', $account_number);
         $day_g -> execute();
         $rday_g = $day_g->get_result();
         while($ch = mysqli_fetch_assoc($rday_g) ){
             $pending_charges = $ch['chg'];
         }
         $remainamount = $cleared_balance - $charge_amount_trt - $pending_charges;
        $receivable_amount = $remainamount + $deposit_amount;

        $pl_event = "Deposit";
    require_once("daily_transaction_limit.php");
    
    if($global_limit == 1) {
        $pldsc = "Deposit";
        $status_pld = "Approved";
        $pdlm = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=?");
        $pdlm -> bind_param('ssss', $account_number, $status_pld, $pldsc, $value_date);
        $pdlm -> execute();
        $rpdlm = $pdlm->get_result();
      
        while($dlm_o = mysqli_fetch_array($rpdlm) ){
            $global_amount_so_far = $dlm_o['dlm'];
        }

        if($deposit_amount + $global_amount_so_far > $transaction_limit_g) {
            $proceed_global = 1;
        }
    }
    if($channel_limit == 1) {
        $pldsc = "Deposit";
        $status_pld = "Approved";
        $pdlm1 = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=? AND channel=?");
        $pdlm1 -> bind_param('ssssi', $account_number, $status_pld, $pldsc, $value_date, $channel_log);
        $pdlm1 -> execute();
        $rpdlm1 = $pdlm1->get_result();
      
        while($dlm_o1 = mysqli_fetch_array($rpdlm1) ){
            $channel_amount_so_far = $dlm_o1['dlm'];
        }

        if($deposit_amount + $channel_amount_so_far > $transaction_limit_c) {
            $proceed_channel = 1;
        }
    }

    $cu_creation_date1 = strtotime($cu_creation_date) * 1000;
    $br_start_date1 = strtotime($br_start_date) * 1000;
    if($br_start_date1 < $cu_creation_date1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>You cannot do transactions on a date below account creation date.</h2>";

    } else if($account_status != "Active" && $account_status != "Frozen" && $account_status != "Dormant" && $account_status != "Delinquent") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Account is not active. You are not allowed to transact on it.</h2>";
    } else if($a_cdt == 1 && $account_status == "Dormant") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>This account is dormant and doesn't allow deposits.</h2>";
    } else if($tl_model == 1 && $has_teller == 0) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Branch is operating a teller model but user has no teller</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_status !="Open") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Deposit not allowed. Teller is not Open.</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_exceed ==1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Deposit not allowed. Teller limit of $currency $tlimit exceeded.</h2>";
    } else if ($maxAmount > 0 && $receivable_amount > $maxAmount) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Deposit not allowed. Account Maximum Limit of <b>$maxAmount</b> exceeded.</h2>";
    } else if($proceed_global == 1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Deposit not allowed. Account Daily Deposit limit of $currency $transaction_limit_g exceeded.</h2>";
    } else if($proceed_channel == 1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Deposit not allowed. Channel Daily Deposit limit of $currency $transaction_limit_c exceeded.</h2>";
    } else {

        $_SESSION['msg1'] = "Success";
    $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
    $pod1 -> bind_param('i', $customer_id);
    $pod1 -> execute();
    $rpod1 = $pod1->get_result();

    while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        $fname = $row1["fname"];
        $mname = $row1["mname"];
        $lname = $row1["lname"];
        //$customer_branch = $row1["branch"];
        //$customer_rm = $row1["secondary_relationship_manager"];
        $cu_character = strtoupper($customer_name[0]);
    }

    date_default_timezone_set("Africa/Lagos");
$deposit_transaction_date = date("Y-m-d H:i:s");
$transaction_date = date("Y-m-d H:i:s");

$num = mt_rand(100000, 999999);
$stamp_1 = date("Yhis");
$orderId = $stamp_1 . $num;

$transaction_id = "C$cu_character" . "$orderId";

$description = "Deposit";
$type = "Credit";

    $new_amount = $cleared_balance + $deposit_amount;
    $previous_balance = $cleared_balance;

    //UPDATE CUSTOMER ACCOUNT

          $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
          $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
          $pw->execute();
          $pw->close();

//INSERT INTO TRANSACTION TABLE
if($has_teller == 1) {
$w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
$w->bind_param("ssidddsssssiiiisii", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deposit_amount, $type, $description, $deposit_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $teller_id, $offline_id);
$w->execute();
$last_id = mysqli_insert_id($db);


$rup = $db->prepare("UPDATE teller_balances SET balance=? WHERE id=?");
$rup->bind_param('di', $fundteller_amount, $teller_id);
$rup->execute();
$rup->close();

} else {
    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deposit_amount, $type, $description, $deposit_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $offline_id);
    $w->execute();
    $last_id = mysqli_insert_id($db);
}
$entity_id = "TRR$last_id";

//INSERT INTO ACTIVITY TABLE
$act_dsc = "Funds Deposit to customer account";
$act_type = "Deposit";
$wW = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
$wW->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
$wW->execute();

if($has_teller == 1) {
    $dba = $tl_gl;
} else {
    $dba = $saving_reference; 
}
//INSERT INTO JOURNAL
$crd_gl = -$deposit_amount;
$journal_date = $value_date;
$journal_type = "Automatic";
$journal_description = "Funds Deposit to customer account";
$jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
$jn->bind_param("iddiiiissss", $last_id, $crd_gl, $deposit_amount, $saving_control, $dba, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
$jn->execute();

    //DO SMS INTEGRATION
    $biz_rule = "Funds Deposited";
    $brn = $customer_branch;
    $rm = $customer_rm;
    $pg = $productGroup;
    $account_id = $account_id;
    $account_no = $account_number;
    $vdate = $value_date;
    $tdate = $deposit_transaction_date;
    $tamount = $deposit_amount;
    $cb = $new_amount;

    include("sms_int.php");

    //DO THE CHARGES THING

        if($charge_sms == 1) {
        $charge_tl1 = "Deposit Fee";
        $charge_tl2 = "Single SMS Fee";
        //$charge_tl4 = "Email Fee";
        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE active=? AND chargetype =? OR chargetype =?)');
        $incr -> bind_param('ssss', $product, $yes, $charge_tl1, $charge_tl2);
        $incr -> execute();
        $rincr = $incr->get_result();
        } else {
        $charge_tl1 = "Deposit Fee";
        //$charge_tl2 = "Single SMS Fee";
        //$charge_tl4 = "Email Fee";
        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
        $incr -> bind_param('sss', $product, $charge_tl1, $yes);
        $incr -> execute();
        $rincr = $incr->get_result();
        }
                    if($rincr->num_rows > 0) {


                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source = $fr['funding_source'];
                        }

                        foreach ($rincr as $iid):
                        
                        $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                        $de -> bind_param('i', $iid['cid']);
                        $de -> execute();
                        $rde = $de->get_result();
                        while($dee = mysqli_fetch_array($rde) ){
                        //Call Charge Amount
                        $trnsss_amount = $deposit_amount;
                        $chid = $iid['cid'];
                        include('../../charges.php');
                        //End Call Charge Amount
                        $charge_name = $dee['name'];
                        $charge_option = $dee['charge_option'];
                        $triggertype = $dee['triggertype'];
                        $chargetype = $dee['chargetype'];
                        }

                        $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                        $set -> bind_param('ss', $product, $ch_id);
                        $set -> execute();
                        $rset = $set->get_result();
                        while($rrt = mysqli_fetch_array($rset) ){
                            $income_acc = $rrt['income_acc'];
                        }

                            $cb = $db -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                            $cb -> bind_param('s', $account_number);
                            $cb -> execute();
                            $rcb = $cb->get_result();
    
                            while($rbb = mysqli_fetch_assoc($rcb) ){
                            $cleared_bal = $rbb["cleared_balance"];
                            }

                        if ($charge_option != "Flat") {
                            $charge_amount = $deposit_amount * ($charge_amount/100);
                        }
                        if($chargetype == "Single SMS Fee") {
                            $charge_amount = $charge_amount * $sms_count_pay;
                        }
                        if ($triggertype == "Per Transaction" && $charge_amount >0) {

                            
                            $value_date = date("Y-m-d H:i:s");
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;
    
                            $new_amount_c = $cleared_bal - $charge_amount;
    
                            $description_c = "$charge_name";
                            $type_c = "Debit";
        
                            $debit_comment = "$charge_name";
    
                            $transaction_id_c = "D$cu_character" . "$orderId";
    
                            //INSERT CHARGES INTO TRANSACTION TABLE
                            $wc = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $account_number, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                            $wc->execute();
                            $last_id_c = mysqli_insert_id($db);
    
                            $entity_id_c = "TRR$last_id_c";
    
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "$charge_name debit from customer account";
                            $act_type = "Debit";
                            $wwc = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $usbrn, $channel_log);
                            $wwc->execute();
    
                            $crd_gl1 = -$charge_amount;
                            $journal_description = "$charge_name";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
    
                            $upd = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $upd->bind_param('ds', $new_amount_c, $account_number);
                            $upd->execute();

                            } else {
                                //INSERT CHARGE INTO TEM CHARGES TABLE
                                if($charge_amount>0) {
                                $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                $inch->bind_param("sdss", $account_number, $charge_amount, $charge_name, $triggertype);
                                $inch->execute();
                                }

                                $new_amount_c = $new_amount;
                            }
                            //DO SMS INTEGRATION
                            if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                $biz_rule = "Charge Deducted";
                                $brn = $customer_branch;
                                $rm = $customer_rm;
                                $pg = $productGroup;
                                $account_id = $account_id;
                                $account_no = $account_number;
                                $vdate = $value_date;
                                $tdate = $transaction_date;
                                $tamount = $charge_amount;
                                $cb = $new_amount_c;

                                include_once("sms_int.php");
                            }
    
                            endforeach;
                        }

    }


    //UPDATE WORKFLOW TRANSACTION
    $mman = $db -> prepare("SELECT proof FROM verify_transactions WHERE id=?");
    $mman -> bind_param('i', $verify_id);
    $mman -> execute();
    $rmman = $mman->get_result();

    while($gut = mysqli_fetch_assoc($rmman) ){
        $proof = $gut['proof'];
    }
    if($proof !="") {
        unlink($proof);
    }
    $nul = NULL;
    $update = "Approved";

    $io = $db->prepare("UPDATE verify_transactions SET status=?, proof=? WHERE id=?");
    $io->bind_param('ssi', $update, $nul, $verify_id);
    $io->execute();
    $io->close();

    //UPDATE WORK QUEUE STATUS
    $ent_id = 41;
    $act_id = 39;
   // $act_id2 = 64;
    $wfcheck = $db -> prepare('SELECT * FROM work_queue WHERE main_area_id=? AND entity_id=? AND action_id=?');
    $wfcheck -> bind_param('iii', $verify_id, $ent_id, $act_id);
    $wfcheck -> execute();
    $rwfcheck = $wfcheck->get_result();

    if ($rwfcheck->num_rows > 0) {

        $new_status = "Treated";

        $updwk = $db->prepare("UPDATE work_queue SET status=?, $by=? WHERE main_area_id=? AND entity_id=? AND action_id=?");
        $updwk->bind_param('siiii', $new_status, $aid, $verify_id, $ent_id, $act_id);
        $updwk->execute(); 

    }    

}//END DEPOSIT


//WITHDRAW TRANSACTION FUNCTION
function approveWithdraw($by, $verify_id, $br_start_date, $action, $db, $withdraw_amount, $withdraw_comment, $customer_id, $account_number, $value_date, $maintenance, $login_session_expiry, $org_code, $egis_api, $egis_secret, $egis_transfers, $site_name, $egis_api_root, $is_sms_active, $is_email, $site_domain) {
    include('../welcome_user.php');
    $onee = 1;
    $rev = "X";
    $yes="Yes";
    $_SESSION['msg1'] = "";

    $pod = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
    $pod -> bind_param('is', $customer_id, $account_number);
    $pod -> execute();
    $rpod = $pod->get_result();

while($row = mysqli_fetch_assoc($rpod) ){
    $account_id = $row['id'];
    $product_type = $row['product_type'];
    $product = $row['product'];
    //$opening_amount = $row['opening_amount'];
    $plan_amount = $row['plan_amount'];
    $cleared_balance = $row['cleared_balance'];
    //$customer_branch = $row["secondary_branch"];
    $customer_rm = $row["secondary_relationship_manager"];
    $creation_date = $row["creation_date"];
    $approval_date = $row["approval_date"];
    $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
    $account_status = $row['status'];
    $total_debited_thrift_fee = $row['total_debited_thrift_fee'];
    $sms_alert = $row["sms_alert"];
    $email_alert = $row["email_alert"];
    $currency = $row["currency"];
    }

     //GET INITIATOR BRANCH
     $ovr = $db -> prepare('SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?)');
     $ovr -> bind_param('i', $verify_id);
     $ovr -> execute();
     $rovr = $ovr->get_result();
 
     while($iov = mysqli_fetch_assoc($rovr) ){
         $customer_branch = $iov['branch'];
     }
 

    if($product_type == "Savings" || $product_type == "Current" || $product_type == "Float") {
        $cnl = $channel_log;
        require_once("dorm_check.php");
    } else {
        $a_dbt = 0;
        $a_cdt = 0;
        $a_ph = 0;
        $a_em = 0;
    }

    //CHECK IF PND IS SET FOR THIS ACCOUNT
    $ppnd = $db -> prepare('SELECT * FROM pnd WHERE account_id=?');
    $ppnd -> bind_param('i', $account_id);
    $ppnd -> execute();
    $rppnd = $ppnd->get_result();
    if ($rppnd->num_rows > 0) {
        $is_pnd = 1;
    } else {
        $is_pnd = 0;
    }
    //CHECK IF THERE'S LIEN FOR THIS ACCOUNT
    $lln = $db -> prepare('SELECT * FROM lien WHERE account_id=?');
    $lln -> bind_param('i', $account_id);
    $lln -> execute();
    $rlln = $lln->get_result();

    if ($rlln->num_rows > 0) {
        while($jvx = mysqli_fetch_assoc($rlln) ){ 
            $lien= $jvx["amount"];
        }
    } else {
        $lien = 0;
    }

    //CHECK IF USER HAS TELLER

    $tty="Teller";
    $seltl = $db -> prepare('SELECT * FROM teller_balances WHERE user_id IN(SELECT created_by FROM verify_transactions WHERE id=?) AND type=? AND currency=?');
    $seltl->bind_param("iss", $verify_id, $tty, $currency);
    $seltl->execute();
    $rseltl = $seltl->get_result();

    if($rseltl->num_rows > 0) {
        while($tlb = mysqli_fetch_assoc($rseltl) ){
            $teller_id = $tlb["id"];
            $tl_balance = $tlb["balance"];
            $tl_gl = $tlb["gl"];
            $tl_status = $tlb["status"];
        }

            $fundteller_amount = $tl_balance - $withdraw_amount;
            $has_teller=1;
        
    } else {
        $has_teller=0;
        $tl_balance = 0;
        $tl_status ="";
        $tl_gl ="";
    }

    $tty1="Tellering";
    $seltl1 = $db -> prepare('SELECT * FROM branch WHERE operational_model=? AND id IN(SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?))');
    $seltl1->bind_param("si", $tty1, $verify_id);
    $seltl1->execute();
    $rseltl1 = $seltl1->get_result();

    if($rseltl1->num_rows > 0) {
        $tl_model=1;
        
    } else {
    $tl_model=0;
    }

    if($global_limit == 1) {
        $pldsc = "Withdraw";
        $status_pld = "Approved";
        $pdlm = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=?");
        $pdlm -> bind_param('ssss', $account_number, $status_pld, $pldsc, $value_date);
        $pdlm -> execute();
        $rpdlm = $pdlm->get_result();
      
        while($dlm_o = mysqli_fetch_array($rpdlm) ){
            $global_amount_so_far = $dlm_o['dlm'];
        }

        if($withdraw_amount + $global_amount_so_far > $transaction_limit_g) {
            $proceed_global = 1;
        }
    }
    if($channel_limit == 1) {
        $pldsc = "Withdraw";
        $status_pld = "Approved";
        $pdlm1 = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=? AND channel=?");
        $pdlm1 -> bind_param('ssssi', $account_number, $status_pld, $pldsc, $value_date, $channel_log);
        $pdlm1 -> execute();
        $rpdlm1 = $pdlm1->get_result();
      
        while($dlm_o1 = mysqli_fetch_array($rpdlm1) ){
            $channel_amount_so_far = $dlm_o1['dlm'];
        }

        if($withdraw_amount + $channel_amount_so_far > $transaction_limit_c) {
            $proceed_channel = 1;
        }
    }

    $cu_creation_date1 = strtotime($cu_creation_date) * 1000;
    $br_start_date1 = strtotime($br_start_date) * 1000;
    if($br_start_date1 < $cu_creation_date1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>You cannot do transactions on a date below account creation date.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($account_status == "Invalid" || $account_status == "Pending" || $account_status == "Closed" || $account_status == "Frozen") {
        
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Withdrawal is not allowed for this account</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($a_dbt == 1 && $account_status == "Dormant") {
        
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>This account is dormant and doesn't allow withdrawals.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($tl_model == 1 && $has_teller == 0) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Branch is operating a teller model but user has no teller</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_status !="Open") {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Withdrawal not allowed. Teller is not Open.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($withdraw_amount > $tl_balance && $tl_model == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Teller does not have sufficient funds to handle this withdrawal.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($is_pnd == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Account does not currently allow debit transactions.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($proceed_global == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Withdrawal is not allowed. Account Daily Withdrawal limit of $currency $transaction_limit_g exceeded.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($proceed_channel == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Withdrawal is not allowed. Channel Daily Withdrawal limit of $currency $transaction_limit_c exceeded.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else {

        if ($product_type == "Savings") {
            //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
            $yui = $db -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
            $yui -> bind_param('i', $account_id);
            $yui -> execute();
            $ryui = $yui->get_result();
        
            if ($ryui->num_rows > 0) {
                while($io = mysqli_fetch_array($ryui) ){
                    $curr_locked = $io['curr_locked'];
            
                }
            } else {
                $curr_locked = 0;
            }

            $product2 = str_replace("S","","$product");
            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
                }
                $al_withdraw = 1;
            
        }  else if ($product_type == "Thrift") {

            $product2 = str_replace("T","","$product");
                
            $sc = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $deduct_charge_per_tenure = $sc1['deduct_charge_per_tenure'];
                    $allow_premature_withdrawal = $sc1['allow_premature_withdrawal'];
                    $plan_count = $sc1['plan_count'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
                }
        
                if ($allow_premature_withdrawal == "Yes") {
                    //GET CLEARED BALANCE BY OMITTING DAYS/WEEKS/MONTHS THAT DEPOSIT DIDN'T TAKE PLACE
                    
                    $today_date = date("Y-m-d");
                    $date1 = new DateTime($approval_date);
                    $date2 = new DateTime($today_date);
                    $total_days  = $date2->diff($date1)->format('%a');
            
                    $amount_case = $cleared_balance / $plan_amount;
            
                    if($total_debited_thrift_fee >0) {
                        $debit_count = $total_debited_thrift_fee/$plan_amount;
            
                        for($o=0; $o<$debit_count; $o++) {
                            $total_days = $total_days - $plan_count;
                        }
                    } else {
                        $debit_count = 0 ;
                    }
            
                        $charge_count = 0;
                        $status_tr = "Approved";
                        for ($i=0; $i < $total_days; $i += $plan_count) {
                            //$end_date = $creation_date + $plan_count;
                            $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
            
                            $cdt = "Credit";
                            $grec = $db -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                            $grec -> bind_param('sssss', $account_number, $status_tr, $cdt, $approval_date, $end_date);
                            $grec -> execute();
                            $rgrec = $grec->get_result();
            
                            while($gre_r = mysqli_fetch_array($rgrec) ){
                                $sum_amount = $gre_r['tram'];
            
                            }
                            if ($sum_amount > 0) {
                                $charge_count = $charge_count + 1;
                            }
            
                            $approval_date = $end_date;
            
                        }
            
                        if ($amount_case > $charge_count && $amount_case > $plan_count) {
                            $charge_count = ceil($amount_case/$plan_count);
                        }
            
                        $balance_count = $charge_count - $debit_count;
            
                    
                        /*
                        if ($deduct_charge_per_tenure == "Yes") {
                            $charge_amount_trt = ($balance_count * $plan_amount) - $total_debited_thrift_fee;total_debited_thrift_fee was added in case its charge per tenure
                        } else {
                            $charge_amount_trt = $balance_count * $plan_amount;
                        }
                        */
                        $charge_amount_trt = $balance_count * $plan_amount;
                        //$net = $cleared_balance - $charge_amount;
                        $curr_locked = $charge_amount_trt;
                        $al_withdraw = 1;
                    } else {
                        $al_withdraw = 0;
                        $curr_locked = 0;
                    }
        
        } else if ($product_type == "Term Deposit") {
            $product2 = str_replace("TD","","$product");
                
                    $sc = $db -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                    $sc -> bind_param('i', $product2);
                    $sc -> execute();
                    $rsc = $sc->get_result();
                        while($sc1 = mysqli_fetch_array($rsc) ){
                            $saving_reference = $sc1['saving_reference'];
                            $saving_control = $sc1['saving_control'];
                            $productGroup = $sc1['productGroup'];
                        }
                        $minAmount = 0; //SET ON PURPOSE FOR GENERAL USE
                        $curr_locked = 0;
                        $al_withdraw = 1;
        } else if ($product_type == "Current") {

            $product2 = str_replace("C","","$product");
            $sc = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
                }
                $al_withdraw = 1;
                $curr_locked = 0;
            
        } else if ($product_type == "Float") {

            $product2 = str_replace("F","","$product");
            $sc = $db -> prepare('SELECT * FROM floatproduct WHERE id =?');
            $sc -> bind_param('i', $product2);
            $sc -> execute();
            $rsc = $sc->get_result();
                while($sc1 = mysqli_fetch_array($rsc) ){
                    $saving_reference = $sc1['saving_reference'];
                    $saving_control = $sc1['saving_control'];
                    $productGroup = $sc1['productGroup'];
                    $minAmount = $sc1['minAmount'];
                }
                $al_withdraw = 1;
                $curr_locked = 0;
            
        } else {
            $curr_locked = 0;
            $al_withdraw = 1;
        }        

        $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
        $pod1 -> bind_param('i', $customer_id);
        $pod1 -> execute();
        $rpod1 = $pod1->get_result();

        while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        $fname = $row1["fname"];
        $mname = $row1["mname"];
        $lname = $row1["lname"];
            $cu_character = strtoupper($customer_name[0]);
        }

        date_default_timezone_set("Africa/Lagos");
        $withdraw_transaction_date = date("Y-m-d H:i:s");
        $transaction_date = date("Y-m-d H:i:s");

        $num = mt_rand(100000, 999999);
        $stamp = date("Yhis");
        $stamp_1 = date("Yhis");
        $orderId = $stamp . $num;

        $transaction_id = "D$cu_character" . "$orderId";

        $description = "Withdraw";
        $type = "Debit";

        if($is_sms_active == 1 && $egis_transfers == 2) {

            $biz_rule = "Funds Withdrawn";
            $st_cmp = "Active";
            $trig = "Triggered";
        
            $xmxc = $db -> prepare('SELECT * FROM sms_campaign WHERE product_type=? AND business_rule=? AND status=? AND type=?');
            $xmxc -> bind_param('ssss', $product_type, $biz_rule, $st_cmp, $trig);
            $xmxc -> execute();
            $rxmxc = $xmxc->get_result();
        
        
        
        if($sms_alert =="Yes" && $rxmxc->num_rows >0) {
        
            while($xv = mysqli_fetch_array($rxmxc) ){
                $message = $xv['message'];
                $branches = explode(" , ", $xv['branches']);
                $relationship_officers = explode(" , ", $xv['relationship_officers']);
                $product_groups = explode(" , ", $xv['product_groups']);
            }
        
            if (!empty($branches)) {
        
                if (in_array($customer_branch, $branches)) {
                    $brn_sms = 1;
                } else {
                    $brn_sms = 0;
                }
        
            } else {
                $brn_sms = 1;
            }
            if (!empty($relationship_officers)) {
        
                if (in_array($customer_rm, $relationship_officers)) {
                    $rm_sms = 1;
                } else {
                    $rm_sms = 0;
                }
        
            } else {
                $rm_sms = 1;
            }
        
            if (!empty($product_groups)) {
        
                if (in_array($productGroup, $product_groups)) {
                    $pg_sms = 1;
                } else {
                    $pg_sms = 0;
                }
        
            } else {
                $pg_sms = 1;
            }
        
            if ($brn_sms == 1 || $rm_sms==1 || $pg_sms == 1) {
        
                $charge_sms = 1;
            } else {
                $charge_sms = 0;
            }
        
        
        } else {
            $charge_sms = 0;
        }
        
        } else {
        $charge_sms = 0;
        }
        
        //CHECK IF EMAIL ALERT IS ENABLED
        if($is_email == 1) {
        
            if($email_alert =="Yes") {
            
                $charge_email = 1;
            
                $yio = $db -> prepare('SELECT * FROM email_alert WHERE account_id=?');
                $yio -> bind_param('i', $account_id);
                $yio -> execute();
                $ryio = $yio->get_result();
                while($lk = mysqli_fetch_array($ryio) ){
                    $alert_email = $lk['email'];
                }//THIS IS NOT YET READY. APPLY CHARGE ONCE IT'S READY
            } else {
                $charge_email = 0;
            }
            
            } else {
            $charge_email = 0;
            }

        //CHECK IF THERE'S CHARGE AND SEE IF USER BALANCE IS ENOUGH TO HANDLE IT AND THE WITHDRAWAL
                    $charge_debit = 0;
                    if($charge_sms == 1) {
                        $charge_tl1 = "Withdrawal Fee";
                        $charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE active=? AND chargetype =? OR chargetype =?)');
                        $incr -> bind_param('ssss', $product, $yes, $charge_tl1, $charge_tl2);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        } else {
                        $charge_tl1 = "Withdrawal Fee";
                        //$charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                        $incr -> bind_param('sss', $product, $charge_tl1, $yes);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        }
                                if($rincr->num_rows > 0) {

                                foreach ($rincr as $iid):
                                
                                $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                                $de -> bind_param('i', $iid['cid']);
                                $de -> execute();
                                $rde = $de->get_result();
                                while($dee = mysqli_fetch_array($rde) ){
                                //Call Charge Amount
                                $trnsss_amount = $withdraw_amount;
                                $chid = $iid['cid'];
                                include('../../charges.php');
                                //End Call Charge Amount
                                $charge_name = $dee['name'];
                                $charge_option = $dee['charge_option'];
                                // $triggertype = $dee['triggertype'];
                                }

                                if ($charge_option != "Flat") {
                                    $charge_amount = $withdraw_amount * ($charge_amount/100);
                                }
                                    $charge_debit +=$charge_amount;
                                    endforeach;

                                    $total_debit = $withdraw_amount + $charge_debit + $curr_locked + $lien + $minAmount;
                                } else {
                                    $total_debit = $withdraw_amount + $curr_locked + $lien + $minAmount;
                                }

        if ($cleared_balance < $total_debit) {

            echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
            echo "</br></br><h2 class='center text-danger'>Insufficient Funds.</h2>";
            $_SESSION['msg1'] = "Failed";
            }
                
            else if ($cleared_balance >= $total_debit && $al_withdraw == 1) {
                $_SESSION['msg1'] = "Success";
        $new_amount = $cleared_balance - $withdraw_amount;
        $previous_balance = $cleared_balance;

    //UPDATE CUSTOMER ACCOUNT

          $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
          $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
          $pw->execute();
          $pw->close();

          //INSERT INTO TRANSACTION TABLE
          if ($has_teller == 1) {
            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $withdraw_amount, $type, $description, $withdraw_transaction_date, $value_date, $withdraw_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $teller_id);
            $w->execute();
            $last_id = mysqli_insert_id($db);

            $saving_reference = $tl_gl;


                $rup = $db->prepare("UPDATE teller_balances SET balance=? WHERE id=?");
                $rup->bind_param('di', $fundteller_amount, $teller_id);
                $rup->execute();
                $rup->close();


          } else {
            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $withdraw_amount, $type, $description, $withdraw_transaction_date, $value_date, $withdraw_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1);
            $w->execute();
            $last_id = mysqli_insert_id($db);
          }

        $entity_id = "TRR$last_id";

        //INSERT INTO ACTIVITY TABLE
        $act_dsc = "Funds Withdrawal from customer account";
        $act_type = "Withdrawal";
        $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
        $ww->execute();

        if ($product_type=="Savings" || $product_type=="Current" || $product_type=="Thrift" || $product_type=="Float") {
        //INSERT INTO JOURNAL
        $crd_gl = -$withdraw_amount;
        $journal_date = $value_date;
        $journal_type = "Automatic";
        $journal_description = "Funds Withdrawal from customer account";
        $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        $jn->bind_param("iddiiiissss", $last_id, $crd_gl, $withdraw_amount, $saving_reference, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
        $jn->execute();
        
        } else if ($product_type=="Term Deposit") {
        //
        //INSERT INTO JOURNAL
        $crd_gl = -$withdraw_amount;
        $journal_date = $value_date;
        $journal_type = "Automatic";
        $journal_description = "Funds Withdrawal from customer account";
        $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        $jn->bind_param("iddiiiissss", $last_id, $crd_gl, $withdraw_amount, $saving_control, $saving_reference, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
        $jn->execute();
        
        } else if ($product_type=="Share") {
            $product2 = str_replace("SH","","$product");
        }

        //DEDUCT ALL APPLICABLE CHARGES
        if($charge_sms == 1) {

            $yui = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
            $yui -> bind_param('i', $account_id);
            $yui -> execute();
            $ryui = $yui->get_result();
            while($io = mysqli_fetch_array($ryui) ){
                $alert_phone = $io['phone_no'];
            }

    //DO ALL SHORTCODE REPLACEMENTS
    $dst_account = "**".substr($account_number, -4);
    $message = str_replace("[accountNo]",$dst_account,$message);
    $message = str_replace("[fname]",$fname,$message);
    $message = str_replace("[lname]",$lname,$message);
    $message = str_replace("[mname]",$mname,$message);
    $message = str_replace("[vdate]",$value_date,$message);
    $message = str_replace("[adate]",$withdraw_transaction_date,$message);
    $message = str_replace("[amount]",number_format($withdraw_amount, 2, '.', ','),$message);
    $message = str_replace("[balance]",number_format($new_amount, 2, '.', ','),$message);
    $message = str_replace("[trbranch]",$customer_branch,$message);
    

    //SEND TO EGIS SERVICES FOR SENDING SMS HERE

    $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);

    $ch1 = curl_init();
    curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
    curl_setopt($ch1, CURLOPT_POST, 1);
    curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);

    $headers1 = [
    'Content-Type: application/json'
    ];

    curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);

    $request1 = curl_exec ($ch1);

    curl_close ($ch1);
    if ($request1) {
    $result1 = json_decode($request1, true);
    }
        
    $token = $result1['token'];

    $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone, 'message' => $message);

    $ch3 = curl_init();
    curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/sms.php");
    curl_setopt($ch3, CURLOPT_POST, 1);
    curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
    curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
    //Set your auth headers
    curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Authorization: Bearer ' . $token
    ));

    // get stringified data/output. See CURLOPT_RETURNTRANSFER
    $data1 = curl_exec($ch3);

    //$decode1 = json_decode($data1);

        $charge_tl1 = "Withdrawal Fee";
        $charge_tl2 = "Single SMS Fee";
        //$charge_tl4 = "Email Fee";
        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE active=? AND chargetype =? OR chargetype =?)');
        $incr -> bind_param('ssss', $product, $yes, $charge_tl1, $charge_tl2);
        $incr -> execute();
        $rincr = $incr->get_result();
        } else {
        $charge_tl1 = "Withdrawal Fee";
        //$charge_tl2 = "Single SMS Fee";
        //$charge_tl4 = "Email Fee";
        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
        $incr -> bind_param('sss', $product, $charge_tl1, $yes);
        $incr -> execute();
        $rincr = $incr->get_result();
        }
                    if($rincr->num_rows > 0) {

                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source = $fr['funding_source'];
                        }

                        foreach ($rincr as $iid):
                        
                        $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                        $de -> bind_param('i', $iid['cid']);
                        $de -> execute();
                        $rde = $de->get_result();
                        while($dee = mysqli_fetch_array($rde) ){
                        //Call Charge Amount
                        $trnsss_amount = $withdraw_amount;
                        $chid = $iid['cid'];
                        include('../../charges.php');
                        //End Call Charge Amount
                        $charge_name = $dee['name'];
                        $charge_option = $dee['charge_option'];
                        $triggertype = $dee['triggertype'];
                        $chargetype = $dee['chargetype'];
                        }

                        $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                        $set -> bind_param('ss', $product, $iid['cid']);
                        $set -> execute();
                        $rset = $set->get_result();
                        while($rrt = mysqli_fetch_array($rset) ){
                            $income_acc = $rrt['income_acc'];
                        }

                            $cb = $db -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                            $cb -> bind_param('s', $account_number);
                            $cb -> execute();
                            $rcb = $cb->get_result();
    
                            while($rbb = mysqli_fetch_assoc($rcb) ){
                            $cleared_bal = $rbb["cleared_balance"];
                            }

                        if ($charge_option != "Flat") {
                            $charge_amount = $withdraw_amount * ($charge_amount/100);
                        }
                        if ($triggertype == "Per Transaction" && $charge_amount >0) {
                            
                            $value_date = date("Y-m-d H:i:s");
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;
    
                            $new_amount_c = $cleared_bal - $charge_amount;
    
                            $description_c = "$charge_name";
                            $type_c = "Debit";
        
                            $debit_comment = "$charge_name";
    
                            $transaction_id_c = "D$cu_character" . "$orderId";
    
                            //INSERT CHARGES INTO TRANSACTION TABLE
                            $wc = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $account_number, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                            $wc->execute();
                            $last_id_c = mysqli_insert_id($db);
    
                            $entity_id_c = "TRR$last_id_c";
    
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "$charge_name debit from customer account";
                            $act_type = "Debit";
                            $wwc = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $usbrn, $channel_log);
                            $wwc->execute();
    
                            $crd_gl1 = -$charge_amount;
                            $journal_description = "$charge_name";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
    
                            $upd = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $upd->bind_param('ds', $new_amount_c, $account_number);
                            $upd->execute();
                            } else {
                                //INSERT CHARGE INTO TEM CHARGES TABLE
                                if($charge_amount>0) {
                                $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                $inch->bind_param("sdss", $account_number, $charge_amount, $charge_name, $triggertype);
                                $inch->execute();
                                }

                                $new_amount_c = $new_amount;
                            }

                            //DO SMS INTEGRATION
                            if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                $biz_rule = "Charge Deducted";
                                $brn = $customer_branch;
                                $rm = $customer_rm;
                                $pg = $productGroup;
                                $account_id = $account_id;
                                $account_no = $account_number;
                                $vdate = $value_date;
                                $tdate = $transaction_date;
                                $tamount = $charge_amount;
                                $cb = $new_amount_c;

                                include_once("sms_int.php");
                            }
    
                            endforeach;
                        }


            //UPDATE WORK QUEUE STATUS

            //UPDATE WORKFLOW TRANSACTION
            $update = "Approved";

            $io = $db->prepare("UPDATE verify_transactions SET status=? WHERE id=?");
            $io->bind_param('si', $update, $verify_id);
            $io->execute();
            $io->close();

            $ent_id = 41;
            $act_id = 40;
            $wfcheck = $db -> prepare('SELECT * FROM work_queue WHERE main_area_id=? AND entity_id=? AND action_id=?');
            $wfcheck -> bind_param('iii', $verify_id, $ent_id, $act_id);
            $wfcheck -> execute();
            $rwfcheck = $wfcheck->get_result();

            if ($rwfcheck->num_rows > 0) {

                $new_status = "Treated";

                $updwk = $db->prepare("UPDATE work_queue SET status=?, $by=? WHERE main_area_id=? AND entity_id=? AND action_id=?");
                $updwk->bind_param('siiii', $new_status, $aid, $verify_id, $ent_id, $act_id);
                $updwk->execute(); 
            }

        }   
    } 

}//END WITHDRAW


//REPAYMENT TRANSACTION FUNCTION
function approveRepayment($by, $verify_id, $br_start_date, $action, $db, $repay_amount, $repay_comment, $customer_id, $account_number, $value_date, $maintenance, $login_session_expiry, $org_code, $egis_api, $egis_secret, $egis_transfers, $site_name, $egis_api_root, $is_sms_active, $is_email, $offline_id, $site_domain, $long_name) {
    include('../welcome_user.php');
    $onee = 1;
    $rev = "X";
    $_SESSION['msg1'] = "";

        $pod = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
        $pod -> bind_param('is', $customer_id, $account_number);
        $pod -> execute();
        $rpod = $pod->get_result();

        while($row = mysqli_fetch_assoc($rpod) ){
            $account_id = $row['id'];
            $product_type = $row['product_type'];
            $cleared_balance = $row['cleared_balance'];
            $linked_savings_account = $row['linked_savings_account'];
            $product = $row['product'];
            $agreed_interest_rate = $row['agreed_interest_rate'];
            //$customer_branch = $row["secondary_branch"];
            $customer_rm = $row["secondary_relationship_manager"];
            $cu_creation_date = date('d-m-Y', strtotime($row['application_date']));
            $account_status = $row['status'];
            $sms_alert = $row["sms_alert"];
            $email_alert = $row["email_alert"];
            $currency = $row["currency"];
            $dva_account = $row['dva_account'];
        }
 //GET INITIATOR BRANCH
 $ovr = $db -> prepare('SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?)');
 $ovr -> bind_param('i', $verify_id);
 $ovr -> execute();
 $rovr = $ovr->get_result();

 while($iov = mysqli_fetch_assoc($rovr) ){
     $customer_branch = $iov['branch'];
 }

        //CHECK WAIVER POLICY
$active = "Active";
    

$pty = "Loan Account";
$tpd = $product;
$nm = "Interest Waiver";



$crpnd = $db -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
$crpnd->bind_param("sss", $pty, $active, $nm);
$crpnd -> execute();
$rcrpnd = $crpnd->get_result();
if ($rcrpnd->num_rows > 0) {
//$proceed = 0;
while($jvx = mysqli_fetch_assoc($rcrpnd) ){ 
    $days_to_due= $jvx["days_to_due"];

    if(strpos($jvx['affected_products'], ' , ') !== false) {
        // explodable
        $productssarray = explode(' , ',$jvx['affected_products']);

      } else {
        // not explodable
        $productssarray = array($jvx['affected_products']);

      }

      if(strpos($jvx['channels'], ' , ') !== false) {
        // explodable
        $channelsarray = explode(' , ',$jvx['channels']);

      } else {
        // not explodable
        $channelsarray = array($jvx['channels']);

      }

      if(strpos($jvx['affected_branches'], ' , ') !== false) {
        // explodable
        $brancharray = explode(' , ',$jvx['affected_branches']);

      } else {
        // not explodable
        $brancharray = array($jvx['affected_branches']);

      }

        if (in_array($tpd, $productssarray) && in_array($channel_log, $channelsarray) && in_array($customer_branch, $brancharray)) {
            
           $waive = 1;
         } else {
             $waive = 0;
         }
}
} else {
$waive = 0;
}

        //CHECK IF USER HAS TELLER

    $tty="Teller";
    $seltl = $db -> prepare('SELECT * FROM teller_balances WHERE user_id IN(SELECT created_by FROM verify_transactions WHERE id=?) AND type=? AND currency=?');
    $seltl->bind_param("iss", $verify_id, $tty, $currency);
    $seltl->execute();
    $rseltl = $seltl->get_result();

    if($rseltl->num_rows > 0) {
        while($tlb = mysqli_fetch_assoc($rseltl) ){
            $teller_id = $tlb["id"];
            $tl_balance = $tlb["balance"];
            $tl_gl = $tlb["gl"];
            $tl_status = $tlb["status"];
        }

            $fundteller_amount = $tl_balance + $repay_amount;
            $has_teller=1;

            //Teller Limits
            $ovl = $db -> prepare('SELECT olimit, slimit, tlimit FROM config_tellers WHERE gl=?');
            $ovl -> bind_param('i', $tl_gl);
            $ovl -> execute();
            $rovl = $ovl->get_result();

            while ($lu = $rovl->fetch_array()) {
                $olimit = $lu['olimit'];
                $slimit = $lu['slimit'];
                $tlimit = $lu['tlimit'];
            }

            if ($fundteller_amount > $tlimit) {
                $tl_exceed = 1;//do not proceed, exceeds limit
            } else {
                $tl_exceed = 0;//proceed within limits
            }
        
    } else {
    $has_teller=0;
    }

    $tty1="Tellering";
    $seltl1 = $db -> prepare('SELECT * FROM branch WHERE operational_model=? AND id IN(SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?))');
    $seltl1->bind_param("si", $tty1, $verify_id);
    $seltl1->execute();
    $rseltl1 = $seltl1->get_result();

    if($rseltl1->num_rows > 0) {
        $tl_model=1;
        
    } else {
    $tl_model=0;
    }

    $product2 = str_replace("L","","$product");

$ttr = $db -> prepare("SELECT * FROM loanproduct WHERE id=?");
$ttr -> bind_param('i', $product2);
$ttr -> execute();
$rttr = $ttr->get_result();

    while($ps = mysqli_fetch_assoc($rttr) ){
        $transactionProcessingStrategy = $ps["transactionProcessingStrategy"];
        $fund_source = $ps['fund_source'];
        $loan_portfolio = $ps['loan_portfolio'];
        $income_for_interest = $ps['income_for_interest'];
        $automaticallyAllocateOverpayments = $ps['automaticallyAllocateOverpayments'];
        $productGroup = $ps['productGroup'];
        $debitChargesFromLinkedSavings = $ps['debitChargesFromLinkedSavings'];
}


    $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
    $pod1 -> bind_param('i', $customer_id);
    $pod1 -> execute();
    $rpod1 = $pod1->get_result();

    while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        $fname = $row1["fname"];
        $mname = $row1["mname"];
        $lname = $row1["lname"];
        $cu_character = strtoupper($customer_name[0]);
}

date_default_timezone_set("Africa/Lagos");
$repay_transaction_date = date("Y-m-d H:i:s");
$transaction_date = date("Y-m-d H:i:s");

$num = mt_rand(100000, 999999);
$stamp_all = date("Yhis");
$orderId = $stamp_all . $num;

$transaction_id = "R$cu_character" . "$orderId";

$description = "Repayment";
$type = "Credit";
$yes="Yes";
/*
//check if amount is more than total expected payment
$lsh1 = $db -> prepare("SELECT sum(expected_principal_interest) as total_expected FROM loan_schedule WHERE account_no=? AND customer_id=?");
$lsh1 -> bind_param('si', $account_number, $customer_id);
$lsh1 -> execute();
$rlsh1 = $lsh1->get_result();
    while($ssi1 = mysqli_fetch_assoc($rlsh1) ){
        $total_expected = $ssi1["total_expected"];
    }

//
$lsh2 = $db -> prepare("SELECT sum(settlled_principal_interest) as total_settlled FROM loan_schedule WHERE account_no=? AND customer_id=?");
$lsh2 -> bind_param('si', $account_number, $customer_id);
$lsh2 -> execute();
$rlsh2 = $lsh2->get_result();
    while($ssi2 = mysqli_fetch_assoc($rlsh2) ){
        $total_settlled = $ssi2["total_settlled"];
    }
    $total_balance = $total_expected - $total_settlled;
    */
    $today_date = date("Y-m-d");
    $total_balance = round($cleared_balance * -1);
    if ($waive == 1) {
        //CALCULATE WAIVE DATE
        if($days_to_due > 0) {
            $waive_date = date("Y-m-d", strtotime($today_date . "+ $days_to_due days"));
        } else {
            $waive_date = $today_date;
        }
    //SUM ALL OUTSTANDING PRINCIPAL
    $wvc = $db -> prepare("SELECT SUM(expected_principal)-SUM(settlled_principal) as p_expted FROM loan_schedule WHERE account_no=? AND customer_id=?");
    $wvc -> bind_param('si', $account_number, $customer_id);
    $wvc -> execute();
    $rwvc = $wvc->get_result();
        while($wv1 = mysqli_fetch_assoc($rwvc) ){
            $p_expted = $wv1["p_expted"];
        }
        /*
    //GET DUE INTEREST
    $gdi = $db -> prepare("SELECT SUM(expected_interest) AS not_due FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_interest < expected_interest AND expected_date >? ORDER BY id ASC");
    $gdi -> bind_param('sis', $account_number, $customer_id, $waive_date);
    $gdi -> execute();
    $rgdi = $gdi->get_result();
        while($gv1 = mysqli_fetch_assoc($rgdi) ){
            $not_due = $gv1["not_due"];
        }
        */
    $wvi = $db -> prepare("SELECT COALESCE(sum(l.due_interest),0) + (SELECT COALESCE(sum(l.expected_interest),0) from loan_schedule l where l.expected_date <=(CURRENT_DATE + INTERVAL ? day) and l.account_no=? and l.due_interest =0 and l.settlled_interest !=l.expected_interest) as duei FROM loan_schedule l where l.account_no=?");
    $wvi -> bind_param('iss', $days_to_due, $account_number, $account_number);
    $wvi -> execute();
    $rwvi = $wvi->get_result();
        while($wv1 = mysqli_fetch_assoc($rwvi) ){
            $i_expted = $wv1["duei"];
        }

        $t_expected_with_waiver = $p_expted + $i_expted;

        //overwrite total balance
        if($repay_amount >= $t_expected_with_waiver) {
            $total_balance = round($t_expected_with_waiver, 2);
        } else {
            $waive_date = $today_date;
            $waive=0;
        }
    } else {
        $waive_date = $today_date;
    }

    $cu_creation_date1 = strtotime($cu_creation_date) * 1000;
    $br_start_date1 = strtotime($br_start_date) * 1000;
    if($br_start_date1 < $cu_creation_date1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>You cannot do transactions on a date below account creation date.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($account_status != "Active" && $account_status != "Delinquent") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Account is not active. You are not allowed to transact on it.</h2>";
    } else if($tl_model == 1 && $has_teller == 0) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Branch is operating a teller model but user has no teller</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_status !="Open") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Repayment not allowed. Teller is not Open.</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_exceed ==1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Repayment not allowed. Teller limit of $currency $tlimit exceeded.</h2>";
    } else if($repay_amount > $total_balance && $automaticallyAllocateOverpayments == "No") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Overpayment isn't allowed. Please repay the exact loan balance.</h2>";
    } else {
         

            //UPDATE LOAN SCHEDULE TABLE
                        $bal_credit = $repay_amount - $total_balance;
                        if($repay_amount > $total_balance && $total_balance > 0 && $bal_credit > 0) {

                            
                            $sel = $db -> prepare("SELECT * FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();

                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                            
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }

                            $new_amount1 = $sav_cleared_bal + $bal_credit;
                            $previous_balance1 = $sav_cleared_bal;

                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();

                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;

                            $transaction_id1 = "C$cu_character" . "$orderId";

                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";

                            $rev = "X";
                            if($has_teller==1) { 
                            $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $x->bind_param("ssidddssssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                            $x->execute();
                            $last_id1 = mysqli_insert_id($db);

                            $dba = $tl_gl;
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddssssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $saving_reference;
                            }
                            $entity_id1 = "TRR$last_id1";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $usbrn, $channel_log);
                            $xx->execute();

                            $crd_gl = -$bal_credit;
                            //INSERT INTO JOURNAL
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id1, $crd_gl, $bal_credit, $saving_control, $dba, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
                            
                            //UPDATE LOAN BALANCE
                            $new_amount = $cleared_balance + $total_balance;
                            $previous_balance = $cleared_balance;
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiisii", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $offline_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                $dba = $tl_gl;
                                } else {
                                    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $offline_id);
                                    $w->execute();
                                    $last_id = mysqli_insert_id($db);

                                    $dba = $saving_control;
                                }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                            $act_type = "Loan Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                            $ww->execute();

                            $paing_amount = $total_balance;
                        } else if($repay_amount == $total_balance && $total_balance > 0) {

                            //UPDATE LOAN BALANCE
                            $new_amount = $cleared_balance + $total_balance;
                            $previous_balance = $cleared_balance;
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) { 
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiisii", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $offline_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $tl_gl;
                            } else {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $offline_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $saving_reference;
                            }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                            $act_type = "Loan Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                            $ww->execute();
                            $paing_amount = $total_balance;
                         }
                          else if($repay_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) {

                            $sel = $db -> prepare("SELECT * FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();

                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                            
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }

                            $new_amount1 = $repay_amount + $sav_cleared_bal;
                            $previous_balance1 = $sav_cleared_bal;

                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();

                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;

                            $transaction_id1 = "C$cu_character" . "$orderId";

                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";


                            if($has_teller==1) { 
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddsssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $repay_amount, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $tl_gl;
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddsssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $repay_amount, $type2, $description2, $repay_transaction_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);

                                $dba = $saving_reference;
                            }

                            $entity_id1 = "TRR$last_id1";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $usbrn, $channel_log);
                            $xx->execute();

                            //INSERT INTO JOURNAL
                            $crd_gl1 = -$repay_amount;
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id1, $crd_gl1, $repay_amount, $saving_control, $dba, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();

                            $paing_amount = 0;
                            
                        } else if($repay_amount < $total_balance && $total_balance > 0){

                            //UPDATE CUSTOMER ACCOUNT
                            $new_amount = $cleared_balance + $repay_amount;
                            $previous_balance = $cleared_balance;

                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();

                            //INSERT INTO TRANSACTIONS TABLE
                            if($has_teller==1) { 
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiisii", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $repay_amount, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $offline_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $tl_gl;
                            } else {
                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, offline_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $repay_amount, $type, $description, $repay_transaction_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $offline_id);
                                $w->execute();
                                $last_id = mysqli_insert_id($db);

                                //$dba = $saving_reference;
                            }

                            $entity_id = "TRR$last_id";

                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Loan repayment of $repay_amount for account number $account_number";
                            $act_type = "Repayment";
                            $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                            $ww->execute();
                            
                            $paing_amount = $repay_amount;
                        }

                        //for egis_credit check
                        $repayment_amount_egis = $paing_amount;
                        //end for egis credit check
                        //DO SMS INTEGRATION
                        $biz_rule = "Loan Repayed";
                        $brn = $customer_branch;
                        $rm = $customer_rm;
                        $pg = $productGroup;
                        $account_id = $account_id;
                        $account_no = $account_number;
                        $vdate = $value_date;
                        $tdate = $repay_transaction_date;
                        $tamount = $repay_amount;
                        $cb = $new_amount;

                        include("sms_int.php");

                        if (($repay_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) || ($repay_amount > $total_balance && $total_balance > 0 && $bal_credit > 0)) {
                            if($sms_alert_r == "Yes") {
                                $yui_c = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                $yui_c -> bind_param('i', $account_id_r);
                                $yui_c -> execute();
                                $ryui_c = $yui_c->get_result();
                                while($io_c = mysqli_fetch_array($ryui_c) ){
                                    $alert_phone_r = $io_c['phone_no'];
                                }

                                if ($repay_amount > $total_balance && $total_balance == 0) {
                                    $bal_credit = $repay_amount;
                                }
                                $lonacc = substr($account_number, -4);
                                $dst_account = substr($linked_savings_account, -4);
                                $message = "Acct:**[accountNo]
                                CR:N[amount]
                                Desc:LOAN OVER PAYMENT DEPOSIT**$lonacc
                                DT:[vdate]
                                Bal:[balance]CR";
                                $message = str_replace("[accountNo]",$dst_account,$message);
                                $message = str_replace("[vdate]",$value_date,$message);
                                $message = str_replace("[adate]",$repay_transaction_date,$message);
                                $message = str_replace("[amount]",number_format($bal_credit, 2, '.', ','),$message);
                                $message = str_replace("[balance]",number_format($new_amount1, 2, '.', ','),$message);
                                $message = str_replace("[trbranch]",$customer_branch,$message);
                        
                                //SEND TO EGIS SERVICES FOR SENDING SMS HERE
                        
                                $postdata4 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone_r, 'message' => $message);
                        
                                $ch4 = curl_init();
                                curl_setopt($ch4, CURLOPT_URL,"$egis_api_root/sms.php");
                                curl_setopt($ch4, CURLOPT_POST, 1);
                                curl_setopt($ch4, CURLOPT_POSTFIELDS,json_encode($postdata4));  //Post Fields
                                curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
                                //Set your auth headers
                                curl_setopt($ch4, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $token
                                ));
                        
                                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                $data2 = curl_exec($ch4);
                        
                                //$decode2 = json_decode($data2);

                                //CHECK IF CHARGE IS CONFIGURED AND PROCESS
                                $charge_text = "Single SMS Fee";
                                $ruo = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                                $ruo -> bind_param('sss', $product_s, $charge_text, $yes);
                                $ruo -> execute();
                                $rruo = $ruo->get_result();
                                if($rruo->num_rows > 0) {

                                    while($yii = mysqli_fetch_array($rruo) ){
                                        $ch_id = $yii['cid'];
                                    }

                                    $yd = $db -> prepare('SELECT * FROM charges WHERE id=?');
                                    $yd -> bind_param('i', $ch_id);
                                    $yd -> execute();
                                    $ryd = $yd->get_result();
                                    while($ydd = mysqli_fetch_array($ryd) ){
                                    //Call Charge Amount
                                    $trnsss_amount = $bal_credit;
                                    $chid = $ch_id;
                                    include('../../charges.php');
                                    //End Call Charge Amount
                                    $charge_name_s = $ydd['name'];
                                    $charge_option_s = $ydd['charge_option'];
                                    $triggertype_s = $ydd['triggertype'];
                                    }
                                    $charge_amount_s = $charge_amount; //deliberate from charges.php
                                    if ($charge_option_s != "Flat") {
                                        $charge_amount_s = $bal_credit * ($charge_amount_s/100);
                                    }

                                    $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                    $set -> bind_param('ss', $product_s, $ch_id);
                                    $set -> execute();
                                    $rset = $set->get_result();
                                    if ($rset->num_rows > 0) {
                                        while($rrt = mysqli_fetch_array($rset) ){
                                            $income_acc_s = $rrt['income_acc'];
                                        }
                                    }

                                    ////////
                                        if ($triggertype_s == "Per Transaction") {
                                        $final_balance = $new_amount1 - $charge_amount_s;
                                        $num_ls = mt_rand(100000, 999999);
                                        $stamp_ln = date("Yhis");
                                        $orderId_ln = $stamp_ln . $num_ls;

                                        $transaction_id_ln = "D$cu_character_ben" . "$orderId_ln";

                                        $description2 = "$charge_name_s";
                                        $type2 = "Debit";
                                        $charge_comment = "$charge_name_s";

                                        $rev = "X";
                                        $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $account_id_r, $newamount1, $final_balance, $charge_amount_s, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                        $xln->execute();
                                        $last_id_ln = mysqli_insert_id($db);
                                        $entity_id_ln = "TRR$last_id_ln";

                                        $crd_gl1 = -$charge_amount_s;
                                        $journal_description = "$charge_name_s";
                                        $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                        $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount_s, $income_acc_s, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                        $jn->execute();


                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "$charge_name_s";
                                        $act_type = "Fee";
                                        $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $usbrn, $channel_log);
                                        $xx->execute();

                                        $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                        $upd_s->bind_param('ds', $final_balance, $linked_savings_account);
                                        $upd_s->execute();
                                        } else {
                                            //INSERT CHARGE INTO TEM CHARGES TABLE
                                        $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                        $inch->bind_param("sdss", $linked_savings_account, $charge_amount_s, $charge_name_s, $triggertype_s);
                                        $inch->execute();
                                        }

                                }
                            }
                        }

                        //DEDUCT REPAYMENT CHARGES FROM LINKED SAVINGS ACCOUNT
                        //INSERT LOAN ACCOUNT CHARGES IF ANY
                        

                        if($charge_sms == 1) {
                            //$charge_tl1 = "Repayment Fee";
                            $charge_tl2 = "Single SMS Fee";
                            //$charge_tl4 = "Email Fee";
                            $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                            $incr -> bind_param('sss', $product, $charge_tl2, $yes);
                            $incr -> execute();
                            $rincr = $incr->get_result();
                        
                         if($rincr->num_rows > 0) {
        
        
                             foreach ($rincr as $iid):
                             
                             $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                             $de -> bind_param('i', $iid['cid']);
                             $de -> execute();
                             $rde = $de->get_result();
                             while($dee = mysqli_fetch_array($rde) ){
                             $ch_id = $dee['id'];
                             //Call Charge Amount
                            $trnsss_amount = $paing_amount;
                            $chid = $ch_id;
                            include('../../charges.php');
                            //End Call Charge Amount
                             $charge_name = $dee['name'];
                             $charge_option = $dee['charge_option'];
                             $triggertype = $dee['triggertype'];
                             $chargetype = $dee['chargetype'];
                             }

                             $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                            $set -> bind_param('ss', $product, $ch_id);
                            $set -> execute();
                            $rset = $set->get_result();
                            if ($rset->num_rows > 0) {
                                while($rrt = mysqli_fetch_array($rset) ){
                                    $income_acc = $rrt['income_acc'];
                                }
                            } else {
                            $set1 = $db -> prepare('SELECT income_acc FROM income_account_map_fees_receivable WHERE product_id=? AND fee=?');
                            $set1 -> bind_param('ss', $product, $ch_id);
                            $set1 -> execute();
                            $rset1 = $set1->get_result();
                            if ($rset1->num_rows > 0) {
                                while($rtt1 = mysqli_fetch_array($rset1) ){
                                    $income_acc = $rtt1['income_acc'];
                                }
                            } else {
                                $set2 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties WHERE product_id=? AND fee=?');
                                $set2 -> bind_param('ss', $product, $ch_id);
                                $set2 -> execute();
                                $rset2 = $set2->get_result();
                                if ($rset2->num_rows > 0) {
                                    while($rtt2 = mysqli_fetch_array($rset2) ){
                                        $income_acc = $rtt2['income_acc'];
                                    }
                                } else {

                                    $set3 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_receivable WHERE product_id=? AND fee=?');
                                    $set3 -> bind_param('ss', $product, $ch_id);
                                    $set3 -> execute();
                                    $rset3 = $set3->get_result();
                                    if ($rset3->num_rows > 0) {
                                        while($rtt3 = mysqli_fetch_array($rset3) ){
                                            $income_acc = $rtt3['income_acc'];
                                        }
                                    } else {
                                        $set4 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended WHERE product_id=? AND fee=?');
                                        $set4 -> bind_param('ss', $product, $ch_id);
                                        $set4 -> execute();
                                        $rset4 = $set4->get_result();
                                        if ($rset4->num_rows > 0) {
                                            while($rtt4 = mysqli_fetch_array($rset4) ){
                                                $income_acc = $rtt4['income_acc'];
                                            }
                                        } else {
                                            $set5 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl WHERE product_id=? AND fee=?');
                                            $set5 -> bind_param('ss', $product, $ch_id);
                                            $set5 -> execute();
                                            $rset5 = $set5->get_result();
                                            if ($rset5->num_rows > 0) {
                                                while($rtt5 = mysqli_fetch_array($rset5) ){
                                                    $income_acc = $rtt5['income_acc'];
                                                }
                                            } else {
                                                $set6 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl_2 WHERE product_id=? AND fee=?');
                                                $set6 -> bind_param('ss', $product, $ch_id);
                                                $set6 -> execute();
                                                $rset6 = $set6->get_result();
                                                if ($rset6->num_rows > 0) {
                                                    while($rtt6 = mysqli_fetch_array($rset6) ){
                                                        $income_acc = $rtt6['income_acc'];
                                                    }
                                                } else {
                                                    $set7 = $db -> prepare('SELECT income_acc FROM income_account_map_suspended_fee WHERE product_id=? AND fee=?');
                                                    $set7 -> bind_param('ss', $product, $ch_id);
                                                    $set7 -> execute();
                                                    $rset7 = $set7->get_result();
                                                    if ($rset7->num_rows > 0) {
                                                        while($rtt7 = mysqli_fetch_array($rset7) ){
                                                            $income_acc = $rtt7['income_acc'];
                                                        }
                                                    } else {
                            
                                                    }
                                                }
                                            }
                                        }
            
                                    }
        
                                }
                            }
                        }

                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source = $fr['funding_source'];
                        }
        
                             if ($charge_option != "Flat") {
                                 $charge_amount = $paing_amount * ($charge_amount/100);
                             }

                             if ($debitChargesFromLinkedSavings == "Yes") {

                                //CHARGE LINKED SAVINGS ACCOUNT
                                 //FOR CHARGE DEDUCTION IF SET TO CHARGE FROM LINKED SAVINGS ACCOUNT
                                    $lsa = $db -> prepare("SELECT * FROM accounts WHERE account_number IN (SELECT linked_savings_account FROM accounts WHERE id=?)");
                                    $lsa->bind_param("i", $account_id);
                                    $lsa->execute();
                                    $rlsa = $lsa->get_result();
                                    while($wp = mysqli_fetch_array($rlsa) ){
                                        $linked_savings_account_id = $wp["id"];
                                        $linked_savings_cleared_balance = $wp["cleared_balance"];
                                        $linked_savings_account = $wp["account_number"];
                                        $linked_savings_account_customer_id = $wp["customer_id"];
                                        $linked_savings_account_product = $wp["product"];
                                    }
                                    $linked_savings_account_product2 = str_replace("S","","$linked_savings_account_product");

                                    $sc_ln = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                                    $sc_ln -> bind_param('i', $linked_savings_account_product2);
                                    $sc_ln -> execute();
                                    $rsc_ln = $sc_ln->get_result();
                                        while($sc1_ln = mysqli_fetch_array($rsc_ln) ){
                                            $linked_savings_saving_control = $sc1_ln['saving_control'];
                                            $linked_savings_product_group = $sc1_ln['productGroup'];
                                        }

                                    if ($triggertype == "Per Transaction" && $charge_amount >0) {
                                    $new_linked_savings = $linked_savings_cleared_balance - $charge_amount;
                                    $num_ls = mt_rand(100000, 999999);
                                    $stamp_ln = date("Yhis");
                                    $orderId_ln = $stamp_ln . $num_ls;

                                    $transaction_id_ln = "D$cu_character" . "$orderId_ln";

                                    $description2 = "$charge_name";
                                    $type2 = "Debit";
                                    $charge_comment = "$charge_name";

                                    
                                    $rev = "X";
                                    $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $linked_savings_account_customer_id, $linked_savings_cleared_balance, $new_linked_savings, $charge_amount, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                    $xln->execute();
                                    $last_id_ln = mysqli_insert_id($db);
                                    $entity_id_ln = "TRR$last_id_ln";

                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount, $income_acc, $linked_savings_saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();


                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "$charge_name";
                                    $act_type = "Fee";
                                    $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $usbrn, $channel_log);
                                    $xx->execute();

                                    $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                    $upd_s->bind_param('ds', $new_linked_savings, $linked_savings_account);
                                    $upd_s->execute();
                                    } else {
                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                        if($charge_amount>0) {
                                       $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                       $inch->bind_param("sdss", $linked_savings_account, $charge_amount, $charge_name, $triggertype);
                                       $inch->execute();
                                        }

                                       $new_linked_savings = $linked_savings_cleared_balance;
                                    }

                                    //DO SMS INTEGRATION
                                    if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                        $biz_rule = "Charge Deducted";
                                        $brn = $customer_branch;
                                        $rm = $customer_rm;
                                        $pg = $linked_savings_product_group;
                                        $account_id = $linked_savings_account_id;
                                        $account_no = $linked_savings_account;
                                        $vdate = $value_date;
                                        $tdate = $transaction_date;
                                        $tamount = $charge_amount;
                                        $cb = $new_linked_savings;

                                        include_once("sms_int.php");
                                    }
                            
                            } else {
                                
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id, $crd_gl1, $charge_amount, $income_acc, $funding_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();
                                             

                            }
                        endforeach;
                        }
                    }
                        $waive_amount = 0;
                        $update_principal_jornal = 0;
                        $update_interest_jornal = 0;
                        $update_principal_interest_jornal = 0;

                        $zero = 0;
                        $ggt = $db -> prepare("SELECT * FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_principal_interest != expected_principal_interest ORDER BY id ASC");
                        $ggt -> bind_param('si', $account_number, $customer_id);
                        $ggt -> execute();
                        $rggt = $ggt->get_result();
                        
                            foreach ($rggt as $ick):

                                $wv_amt = 0;
                                $update_id = 0;
                                $expected_interest = 0;
                                $expected_principal = 0;
                                $expected_principal_interest = 0;
                                $settlled_interest = 0;
                                $settlled_principal = 0;
                                $settlled_principal_interest = 0;
                                $due_interest = 0;
                                $due_principal = 0;
                                $due_principal_interest = 0;
                                $expected_date = "";
    
                                $sp2 = 0;
                                $si2 = 0;
                                $spi2 = 0;

                                $update_id = $ick["id"];
                                $expected_interest = $ick["expected_interest"];
                                $expected_principal = $ick["expected_principal"];
                                $expected_principal_interest = $ick["expected_principal_interest"];
                                $settlled_interest = $ick["settlled_interest"];
                                $settlled_principal = $ick["settlled_principal"];
                                $settlled_principal_interest = $ick["settlled_principal_interest"];
                                $due_interest = $ick["due_interest"];
                                $due_principal = $ick["due_principal"];
                                $due_principal_interest = $ick["due_principal_interest"];
                                $expected_date = $ick["expected_date"];
    
                                $sp2 = $ick["settlled_principal"];
                                $si2 = $ick["settlled_interest"];
                                $spi2 = $ick["settlled_principal_interest"];

                           /* $lsh = $db -> prepare("SELECT * FROM loan_schedule WHERE id=? ORDER BY id ASC");
                            $lsh -> bind_param('i', $ick["id"]);
                            $lsh -> execute();
                            $rlsh = $lsh->get_result();

                            while($lon = mysqli_fetch_assoc($rlsh) ){

                                $update_id = $lon["id"];
                                $expected_interest = $lon["expected_interest"];
                                $expected_principal = $lon["expected_principal"];
                                $expected_principal_interest = $lon["expected_principal_interest"];
                                $settlled_interest = $lon["settlled_interest"];
                                $settlled_principal = $lon["settlled_principal"];
                                $settlled_principal_interest = $lon["settlled_principal_interest"];
                                $due_interest = $lon["due_interest"];
                                $due_principal = $lon["due_principal"];
                                $due_principal_interest = $lon["due_principal_interest"];
                                $expected_date = $lon["expected_date"];
    
                                $sp2 = $lon["settlled_principal"];
                                $si2 = $lon["settlled_interest"];
                                $spi2 = $lon["settlled_principal_interest"];
    
                                }*/


                                    //APPLY TRANSACTION PROCESSING STRATEGY
                                    if ($transactionProcessingStrategy == "Custom for LARDI") {
                                        $strange_calc = ($agreed_interest_rate/100) +1;

                                        $deduct_principal = $paing_amount/$strange_calc;
                                        $deduct_interest = $paing_amount - $deduct_principal;
                                    }
                                    if ($paing_amount >0) {

                                        $principal_to_pay = $expected_principal - $settlled_principal;
                                        $interest_to_pay = $expected_interest - $settlled_interest;
                                        if ($transactionProcessingStrategy == "Penalties, Fees, Interest, Principal Order") {
                                            //
    
                                        } else if ($transactionProcessingStrategy == "Custom for LARDI") {
                                            //

                                            if ($deduct_principal >= $principal_to_pay && $principal_to_pay >0) {
                                                
                                                $settlled_principal = $settlled_principal + $principal_to_pay;

                                                $deduct_principal = $deduct_principal - $principal_to_pay;
                                                
                                                
                                            } else if ($deduct_principal < $principal_to_pay && $principal_to_pay >0 && $deduct_principal >0) {
                                                    $settlled_principal = $settlled_principal + $deduct_principal;
                                                    $deduct_principal = $deduct_principal - $deduct_principal;
                                                
                                            }

                                            if ($deduct_interest > 0 && $deduct_interest>= $interest_to_pay && $interest_to_pay > 0) {

                                                    $settlled_interest = $settlled_interest + $interest_to_pay;
                                                    
                                                        if($waive == 1 && $expected_date > $waive_date) {
                                                            $deduct_interest = $deduct_interest;
                                                            $is_wave = 2;
                                                            $si2 = $si2 + $interest_to_pay;
                                                            $waive_amount = $waive_amount + $interest_to_pay;
                                                            $wv_amt = $wv_amt + $interest_to_pay;
                                                        } else {
                                                            $deduct_interest = $deduct_interest - $interest_to_pay;
                                                            $is_wave = NULL;
                                                        }

                                                
                                            } else if ($deduct_interest > 0 && $deduct_interest < $interest_to_pay && $interest_to_pay > 0) {
                                            
                                                    $settlled_interest = $settlled_interest + $deduct_interest;

                                                    if($waive == 1 && $expected_date > $waive_date) {
                                                        $deduct_interest = $deduct_interest;
                                                        $is_wave = 2;
                                                        $si2 = $si2 + $deduct_interest;
                                                        $waive_amount = $waive_amount + $deduct_interest;
                                                        $wv_amt = $wv_amt + $deduct_interest;
                                                    } else {
                                                        $deduct_interest = $deduct_interest - $deduct_interest;
                                                        $is_wave = NULL;
                                                    }
                                            }
                                            $paing_amount = $deduct_principal + $deduct_interest;
    
                                        } else if ($transactionProcessingStrategy == "Principal, Interest, Penalties, Fees  Order") {
    
                                            if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {
    
                                                $settlled_principal = $settlled_principal + $principal_to_pay;
    
                                                $paing_amount = $paing_amount - $principal_to_pay;
                                                
                                                
                                            } else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                                    $settlled_principal = $settlled_principal + $paing_amount;
                                                    $paing_amount = $paing_amount - $paing_amount;
                                                
                                            }
    
                                            if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                                    $settlled_interest = $settlled_interest + $interest_to_pay;
                                                    
                                                        if($waive == 1 && $expected_date > $waive_date) {
                                                            $paing_amount = $paing_amount;
                                                            $is_wave = 2;
                                                            $si2 = $si2 + $interest_to_pay;
                                                            $waive_amount = $waive_amount + $interest_to_pay;
                                                            $wv_amt = $wv_amt + $interest_to_pay;
                                                        } else {
                                                            $paing_amount = $paing_amount - $interest_to_pay;
                                                            $is_wave = NULL;
                                                        }
                                                
                                            } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                               
                                                    $settlled_interest = $settlled_interest + $paing_amount;

                                                    if($waive == 1 && $expected_date > $waive_date) {
                                                        $paing_amount = $paing_amount;
                                                        $is_wave = 2;
                                                        $si2 = $si2 + $paing_amount;
                                                        $waive_amount = $waive_amount + $paing_amount;
                                                        $wv_amt = $wv_amt + $paing_amount;
                                                    } else {
                                                        $paing_amount = $paing_amount - $paing_amount;
                                                        $is_wave = NULL;
                                                    }

                                            }
                                           // echo "$paing_amount - $settlled_principal-a</br>";
                                    
                                            } else if ($transactionProcessingStrategy == "Interest, Principal, Penalties, Fees  Order") {
                                                if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                                    $settlled_interest = $settlled_interest + $interest_to_pay;
                                                    
                                                        if($waive == 1 && $expected_date > $waive_date) {
                                                            $paing_amount = $paing_amount;
                                                            $is_wave = 2;
                                                            $si2 = $si2 + $interest_to_pay;
                                                            $waive_amount = $waive_amount + $interest_to_pay;
                                                            $wv_amt = $wv_amt + $interest_to_pay;
                                                        } else {
                                                            $paing_amount = $paing_amount - $interest_to_pay;
                                                            $is_wave = NULL;
                                                        }
                                                
                                            } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                               
                                                    $settlled_interest = $settlled_interest + $paing_amount;

                                                    if($waive == 1 && $expected_date > $waive_date) {
                                                        $paing_amount = $paing_amount;
                                                        $is_wave = 2;
                                                        $si2 = $si2 + $paing_amount;
                                                        $waive_amount = $waive_amount + $paing_amount;
                                                        $wv_amt = $wv_amt + $paing_amount;
                                                    } else {
                                                        $paing_amount = $paing_amount - $paing_amount;
                                                        $is_wave = NULL;
                                                    }

                                            }
    
                                            if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {
    
                                                $settlled_principal = $settlled_principal + $principal_to_pay;

    
                                                $paing_amount = $paing_amount - $principal_to_pay;
                                                
                                                
                                            } else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                                    $settlled_principal = $settlled_principal + $paing_amount;
                                                    $paing_amount = $paing_amount - $paing_amount;

                                                
                                            }

                                        }
                                          
                                          
                                           
                                            
                                            $due_principal = $expected_principal - $settlled_principal;
                                            $due_interest = $expected_interest - $settlled_interest;
                                            $settlled_principal_interest = $settlled_principal + $settlled_interest;

                                            
                                                $due_principal_interest = $due_principal + $due_interest;

                                            $update_principal_jornal += $settlled_principal - $sp2;
                                            $update_interest_jornal += $settlled_interest - $si2;
                                            $update_principal_interest_jornal += $settlled_principal_interest - $spi2;

                                            
                                            

                                            if($due_principal <1) {
                                                $due_principal = 0;
                                            }
                                            if($due_interest <1) {
                                                $due_interest = 0;
                                            }
                                            if($due_principal_interest <1) {
                                                $due_principal_interest = 0;
                                            }

                                            //REMOVE ANY UNNECESSARY FRACTIONS
                                            $check_diff = $expected_principal_interest - $settlled_principal_interest;
                                            
                                            $today = date("Y-m-d");
                                            if($expected_date > $today) {
                                                $due_principal_interest = 0;
                                                $due_principal= 0;
                                                $due_interest = 0;
                                            }

                                            if ($check_diff <= 0.009) {
                                                $settlled_principal_interest = $expected_principal_interest;
                                                $settlled_principal = $expected_principal;
                                                $settlled_interest = $expected_interest;
                                                $due_principal_interest = 0;
                                                $due_principal= 0;
                                                $due_interest = 0;
                                            }

                                            
                                            $d1 = date("Y-m-d", strtotime($today_date));
                                            $d2 = date("Y-m-d", strtotime($expected_date));
                                            $difference = strtotime($d2) - strtotime($d1);
                                            $diff = $difference/(60 * 60)/24;
                                            if($diff > 0) {
                                                $settlled_status = "E";
                                            } else if($diff == 0) {
                                                $settlled_status = "A";
                                            } else {
                                                $settlled_status = "L";
                                            }

                
                                            
                                            if($waive == 1) {
                                                $due_principal_interest = 0;
                                                $due_principal = 0;
                                                $due_interest = 0;
                                                $ls = $db->prepare("UPDATE loan_schedule SET settlled_principal=expected_principal, settlled_interest=expected_interest, settlled_principal_interest=expected_principal_interest, due_principal=?, due_interest=?, due_principal_interest=?, transaction_id=?, interest_status=?, settlled_date=?, settlled_status=?, days_difference=? WHERE id=?");
                                               // echo 'prepare error: ', $db->error, PHP_EOL;
                                                $ls->bind_param('dddiissii', $due_principal, $due_interest, $due_principal_interest, $last_id, $is_wave, $today_date, $settlled_status, $diff, $update_id);
                                                $ls->execute();

                                                $bxa = $db->prepare("INSERT INTO schedule_reverse (shid, tid) VALUES (?,?)");
                                                $bxa->bind_param("ii", $update_id, $last_id);
                                                $bxa->execute();

    
                                                $update_interest_jornal = $i_expted;
                                                $update_principal_interest_jornal = $t_expected_with_waiver;
                                                
    
                                                } else {
                                                    $ls = $db->prepare("UPDATE loan_schedule SET settlled_principal=?, settlled_interest=?, settlled_principal_interest=?, due_principal=?, due_interest=?, due_principal_interest=?, transaction_id=?, interest_status=?, settlled_date=?, settlled_status=?, days_difference=? WHERE id=?");
                                                    // echo 'prepare error: ', $db->error, PHP_EOL;
                                                     $ls->bind_param('ddddddiissii', $settlled_principal, $settlled_interest, $settlled_principal_interest, $due_principal, $due_interest, $due_principal_interest, $last_id, $is_wave, $today_date, $settlled_status, $diff, $update_id);
                                                     $ls->execute();

                                                    $bxa = $db->prepare("INSERT INTO schedule_reverse (shid, tid) VALUES (?,?)");
                                                    $bxa->bind_param("ii", $update_id, $last_id);
                                                    $bxa->execute();

         
                                                    $bk_principal = $settlled_principal - $sp2;
                                                    $bk_interest = $settlled_interest - $si2;
                                                    $bk_principal_interest = $settlled_principal_interest -  $spi2;
     
         
                                                     $ch = $db->prepare("INSERT INTO loan_schedule_backup (schedule_id, last_paid_principal, last_paid_interest, last_paid_principal_interest, waived_interest) VALUES (?,?,?,?,?)");
                                                     $ch->bind_param("idddd", $update_id, $bk_principal, $bk_interest, $bk_principal_interest, $wv_amt);
                                                     $ch->execute();
                                                }
                                        }

                        //}
                            endforeach;                            

                            if($has_teller==1) { 
                                $fund_source = $tl_gl;


                                    $rup = $db->prepare("UPDATE teller_balances SET balance=? WHERE id=?");
                                    $rup->bind_param('di', $fundteller_amount, $teller_id);
                                    $rup->execute();
                                    $rup->close();
            
                            }

                            $today_date = date("Y-m-d");
                            $today = date("Y-m-d");


                            if ($update_principal_jornal > 0) {

                                            $crd_gl2 = -$update_principal_jornal;
                                            $journal_date = $value_date;
                                            $journal_type = "Automatic";
                                            $journal_description = "Loan Repayment";
                                            $jn1 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                            $jn1->bind_param("iddiiiissss", $last_id, $crd_gl2, $update_principal_interest_jornal, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                            $jn1->execute();

                            }
                            if ($update_interest_jornal > 0) {
                                            $crd_gl3 = -$update_interest_jornal;
                                            $journal_date = $value_date;
                                            $journal_description = "Loan Interest";
                                            if($update_principal_jornal == 0) {
                                                $fs = $update_interest_jornal;
                                            } else {
                                            $fs = 0;
                                            }
                                            $jn2 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                            $jn2->bind_param("iddiiiissss", $last_id, $crd_gl3, $fs, $income_for_interest, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                            $jn2->execute();
                            }

                            //CLOSE ACCOUNT IF BALANCE IS ZERO
                            $cld = $db -> prepare('SELECT * FROM accounts WHERE account_number=? AND customer_id=?');
                            $cld -> bind_param('si', $account_number, $customer_id);
                            $cld -> execute();
                            $rcld = $cld->get_result();

                            while($cl = mysqli_fetch_assoc($rcld) ){

                                $acc_balance = $cl['cleared_balance'];

                            }

                            if ($waive == 1) {

                                $acc_balance = 0;

                            }
                            $zero = 0;
                            if ($acc_balance *-1 < 1) {
                                $clooo = "Closed";
                               
                                $io = $db->prepare("UPDATE accounts SET status=?, cleared_balance=?, closed_date=? WHERE customer_id=? AND account_number=?");
                                $io->bind_param('sdsis', $clooo, $zero, $value_date, $customer_id, $account_number);
                                $io->execute();
                                $io->close();
                                if ($io) {
                                $clo = $db->prepare("UPDATE loan_schedule SET due_principal=?, due_interest=?, due_principal_interest=? WHERE account_no=?");
                                $clo->bind_param('ddds', $zero, $zero, $zero, $account_number);
                                $clo->execute();
                                $clo->close();

                                $clo1 = $db->prepare("UPDATE loan_schedule SET settlled_principal=expected_principal, settlled_interest=expected_interest, settlled_principal_interest=expected_principal_interest WHERE account_no=? AND settlled_principal_interest<expected_principal_interest");
                                $clo1->bind_param('s', $account_number);
                                $clo1->execute();
                                $clo1->close();

                                //DELETE REPAYMENT BACKUP FOR REVERSALS
                                $dl5 = $db->prepare("DELETE FROM schedule_reverse WHERE shid IN(SELECT id FROM loan_schedule WHERE loan_id=?)");
                                $dl5->bind_param("i", $account_id);
                                $dl5->execute();

                                $dlbk = $db->prepare("DELETE FROM loan_schedule_backup WHERE schedule_id IN(SELECT id FROM loan_schedule WHERE loan_id=?)");
                                $dlbk->bind_param("i", $account_id);
                                $dlbk->execute();

                                //UPDATE LOCKED SAVINGS TO 0 IF ANY FOR THIS LOAN
    
                                $upd_sav = $db->prepare("UPDATE lock_funds SET locked_amount=? WHERE loan_id=?");
                                $upd_sav->bind_param('di', $zero, $account_id);
                                $upd_sav->execute();
                                $upd_sav->close();

                                    if($dva_account != "") {
                                    //DELETE DVA
                                   $dvpdta =  array('dva' => $dva_account);
                                   $ddva = curl_init();
                                   curl_setopt($ddva, CURLOPT_URL,"$egis_api_root/delete_dva.php");
                                   curl_setopt($ddva, CURLOPT_POST, 1);
                                   curl_setopt($ddva, CURLOPT_POSTFIELDS,json_encode($dvpdta));  //Post Fields
                                   curl_setopt($ddva, CURLOPT_RETURNTRANSFER, true);
                                   //Set your auth headers
                                   curl_setopt($ddva, CURLOPT_HTTPHEADER, array(
                                       'Content-Type: application/json'
                                   ));
                                                   
                                   // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                   $datadva2 = curl_exec($ddva);
                                   curl_close ($ddva);
                                    }
                                }
                            } else {
                                $io = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                $io->bind_param('dis', $acc_balance, $customer_id, $account_number);
                                $io->execute();
                                $io->close();
                            }

                            //UPDATE EGIS CREDIT_CHECK
                            include("credit_update.php");


        
            if ($total_balance == 0) {
                $_SESSION['msg1'] = "Failed";
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>You have previously completed all repayments. Funds have been moved to your attached savings account.</h2>";
                
            }
       // }


        //UPDATE WORK QUEUE STATUS

        //UPDATE WORKFLOW TRANSACTION
        $mman = $db -> prepare("SELECT proof FROM verify_transactions WHERE id=?");
        $mman -> bind_param('i', $verify_id);
        $mman -> execute();
        $rmman = $mman->get_result();

        while($gut = mysqli_fetch_assoc($rmman) ){
            $proof = $gut['proof'];
        }
        if($proof !="") {
            unlink($proof);
        }
        $nul = NULL;
        $update = "Approved";

        $io = $db->prepare("UPDATE verify_transactions SET status=?, proof=? WHERE id=?");
        $io->bind_param('ssi', $update, $nul, $verify_id);
        $io->execute();
        $io->close();

        $ent_id = 34;
        $act_id = 28;
        $wfcheck = $db -> prepare('SELECT * FROM work_queue WHERE main_area_id=? AND entity_id=? AND action_id=?');
        $wfcheck -> bind_param('iii', $verify_id, $ent_id, $act_id);
        $wfcheck -> execute();
        $rwfcheck = $wfcheck->get_result();

        if ($rwfcheck->num_rows > 0) {

            $new_status = "Treated";

            $updwk = $db->prepare("UPDATE work_queue SET status=?, $by=? WHERE main_area_id=? AND entity_id=? AND action_id=?");
            $updwk->bind_param('siiii', $new_status, $aid, $verify_id, $ent_id, $act_id);
            $updwk->execute(); 

        }    

    }

}//END REPAYMENT

//LOAN RECOVERY TRANSACTION FUNCTION
function approveRecovery($by, $verify_id, $br_start_date, $action, $db, $repay_amount, $repay_comment, $customer_id, $account_number, $value_date, $maintenance, $login_session_expiry, $org_code, $egis_api, $egis_secret, $egis_transfers, $site_name, $egis_api_root, $is_sms_active, $is_email, $offline_id, $site_domain, $update_delinquent_amount, $recovery_type, $recovered_by, $long_name) {
    include('../welcome_user.php');
    $onee = 1;
    $rev = "X";
    $_SESSION['msg1'] = "";

        $pod = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
        $pod -> bind_param('is', $customer_id, $account_number);
        $pod -> execute();
        $rpod = $pod->get_result();

        while($row = mysqli_fetch_assoc($rpod) ){
            $account_id = $row['id'];
            $product_type = $row['product_type'];
            $cleared_balance = $row['cleared_balance'];
            $linked_savings_account = $row['linked_savings_account'];
            $product = $row['product'];
            $agreed_interest_rate = $row['agreed_interest_rate'];
           // $customer_branch = $row["secondary_branch"];
            $customer_rm = $row["secondary_relationship_manager"];
            $cu_creation_date = date('d-m-Y', strtotime($row['application_date']));
            $account_status = $row['status'];
            $sms_alert = $row["sms_alert"];
            $email_alert = $row["email_alert"];
            $currency = $row["currency"];
            $dva_account = $row['dva_account'];

        }
         //GET INITIATOR BRANCH
        $ovr = $db -> prepare('SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?)');
        $ovr -> bind_param('i', $verify_id);
        $ovr -> execute();
        $rovr = $ovr->get_result();

        while($iov = mysqli_fetch_assoc($rovr) ){
            $customer_branch = $iov['branch'];
        }
        $last_id_deli = NULL;
        //CHECK WAIVER POLICY
        $active = "Active";
            

                $pty = "Loan Account";
                $tpd = $product;
                $nm = "Interest Waiver";
            

        
            $crpnd = $db -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
            $crpnd->bind_param("sss", $pty, $active, $nm);
            $crpnd -> execute();
            $rcrpnd = $crpnd->get_result();
            if ($rcrpnd->num_rows > 0) {
                //$proceed = 0;
                while($jvx = mysqli_fetch_assoc($rcrpnd) ){ 
                    $days_to_due= $jvx["days_to_due"];

                    if(strpos($jvx['affected_products'], ' , ') !== false) {
                        // explodable
                        $productssarray = explode(' , ',$jvx['affected_products']);
            
                    } else {
                        // not explodable
                        $productssarray = array($jvx['affected_products']);
            
                    }

                    if(strpos($jvx['channels'], ' , ') !== false) {
                        // explodable
                        $channelsarray = explode(' , ',$jvx['channels']);
            
                    } else {
                        // not explodable
                        $channelsarray = array($jvx['channels']);
            
                    }

                    if(strpos($jvx['affected_branches'], ' , ') !== false) {
                        // explodable
                        $brancharray = explode(' , ',$jvx['affected_branches']);
            
                      } else {
                        // not explodable
                        $brancharray = array($jvx['affected_branches']);
            
                      }
        
                        if (in_array($tpd, $productssarray) && in_array($channel_log, $channelsarray) && in_array($customer_branch, $brancharray)) {
                            
                           $waive = 1;
                         } else {
                             $waive = 0;
                         }
                }
            } else {
                $waive = 0;
            }
        //CHECK IF USER HAS TELLER

    $tty="Teller";
    $seltl = $db -> prepare('SELECT * FROM teller_balances WHERE user_id IN(SELECT created_by FROM verify_transactions WHERE id=?) AND type=? AND currency=?');
    $seltl->bind_param("iss", $verify_id, $tty, $currency);
    $seltl->execute();
    $rseltl = $seltl->get_result();

    if($rseltl->num_rows > 0) {
        while($tlb = mysqli_fetch_assoc($rseltl) ){
            $teller_id = $tlb["id"];
            $tl_balance = $tlb["balance"];
            $tl_gl = $tlb["gl"];
            $tl_status = $tlb["status"];
        }

            $fundteller_amount = $tl_balance + $repay_amount;
            $has_teller=1;

            //Teller Limits
            $ovl = $db -> prepare('SELECT olimit, slimit, tlimit FROM config_tellers WHERE gl=?');
            $ovl -> bind_param('i', $tl_gl);
            $ovl -> execute();
            $rovl = $ovl->get_result();

            while ($lu = $rovl->fetch_array()) {
                $olimit = $lu['olimit'];
                $slimit = $lu['slimit'];
                $tlimit = $lu['tlimit'];
            }

            if ($fundteller_amount > $tlimit) {
                $tl_exceed = 1;//do not proceed, exceeds limit
            } else {
                $tl_exceed = 0;//proceed within limits
            }
        
    } else {
    $has_teller=0;
    }

    $tty1="Tellering";
    $seltl1 = $db -> prepare('SELECT * FROM branch WHERE operational_model=? AND id IN(SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?))');
    $seltl1->bind_param("si", $tty1, $verify_id);
    $seltl1->execute();
    $rseltl1 = $seltl1->get_result();

    if($rseltl1->num_rows > 0) {
        $tl_model=1;
        
    } else {
    $tl_model=0;
    }

    $product2 = str_replace("L","","$product");

$ttr = $db -> prepare("SELECT * FROM loanproduct WHERE id=?");
$ttr -> bind_param('i', $product2);
$ttr -> execute();
$rttr = $ttr->get_result();

    while($ps = mysqli_fetch_assoc($rttr) ){
        $transactionProcessingStrategy = $ps["transactionProcessingStrategy"];
        $fund_source = $ps['fund_source'];
        $loan_portfolio = $ps['loan_portfolio'];
        $income_for_interest = $ps['income_for_interest'];
        $income_from_recovery = $ps['income_from_recovery'];
        $income_from_penalties = $ps['income_from_penalties'];
        $productGroup = $ps['productGroup'];
        $automaticallyAllocateOverpayments = $ps['automaticallyAllocateOverpayments'];
        $debitChargesFromLinkedSavings  = $ps['debitChargesFromLinkedSavings'];
}


    $pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
    $pod1 -> bind_param('i', $customer_id);
    $pod1 -> execute();
    $rpod1 = $pod1->get_result();

    while($row1 = mysqli_fetch_assoc($rpod1) ){
        $customer_name = $row1["fname"];
        $fname = $row1["fname"];
        $mname = $row1["mname"];
        $lname = $row1["lname"];
        $cu_character = strtoupper($customer_name[0]);
}

date_default_timezone_set("Africa/Lagos");
$repay_transaction_date = date("Y-m-d H:i:s");
$recovery_transaction_date = date("Y-m-d H:i:s");
$transaction_date = date("Y-m-d H:i:s");
$today_date = date("Y-m-d");
$target_date = date("Y-m-d H:i:s");

$num = mt_rand(100000, 999999);
$stamp_all = date("Yhis");
$orderId = $stamp_all . $num;

$num_rv = mt_rand(10000000, 99999999);
$group_reverse = $stamp_all . $num_rv;

$transaction_id = "R$cu_character" . "$orderId";

$description = "Repayment";
// $repay_comment = "Loan Repayment";
$type = "Credit";
$yes = "Yes";

$post_exp_penalty = 0;
//SUM ALL OUTSTANDING PENALTIES
$zo = 0;
$epn = $db -> prepare("SELECT SUM(penalty) as p_pen FROM loan_schedule WHERE account_no=? AND customer_id=? AND penalty > ?");
$epn -> bind_param('sid', $account_number, $customer_id, $zo);
$epn -> execute();
$repn = $epn->get_result();
if($repn->num_rows > 0) {
    while($ep1 = mysqli_fetch_assoc($repn) ){
        $exp_penalty = $ep1["p_pen"];
    }
} else {
    $exp_penalty = 0;
}

    $total_balance = round($cleared_balance * -1);

    if($transactionProcessingStrategy == "Penalties, Principal, Interest, Fees  Order" && $exp_penalty > 0) {
        $penfirst =1;
    } else {
        $penfirst =0;
    }

    $today_date1 = date("Y-m-d");
        if ($waive == 1) {
            //CALCULATE WAIVE DATE
            if($days_to_due > 0) {
                $waive_date = date("Y-m-d", strtotime($today_date1 . "+ $days_to_due days"));
            } else {
                $waive_date = $today_date1;
            }
        //SUM ALL OUTSTANDING PRINCIPAL
        $wvc = $db -> prepare("SELECT SUM(expected_principal)-SUM(settlled_principal) as p_expted FROM loan_schedule WHERE account_no=? AND customer_id=?");
        $wvc -> bind_param('si', $account_number, $customer_id);
        $wvc -> execute();
        $rwvc = $wvc->get_result();
            while($wv1 = mysqli_fetch_assoc($rwvc) ){
                $p_expted = $wv1["p_expted"];
            }
    
        $wvi = $db -> prepare("SELECT COALESCE(sum(l.due_interest),0) + (SELECT COALESCE(sum(l.expected_interest),0) from loan_schedule l where l.expected_date <=(CURRENT_DATE + INTERVAL ? day) and l.account_no=? and l.due_interest =0 and l.settlled_interest !=l.expected_interest) as duei FROM loan_schedule l where l.account_no=?");
        $wvi -> bind_param('iss', $days_to_due, $account_number, $account_number);
        $wvi -> execute();
        $rwvi = $wvi->get_result();
            while($wv1 = mysqli_fetch_assoc($rwvi) ){
                $i_expted = $wv1["duei"];
            }
    
            $t_expected_with_waiver = $p_expted + $i_expted;
    
            //overwrite total balance
            if($amount >= $t_expected_with_waiver) {
                $total_balance = round($t_expected_with_waiver, 2);
            } else {
                $waive_date = $today_date1;
                $waive=0;
            }
        } else {
            $waive_date = $today_date1;
        }

    if($exp_penalty > 0) {
        $total_balance = $total_balance + $exp_penalty;
    }
        

        if($transactionProcessingStrategy == "Penalties, Principal, Interest, Fees  Order" && $exp_penalty > 0) {
            $penfirst =1;
        } else {
            $penfirst =0;
        }

        if($exp_penalty > 0) {
            $total_balance = $total_balance + $exp_penalty;
        }

    

    $cu_creation_date1 = strtotime($cu_creation_date) * 1000;
    $br_start_date1 = strtotime($br_start_date) * 1000;
    if($br_start_date1 < $cu_creation_date1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>You cannot do transactions on a date below account creation date.</h2>";
        $_SESSION['msg1'] = "Failed";
    } else if($account_status != "Delinquent") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Account is not delinquent. You are not allowed to post recovery.</h2>";
    } else if($tl_model == 1 && $has_teller == 0) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Branch is operating a teller model but user has no teller</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_status !="Open") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Repayment not allowed. Teller is not Open.</h2>";
    } else if($tl_model == 1 && $has_teller == 1 && $tl_exceed ==1) {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Repayment not allowed. Teller limit of $currency $tlimit exceeded.</h2>";
    } else if($repay_amount > $total_balance && $automaticallyAllocateOverpayments == "No") {
        $_SESSION['msg1'] = "Failed";
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Overpayment isn't allowed. Please repay the exact loan balance.</h2>";
    } else {
         
        $recovery_amount = $repay_amount;
        $bal_credit = $recovery_amount - $total_balance;
            //UPDATE LOAN SCHEDULE TABLE
                        //GET ALL DELINQUENT AMOUNTS
        $today = date("Y-m-d");
        $zero = 0;
        $deli = $db -> prepare("SELECT SUM(due_principal_interest) as deli FROM loan_schedule WHERE loan_id=? AND expected_date < ? AND due_principal_interest > ?");
        $deli -> bind_param('isi', $account_id, $today, $zero);
        $deli -> execute();
        $rdeli = $deli->get_result();

        while($dib = mysqli_fetch_assoc($rdeli) ){
            $deliquent_amount = $dib['deli'];
        }

        if($bal_credit > 0) {
            $transactions_gl_posts = $recovery_amount - $bal_credit;
        } else {
            $transactions_gl_posts = $recovery_amount;
        }
        if($penfirst == 1) {
            if ($exp_penalty >= $transactions_gl_posts) {
                $non_deliquent_amount = 0;
                $deliquent_amount = 0;
                $exp_penalty = $transactions_gl_posts;
            } else {
                $deliquent_amount_bl = $transactions_gl_posts - $exp_penalty;
            
                if($deliquent_amount >= $deliquent_amount_bl) {
                    $non_deliquent_amount = 0;
                    $deliquent_amount = $deliquent_amount_bl;
                } else {
                    $non_deliquent_amount = $deliquent_amount_bl - $deliquent_amount;
                }  
            }
        
        } else {
            if($deliquent_amount > $transactions_gl_posts) {
                $non_deliquent_amount = 0;
                $deliquent_amount = $transactions_gl_posts;
                $exp_penalty = 0;
            } else {
                $deliquent_amount_bl = $transactions_gl_posts - $deliquent_amount;
                if($exp_penalty >= $deliquent_amount_bl) {
                    $exp_penalty = $deliquent_amount_bl;
                    $non_deliquent_amount = 0;
                } else {
                    $non_deliquent_amount = $deliquent_amount_bl - $exp_penalty;
                }
            }
        }

            //UPDATE LOAN SCHEDULE TABLE

                        
                        if($recovery_amount > $total_balance && $total_balance > 0 && $bal_credit > 0) {
                    
                            $sel = $db -> prepare("SELECT id, cleared_balance, product, sms_alert FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();
                            
                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                        
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }
                            
                            $new_amount1 = $sav_cleared_bal + $bal_credit;
                            $previous_balance1 = $sav_cleared_bal;
                            
                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();
                            
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;
                            
                            $transaction_id1 = "C$cu_character" . "$orderId";
                            
                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";
                            
                            if($has_teller==1) { 
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddssssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $target_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);
                        
                                $dba = $tl_gl;
                        
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddssssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $bal_credit, $type2, $description2, $target_date, $value_date, $deposit_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);
                        
                                $dba = $saving_reference;
                        
                            }
                            $entity_id1 = "TRR$last_id1";
                            
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $usbrn, $channel_log);
                            $xx->execute();
                        
                            //INSERT INTO JOURNAL
                            $crd_gl = -$bal_credit;
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, type, description, date, branch, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiisssis", $last_id1, $crd_gl, $bal_credit, $saving_control, $dba, $aid, $journal_type, $journal_description, $journal_date, $customer_branch, $currency);
                            $jn->execute();
                            
                            //UPDATE LOAN BALANCE
                        
                            if($exp_penalty > 0) {
                                $new_amount = $cleared_balance + $total_balance - $exp_penalty;
                                $previous_balance = $cleared_balance;
                            } else {
                                $new_amount = $cleared_balance + $total_balance;
                                $previous_balance = $cleared_balance;
                            }
                            $repay_comment = "Loan Repayment";
                        
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();
                        
                            //INSERT INTO TRANSACTIONS TABLE
                            //separate delinquent amount posting
                            if($deliquent_amount > 0 && $non_deliquent_amount >0) {
                        
                                if($has_teller==1) { 
                                    $type1 = "Credit";
                                    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $w->bind_param("ssidddsssssiiiiisis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $rev);
                                    $w->execute();
                                    $last_id = mysqli_insert_id($db);
                        
                                    $num = mt_rand(100000, 999999);
                                    $stpp = str_shuffle(date("Yhis"));
                                    $orderId = $stpp . $num;
                        
                                    $transaction_id = "R$cu_character" . "$orderId";
                        
                                    $description = "Recovery";
                                    $type1 = "Credit";
                                    $repay_comment = "Loan Recovery";
                        
                                    $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $w_d->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                    $w_d->execute();
                                    $last_id_deli = mysqli_insert_id($db);
                        
                                    $dba = $tl_gl;
                                    } else {
                                        $type1 = "Credit";
                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w->bind_param("ssidddsssssiiiiiss", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $rev);
                                        $w->execute();
                                        $last_id = mysqli_insert_id($db);
                        
                                        $num = mt_rand(100000, 999999);
                                        $stpp = str_shuffle(date("Yhis"));
                                        $orderId = $stpp . $num;
                        
                                        $transaction_id = "R$cu_character" . "$orderId";
                        
                                        $description = "Recovery";
                                        $type1 = "Credit";
                                        $repay_comment = "Loan Recovery";
                        
                                        $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w_d->bind_param("ssidddsssssiiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                        $w_d->execute();
                                        $last_id_deli = mysqli_insert_id($db);
                        
                                        $dba = $saving_reference;
                                    }
                        
                                    $entity_id = "TRR$last_id";
                        
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "Loan repayment of $non_deliquent_amount for account number $account_number";
                                    $act_type = "Loan Repayment";
                                    $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                    $ww->execute();
                        
                                    $entity_id_d = "TRR$last_id_deli";
                        
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                    $act_type_d = "Loan Recovery";
                                    $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                    $ww_d->execute();
                                    } else if($deliquent_amount > 0 && $non_deliquent_amount ==0) {
                        
                                        if($has_teller==1) { 
                                            $num = mt_rand(100000, 999999);
                                            $stpp = str_shuffle(date("Yhis"));
                                            $orderId = $stpp . $num;
                                    
                                            $transaction_id = "R$cu_character" . "$orderId";
                                    
                                            $description = "Recovery";
                                            $type1 = "Credit";
                                            $repay_comment = "Loan Recovery";
                                    
                                            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                            $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                            $w->execute();
                                            $last_id_deli = mysqli_insert_id($db);
                                            $last_id = $last_id_deli;
                                    
                                            $dba = $tl_gl;
                                            } else {
                                    
                                                $num = mt_rand(100000, 999999);
                                                $stpp = str_shuffle(date("Yhis"));
                                                $orderId = $stpp . $num;
                                    
                                                $transaction_id = "R$cu_character" . "$orderId";
                                    
                                                $description = "Recovery";
                                                $type1 = "Credit";
                                                $repay_comment = "Loan Recovery";
                                    
                                                $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                $w_d->bind_param("ssidddsssssiiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                $w_d->execute();
                                                $last_id_deli = mysqli_insert_id($db);
                                    
                                                $dba = $saving_reference;
                                            }
                                    
                                            $last_id = 0;
                                    
                                            //INSERT INTO ACTIVITY TABLE
                                            $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                            $act_type_d = "Loan Recovery";
                                            $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                            $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                            $ww_d->execute();
                                            } else {
                                                $type1 = "Credit";
                                                if($has_teller==1) { 
                                                    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                    $w->bind_param("ssidddsssssiiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                                    $w->execute();
                                                    $last_id = mysqli_insert_id($db);
                        
                                                    $dba = $tl_gl;
                                                    } else {
                                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                        $w->bind_param("ssidddsssssiiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type1, $description, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                        $w->execute();
                                                        $last_id = mysqli_insert_id($db);
                        
                                                        $dba = $saving_reference;
                                                    }
                        
                                                    $entity_id = "TRR$last_id";
                        
                                                    //INSERT INTO ACTIVITY TABLE
                                                    $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                                                    $act_type = "Loan Repayment";
                                                    $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                    $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                                    $ww->execute();
                                            }
                                            
                                            $paing_amount = $total_balance;
                                            } else if($recovery_amount == $total_balance && $total_balance > 0) {
                        
                                //UPDATE LOAN BALANCE
                                if($exp_penalty > 0) {
                                    $new_amount = $cleared_balance + $total_balance - $exp_penalty;
                                    $previous_balance = $cleared_balance;
                                } else {
                                    $new_amount = $cleared_balance + $total_balance;
                                    $previous_balance = $cleared_balance;
                                }
                                
                                $repay_comment = "Loan Repayment";
                            
                                $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                                $pw->execute();
                                $pw->close();
                            
                                //INSERT INTO TRANSACTIONS TABLE
                                //separate delinquent amount posting
                        
                                if($deliquent_amount > 0 && $non_deliquent_amount >0) {
                        
                                    if($has_teller==1) { 
                                        $type1 = "Credit";
                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w->bind_param("ssidddsssssiiiisis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $rev);
                                        $w->execute();
                                        $last_id = mysqli_insert_id($db);
                        
                                        $num = mt_rand(100000, 999999);
                                        $stpp = str_shuffle(date("Yhis"));
                                        $orderId = $stpp . $num;
                        
                                        $transaction_id = "R$cu_character" . "$orderId";
                        
                                        $description = "Recovery";
                                        $type1 = "Credit";
                                        $repay_comment = "Loan Recovery";
                        
                                        $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w_d->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                        $w_d->execute();
                                        $last_id_deli = mysqli_insert_id($db);
                        
                                        //$dba = $tl_gl;
                                        } else {
                                            $type1 = "Credit";
                                            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                            $w->bind_param("ssidddsssssiiiiss", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $rev);
                                            $w->execute();
                                            $last_id = mysqli_insert_id($db);
                        
                                            $num = mt_rand(100000, 999999);
                                            $stpp = str_shuffle(date("Yhis"));
                                            $orderId = $stpp . $num;
                        
                                            $transaction_id = "R$cu_character" . "$orderId";
                        
                                            $description = "Recovery";
                                            $type1 = "Credit";
                                            $repay_comment = "Loan Recovery";
                        
                                            $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                            $w_d->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                            $w_d->execute();
                                            $last_id_deli = mysqli_insert_id($db);
                        
                                        // $dba = $saving_reference;
                                        }
                        
                                        $entity_id = "TRR$last_id";
                        
                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "Loan repayment of $non_deliquent_amount for account number $account_number";
                                        $act_type = "Loan Repayment";
                                        $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                        $ww->execute();
                        
                                        $entity_id_d = "TRR$last_id_deli";
                        
                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                        $act_type_d = "Loan Recovery";
                                        $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                        $ww_d->execute();
                                        } else if($deliquent_amount > 0 && $non_deliquent_amount ==0) {
                        
                                            if($has_teller==1) { 
                                                $num = mt_rand(100000, 999999);
                                                $stpp = str_shuffle(date("Yhis"));
                                                $orderId = $stpp . $num;
                                        
                                                $transaction_id = "R$cu_character" . "$orderId";
                                        
                                                $description = "Recovery";
                                                $type1 = "Credit";
                                                $repay_comment = "Loan Recovery";
                                        
                                                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                                $w->execute();
                                                $last_id_deli = mysqli_insert_id($db);
                        
                                                $last_id = $last_id_deli;
                                        
                                            // $dba = $tl_gl;
                                                } else {
                                        
                                                    $num = mt_rand(100000, 999999);
                                                    $stpp = str_shuffle(date("Yhis"));
                                                    $orderId = $stpp . $num;
                                        
                                                    $transaction_id = "R$cu_character" . "$orderId";
                                        
                                                    $description = "Recovery";
                                                    $type1 = "Credit";
                                                    $repay_comment = "Loan Recovery";
                                        
                                                    $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                    $w_d->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                    $w_d->execute();
                                                    $last_id_deli = mysqli_insert_id($db);
                                        
                                                //  $dba = $saving_reference;
                                                }
                                        
                                                $last_id = 0;
                                        
                                                //INSERT INTO ACTIVITY TABLE
                                                $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                                $act_type_d = "Loan Recovery";
                                                $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                                $ww_d->execute();
                                                } else {
                                                    $type1 = "Credit";
                                                    if($has_teller==1) { 
                                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                        $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                                        $w->execute();
                                                        $last_id = mysqli_insert_id($db);
                            
                                                    // $dba = $tl_gl;
                                                        } else {
                                                            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                            $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $total_balance, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                            $w->execute();
                                                            $last_id = mysqli_insert_id($db);
                            
                                                        // $dba = $saving_reference;
                                                        }
                        
                                                        $entity_id = "TRR$last_id";
                        
                                                        //INSERT INTO ACTIVITY TABLE
                                                        $act_dsc = "Loan repayment of $total_balance for account number $account_number";
                                                        $act_type = "Loan Repayment";
                                                        $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                        $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                                        $ww->execute();
                                                }
                            
                            $paing_amount = $total_balance;
                            } else if($recovery_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) {
                                
                        
                            $sel = $db -> prepare("SELECT * FROM accounts WHERE account_number=?");
                            $sel -> bind_param('s', $linked_savings_account);
                            $sel -> execute();
                            $rsel = $sel->get_result();
                            
                            while($ssi = mysqli_fetch_assoc($rsel) ){
                                $sav_cleared_bal = $ssi["cleared_balance"];
                                $product_s = $ssi["product"];
                                $sms_alert_r = $ssi["sms_alert"];
                                $account_id_r = $ssi["id"];
                            }
                        
                            $product2_s = str_replace("S","","$product_s");
                            $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                            $sc -> bind_param('i', $product2_s);
                            $sc -> execute();
                            $rsc = $sc->get_result();
                                while($sc1 = mysqli_fetch_array($rsc) ){
                                    $saving_reference = $sc1['saving_reference'];
                                    $saving_control = $sc1['saving_control'];
                                }
                            
                            $new_amount1 = $sav_cleared_bal + $recovery_amount;
                            $previous_balance1 = $sav_cleared_bal;
                            
                            $pw1 = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $pw1->bind_param('ds', $new_amount1, $linked_savings_account);
                            $pw1->execute();
                            $pw1->close();
                            
                            $num = mt_rand(100000, 999999);
                            $stamp = date("Yhis");
                            $orderId = $stamp . $num;
                            
                            $transaction_id1 = "C$cu_character" . "$orderId";
                            
                            $description2 = "Deposit";
                            $type2 = "Credit";
                            $deposit_comment = "Loan Overpayment balance";
                            
                            if($has_teller==1) { 
                            $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $x->bind_param("ssidddsssssiiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $recovery_amount, $type2, $description2, $target_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid, $teller_id);
                            $x->execute();
                            $last_id1 = mysqli_insert_id($db);
                        
                            $dba = $tl_gl;
                            } else {
                                $x = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $x->bind_param("ssidddsssssiiii", $transaction_id1, $linked_savings_account, $customer_id, $previous_balance1, $new_amount1, $recovery_amount, $type2, $description2, $target_date, $value_date, $deposit_comment, $customer_branch, $customer_rm, $channel_log, $aid);
                                $x->execute();
                                $last_id1 = mysqli_insert_id($db);
                        
                                $dba = $saving_reference;
                            }
                            $entity_id1 = "TRR$last_id1";
                            
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc = "Funds Deposit to customer account (Loan overpayment)";
                            $act_type = "Deposit";
                            $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id1, $aid, $usbrn, $channel_log);
                            $xx->execute();
                        
                            //INSERT INTO JOURNAL
                            $crd_gl1 = -$recovery_amount;
                            $journal_date = $value_date;
                            $journal_type = "Automatic";
                            $journal_description = "Loan Overpayment Deposit to customer account";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, type, description, date, branch, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiisssis", $last_id1, $crd_gl1, $recovery_amount, $saving_control, $dba, $aid, $journal_type, $journal_description, $journal_date, $customer_branch, $currency);
                            $jn->execute();
                        
                                $paing_amount = 0;
                            } else if($recovery_amount < $total_balance && $total_balance > 0) {
                                if($exp_penalty > 0) {
                                    $new_amount = $cleared_balance + $recovery_amount - $exp_penalty;
                                    $previous_balance = $cleared_balance;
                                } else {
                                    $new_amount = $cleared_balance + $recovery_amount;
                                    $previous_balance = $cleared_balance;
                                }
                                
                        
                            $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                            $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                            $pw->execute();
                            $pw->close();
                                
                            $repay_comment = "Loan Repayment";
                            //INSERT INTO TRANSACTIONS TABLE
                            //separate delinquent amount posting
                            if($deliquent_amount > 0 && $non_deliquent_amount >0) {
                        
                                if($has_teller==1) { 
                                    $type1 = "Credit";
                                    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $w->bind_param("ssidddsssssiiiisis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $rev);
                                    $w->execute();
                                    $last_id = mysqli_insert_id($db);
                            
                                    $num = mt_rand(100000, 999999);
                                    $stpp = str_shuffle(date("Yhis"));
                                    $orderId = $stpp . $num;
                            
                                    $transaction_id = "R$cu_character" . "$orderId";
                            
                                    $description = "Recovery";
                                    $type1 = "Credit";
                                    $repay_comment = "Loan Recovery";
                            
                                    $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $w_d->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                    $w_d->execute();
                                    $last_id_deli = mysqli_insert_id($db);
                            
                                // $dba = $tl_gl;
                                    } else {
                                        $type1 = "Credit";
                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w->bind_param("ssidddsssssiiiiss", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $non_deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $rev);
                                        $w->execute();
                                        $last_id = mysqli_insert_id($db);
                            
                                        $num = mt_rand(100000, 999999);
                                        $stpp = str_shuffle(date("Yhis"));
                                        $orderId = $stpp . $num;
                            
                                        $transaction_id = "R$cu_character" . "$orderId";
                            
                                        $description = "Recovery";
                                        $type1 = "Credit";
                                        $repay_comment = "Loan Recovery";
                            
                                        $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $w_d->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                        $w_d->execute();
                                        $last_id_deli = mysqli_insert_id($db);
                            
                                    //  $dba = $saving_reference;
                                    }
                            
                                    $entity_id = "TRR$last_id";
                            
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "Loan repayment of $non_deliquent_amount for account number $account_number";
                                    $act_type = "Loan Repayment";
                                    $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                    $ww->execute();
                            
                                    $entity_id_d = "TRR$last_id_deli";
                            
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                    $act_type_d = "Loan Recovery";
                                    $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                    $ww_d->execute();
                                    } else if($deliquent_amount > 0 && $non_deliquent_amount ==0) {
                            
                                        if($has_teller==1) { 
                                            $num = mt_rand(100000, 999999);
                                            $stpp = str_shuffle(date("Yhis"));
                                            $orderId = $stpp . $num;
                                    
                                            $transaction_id = "R$cu_character" . "$orderId";
                                    
                                            $description = "Recovery";
                                            $type1 = "Credit";
                                            $repay_comment = "Loan Recovery";
                                    
                                            $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                            $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                            $w->execute();
                                            $last_id_deli = mysqli_insert_id($db);
                                            $last_id = $last_id_deli;
                                        // $dba = $tl_gl;
                                            } else {
                                    
                                                $num = mt_rand(100000, 999999);
                                                $stpp = str_shuffle(date("Yhis"));
                                                $orderId = $stpp . $num;
                                    
                                                $transaction_id = "R$cu_character" . "$orderId";
                                    
                                                $description = "Recovery";
                                                $type1 = "Credit";
                                                $repay_comment = "Loan Recovery";
                                    
                                                $w_d = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                $w_d->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $deliquent_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                $w_d->execute();
                                                $last_id_deli = mysqli_insert_id($db);
                                    
                                            //  $dba = $saving_reference;
                                            }
                                    
                                            $last_id = 0;
                                    
                                            //INSERT INTO ACTIVITY TABLE
                                            $act_dsc_d = "Loan recovery of $deliquent_amount for account number $account_number";
                                            $act_type_d = "Loan Recovery";
                                            $ww_d = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                            $ww_d->bind_param("sssiii", $act_dsc_d, $act_type_d, $entity_id_d, $aid, $usbrn, $channel_log);
                                            $ww_d->execute();
                                            } else {
                                                $type1 = "Credit";
                                                if($has_teller==1) { 
                                                    $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group, teller_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                    $w->bind_param("ssidddsssssiiiisi", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $recovery_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id);
                                                    $w->execute();
                                                    $last_id = mysqli_insert_id($db);
                            
                                                // $dba = $tl_gl;
                                                    } else {
                                                        $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                        $w->bind_param("ssidddsssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $recovery_amount, $type1, $description, $target_date, $value_date, $repay_comment, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                                        $w->execute();
                                                        $last_id = mysqli_insert_id($db);
                            
                                                    // $dba = $saving_reference;
                                                    }
                            
                                                    $entity_id = "TRR$last_id";
                            
                                                    //INSERT INTO ACTIVITY TABLE
                                                    $act_dsc = "Loan repayment of $recovery_amount for account number $account_number";
                                                    $act_type = "Loan Repayment";
                                                    $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                                    $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                                                    $ww->execute();
                                            }
                        
                            $paing_amount = $recovery_amount;
                            }
                        
                            //PAY PENALTY IF PENALTY AMOUNT IS > 0
                            if($exp_penalty>0) {
                                $rget = $db -> prepare("SELECT cleared_balance FROM accounts WHERE account_number=? AND customer_id=?");
                                $rget -> bind_param('si', $account_number, $customer_id);
                                $rget -> execute();
                                $rrget = $rget->get_result();
                                
                                while($ccb = mysqli_fetch_assoc($rrget) ){
                                    $cleared_balance_pl = $ccb["cleared_balance"];
                            
                                }
                                $transaction_id_pn = "P$cu_character" . str_shuffle($orderId);
                                $previous_balance_pn = $cleared_balance_pl;
                                $new_amount_pn = $cleared_balance_pl + $exp_penalty;
                                $description_pn = "Penalty";
                                $type1 = "Credit";
                                
                                if($has_teller==1) {
                                    $wpn = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, teller_id, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $wpn->bind_param("ssidddsssssiiiiisis", $transaction_id_pn, $account_number, $customer_id, $previous_balance_pn, $new_amount_pn, $exp_penalty, $type1, $description_pn, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $teller_id, $rev);
                                    $wpn->execute();
                                    $last_id_pn = mysqli_insert_id($db);
                                    
                            
                                    } else {
                                        $wpn = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, overpayment_id, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $wpn->bind_param("ssidddsssssiiiiis", $transaction_id_pn, $account_number, $customer_id, $previous_balance_pn, $new_amount_pn, $exp_penalty, $type1, $description_pn, $target_date, $value_date, $repay_comment, $last_id1, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all, $rev);
                                        $wpn->execute();
                                        $last_id_pn = mysqli_insert_id($db);
                            
                                    }
                            
                                    $entity_id_pn = "TRR$last_id_pn";
                            
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc_pn = "Loan Penalty of $exp_penalty for account number $account_number";
                                    $act_type_pn = "Loan Penalty";
                                    $ww_pn = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $ww_pn->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel);
                                    $ww_pn->execute();
                            }

                        //UPDATE DELINQUENT AMOUNT IN JOURNAL ENTRY
                        /*$updlin = $db->prepare("UPDATE journals SET recovery_amount=? WHERE id=?");
                        $updlin->bind_param('di', $update_delinquent_amount, $delinquent_id);
                        $updlin->execute();*/

                        //for egis_credit check
                        $repayment_amount_egis = $paing_amount;
                        //end for egis credit check

                        //DO SMS INTEGRATION
                        $biz_rule = "Loan Repayed";
                        $brn = $usbrn;
                        $rm = $customer_rm;
                        $pg = $productGroup;
                        $account_id = $account_id;
                        $account_no = $account_number;
                        $vdate = $value_date;
                        $tdate = $recovery_transaction_date;
                        $tamount = $recovery_amount;
                        $cb = $new_amount;

                        include("sms_int.php");

                        if (($recovery_amount > $total_balance && $total_balance == 0 && $bal_credit > 0) || ($recovery_amount > $total_balance && $total_balance > 0 && $bal_credit > 0)) {
                            if($sms_alert_r == "Yes") {
                                $yui_c = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                                $yui_c -> bind_param('i', $account_id_r);
                                $yui_c -> execute();
                                $ryui_c = $yui_c->get_result();
                                while($io_c = mysqli_fetch_array($ryui_c) ){
                                    $alert_phone_r = $io_c['phone_no'];
                                }

                                if ($recovery_amount > $total_balance && $total_balance == 0) {
                                    $bal_credit = $recovery_amount;
                                }
                                $lonacc = substr($account_number, -4);
                                $dst_account = substr($linked_savings_account, -4);
                                $message = "Acct:**[accountNo]
                                CR:N[amount]
                                Desc:LOAN OVER PAYMENT DEPOSIT**$lonacc
                                DT:[vdate]
                                Bal:[balance]CR";
                                $message = str_replace("[accountNo]",$dst_account,$message);
                                $message = str_replace("[vdate]",$value_date,$message);
                                $message = str_replace("[adate]",$recovery_transaction_date,$message);
                                $message = str_replace("[amount]",number_format($bal_credit, 2, '.', ','),$message);
                                $message = str_replace("[balance]",number_format($new_amount1, 2, '.', ','),$message);
                                $message = str_replace("[trbranch]",$usbrn,$message);
                        
                                //SEND TO EGIS SERVICES FOR SENDING SMS HERE
                        
                                $postdata4 =  array('organization_code' => $org_code, 'branch_id' => $usbrn, 'recipient_phone' => $alert_phone_r, 'message' => $message);
                        
                                $ch4 = curl_init();
                                curl_setopt($ch4, CURLOPT_URL,"$egis_api_root/sms.php");
                                curl_setopt($ch4, CURLOPT_POST, 1);
                                curl_setopt($ch4, CURLOPT_POSTFIELDS,json_encode($postdata4));  //Post Fields
                                curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
                                //Set your auth headers
                                curl_setopt($ch4, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $token
                                ));
                        
                                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                $data2 = curl_exec($ch4);
                        
                                //$decode2 = json_decode($data2);

                                //CHECK IF CHARGE IS CONFIGURED AND PROCESS
                                $charge_text = "Single SMS Fee";
                                $ruo = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                                $ruo -> bind_param('sss', $product_s, $charge_text, $yes);
                                $ruo -> execute();
                                $rruo = $ruo->get_result();
                                if($rruo->num_rows > 0) {

                                    while($yii = mysqli_fetch_array($rruo) ){
                                        $ch_id = $yii['cid'];
                                    }

                                    $yd = $db -> prepare('SELECT * FROM charges WHERE id=?');
                                    $yd -> bind_param('i', $ch_id);
                                    $yd -> execute();
                                    $ryd = $yd->get_result();
                                    while($ydd = mysqli_fetch_array($ryd) ){
                                    //Call Charge Amount
                                    $trnsss_amount = $bal_credit;
                                    $chid = $ch_id;
                                    include('../../charges.php');
                                    //End Call Charge Amount
                                    $charge_name_s = $ydd['name'];
                                    $charge_option_s = $ydd['charge_option'];
                                    $triggertype_s = $ydd['triggertype'];
                                    }
                                    $charge_amount_s = $charge_amount;//deliberate from charges.php
                                    if ($charge_option_s != "Flat") {
                                        $charge_amount_s = $bal_credit * ($charge_amount_s/100);
                                    }

                                    $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                    $set -> bind_param('ss', $product_s, $ch_id);
                                    $set -> execute();
                                    $rset = $set->get_result();
                                    if ($rset->num_rows > 0) {
                                        while($rrt = mysqli_fetch_array($rset) ){
                                            $income_acc_s = $rrt['income_acc'];
                                        }
                                    }

                                    ////////
                                        if ($triggertype_s == "Per Transaction") {
                                        $final_balance = $new_amount1 - $charge_amount_s;
                                        $num_ls = mt_rand(100000, 999999);
                                        $stamp_ln = date("Yhis");
                                        $orderId_ln = $stamp_ln . $num_ls;

                                        $transaction_id_ln = "D$cu_character_ben" . "$orderId_ln";

                                        $description2 = "$charge_name_s";
                                        $type2 = "Debit";
                                        $charge_comment = "$charge_name_s";

                                        $rev = "X";
                                        $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                        $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $account_id_r, $newamount1, $final_balance, $charge_amount_s, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                        $xln->execute();
                                        $last_id_ln = mysqli_insert_id($db);
                                        $entity_id_ln = "TRR$last_id_ln";

                                        $crd_gl1 = -$charge_amount_s;
                                        $journal_description = "$charge_name_s";
                                        $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                        $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount_s, $income_acc_s, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                        $jn->execute();


                                        //INSERT INTO ACTIVITY TABLE
                                        $act_dsc = "$charge_name_s";
                                        $act_type = "Fee";
                                        $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                        $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $usbrn, $channel_log);
                                        $xx->execute();

                                        $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                        $upd_s->bind_param('ds', $final_balance, $linked_savings_account);
                                        $upd_s->execute();
                                        } else {
                                            //INSERT CHARGE INTO TEM CHARGES TABLE
                                        $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                        $inch->bind_param("sdss", $linked_savings_account, $charge_amount_s, $charge_name_s, $triggertype_s);
                                        $inch->execute();
                                        }

                                }

                            }
                        }

                        //DEDUCT REPAYMENT CHARGES FROM LINKED SAVINGS ACCOUNT
                        //INSERT LOAN ACCOUNT CHARGES IF ANY
                        

                        if($charge_sms == 1) {
                            //$charge_tl1 = "Repayment Fee";
                            $charge_tl2 = "Single SMS Fee";
                            //$charge_tl4 = "Email Fee";
                            $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                            $incr -> bind_param('sss', $product, $charge_tl2, $yes);
                            $incr -> execute();
                            $rincr = $incr->get_result();
                        
                         if($rincr->num_rows > 0) {
        
        
                             foreach ($rincr as $iid):
                             
                             $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                             $de -> bind_param('i', $iid['cid']);
                             $de -> execute();
                             $rde = $de->get_result();
                             while($dee = mysqli_fetch_array($rde) ){
                             $ch_id = $dee['id'];
                             //Call Charge Amount
                            $trnsss_amount = $paing_amount;
                            $chid = $ch_id;
                            include('../../charges.php');
                            //End Call Charge Amount
                             $charge_name = $dee['name'];
                             $charge_option = $dee['charge_option'];
                             $triggertype = $dee['triggertype'];
                             $chargetype = $dee['chargetype'];
                             }

                             $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                            $set -> bind_param('ss', $product, $ch_id);
                            $set -> execute();
                            $rset = $set->get_result();
                            if ($rset->num_rows > 0) {
                                while($rrt = mysqli_fetch_array($rset) ){
                                    $income_acc = $rrt['income_acc'];
                                }
                            } else {
                            $set1 = $db -> prepare('SELECT income_acc FROM income_account_map_fees_receivable WHERE product_id=? AND fee=?');
                            $set1 -> bind_param('ss', $product, $ch_id);
                            $set1 -> execute();
                            $rset1 = $set1->get_result();
                            if ($rset1->num_rows > 0) {
                                while($rtt1 = mysqli_fetch_array($rset1) ){
                                    $income_acc = $rtt1['income_acc'];
                                }
                            } else {
                                $set2 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties WHERE product_id=? AND fee=?');
                                $set2 -> bind_param('ss', $product, $ch_id);
                                $set2 -> execute();
                                $rset2 = $set2->get_result();
                                if ($rset2->num_rows > 0) {
                                    while($rtt2 = mysqli_fetch_array($rset2) ){
                                        $income_acc = $rtt2['income_acc'];
                                    }
                                } else {

                                    $set3 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_receivable WHERE product_id=? AND fee=?');
                                    $set3 -> bind_param('ss', $product, $ch_id);
                                    $set3 -> execute();
                                    $rset3 = $set3->get_result();
                                    if ($rset3->num_rows > 0) {
                                        while($rtt3 = mysqli_fetch_array($rset3) ){
                                            $income_acc = $rtt3['income_acc'];
                                        }
                                    } else {
                                        $set4 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended WHERE product_id=? AND fee=?');
                                        $set4 -> bind_param('ss', $product, $ch_id);
                                        $set4 -> execute();
                                        $rset4 = $set4->get_result();
                                        if ($rset4->num_rows > 0) {
                                            while($rtt4 = mysqli_fetch_array($rset4) ){
                                                $income_acc = $rtt4['income_acc'];
                                            }
                                        } else {
                                            $set5 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl WHERE product_id=? AND fee=?');
                                            $set5 -> bind_param('ss', $product, $ch_id);
                                            $set5 -> execute();
                                            $rset5 = $set5->get_result();
                                            if ($rset5->num_rows > 0) {
                                                while($rtt5 = mysqli_fetch_array($rset5) ){
                                                    $income_acc = $rtt5['income_acc'];
                                                }
                                            } else {
                                                $set6 = $db -> prepare('SELECT income_acc FROM income_account_map_penalties_suspended_gl_2 WHERE product_id=? AND fee=?');
                                                $set6 -> bind_param('ss', $product, $ch_id);
                                                $set6 -> execute();
                                                $rset6 = $set6->get_result();
                                                if ($rset6->num_rows > 0) {
                                                    while($rtt6 = mysqli_fetch_array($rset6) ){
                                                        $income_acc = $rtt6['income_acc'];
                                                    }
                                                } else {
                                                    $set7 = $db -> prepare('SELECT income_acc FROM income_account_map_suspended_fee WHERE product_id=? AND fee=?');
                                                    $set7 -> bind_param('ss', $product, $ch_id);
                                                    $set7 -> execute();
                                                    $rset7 = $set7->get_result();
                                                    if ($rset7->num_rows > 0) {
                                                        while($rtt7 = mysqli_fetch_array($rset7) ){
                                                            $income_acc = $rtt7['income_acc'];
                                                        }
                                                    } else {
                            
                                                    }
                                                }
                                            }
                                        }
            
                                    }
        
                                }
                            }
                        }

                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source = $fr['funding_source'];
                        }
        
                             if ($charge_option != "Flat") {
                                 $charge_amount = $paing_amount * ($charge_amount/100);
                             }

                             if ($debitChargesFromLinkedSavings == "Yes") {

                                //CHARGE LINKED SAVINGS ACCOUNT
                                 //FOR CHARGE DEDUCTION IF SET TO CHARGE FROM LINKED SAVINGS ACCOUNT
                                    $lsa = $db -> prepare("SELECT * FROM accounts WHERE account_number IN (SELECT linked_savings_account FROM accounts WHERE id=?)");
                                    $lsa->bind_param("i", $account_id);
                                    $lsa->execute();
                                    $rlsa = $lsa->get_result();
                                    while($wp = mysqli_fetch_array($rlsa) ){
                                        $linked_savings_account_id = $wp["id"];
                                        $linked_savings_cleared_balance = $wp["cleared_balance"];
                                        $linked_savings_account = $wp["account_number"];
                                        $linked_savings_account_customer_id = $wp["customer_id"];
                                        $linked_savings_account_product = $wp["product"];
                                    }
                                    $linked_savings_account_product2 = str_replace("S","","$linked_savings_account_product");

                                    $sc_ln = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                                    $sc_ln -> bind_param('i', $linked_savings_account_product2);
                                    $sc_ln -> execute();
                                    $rsc_ln = $sc_ln->get_result();
                                        while($sc1_ln = mysqli_fetch_array($rsc_ln) ){
                                            $linked_savings_saving_control = $sc1_ln['saving_control'];
                                            $linked_savings_product_group = $sc1_ln['productGroup'];
                                        }

                                    if ($triggertype == "Per Transaction" && $charge_amount >0) {
                                    $new_linked_savings = $linked_savings_cleared_balance - $charge_amount;
                                    $num_ls = mt_rand(100000, 999999);
                                    $stamp_ln = date("Yhis");
                                    $orderId_ln = $stamp_ln . $num_ls;

                                    $transaction_id_ln = "D$cu_character" . "$orderId_ln";

                                    $description2 = "$charge_name";
                                    $type2 = "Debit";
                                    $charge_comment = "$charge_name";

                                    $rev = "X";
                                    $xln = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, status, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $xln->bind_param("ssidddssssssiiiis", $transaction_id_ln, $linked_savings_account, $linked_savings_account_customer_id, $linked_savings_cleared_balance, $new_linked_savings, $charge_amount, $type2, $description2, $transaction_date, $value_date, $charge_comment, $rev, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_all);
                                    $xln->execute();
                                    $last_id_ln = mysqli_insert_id($db);
                                    $entity_id_ln = "TRR$last_id_ln";

                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id_ln, $crd_gl1, $charge_amount, $income_acc, $linked_savings_saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();


                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "$charge_name";
                                    $act_type = "Fee";
                                    $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $xx->bind_param("sssiii", $act_dsc, $act_type, $entity_id_ln, $aid, $usbrn, $channel_log);
                                    $xx->execute();

                                    $upd_s = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                    $upd_s->bind_param('ds', $new_linked_savings, $linked_savings_account);
                                    $upd_s->execute();
                                    } else {
                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                        if($charge_amount>0) {
                                       $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                       $inch->bind_param("sdss", $linked_savings_account, $charge_amount, $charge_name, $triggertype);
                                       $inch->execute();
                                        }

                                       $new_linked_savings = $linked_savings_cleared_balance;
                                    }

                                    //DO SMS INTEGRATION
                                    if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                        $biz_rule = "Charge Deducted";
                                        $brn = $customer_branch;
                                        $rm = $customer_rm;
                                        $pg = $linked_savings_product_group;
                                        $account_id = $linked_savings_account_id;
                                        $account_no = $linked_savings_account;
                                        $vdate = $value_date;
                                        $tdate = $transaction_date;
                                        $tamount = $charge_amount;
                                        $cb = $new_linked_savings;

                                        include_once("sms_int.php");
                                    }
                            
                            } else {
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id, $crd_gl1, $charge_amount, $income_acc, $funding_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();
                                             

                            }
                        endforeach;
                        }
                    }
                        //UPDATE LOAN SCHEDULE TABLE
                $waive_amount = 0;
                $update_principal_jornal = 0;
                $update_interest_jornal = 0;
                $update_principal_interest_jornal = 0;
                $deliquent_principal = 0;
                $non_deliquent_principal = 0;
                $deliquent_interest = 0;
                $non_deliquent_interest = 0;

                $update_penalty = 0;

                $zero = 0;
                $ggt = $db -> prepare("SELECT * FROM loan_schedule WHERE account_no=? AND customer_id=? AND settlled_principal_interest < expected_principal_interest ORDER BY id ASC");
                $ggt -> bind_param('si', $account_number, $customer_id);
                $ggt -> execute();
                $rggt = $ggt->get_result();
                
                    foreach ($rggt as $ick):

                        $wv_amt = 0;
                        $update_id = 0;
                        $expected_interest = 0;
                        $expected_principal = 0;
                        $expected_principal_interest = 0;
                        $settlled_interest = 0;
                        $settlled_principal = 0;
                        $settlled_principal_interest = 0;
                        $due_interest = 0;
                        $due_principal = 0;
                        $due_principal_interest = 0;
                        $expected_date = "";
                        $penalty = 0;

                        $sp2 = 0;
                        $si2 = 0;
                        $spi2 = 0;

                        $update_id = $ick["id"];
                        $expected_interest = $ick["expected_interest"];
                        $expected_principal = $ick["expected_principal"];
                        $expected_principal_interest = $ick["expected_principal_interest"];
                        $settlled_interest = $ick["settlled_interest"];
                        $settlled_principal = $ick["settlled_principal"];
                        $settlled_principal_interest = $ick["settlled_principal_interest"];
                        $due_interest = $ick["due_interest"];
                        $due_principal = $ick["due_principal"];
                        $due_principal_interest = $ick["due_principal_interest"];
                        $expected_date = $ick["expected_date"];
                        $penalty = $ick["penalty"];

                        $sp2 = $ick["settlled_principal"];
                        $si2 = $ick["settlled_interest"];
                        $spi2 = $ick["settlled_principal_interest"];

                    /*$lsh = $db -> prepare("SELECT * FROM loan_schedule WHERE id=? ORDER BY id ASC");
                    $lsh -> bind_param('i', $ick["id"]);
                    $lsh -> execute();
                    $rlsh = $lsh->get_result();

                    while($lon = mysqli_fetch_assoc($rlsh) ){


                    $update_id = $lon["id"];
                    $expected_interest = $lon["expected_interest"];
                    $expected_principal = $lon["expected_principal"];
                    $expected_principal_interest = $lon["expected_principal_interest"];
                    $settlled_interest = $lon["settlled_interest"];
                    $settlled_principal = $lon["settlled_principal"];
                    $settlled_principal_interest = $lon["settlled_principal_interest"];
                    $due_interest = $lon["due_interest"];
                    $due_principal = $lon["due_principal"];
                    $due_principal_interest = $lon["due_principal_interest"];
                    $expected_date = $lon["expected_date"];

                    $penalty = $lon["penalty"];

                    $sp2 = $lon["settlled_principal"];
                    $si2 = $lon["settlled_interest"];
                    $spi2 = $lon["settlled_principal_interest"];

                    }*/
                    $s_penalty = 0;

                    

                    //$limit = $rlsh->num_rows;
                    //for ($i=0; $i<= $limit; $i++) {
                        /*
                        if ($expected_date > $today_date && $due_interest  == 0) {
                            $due_interest = $expected_interest - $settlled_interest;
                        }
                        if ($expected_date > $today_date && $due_principal  == 0) {
                            $due_principal = $expected_principal - $settlled_principal;
                        }
                        if ($expected_date > $today_date && $due_principal_interest  == 0) {
                            $due_principal_interest = $expected_principal_interest - $settlled_principal_interest;
                        }
                        */

                            //APPLY TRANSACTION PROCESSING STRATEGY
                            if ($transactionProcessingStrategy == "Custom for LARDI") {
                                $strange_calc = ($agreed_interest_rate/100) +1;

                                if($penalty >0) {
                                    $rem_pay_amount = $paing_amount - $penalty;
                                } else {
                                    $rem_pay_amount = $paing_amount;
                                }

                                $deduct_principal = $rem_pay_amount/$strange_calc;
                                $deduct_interest = $rem_pay_amount - $deduct_principal;
                            }
                            if ($paing_amount >0) {

                                $principal_to_pay = $expected_principal - $settlled_principal;
                                $interest_to_pay = $expected_interest - $settlled_interest;
                                if ($transactionProcessingStrategy == "Penalties, Principal, Interest, Fees  Order") {
                                    //
                                    if ($paing_amount >= $penalty && $penalty >0) {
                                        $update_penalty += $penalty;
                                        $s_penalty = $penalty;
                                        $penalty = 0;
                                        $paing_amount = $paing_amount - $penalty;
                                        
                                    } else if ($paing_amount < $penalty && $penalty >0 && $paing_amount >0) {
                                            $update_penalty += $paing_amount;
                                            $s_penalty = $paing_amount;
                                            $penalty = $penalty - $paing_amount;

                                            $paing_amount = $paing_amount - $paing_amount;                                                
                                    }

                                    if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {

                                        $settlled_principal = $settlled_principal + $principal_to_pay;

                                        if ($due_principal >0) {
                                            $due_principal = $due_principal - $settlled_principal;

                                        }
                                        if($expected_date < $today) {
                                            $deliquent_principal += $principal_to_pay;
                                            $last_id = $last_id_deli;
                                        }

                                        $paing_amount = $paing_amount - $principal_to_pay;
                                        
                                        
                                    }  else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                            $settlled_principal = $settlled_principal + $paing_amount;

                                            if($expected_date < $today) {
                                                $deliquent_principal += $paing_amount;
                                                $last_id = $last_id_deli;
                                            }

                                            $paing_amount = $paing_amount - $paing_amount;
                                            
                                        
                                    }

                                    if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                            $settlled_interest = $settlled_interest + $interest_to_pay;
                                            
                                                if($waive == 1 && $expected_date > $waive_date) {
                                                    $paing_amount = $paing_amount;
                                                    $is_wave = 2;
                                                    $si2 = $si2 + $interest_to_pay;
                                                    $waive_amount = $waive_amount + $interest_to_pay;
                                                    $wv_amt = $wv_amt + $interest_to_pay;
                                                } else {
                                                    if($expected_date < $today) {
                                                        $deliquent_interest += $interest_to_pay;
                                                        $last_id = $last_id_deli;
                                                    }
                                                    $paing_amount = $paing_amount - $interest_to_pay;
                                                    $is_wave = NULL;
                                                }
                                        
                                    } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                    
                                            $settlled_interest = $settlled_interest + $paing_amount;

                                            if($waive == 1 && $expected_date > $waive_date) {
                                                $paing_amount = $paing_amount;
                                                $is_wave = 2;
                                                $si2 = $si2 + $paing_amount;
                                                $waive_amount = $waive_amount + $paing_amount;
                                                $wv_amt = $wv_amt + $paing_amount;
                                            } else {
                                                if($expected_date < $today) {
                                                    $deliquent_interest += $paing_amount;
                                                    $last_id = $last_id_deli;
                                                }
                                                $paing_amount = $paing_amount - $paing_amount;
                                                $is_wave = NULL;
                                            }

                                    }


                                } else if ($transactionProcessingStrategy == "Custom for LARDI") {

                                    if ($deduct_principal >= $principal_to_pay && $principal_to_pay >0) {

                                        $settlled_principal = $settlled_principal + $principal_to_pay;
                                    
                                        if($expected_date < $today) {
                                            $deliquent_principal += $principal_to_pay;
                                            $last_id = $last_id_deli;
                                        }
                                    
                                        $deduct_principal = $deduct_principal - $principal_to_pay;
                                        
                                        
                                    }  else if ($deduct_principal < $principal_to_pay && $principal_to_pay >0 && $deduct_principal >0) {
                                            $settlled_principal = $settlled_principal + $deduct_principal;
                                    
                                            if($expected_date < $today) {
                                                $deliquent_principal += $deduct_principal;
                                                $last_id = $last_id_deli;
                                            }
                                    
                                            $deduct_principal = $deduct_principal - $deduct_principal;
                                        
                                    }
                                    
                                    if ($deduct_interest > 0 && $deduct_interest>= $interest_to_pay && $interest_to_pay > 0) {
                                    
                                            $settlled_interest = $settlled_interest + $interest_to_pay;
                                            
                                                if($waive == 1 && $expected_date > $waive_date) {
                                                    $deduct_interest = $deduct_interest;
                                                    $is_wave = 2;
                                                    $si2 = $si2 + $interest_to_pay;
                                                    $waive_amount = $waive_amount + $interest_to_pay;
                                                    $wv_amt = $wv_amt + $interest_to_pay;
                                                } else {
                                                    if($expected_date < $today) {
                                                        $deliquent_interest += $interest_to_pay;
                                                        $last_id = $last_id_deli;
                                                    }
                                                    $deduct_interest = $deduct_interest - $interest_to_pay;
                                                    $is_wave = NULL;
                                                }
                                    
                                    } else if ($deduct_interest > 0 && $deduct_interest < $interest_to_pay && $interest_to_pay > 0) {
                                    
                                            $settlled_interest = $settlled_interest + $deduct_interest;
                                    
                                            if($waive == 1 && $expected_date > $waive_date) {
                                                $deduct_interest = $deduct_interest;
                                                $is_wave = 2;
                                                $si2 = $si2 + $deduct_interest;
                                                $waive_amount = $waive_amount + $deduct_interest;
                                                $wv_amt = $wv_amt + $deduct_interest;
                                            } else {
                                                if($expected_date < $today) {
                                                    $deliquent_interest += $deduct_interest;
                                                    $last_id = $last_id_deli;
                                                }
                                                $deduct_interest = $deduct_interest - $deduct_interest;
                                                $is_wave = NULL;
                                            }
                                    }
                                    
                                    $paing_amount = $deduct_principal + $deduct_interest;
                                    
                                    if ($paing_amount >= $penalty && $penalty >0) {
                                        $update_penalty += $penalty;
                                        $s_penalty = $penalty;
                                        $penalty = 0;
                                        $paing_amount = $paing_amount - $penalty;
                                        
                                    } else if ($paing_amount < $penalty && $penalty >0 && $paing_amount >0) {
                                            $update_penalty += $paing_amount;
                                            $s_penalty = $paing_amount;
                                            $penalty = $penalty - $paing_amount;
                                    
                                            $paing_amount = $paing_amount - $paing_amount;                                                
                                    }                                  
                                    
                                } else if ($transactionProcessingStrategy == "Principal, Interest, Penalties, Fees  Order") {

                                    if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {

                                        $settlled_principal = $settlled_principal + $principal_to_pay;

                                        if($expected_date < $today) {
                                            $deliquent_principal += $principal_to_pay;
                                            $last_id = $last_id_deli;
                                        }

                                        $paing_amount = $paing_amount - $principal_to_pay;
                                        
                                        
                                    }  else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                            $settlled_principal = $settlled_principal + $paing_amount;

                                            if($expected_date < $today) {
                                                $deliquent_principal += $paing_amount;
                                                $last_id = $last_id_deli;
                                            }

                                            $paing_amount = $paing_amount - $paing_amount;
                                            
                                        
                                    }

                                    if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                            $settlled_interest = $settlled_interest + $interest_to_pay;
                                            
                                                if($waive == 1 && $expected_date > $waive_date) {
                                                    $paing_amount = $paing_amount;
                                                    $is_wave = 2;
                                                    $si2 = $si2 + $interest_to_pay;
                                                    $waive_amount = $waive_amount + $interest_to_pay;
                                                    $wv_amt = $wv_amt + $interest_to_pay;
                                                } else {
                                                    if($expected_date < $today) {
                                                        $deliquent_interest += $interest_to_pay;
                                                        $last_id = $last_id_deli;
                                                    }
                                                    $paing_amount = $paing_amount - $interest_to_pay;
                                                    $is_wave = NULL;
                                                }

                                    } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                    
                                            $settlled_interest = $settlled_interest + $paing_amount;

                                            if($waive == 1 && $expected_date > $waive_date) {
                                                $paing_amount = $paing_amount;
                                                $is_wave = 2;
                                                $si2 = $si2 + $paing_amount;
                                                $waive_amount = $waive_amount + $paing_amount;
                                                $wv_amt = $wv_amt + $paing_amount;
                                            } else {
                                                if($expected_date < $today) {
                                                    $deliquent_interest += $paing_amount;
                                                    $last_id = $last_id_deli;
                                                }
                                                $paing_amount = $paing_amount - $paing_amount;
                                                $is_wave = NULL;
                                            }
                                    }

                                    if ($paing_amount >= $penalty && $penalty >0) {
                                        $update_penalty += $penalty;
                                        $s_penalty = $penalty;
                                        $penalty = 0;
                                        $paing_amount = $paing_amount - $penalty;
                                        
                                    } else if ($paing_amount < $penalty && $penalty >0 && $paing_amount >0) {
                                            $update_penalty += $paing_amount;
                                            $s_penalty = $paing_amount;
                                            $penalty = $penalty - $paing_amount;

                                            $paing_amount = $paing_amount - $paing_amount;                                                
                                    }
                                // echo "$paing_amount - $settlled_principal-a</br>";
                            
                                    } else if ($transactionProcessingStrategy == "Interest, Principal, Penalties, Fees  Order") {
                                        if ($paing_amount > 0 && $paing_amount>= $interest_to_pay && $interest_to_pay > 0) {

                                            $settlled_interest = $settlled_interest + $interest_to_pay;
                                            
                                                if($waive == 1 && $expected_date > $waive_date) {
                                                    $paing_amount = $paing_amount;
                                                    $is_wave = 2;
                                                    $si2 = $si2 + $interest_to_pay;
                                                    $waive_amount = $waive_amount + $interest_to_pay;
                                                    $wv_amt = $wv_amt + $interest_to_pay;
                                                } else {
                                                    if($expected_date < $today) {
                                                        $deliquent_interest += $interest_to_pay;
                                                        $last_id = $last_id_deli;
                                                    }
                                                    $paing_amount = $paing_amount - $interest_to_pay;
                                                    $is_wave = NULL;
                                                }
                                        
                                    } else if ($paing_amount > 0 && $paing_amount < $interest_to_pay && $interest_to_pay > 0) {
                                    
                                            $settlled_interest = $settlled_interest + $paing_amount;

                                            if($waive == 1 && $expected_date > $waive_date) {
                                                $paing_amount = $paing_amount;
                                                $is_wave = 2;
                                                $si2 = $si2 + $paing_amount;
                                                $waive_amount = $waive_amount + $paing_amount;
                                                $wv_amt = $wv_amt + $paing_amount;
                                            } else {
                                                
                                                if($expected_date < $today) {
                                                    $deliquent_interest += $paing_amount;
                                                    $last_id = $last_id_deli;
                                                }
                                                $paing_amount = $paing_amount - $paing_amount;
                                                $is_wave = NULL;
                                            }
                                    }

                                    if ($paing_amount >= $principal_to_pay && $principal_to_pay >0) {

                                        $settlled_principal = $settlled_principal + $principal_to_pay;

                                        if($expected_date < $today) {
                                            $deliquent_principal += $principal_to_pay;
                                            $last_id = $last_id_deli;
                                        }

                                        $paing_amount = $paing_amount - $principal_to_pay;
                                        
                                        
                                    } else if ($paing_amount < $principal_to_pay && $principal_to_pay >0 && $paing_amount >0) {
                                            $settlled_principal = $settlled_principal + $paing_amount;

                                            if($expected_date < $today) {
                                                $deliquent_principal += $paing_amount;
                                                $last_id = $last_id_deli;
                                            }

                                            $paing_amount = $paing_amount - $paing_amount;

                                        
                                    }

                                    if ($paing_amount >= $penalty && $penalty >0) {
                                        $update_penalty += $penalty;
                                        $s_penalty = $penalty;
                                        $penalty = 0;
                                        $paing_amount = $paing_amount - $penalty;
                                        
                                    } else if ($paing_amount < $penalty && $penalty >0 && $paing_amount >0) {
                                            $update_penalty += $paing_amount;
                                            $s_penalty = $paing_amount;
                                            $penalty = $penalty - $paing_amount;

                                            $paing_amount = $paing_amount - $paing_amount;                                                
                                    }

                                }
                                
                                
                                    /*

                                    if ($due_principal > 0 && $due_principal >= $settlled_principal) {
                                        $due_principal = $due_principal - $settlled_principal;
                                    } else if ($due_principal > 0 && $due_principal < $settlled_principal) {
                                            $due_principal = 0;
                                    }
                                    */

                                    /*
                                    if ($due_interest > 0 && $due_interest >= $settlled_interest) {
                                        $due_interest = $due_interest - $settlled_interest;
                                    } else if ($due_interest > 0 && $due_interest < $settlled_interest) {
                                        $due_interest = 0;
                                    }
                                    */
                                    $due_principal = $expected_principal - $settlled_principal;
                                    $due_interest = $expected_interest - $settlled_interest;

                                    $settlled_principal_interest = $settlled_principal + $settlled_interest;
                                    //$due_principal_interest_act = $due_principal + $due_interest;

                                    
                                        $due_principal_interest = $due_principal + $due_interest;
                                    

                                    /*
                                    if ($expected_date > $value_date) {
                                        $due_interest = 0;
                                        $due_principal = 0;
                                        $due_principal_interest = 0;
                                    }
                                    */

                                    $update_principal_jornal += $settlled_principal - $sp2;
                                    $update_interest_jornal += $settlled_interest - $si2;
                                    $update_principal_interest_jornal += $settlled_principal_interest - $spi2;

                                    

                                    if($due_principal <1) {
                                        $due_principal = 0;
                                    }
                                    if($due_interest <1) {
                                        $due_interest = 0;
                                    }
                                    if($due_principal_interest <1) {
                                        $due_principal_interest = 0;
                                    }

                                    //REMOVE ANY UNNECESSARY FRACTIONS
                                    $check_diff = $expected_principal_interest - $settlled_principal_interest;
                                    $today = date("Y-m-d");
                                    $today_date1 = date("Y-m-d");
                                    if($expected_date > $today) {
                                        $due_principal_interest = 0;
                                        $due_principal= 0;
                                        $due_interest = 0;
                                    }
                                    
                                    if ($check_diff <= 0.009) {
                                        $settlled_principal_interest = $expected_principal_interest;
                                        $settlled_principal = $expected_principal;
                                        $settlled_interest = $expected_interest;
                                        $due_principal_interest = 0;
                                        $due_principal= 0;
                                        $due_interest = 0;
                                    }

                                    $d1 = date("Y-m-d", strtotime($today_date1));
                                    $d2 = date("Y-m-d", strtotime($expected_date));
                                    $difference = strtotime($d2) - strtotime($d1);
                                    $diff = $difference/(60 * 60)/24;
                                    if($diff > 0) {
                                        $settlled_status = "E";
                                    } else if($diff == 0) {
                                        $settlled_status = "A";
                                    } else {
                                        $settlled_status = "L";
                                    }

                                    if($waive == 1) {
                                        $due_principal_interest = 0;
                                        $due_principal = 0;
                                        $due_interest = 0;
                                        $ls = $db->prepare("UPDATE loan_schedule SET settlled_principal=expected_principal, settlled_interest=expected_interest, settlled_principal_interest=expected_principal_interest, due_principal=?, due_interest=?, due_principal_interest=?, transaction_id=?, interest_status=?, penalty=?, settlled_date=?, settlled_status=?, days_difference=? WHERE id=?");
                                        $ls->bind_param('dddiidssii', $due_principal, $due_interest, $due_principal_interest, $last_id, $is_wave, $penalty, $today_date1, $settlled_status, $diff, $update_id);
                                        $ls->execute();

                                        $bxa = $db->prepare("INSERT INTO schedule_reverse (shid, tid) VALUES (?,?)");
                                        $bxa->bind_param("ii", $update_id, $last_id);
                                        $bxa->execute();


                                        $bk_principal = $settlled_principal - $sp2;
                                        $bk_interest = $settlled_interest - $si2;
                                        $bk_principal_interest = $settlled_principal_interest -  $spi2;

                                        $bk_penalty = $s_penalty - $penalty;

                                        $ch = $db->prepare("INSERT INTO loan_schedule_backup (schedule_id, last_paid_principal, last_paid_interest, last_paid_principal_interest, waived_interest, last_penalty) VALUES (?,?,?,?,?,?)");
                                        $ch->bind_param("iddddd", $update_id, $bk_principal, $bk_interest, $bk_principal_interest, $wv_amt, $bk_penalty);
                                        $ch->execute();

                                        $update_interest_jornal = $i_expted;
                                        $update_principal_interest_jornal = $t_expected_with_waiver;
                                    } else {
                                        $ls = $db->prepare("UPDATE loan_schedule SET settlled_principal=?, settlled_interest=?, settlled_principal_interest=?, due_principal=?, due_interest=?, due_principal_interest=?, transaction_id=?, interest_status=?, penalty=?, settlled_date=?, settlled_status=?, days_difference=? WHERE id=?");
                                        $ls->bind_param('ddddddiidssii', $settlled_principal, $settlled_interest, $settlled_principal_interest, $due_principal, $due_interest, $due_principal_interest, $last_id, $is_wave, $penalty, $today_date1, $settlled_status, $diff, $update_id);
                                        $ls->execute();

                                        $bxa = $db->prepare("INSERT INTO schedule_reverse (shid, tid) VALUES (?,?)");
                                        $bxa->bind_param("ii", $update_id, $last_id);
                                        $bxa->execute();


                                        $bk_principal = $settlled_principal - $sp2;
                                        $bk_interest = $settlled_interest - $si2;
                                        $bk_principal_interest = $settlled_principal_interest -  $spi2;

                                        $bk_penalty = $s_penalty - $penalty;

                                        $ch = $db->prepare("INSERT INTO loan_schedule_backup (schedule_id, last_paid_principal, last_paid_interest, last_paid_principal_interest, waived_interest, last_penalty) VALUES (?,?,?,?,?,?)");
                                        $ch->bind_param("iddddd", $update_id, $bk_principal, $bk_interest, $bk_principal_interest, $wv_amt, $bk_penalty);
                                        $ch->execute();
                                    }
                                }

                        //}
                            endforeach;                            

                            if($has_teller==1) { 
                                $fund_source = $tl_gl;
                            }

                            //$today_date = date("Y-m-d");
                            $today = date("Y-m-d");

                            $fo = 0;

                            if ($update_principal_jornal > 0) {

                                if($deliquent_principal > 0 && $update_principal_jornal > $deliquent_principal) {
                                    $non_deliquent_principal = $update_principal_jornal - $deliquent_principal;
        
                                    $crd_gl2 = -$non_deliquent_principal;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description = "Loan Repayment";
                                    $jn1 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn1->bind_param("iddiiiisssss", $last_id, $crd_gl2, $fo, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency, $group_reverse);
                                    $jn1->execute();
        
                                    $crd_gl2_d = -$deliquent_principal;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description_d = "Loan Recovery";
                                    $jn1_d = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, group_id, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn1_d->bind_param("iddiiiisssiss", $last_id_deli, $crd_gl2_d, $update_principal_interest_jornal, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description_d, $journal_date, $last_id, $currency, $group_reverse);
                                    $jn1_d->execute();
        
                                    //INSERT INTO RECOVERY TABLE
                                    $rcv = $db->prepare("INSERT INTO loan_recovery (loan_id, transaction_id, amount, recovered_by, recovery_type, recovery_date, transaction_date) VALUES (?,?,?,?,?,?,?)");
                                    $rcv->bind_param("iidisss", $account_id, $last_id_deli, $deliquent_principal, $recovered_by, $recovery_type, $value_date, $target_date);
                                    $rcv->execute();
        
                                } else if($deliquent_principal > 0 && $update_principal_jornal <= $deliquent_principal && $update_principal_jornal > 0) {
                                    $crd_gl2_d = -$deliquent_principal;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description_d = "Loan Recovery";
                                    $jn1_d = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, group_id, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn1_d->bind_param("iddiiiisssiss", $last_id_deli, $crd_gl2_d, $update_principal_interest_jornal, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description_d, $journal_date, $last_id, $currency, $group_reverse);
                                    $jn1_d->execute();
        
                                    //INSERT INTO RECOVERY TABLE
                                    $rcv = $db->prepare("INSERT INTO loan_recovery (loan_id, transaction_id, amount, recovered_by, recovery_type, recovery_date, transaction_date) VALUES (?,?,?,?,?,?,?)");
                                    $rcv->bind_param("iidisss", $account_id, $last_id_deli, $deliquent_principal, $recovered_by, $recovery_type, $value_date, $target_date);
                                    $rcv->execute();
        
                                    $last_id = $last_id_deli;
                                } else {
                                    $crd_gl2 = -$update_principal_jornal;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description = "Loan Repayment";
                                    $jn1 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn1->bind_param("iddiiiisssss", $last_id, $crd_gl2, $update_principal_interest_jornal, $loan_portfolio, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency, $group_reverse);
                                    $jn1->execute();
                                }
        
                            }
                            if ($update_interest_jornal > 0) {
        
                                $fs = 0;
                                $fs1 = 0;
                                if($deliquent_interest > 0 && $update_interest_jornal > $deliquent_interest) {
                                    $non_deliquent_interest = $update_interest_jornal - $deliquent_interest;
                            
                                    $crd_gl3 = -$non_deliquent_interest;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description = "Loan Interest";
                                    if($update_principal_jornal == 0) {
                                        $fs = $non_deliquent_interest;
                                    } else {
                                    $fs = 0;
                                    }

                                    if($update_principal_jornal == 0) {
                                        $fs1 = $deliquent_interest;
                                    } else {
                                    $fs1 = 0;
                                    }
                                    $jn2 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn2->bind_param("iddiiiisssss", $last_id, $crd_gl3, $fs, $income_for_interest, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency, $group_reverse);
                                    $jn2->execute();
                            
                                    $crd_gl3_d = -$deliquent_interest;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description_d = "Loan Interest";
                                    $jn2_d = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, group_id, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn2_d->bind_param("iddiiiisssiss", $last_id_deli, $crd_gl3_d, $fs1, $income_from_recovery, $fund_source, $aid, $customer_branch, $journal_type, $journal_description_d, $journal_date, $last_id, $currency, $group_reverse);
                                    $jn2_d->execute();
                            
                                } else if($deliquent_interest > 0 && $update_interest_jornal <= $deliquent_interest && $update_interest_jornal > 0) {

                                    if($update_principal_jornal == 0) {
                                        $fs = $deliquent_interest;
                                    } else {
                                    $fs = 0;
                                    }

                                    $crd_gl3_d = -$deliquent_interest;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description_d = "Loan Interest";
                                    
                                    $jn2_d = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, group_id, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn2_d->bind_param("iddiiiisssiss", $last_id_deli, $crd_gl3_d, $fs, $income_from_recovery, $fund_source, $aid, $customer_branch, $journal_type, $journal_description_d, $journal_date, $last_id, $currency, $group_reverse);
                                    $jn2_d->execute();
                            
                                    //INSERT INTO RECOVERY TABLE
                                    $last_id = $last_id_deli;
                                } else {
                                    if($update_principal_jornal == 0) {
                                        $fs = $update_interest_jornal;
                                    } else {
                                    $fs = 0;
                                    }
                                    $crd_gl3 = -$update_interest_jornal;
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $journal_description = "Loan Interest";

                                    
                                    $jn2 = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn2->bind_param("iddiiiisssss", $last_id, $crd_gl3, $fs, $income_for_interest, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency, $group_reverse);
                                    $jn2->execute();
                                }
                            
                            }                            
        
                            if ($update_penalty > 0) {
                                $crd_gl4 = -$update_penalty;
                                $journal_date = $value_date;
                                $journal_description = "Loan Penalty";
                                $fs = $update_penalty;
                                $jn2j = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency, group_reverse) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                                $jn2j->bind_param("iddiiiisssss", $last_id_pn, $crd_gl4, $fs, $income_from_penalties, $fund_source, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency, $group_reverse);
                                $jn2j->execute();
                            }

                            

                             //CLOSE ACCOUNT IF BALANCE IS ZERO
                    $cld = $db -> prepare('SELECT * FROM accounts WHERE account_number=? AND customer_id=?');
                    $cld -> bind_param('si', $account_number, $customer_id);
                    $cld -> execute();
                    $rcld = $cld->get_result();

                    while($cl = mysqli_fetch_assoc($rcld) ){

                        $acc_balance = $cl['cleared_balance'];
                        $ac_status = $cl['status'];

                    }

                    //GET the current penalty balance
                    $zo = 0;
                    $epn1 = $db -> prepare("SELECT SUM(penalty) as p_pen FROM loan_schedule WHERE account_no=? AND customer_id=? AND penalty > ?");
                    $epn1 -> bind_param('sid', $account_number, $customer_id, $zo);
                    $epn1 -> execute();
                    $repn1 = $epn1->get_result();
                    if($repn1->num_rows > 0) {
                        while($ep11 = mysqli_fetch_assoc($repn1) ){
                            $exp_penalty1 = $ep11["p_pen"];
                        }
                    } else {
                        $exp_penalty1 = 0;
                    }

                    if ($waive == 1) {

                        $acc_balance = 0;

                    }
                    $zero = 0;
                    if ($acc_balance *-1 < 1 && $exp_penalty1 == 0) {
                        $clooo = "Closed";
                        
                        $io = $db->prepare("UPDATE accounts SET status=?, cleared_balance=?, closed_date=? WHERE customer_id=? AND account_number=?");
                        $io->bind_param('sdsis', $clooo, $zero, $today_date, $customer_id, $account_number);
                        $io->execute();
                        $io->close();

                        if ($io) {
                        $clo = $db->prepare("UPDATE loan_schedule SET due_principal=?, due_interest=?, due_principal_interest=? WHERE account_no=?");
                        $clo->bind_param('ddds', $zero, $zero, $zero, $account_number);
                        $clo->execute();
                        $clo->close();

                        $clo1 = $db->prepare("UPDATE loan_schedule SET settlled_principal=expected_principal, settlled_interest=expected_interest, settlled_principal_interest=expected_principal_interest WHERE account_no=? AND settlled_principal_interest<expected_principal_interest");
                        $clo1->bind_param('s', $account_number);
                        $clo1->execute();
                        $clo1->close();
                        //UPDATE LOCKED SAVINGS TO 0 IF ANY FOR THIS LOAN

                        $upd_sav = $db->prepare("UPDATE lock_funds SET locked_amount=? WHERE loan_id=?");
                        $upd_sav->bind_param('di', $zero, $account_id);
                        $upd_sav->execute();
                        $upd_sav->close();

                        //DELETE REPAYMENT BACKUP FOR REVERSALS
                        $dl5 = $db->prepare("DELETE FROM schedule_reverse WHERE shid IN(SELECT id FROM loan_schedule WHERE loan_id=?)");
                        $dl5->bind_param("i", $account_id);
                        $dl5->execute();

                        $dlbk = $db->prepare("DELETE FROM loan_schedule_backup WHERE schedule_id IN(SELECT id FROM loan_schedule WHERE loan_id=?)");
                        $dlbk->bind_param("i", $account_id);
                        $dlbk->execute();

                            if($dva_account != "") {
                                //DELETE DVA
                                $dvpdta =  array('dva' => $dva_account);
                                $ddva = curl_init();
                                curl_setopt($ddva, CURLOPT_URL,"$egis_api_root/delete_dva.php");
                                curl_setopt($ddva, CURLOPT_POST, 1);
                                curl_setopt($ddva, CURLOPT_POSTFIELDS,json_encode($dvpdta));  //Post Fields
                                curl_setopt($ddva, CURLOPT_RETURNTRANSFER, true);
                                //Set your auth headers
                                curl_setopt($ddva, CURLOPT_HTTPHEADER, array(
                                    'Content-Type: application/json'
                                ));
                                                
                                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                $datadva2 = curl_exec($ddva);
                                curl_close ($ddva);
                            }

                        }
                    }  else {

                            if($ac_status == "Delinquent" && $acc_balance *-1 > 1) {
                                $deli1 = $db -> prepare("SELECT SUM(due_principal_interest) as deli FROM loan_schedule WHERE loan_id=? AND expected_date < ? AND due_principal_interest > ?");
                                $deli1 -> bind_param('isi', $account_id, $today, $zero);
                                $deli1 -> execute();
                                $rdeli1 = $deli1->get_result();

                                while($dib1 = mysqli_fetch_assoc($rdeli1) ){
                                    $deliquent_amount1 = $dib1['deli'];
                                }

                                if($deliquent_amount1 == 0) {
                                    $nustatus = "Active";
                                    $io = $db->prepare("UPDATE accounts SET cleared_balance=?, status=? WHERE customer_id=? AND account_number=?");
                                    $io->bind_param('dsis', $acc_balance, $nustatus, $customer_id, $account_number);
                                    $io->execute();
                                    $io->close();
                                    
                                } else {
                                    $io = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                    $io->bind_param('dis', $acc_balance, $customer_id, $account_number);
                                    $io->execute();
                                    $io->close();
                                }

                            } else {
                                $io = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                                $io->bind_param('dis', $acc_balance, $customer_id, $account_number);
                                $io->execute();
                                $io->close();
                            }
                        }

                            //UPDATE EGIS CREDIT_CHECK
                            include("credit_update.php");


        
            if ($total_balance == 0) {
                $_SESSION['msg1'] = "Failed";
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>You have previously completed all repayments. Funds have been moved to your attached savings account.</h2>";
                
            }
       // }


        //UPDATE WORK QUEUE STATUS

        //UPDATE WORKFLOW TRANSACTION
        $mman = $db -> prepare("SELECT proof FROM verify_transactions WHERE id=?");
        $mman -> bind_param('i', $verify_id);
        $mman -> execute();
        $rmman = $mman->get_result();

        while($gut = mysqli_fetch_assoc($rmman) ){
            $proof = $gut['proof'];
        }
        if($proof !="") {
            unlink($proof);
        }
        $nul = NULL;
        $update = "Approved";

        $io = $db->prepare("UPDATE verify_transactions SET status=?, proof=? WHERE id=?");
        $io->bind_param('ssi', $update, $nul, $verify_id);
        $io->execute();
        $io->close();

        $ent_id = 34;
        $act_id = 142;
        $wfcheck = $db -> prepare('SELECT * FROM work_queue WHERE main_area_id=? AND entity_id=? AND action_id=?');
        $wfcheck -> bind_param('iii', $verify_id, $ent_id, $act_id);
        $wfcheck -> execute();
        $rwfcheck = $wfcheck->get_result();

        if ($rwfcheck->num_rows > 0) {

            $new_status = "Treated";

            $updwk = $db->prepare("UPDATE work_queue SET status=?, $by=? WHERE main_area_id=? AND entity_id=? AND action_id=?");
            $updwk->bind_param('siiii', $new_status, $aid, $verify_id, $ent_id, $act_id);
            $updwk->execute(); 

        }    

    }

}//END LOAN RECOVERY

//TRANSFER TRANSACTION FUNCTION
function approveTransfer($by, $verify_id, $br_start_date, $action, $db, $transfer_amount, $transfer_comment, $customer_id, $account_number, $value_date, $to_account, $beneficiary_acc_bank, $transfer_type, $maintenance, $login_session_expiry, $org_code, $egis_api, $egis_secret, $egis_transfers, $site_name, $egis_api_root, $is_sms_active, $is_email, $site_domain) {
    include('../welcome_user.php');
    $_SESSION['msg1'] = "";

    if ($transfer_type == "Inbound" && $inbound == "") {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Inbound Control GL not set. Kindly set it and try again.</h2>";

        $_SESSION['msg1'] = "Failed";
    } elseif ($transfer_type == "Outbound" && $outbound == "") {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Outbound Control GL not set. Kindly set it and try again</h2>";

        $_SESSION['msg1'] = "Failed";
    } else {
        if ($transfer_type == "Inbound") {
            $maingl = $inbound;
        } else if ($transfer_type == "Outbound") {
            $maingl = $outbound;
        }
    $onee = 1;
    $rev = "X";
    $charge_amount_trt_r = 0;
    if ($transfer_type == "Inbound") {

        $sit_con1 = $db -> prepare("SELECT * FROM config");
        $sit_con1 -> execute();
		$resultsit_con1 = $sit_con1->get_result();
		while($mmsit_con1 = mysqli_fetch_assoc($resultsit_con1) ) {
                $site_name = $mmsit_con1['name'];
                
		}

        $beneficiary_acc_bank = "$site_name Bank";
        $charge_text = "Inbound Transfer Fee";
    
        $closed = "Closed";
        $pod5 = $db -> prepare('SELECT * FROM accounts WHERE account_number=? AND status !=?');
        $pod5 -> bind_param('ss', $to_account, $closed);
        $pod5 -> execute();
        $rpod5 = $pod5->get_result();
        if ($rpod5->num_rows > 0) {
        while($row5 = mysqli_fetch_assoc($rpod5) ){
            $account_id_r = $row5['id'];
            $cleared_balance5 = $row5['cleared_balance'];
            $receiver_id = $row5['customer_id'];
            $product5 = $row5['product'];
            $product_type5 = $row5['product_type'];
            $receiver_branch = $row5["secondary_branch"];
            $receiver_rm = $row5["secondary_relationship_manager"];
            $sms_alert_r = $row5["sms_alert"];
            $email_alert_r = $row5["email_alert"];
            $receiver_status = $row5["status"];
            $plan_amount = $row5['plan_amount'];
            $cu_creation_date = date('d-m-Y', strtotime($row5['creation_date']));
            $creation_date = $row5["creation_date"];
            $approval_date = $row5["approval_date"];
            $account_status5 = $row5['status'];
            $total_debited_thrift_fee = $row5['total_debited_thrift_fee'];
    
        }

        if ($product_type5=="Savings") {
            $product5_r = str_replace("S","","$product5");
            $scx = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
            $scx -> bind_param('i', $product5_r);
            $scx -> execute();
            $rscx = $scx->get_result();
                while($sc1x = mysqli_fetch_array($rscx) ){
                    $maxAmount = $sc1x['maxAmount'];
                }
        }  else if ($product_type5=="Thrift") {
            $product5_r = str_replace("T","","$product5");
            $scx = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
            $scx -> bind_param('i', $product5_r);
            $scx -> execute();
            $rscx = $scx->get_result();
            while($sc1x = mysqli_fetch_array($rscx) ){
                $maxAmount = $sc1x['maxAmount'];
                $deduct_charge_per_tenure = $sc1x['deduct_charge_per_tenure'];
                $plan_count = $sc1x['plan_count'];
            }

            $today_date = date("Y-m-d");
            $date1 = new DateTime($approval_date);
            $date2 = new DateTime($today_date);
            $total_days  = $date2->diff($date1)->format('%a');
      
            $amount_case = $cleared_balance5 / $plan_amount;
      
            if($total_debited_thrift_fee >0) {
            $debit_count = $total_debited_thrift_fee/$plan_amount;
                      
                for($o=0; $o<$debit_count; $o++) {
                    $total_days = $total_days - $plan_count;
                }
            } else {
            $debit_count = 0 ;
            }
                
            $charge_count = 0;
            $status_tr = "Approved";
            for ($i=0; $i < $total_days; $i += $plan_count) {
                //$end_date = $creation_date + $plan_count;
                $end_date = date("Y-m-d", strtotime($approval_date . "+".$plan_count." days"));
                
                $cdt = "Credit";
                $grec = $db -> prepare("SELECT SUM(transaction_amount) AS tram FROM transactions WHERE account_number =? AND status=? AND transaction_type=? AND (value_date BETWEEN ? AND ?)");
                $grec -> bind_param('sssss', $to_account, $status_tr, $cdt, $approval_date, $end_date);
                $grec -> execute();
                $rgrec = $grec->get_result();
                
                while($gre_r = mysqli_fetch_array($rgrec) ){
                    $sum_amount = $gre_r['tram'];
                
                }
                if ($sum_amount > 0) {
                    $charge_count = $charge_count + 1;
                }
                
                $approval_date = $end_date;
                
            }
                
            if ($amount_case > $charge_count && $amount_case > $plan_count) {
                $charge_count = ceil($amount_case/$plan_count);
            }
                
            $balance_count = $charge_count - $debit_count;
            $charge_amount_trt_r = $balance_count * $plan_amount;
        } else if ($product_type5=="Current") {
            $product5_r = str_replace("C","","$product5");
            $scx = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
            $scx -> bind_param('i', $product5_r);
            $scx -> execute();
            $rscx = $scx->get_result();
                while($sc1x = mysqli_fetch_array($rscx) ){
                    $maxAmount = $sc1x['maxAmount'];
                }
        }
        $proceed = 1;

        if($product_type5 == "Savings" || $product_type5 == "Current" || $product_type5 == "Float") {

            $active_d = "Active";
            if($product_type5 == "Savings") {
                $pty_d = "Savings Account";
             } else if($product_type5 == "Current") {
                $pty_d = "Current Account";
             } else if($product_type5 == "Float") {
                $pty_d = "Float Account";
             }
            $nm_d = "Dormancy";
            
            $credits1 = "Credit Transactions";
                $crpnd1 = $db -> prepare('SELECT * FROM policies WHERE product_type=? AND status=? AND name=?');
                $crpnd1->bind_param("sss", $pty_d, $active_d, $nm_d);
                $crpnd1 -> execute();
                $rcrpnd1 = $crpnd1->get_result();
                if ($rcrpnd1->num_rows > 0) {
           
                    while($jvx1 = mysqli_fetch_assoc($rcrpnd1) ){  
                        
                        if(strpos($jvx1['affected_products'], ' , ') !== false) {
                            // explodable
                            $productssarray1 = explode(' , ',$jvx1['affected_products']);
                            
                          } else {
                            // not explodable
                            $productssarray11 = array($jvx1['affected_products']);
                          }
           
                          if(strpos($jvx1['restrict_events'], ' , ') !== false) {
                           // explodable
                           $eventsarray1 = explode(' , ',$jvx1['restrict_events']);
                           
                           } else {
                               // not explodable
                               $eventsarray1 = array($jvx1['restrict_events']);
                           }

                           if(strpos($jvx1['channels'], ' , ') !== false) {
                            // explodable
                            $channelsarray1 = explode(' , ',$jvx1['channels']);
                
                            } else {
                                // not explodable
                                $channelsarray1 = array($jvx1['channels']);
                    
                            }
                       }
           
                       if (in_array($product5, $productssarray1) && in_array($channel_log, $channelsarray1)) {
           
                           $pvalid1 = 1;
           
                       } else {
                           $pvalid1 = 0;
                       }
           
                       if (in_array($credits1, $eventsarray1) && in_array($channel_log, $channelsarray1)) {
           
                           $acdts1 = 1;
           
                       } else {
                           $acdts1 = 0;
                       }
           
                       if($pvalid1 == 1 && $acdts1 == 1) {
                           $a_cdt1 = 1;
                       } else {
                           $a_cdt1 = 0;
                       }
                   } else {
                       $a_cdt1 = 0;
                   }
                } else {
                    $a_cdt1 = 0;
                }
        } else {
            $proceed = 2;
            $maxAmount = 0;
            $a_cdt1 = 0;
        }
    
    } else {
        $maxAmount = 0;
        $proceed = 1;
        $charge_text = "Outbound Transfer Fee";
        $a_cdt1 = 0;
    }
    
    $pod = $db -> prepare('SELECT * FROM accounts WHERE customer_id=? AND account_number=?');
    $pod -> bind_param('is', $customer_id, $account_number);
    $pod -> execute();
    $rpod = $pod->get_result();
    
    while($row = mysqli_fetch_assoc($rpod) ){
        $account_id = $row['id'];
        $product_type = $row['product_type'];
        $product = $row['product'];
        $opening_amount = $row['opening_amount'];
        $loan_amount = $row['loan_amount'];
        $cleared_balance = $row['cleared_balance'];
        //$customer_branch = $row["secondary_branch"];
        $branch = $row["secondary_branch"];
        $customer_rm = $row["secondary_relationship_manager"];
        $cu_creation_date = date('d-m-Y', strtotime($row['creation_date']));
        $account_status = $row['status'];
        $sms_alert = $row["sms_alert"];
        $email_alert = $row["email_alert"];
    
    }
    //GET INITIATOR BRANCH
    $ovr = $db -> prepare('SELECT branch FROM users WHERE id IN(SELECT created_by FROM verify_transactions WHERE id=?)');
    $ovr -> bind_param('i', $verify_id);
    $ovr -> execute();
    $rovr = $ovr->get_result();

    while($iov = mysqli_fetch_assoc($rovr) ){
        $customer_branch = $iov['branch'];
    }

    if($product_type == "Savings" || $product_type == "Current" || $product_type == "Float") {
        $cnl = $channel_log;
        require_once("dorm_check.php");
    } else {
        $a_dbt = 0;
        $a_cdt = 0;
        $a_ph = 0;
        $a_em = 0;
    }

     //CHECK IF PND IS SET FOR THIS ACCOUNT
     $ppnd = $db -> prepare('SELECT * FROM pnd WHERE account_id=?');
     $ppnd -> bind_param('i', $account_id);
     $ppnd -> execute();
     $rppnd = $ppnd->get_result();
     if ($rppnd->num_rows > 0) {
         $is_pnd = 1;
     } else {
         $is_pnd = 0;
     }
     //CHECK IF THERE'S LIEN FOR THIS ACCOUNT
     $lln = $db -> prepare('SELECT * FROM lien WHERE account_id=?');
     $lln -> bind_param('i', $account_id);
     $lln -> execute();
     $rlln = $lln->get_result();
 
     if ($rlln->num_rows > 0) {
         while($jvx = mysqli_fetch_assoc($rlln) ){ 
             $lien= $jvx["amount"];
         }
     } else {
         $lien = 0;
     }

     $pl_event = "Transfer";
    require_once("daily_transaction_limit.php");
    
    if($global_limit == 1) {
        $pldsc = "Transfer-out";
        $status_pld = "Approved";
        $pdlm = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=?");
        $pdlm -> bind_param('ssss', $account_number, $status_pld, $pldsc, $value_date);
        $pdlm -> execute();
        $rpdlm = $pdlm->get_result();
      
        while($dlm_o = mysqli_fetch_array($rpdlm) ){
            $global_amount_so_far = $dlm_o['dlm'];
        }

        if($transfer_amount + $global_amount_so_far > $transaction_limit_g) {
            $proceed_global = 1;
        }
    }
    if($channel_limit == 1) {
        $pldsc = "Transfer-out";
        $status_pld = "Approved";
        $pdlm1 = $db -> prepare("SELECT SUM(transaction_amount) AS dlm FROM transactions WHERE account_number =? AND status=? AND transaction_description=? AND value_date=? AND channel=?");
        $pdlm1 -> bind_param('ssssi', $account_number, $status_pld, $pldsc, $value_date, $channel_log);
        $pdlm1 -> execute();
        $rpdlm1 = $pdlm1->get_result();
      
        while($dlm_o1 = mysqli_fetch_array($rpdlm1) ){
            $channel_amount_so_far = $dlm_o1['dlm'];
        }

        if($transfer_amount + $channel_amount_so_far > $transaction_limit_c) {
            $proceed_channel = 1;
        }
    }

    $cu_creation_date1 = strtotime($cu_creation_date) * 1000;
    $br_start_date1 = strtotime($br_start_date) * 1000;
    if($br_start_date1 < $cu_creation_date1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>You cannot do transactions on a date below account creation date.</h2>";

        $_SESSION['msg1'] = "Failed";
    } else if ($a_cdt1 == 1 && $account_status5 == "Dormant") {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Destination account is dormant and does not receive transfers</h2>";

        $_SESSION['msg1'] = "Failed";

    } else if($account_status == "Invalid" || $account_status == "Pending" || $account_status == "Closed" || $account_status == "Frozen") {
        
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Transfer is not allowed for this account</h2>";

        $_SESSION['msg1'] = "Failed";
    } else if($is_pnd == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Account does not currently allow debit transactions.</h2>";

        $_SESSION['msg1'] = "Failed";
    } else if($proceed_global == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Transfer not allowed. Account Daily Transfer limit of $currency $transaction_limit_g exceeded.</h2>";

        $_SESSION['msg1'] = "Failed";
    } else if($proceed_channel == 1) {
        echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
        echo "</br></br><h2 class='center text-danger'>Transfer not allowed. Channel Daily Transfer limit of $currency $transaction_limit_c exceeded.</h2>";

        $_SESSION['msg1'] = "Failed";
    } else {

        if ($product_type == "Savings") {
            //DEDUCT LOCKED FUNDS FROM CLEARED BALANCE IF ANY
            $yui = $db -> prepare('SELECT SUM(locked_amount) as curr_locked  FROM lock_funds WHERE savings_id=?');
            $yui -> bind_param('i', $account_id);
            $yui -> execute();
            $ryui = $yui->get_result();
        
            if ($ryui->num_rows > 0) {
                while($io = mysqli_fetch_array($ryui) ){
                    $curr_locked = $io['curr_locked'];
            
                }
            } else {
                $curr_locked = 0;
            }
        
            
        } else {
            $curr_locked = 0;
        }

$pod1 = $db -> prepare('SELECT fname, mname, lname FROM customer WHERE customer_id=?');
$pod1 -> bind_param('i', $customer_id);
$pod1 -> execute();
$rpod1 = $pod1->get_result();

while($row1 = mysqli_fetch_assoc($rpod1) ){
    $customer_name = $row1["fname"];
    $customer_mname = $row1["mname"];
    $customer_lname = $row1["lname"];
    $cu_character = strtoupper($customer_name[0]);
}

date_default_timezone_set("Africa/Lagos");
$transfer_transaction_date = date("Y-m-d H:i:s");
$transaction_date = date("Y-m-d H:i:s");

$num = mt_rand(100000, 999999);
$stamp = date("Yhis");
$orderId = $stamp . $num;

$stamp_1 = date("Yhis");

$transaction_id = "T$cu_character" . "$orderId";

$description = "Transfer-out";
$type = "Debit";
$yes = "Yes";

if ($product_type=="Savings") {
    $product2 = str_replace("S","","$product");
    $sc = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
    $sc -> bind_param('i', $product2);
    $sc -> execute();
    $rsc = $sc->get_result();
        while($sc1 = mysqli_fetch_array($rsc) ){
            $saving_reference = $sc1['saving_reference'];
            $saving_control = $sc1['saving_control'];
            $productGroup = $sc1['productGroup'];
            $minAmount = $sc1['minAmount'];
        }
}  else if ($product_type=="Thrift") {
    $product2 = str_replace("T","","$product");

    $sc = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
    $sc -> bind_param('i', $product2);
    $sc -> execute();
    $rsc = $sc->get_result();
        while($sc1 = mysqli_fetch_array($rsc) ){
            $saving_reference = $sc1['saving_reference'];
            $saving_control = $sc1['saving_control'];
            $productGroup = $sc1['productGroup'];
            $minAmount = $sc1['minAmount'];
        }
} else if ($product_type=="Current") {
    $product2 = str_replace("C","","$product");
    $sc = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
    $sc -> bind_param('i', $product2);
    $sc -> execute();
    $rsc = $sc->get_result();
        while($sc1 = mysqli_fetch_array($rsc) ){
            $saving_reference = $sc1['saving_reference'];
            $saving_control = $sc1['saving_control'];
            $productGroup = $sc1['productGroup'];
            $minAmount = $sc1['minAmount'];
        }
} else if ($product_type=="Float") {
    $product2 = str_replace("F","","$product");
    $sc = $db -> prepare('SELECT * FROM floatproduct WHERE id =?');
    $sc -> bind_param('i', $product2);
    $sc -> execute();
    $rsc = $sc->get_result();
        while($sc1 = mysqli_fetch_array($rsc) ){
            $saving_reference = $sc1['saving_reference'];
            $saving_control = $sc1['saving_control'];
            $productGroup = $sc1['productGroup'];
            $minAmount = $sc1['minAmount'];
        }
}

if($is_sms_active == 1 && $egis_transfers == 2) {

    $biz_rule = "Funds Transferred";
    $st_cmp = "Active";
    $trig = "Triggered";

    $xmxc = $db -> prepare('SELECT * FROM sms_campaign WHERE product_type=? AND business_rule=? AND status=? AND type=?');
    $xmxc -> bind_param('ssss', $product_type, $biz_rule, $st_cmp, $trig);
    $xmxc -> execute();
    $rxmxc = $xmxc->get_result();



if($sms_alert =="Yes" && $rxmxc->num_rows >0) {

    while($xv = mysqli_fetch_array($rxmxc) ){
        $message = $xv['message'];
        $branches = explode(" , ", $xv['branches']);
        $relationship_officers = explode(" , ", $xv['relationship_officers']);
        $product_groups = explode(" , ", $xv['product_groups']);
    }

    if (!empty($branches)) {

        if (in_array($customer_branch, $branches)) {
            $brn_sms = 1;
        } else {
            $brn_sms = 0;
        }

    } else {
        $brn_sms = 1;
    }
    if (!empty($relationship_officers)) {

        if (in_array($customer_rm, $relationship_officers)) {
            $rm_sms = 1;
        } else {
            $rm_sms = 0;
        }

    } else {
        $rm_sms = 1;
    }

    if (!empty($product_groups)) {

        if (in_array($productGroup, $product_groups)) {
            $pg_sms = 1;
        } else {
            $pg_sms = 0;
        }

    } else {
        $pg_sms = 1;
    }

    if ($brn_sms == 1 || $rm_sms==1 || $pg_sms == 1) {

        $charge_sms = 1;
    } else {
        $charge_sms = 0;
    }


} else {
    $charge_sms = 0;
}

} else {
$charge_sms = 0;
}

//CHECK IF EMAIL ALERT IS ENABLED
if($is_email == 1) {

    if($email_alert =="Yes") {
    
        $charge_email = 1;
    
        $yio = $db -> prepare('SELECT * FROM email_alert WHERE account_id=?');
        $yio -> bind_param('i', $account_id);
        $yio -> execute();
        $ryio = $yio->get_result();
        while($lk = mysqli_fetch_array($ryio) ){
            $alert_email = $lk['email'];
        }//THIS IS NOT YET READY. APPLY CHARGE ONCE IT'S READY
    } else {
        $charge_email = 0;
    }
    
    } else {
    $charge_email = 0;
    }

     //GET SUM OF ALL PENDING CHARGES
     $day_g = $db -> prepare('SELECT SUM(charge_amount) as chg FROM temp_charge WHERE account_number=?');
     $day_g -> bind_param('s', $account_number);
     $day_g -> execute();
     $rday_g = $day_g->get_result();
     while($ch = mysqli_fetch_assoc($rday_g) ){
         $pending_charges = $ch['chg'];
     }
//CHECK IF THERE ARE CHARGES AND ACCOUNT BALANCE IS SUFFICIENT TO HANDLE TRANSFER AND CHARGES
                    $charge_debit = 0;
                    if($charge_sms == 1) {
                        $charge_tl1 = "$charge_text";
                        $charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE active=? AND chargetype =? OR chargetype =?)');
                        $incr -> bind_param('ssss', $product, $yes, $charge_tl1, $charge_tl2);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        } else {
                        $charge_tl1 = "$charge_text";
                        //$charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                        $incr -> bind_param('sss', $product, $charge_tl1, $yes);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        }
                        if($rincr->num_rows > 0) {

                        foreach ($rincr as $iid):
                        
                        $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                        $de -> bind_param('i', $iid['cid']);
                        $de -> execute();
                        $rde = $de->get_result();
                        while($dee = mysqli_fetch_array($rde) ){
                        //Call Charge Amount
                        $trnsss_amount = $transfer_amount;
                        $chid = $iid['cid'];
                        include('../../charges.php');
                        //End Call Charge Amount
                        $charge_name = $dee['name'];
                        $charge_option = $dee['charge_option'];
                        }

                        if ($charge_option != "Flat") {
                            $charge_amount = $transfer_amount * ($charge_amount/100);
                        }
                            $charge_debit +=$charge_amount;
                            endforeach;

                            $total_debit = $transfer_amount + $charge_debit + $curr_locked + $pending_charges + $lien + $minAmount;
                        } else {
                            $total_debit = $transfer_amount + $curr_locked + $pending_charges + $lien + $minAmount;
                        }

                        if($transfer_type == "Inbound") {
                            $pn_g = $db -> prepare('SELECT SUM(charge_amount) as rchg FROM temp_charge WHERE account_number=?');
                            $pn_g -> bind_param('s', $to_account);
                            $pn_g -> execute();
                            $rpn_g = $pn_g->get_result();
                            while($pn = mysqli_fetch_assoc($rpn_g) ){
                                $pending_charges_r = $pn['rchg'];
                            }

                            $receiver_prospective_balance = $cleared_balance5 + $transfer_amount;
                            $receiver_prospective_balance = $receiver_prospective_balance - $pending_charges_r;
                            if($receiver_prospective_balance > $maxAmount) {
                                $destination_limit = 1;
                            } else {
                                $destination_limit = 0;
                            }
                        } else {
                            $destination_limit = 0;
                        }

                        if($maxAmount==0) {
                            $destination_limit = 0;
                        }

        if ($cleared_balance < $total_debit) {

            echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
            echo "</br></br><h2 class='center text-danger'>Insufficient Funds.</h2>";
            $_SESSION['msg1'] = "Failed";

            } else if ($proceed == 2) {

                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>Destination Account not found</h2>";
                $_SESSION['msg1'] = "Failed";
            } else if ($destination_limit == 1) {
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>Destination Account limit of $maxAmount reached</h2>";
                
            } else if ($account_number == $to_account) {

                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>You cannot transfer to the same Account.</h2>";
                $_SESSION['msg1'] = "Failed";

            } else if ($transfer_amount <= 0) {
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>Please enter a valid amount</h2>";
                $_SESSION['msg1'] = "Failed";
            }
                
            else if ($cleared_balance >= $total_debit) {

                //CHECK IF IT'S OUTBOUND TRANSFER
        if ($transfer_type == "Outbound") {
            //CALCULATE FEES
            //$transfer_amount = $loan_amount * -1;
    
            if ($transfer_amount <= 5000) {
                $transfer_fee = 20;
            } else if ($transfer_amount > 5000 && $transfer_amount <= 20000) {
                $transfer_fee = 40;
            } else if ($transfer_amount > 20000 && $transfer_amount <= 50000) {
                $transfer_fee = 60;
            } else if ($transfer_amount > 50000) {
                $transfer_fee = 80;
            }
    
                $total_deduct = $transfer_amount + $transfer_fee;
            
            //CHECK IF THE USER HAS SUFFICIENT BALANCE FOR THE DISBURSEMENT
            if ($egis_transfers == 2) {
                $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
        
                $ch1 = curl_init();
                curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                curl_setopt($ch1, CURLOPT_POST, 1);
                curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
    
                $headers1 = [
                'Content-Type: application/json'
                ];
    
                curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
    
                $request1 = curl_exec ($ch1);
    
                curl_close ($ch1);
                if ($request1) {
                $result1 = json_decode($request1, true);
                }
                    
                $token = $result1['token'];
    
                $postdata1 =  array('organization_code' => $org_code, 'branch' => $branch);
    
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL,"$egis_api_root/branch_balance.php");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata1));  //Post Fields
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                //Set your auth headers
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token
                ));
    
                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                $data = curl_exec($ch);
    
                //echo $data;
    
                //$decode = json_decode($data);
                $decode = json_decode($data, true);
    
                $balance = $decode['balance'];
                $globalbalance = $decode['gbalance'];
                } else {
                    $balance = 0;
                    $globalbalance = 0;
                }
    
            if ($balance < $total_deduct) {
                $proceed_disburse = 0;
            } else {
                $proceed_disburse = 1;
            }
    
            } else {
                $proceed_disburse = 1;
            }

            if ($proceed_disburse == 0) {
                //echo "<p class='text-danger center'>Insufficient Egis Transfer Funds. Please fund your Egis Transfers Balance</p>";
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>Insufficient Egis Transfer Funds. Please fund your Egis Transfers Balance</p></h2>";
                $_SESSION['msg1'] = "Failed";

            }/* else if ($globalbalance < 1200000 && $transfer_type == "Outbound") {
                //echo "<p class='text-danger center'>Insufficient Egis Transfer Funds. Please fund your Egis Transfers Balance</p>";
                echo "<img src='$site_domain/main/images/failed.png' alt='Failed'>";
                echo "</br></br><h2 class='center text-danger'>You have reached your transfer balance threshold. Please topup your Egis Transfers balance</p></h2>";
                $_SESSION['msg1'] = "Failed";

            }*/ else if ($proceed_disburse == 1) {

                $_SESSION['msg1'] = "Success";
                $new_amount = $cleared_balance - $transfer_amount;
                $previous_balance = $cleared_balance;
        
            //UPDATE CUSTOMER ACCOUNT
        
                  $pw = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                  $pw->bind_param('dis', $new_amount, $customer_id, $account_number);
                  $pw->execute();
                  $pw->close();
        
        
                  //INSERT INTO TRANSACTION TABLE
        
        
                    //DO THE ACTUAL TRANSFER HERE
        
                $w = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, to_account, bank, transfer_type, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $w->bind_param("ssidddssssssssiiiis", $transaction_id, $account_number, $customer_id, $previous_balance, $new_amount, $transfer_amount, $type, $description, $transfer_transaction_date, $value_date, $transfer_comment, $to_account, $beneficiary_acc_bank, $transfer_type, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1);
                $w->execute();
                $last_id = mysqli_insert_id($db);
        
                $entity_id = "TRR$last_id";
        
                //INSERT INTO ACTIVITY TABLE
                $act_dsc = "Funds Transfer ($transfer_amount) from $account_number to $to_account";
                $act_type = "Transfer";
                $ww = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                $ww->bind_param("sssiii", $act_dsc, $act_type, $entity_id, $aid, $usbrn, $channel_log);
                $ww->execute();
        
                if ($product_type=="Savings" || $product_type=="Thrift" || $product_type=="Current" || $product_type=="Float") {
                    
                //INSERT INTO JOURNAL
                $crd_gl = -$transfer_amount;
                $journal_date = $value_date;
                $journal_type = "Automatic";
                $journal_description = "Funds Transfer  from $account_number to $to_account";
                $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                $jn->bind_param("iddiiiissss", $last_id, $crd_gl, $transfer_amount, $maingl, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                $jn->execute();
                
                } else if ($product_type=="Term Deposit") {
                    $product2 = str_replace("TD","","$product");
                
                    /*
                    $sc = $db -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                    $sc -> bind_param('i', $product2);
                    $sc -> execute();
                    $rsc = $sc->get_result();
                        while($sc1 = mysqli_fetch_array($rsc) ){
                            $saving_reference = $sc1['saving_reference'];
                            $saving_control = $sc1['saving_control'];
                        }
                //
                //INSERT INTO JOURNAL
                $journal_date = $value_date;
                $journal_type = "Automatic";
                $journal_description = "Funds Transfer  from $account_number to $to_account";
                $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, type, description, date) VALUES (?,?,?,?,?,?,?,?,?)");
                $jn->bind_param("iddiiisss", $last_id, $transfer_amount, $transfer_amount, $saving_control, $saving_reference, $aid, $journal_type, $journal_description, $journal_date);
                $jn->execute();
                */
                
                } else if ($product_type=="Share") {
                    $product2 = str_replace("SH","","$product");
                }
        
                //DEDUCT THE APPLICABLE TRANSFER CHARGES
        
                if($charge_sms == 1) {

                    $yui = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                    $yui -> bind_param('i', $account_id);
                    $yui -> execute();
                    $ryui = $yui->get_result();
                    while($io = mysqli_fetch_array($ryui) ){
                        $alert_phone = $io['phone_no'];
                    }
            
                    //DO ALL SHORTCODE REPLACEMENTS
                    $dst_account = "**".substr($account_number, -4);
                    $message = str_replace("[accountNo]",$dst_account,$message);
                    $message = str_replace("[fname]",$fname,$message);
                    $message = str_replace("[lname]",$lname,$message);
                    $message = str_replace("[mname]",$mname,$message);
                    $message = str_replace("[vdate]",$value_date,$message);
                    $message = str_replace("[adate]",$transfer_transaction_date,$message);
                    $message = str_replace("[amount]",number_format($transfer_amount, 2, '.', ','),$message);
                    $message = str_replace("[balance]",number_format($new_amount, 2, '.', ','),$message);
                    $message = str_replace("[trbranch]",$customer_branch,$message);
                    
            
                    //SEND TO EGIS SERVICES FOR SENDING SMS HERE
            
                    $postdata =  array('api' => $egis_api, 'secret' => $egis_secret);
            
                    $ch1 = curl_init();
                    curl_setopt($ch1, CURLOPT_URL,"$egis_api_root/login.php");
                    curl_setopt($ch1, CURLOPT_POST, 1);
                    curl_setopt($ch1, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
            
                    $headers1 = [
                    'Content-Type: application/json'
                    ];
            
                    curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
            
                    $request1 = curl_exec ($ch1);
            
                    curl_close ($ch1);
                    if ($request1) {
                    $result1 = json_decode($request1, true);
                    }
                        
                    $token = $result1['token'];
            
                    $postdata3 =  array('organization_code' => $org_code, 'branch_id' => $customer_branch, 'recipient_phone' => $alert_phone, 'message' => $message);
            
                    $ch3 = curl_init();
                    curl_setopt($ch3, CURLOPT_URL,"$egis_api_root/sms.php");
                    curl_setopt($ch3, CURLOPT_POST, 1);
                    curl_setopt($ch3, CURLOPT_POSTFIELDS,json_encode($postdata3));  //Post Fields
                    curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
                    //Set your auth headers
                    curl_setopt($ch3, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                    ));
            
                    // get stringified data/output. See CURLOPT_RETURNTRANSFER
                    $data1 = curl_exec($ch3);
            
                    //$decode1 = json_decode($data1);
            
                        $charge_tl1 = "$charge_text";
                        $charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE active=? AND chargetype =? OR chargetype =?)');
                        $incr -> bind_param('ssss', $product, $yes, $charge_tl1, $charge_tl2);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        } else {
                        $charge_tl1 = "$charge_text";
                        //$charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                        $incr -> bind_param('sss', $product, $charge_tl1, $yes);
                        $incr -> execute();
                        $rincr = $incr->get_result();
                        }
                            if($rincr->num_rows > 0) {
        
                                $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                                $fx -> bind_param('s', $product);
                                $fx -> execute();
                                $rfx = $fx->get_result();
                                while($fr = mysqli_fetch_array($rfx) ){
                                    $funding_source = $fr['funding_source'];
                                }
        
                                foreach ($rincr as $iid):
                                
                                $de = $db -> prepare('SELECT * FROM charges WHERE id=?');
                                $de -> bind_param('i', $iid['cid']);
                                $de -> execute();
                                $rde = $de->get_result();
                                while($dee = mysqli_fetch_array($rde) ){
                                //Call Charge Amount
                                $trnsss_amount = $transfer_amount;
                                $chid = $iid['cid'];
                                include('../../charges.php');
                                //End Call Charge Amount
                                $charge_name = $dee['name'];
                                $charge_option = $dee['charge_option'];
                                $triggertype = $dee['triggertype'];
                                $chargetype = $dee['chargetype'];
                                }

                                $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                                $set -> bind_param('ss', $product, $ch_id);
                                $set -> execute();
                                $rset = $set->get_result();
                                while($rrt = mysqli_fetch_array($rset) ){
                                    $income_acc = $rrt['income_acc'];
                                }
        
                                    $cb = $db -> prepare('SELECT cleared_balance FROM accounts WHERE account_number=?');
                                    $cb -> bind_param('s', $account_number);
                                    $cb -> execute();
                                    $rcb = $cb->get_result();
            
                                    while($rbb = mysqli_fetch_assoc($rcb) ){
                                    $cleared_bal = $rbb["cleared_balance"];
                                    }
        
                                if ($charge_option != "Flat") {
                                    $charge_amount = $transfer_amount * ($charge_amount/100);
                                }
                                if ($triggertype == "Per Transaction" && $charge_amount >0) {
                                    
                                    $value_date = date("Y-m-d H:i:s");
                                    $num = mt_rand(100000, 999999);
                                    $stamp = date("Yhis");
                                    $orderId = $stamp . $num;
        
            
                                    $new_amount_c = $cleared_bal - $charge_amount;
            
                                    $description_c = "$charge_name";
                                    $type_c = "Debit";
                
                                    $debit_comment = "$charge_name";
            
                                    $transaction_id_c = "D$cu_character" . "$orderId";
            
                                    //INSERT CHARGES INTO TRANSACTION TABLE
                                    $wc = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                    $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c, $account_number, $customer_id, $cleared_bal, $new_amount_c, $charge_amount, $type_c, $description_c, $transaction_date, $value_date, $debit_comment, $onee, $customer_branch, $customer_rm, $channel_log, $aid, $stamp_1, $rev);
                                    $wc->execute();
                                    $last_id_c = mysqli_insert_id($db);
            
                                    $entity_id_c = "TRR$last_id_c";
            
                                    //INSERT INTO ACTIVITY TABLE
                                    $act_dsc = "$charge_name debit from customer account";
                                    $act_type = "Debit";
                                    $wwc = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                                    $wwc->bind_param("sssiii", $act_dsc, $act_type, $entity_id_c, $aid, $usbrn, $channel_log);
                                    $wwc->execute();
            
                                    $journal_date = $value_date;
                                    $journal_type = "Automatic";
                                    $crd_gl1 = -$charge_amount;
                                    $journal_description = "$charge_name";
                                    $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                                    $jn->bind_param("iddiiiissss", $last_id_c, $crd_gl1, $charge_amount, $income_acc, $saving_control, $aid, $customer_branch, $journal_type, $journal_description, $journal_date, $currency);
                                    $jn->execute();
            
                                    $upd = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                                    $upd->bind_param('ds', $new_amount_c, $account_number);
                                    $upd->execute();

                                    } else {
                                        //INSERT CHARGE INTO TEM CHARGES TABLE
                                        if($charge_amount>0) {
                                        $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                        $inch->bind_param("sdss", $account_number, $charge_amount, $charge_name, $triggertype);
                                        $inch->execute();
                                        }

                                        $new_amount_c = $new_amount;
                                    }

                                    //DO SMS INTEGRATION
                                    if ($sms_alert == "Yes" && $chargetype !="Single SMS Fee") {
                                        $biz_rule = "Charge Deducted";
                                        $brn = $customer_branch;
                                        $rm = $customer_rm;
                                        $pg = $productGroup;
                                        $account_id = $account_id;
                                        $account_no = $account_number;
                                        $vdate = $value_date;
                                        $tdate = $transaction_date;
                                        $tamount = $charge_amount;
                                        $cb = $new_amount_c;

                                        include_once("sms_int.php");
                                    }
            
                                    endforeach;
                                }
        
        
        
                //RECEIVER PROCESSES BELOW
        
                if ($transfer_type == "Inbound") {
                    //INTERNAL TRANSFERS
                    $podt = $db -> prepare('SELECT fname FROM customer WHERE customer_id=?');
                    $podt -> bind_param('i', $receiver_id);
                    $podt -> execute();
                    $rpodt = $podt->get_result();
        
                    while($rtt = mysqli_fetch_assoc($rpodt) ){
                        $receiver_name = $rtt["fname"];
                        $rc_character = strtoupper($receiver_name[0]);
                    }
        
                    $num1 = mt_rand(100000, 999999);
                    $stamp1 = date("Yhis");
                    $orderId1 = $stamp1 . $num1;
        
                    $transaction_id1 = "C$rc_character" . "$orderId1";
        
                    $description1 = "Transfer-in";
                    $type1 = "Credit";
        
                    $new_amount1 = $cleared_balance5 + $transfer_amount;
                    $previous_balance1 = $cleared_balance5;
        
                    $crr = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE customer_id=? AND account_number=?");
                    $crr->bind_param('dis', $new_amount1, $receiver_id, $to_account);
                    $crr->execute();
                    $crr->close();
        
                    $r_status="X";
                    $wi = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, to_account, bank, transfer_type, status, transfer_id, branch_id, relationship_manager, channel, created_by, tr_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $wi->bind_param("ssidddsssssssssiiiiis", $transaction_id1, $to_account, $receiver_id, $previous_balance1, $new_amount1, $transfer_amount, $type1, $description1, $transfer_transaction_date, $value_date, $transfer_comment, $to_account, $beneficiary_acc_bank, $transfer_type, $r_status, $last_id, $receiver_branch, $receiver_rm, $channel_log, $aid, $stamp_1);
                    $wi->execute();
                    $last_id1 = mysqli_insert_id($db);
        
                    $entity_id1 = "TRR$last_id1";
        
                    //INSERT INTO ACTIVITY TABLE
                    $act_dsc1 = "Funds Transfer ($transfer_amount) from $account_number to $to_account";
                    $act_type1 = "Transfer";
                    $xx = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                    $xx->bind_param("sssiii", $act_dsc1, $act_type1, $entity_id1, $aid, $usbrn, $channel_log);
                    $xx->execute();
        
                    
        
                    if ($product_type5=="Savings") {
                        $product2_r = str_replace("S","","$product5");
                        $scr = $db -> prepare('SELECT * FROM savingsproduct WHERE id =?');
                        $scr -> bind_param('i', $product2_r);
                        $scr -> execute();
                        $rscr = $scr->get_result();
                            while($sc1r = mysqli_fetch_array($rscr) ){
                                $saving_reference_r = $sc1r['saving_reference'];
                                $saving_control_r = $sc1r['saving_control'];
                                $productGroup_r = $sc1r['productGroup'];
                            }
                    
                    } else if ($product_type5=="Current") {
                    $product2_r = str_replace("C","","$product5");
                    $scr = $db -> prepare('SELECT * FROM currentproduct WHERE id =?');
                    $scr -> bind_param('i', $product2_r);
                    $scr -> execute();
                    $rscr = $scr->get_result();
                        while($sc1r = mysqli_fetch_array($rscr) ){
                            $saving_reference_r = $sc1r['saving_reference'];
                            $saving_control_r = $sc1r['saving_control'];
                            $productGroup_r = $sc1r['productGroup'];
                        } 
                    } else if ($product_type5=="Thrift") {
                        $product2_r = str_replace("T","","$product5");
                    
                        $scr = $db -> prepare('SELECT * FROM thriftproduct WHERE id =?');
                        $scr -> bind_param('i', $product2_r);
                        $scr -> execute();
                        $rscr = $scr->get_result();
                            while($sc1r = mysqli_fetch_array($rscr) ){
                                $saving_reference_r = $sc1r['saving_reference'];
                                $saving_control_r = $sc1r['saving_control'];
                                $productGroup_r = $sc1r['productGroup'];
                            }
                    
                    } else if ($product_type5=="Float") {
                        $product2_r = str_replace("F","","$product5");
                        $scr = $db -> prepare('SELECT * FROM floatproduct WHERE id =?');
                        $scr -> bind_param('i', $product2_r);
                        $scr -> execute();
                        $rscr = $scr->get_result();
                            while($sc1r = mysqli_fetch_array($rscr) ){
                                $saving_reference_r = $sc1r['saving_reference'];
                                $saving_control_r = $sc1r['saving_control'];
                                $productGroup_r = $sc1r['productGroup'];
                            }
                    } else if ($product_type5=="Term Deposit") {
                        $product2_r = str_replace("TD","","$product5");
                    
                        /*
                        $scr = $db -> prepare('SELECT * FROM term_deposit_product WHERE id =?');
                        $scr -> bind_param('i', $product2_r);
                        $scr -> execute();
                        $rscr = $scr->get_result();
                            while($sc1r = mysqli_fetch_array($rscr) ){
                                $saving_reference_r = $sc1r['saving_reference'];
                                $saving_control_r = $sc1r['saving_control'];
                            }
                    //
                    //INSERT INTO JOURNAL
                    $journal_date = $value_date;
                    $journal_type = "Automatic";
                    $journal_description = "Funds Transfer  from $account_number to $to_account";
                    $jnr = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, type, description, date) VALUES (?,?,?,?,?,?,?,?,?)");
                    $jnr->bind_param("iddiiisss", $last_id1, $transfer_amount, $transfer_amount, $saving_control_r, $saving_reference_r, $aid, $journal_type, $journal_description, $journal_date);
                    $jnr->execute();
                    */
                    
                    } else if ($product_type5=="Share") {
                        $product2_r = str_replace("SH","","$product5");
                    }
                    //INSERT INTO JOURNAL
                    $journal_date = $value_date;
                    $journal_type = "Automatic";
                    $journal_description = "Funds Transfer  from $account_number to $to_account";
                    $jnr = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                    $jnr->bind_param("iddiiiissss", $last_id1, $crd_gl, $transfer_amount, $saving_control_r, $maingl, $aid, $receiver_branch, $journal_type, $journal_description, $journal_date, $currency);
                    $jnr->execute();


                        //SEND SMS FOR RECEIVER IF ENABLED
                if ($sms_alert_r == "Yes" && $charge_sms == 1) {

                    $yui_c = $db -> prepare('SELECT * FROM sms_alert_phone WHERE account_id=?');
                    $yui_c -> bind_param('i', $account_id_r);
                    $yui_c -> execute();
                    $ryui_c = $yui_c->get_result();
                    while($io_c = mysqli_fetch_array($ryui_c) ){
                        $alert_phone_r = $io_c['phone_no'];
                    }
            
                    //DO ALL SHORTCODE REPLACEMENTS
                    $dst_account = substr($to_account, -4);
                    $message = "Acct:**[accountNo]
                    CR:N[amount]
                    Desc:TRASFER FROM ". strtoupper($customer_name)." " . strtoupper($customer_mname)." " . strtoupper($customer_lname)."
                    DT:[vdate]
                    Bal:[balance]CR";
                    $message = str_replace("[accountNo]",$dst_account,$message);
                    $message = str_replace("[vdate]",$value_date,$message);
                    $message = str_replace("[adate]",$transaction_date,$message);
                    $message = str_replace("[amount]",number_format($transfer_amount, 2, '.', ','),$message);
                    $message = str_replace("[balance]",number_format($new_amount1, 2, '.', ','),$message);
                    $message = str_replace("[trbranch]",$receiver_branch,$message);
            
                    //SEND TO EGIS SERVICES FOR SENDING SMS HERE
            
                    $postdata4 =  array('organization_code' => $org_code, 'branch_id' => $receiver_branch, 'recipient_phone' => $alert_phone_r, 'message' => $message);
            
                    $ch4 = curl_init();
                    curl_setopt($ch4, CURLOPT_URL,"$egis_api_root/sms.php");
                    curl_setopt($ch4, CURLOPT_POST, 1);
                    curl_setopt($ch4, CURLOPT_POSTFIELDS,json_encode($postdata4));  //Post Fields
                    curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
                    //Set your auth headers
                    curl_setopt($ch4, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                    ));
            
                    // get stringified data/output. See CURLOPT_RETURNTRANSFER
                    $data2 = curl_exec($ch4);
            
                    //$decode2 = json_decode($data2);
            
            
                        
                        $charge_tl2 = "Single SMS Fee";
                        //$charge_tl4 = "Email Fee";
                        $incr_c = $db -> prepare('SELECT cid FROM product_charges WHERE product_id =? AND cid IN (SELECT id FROM charges WHERE chargetype =? AND active=?)');
                        $incr_c -> bind_param('sss', $product5, $charge_tl2, $yes);
                        $incr_c -> execute();
                        $rincr_c = $incr_c->get_result();
            
                        if($rincr_c->num_rows > 0) {
            
            
                        $fx = $db -> prepare('SELECT funding_source FROM advanced_account_rule WHERE product_id=?');
                        $fx -> bind_param('s', $product5);
                        $fx -> execute();
                        $rfx = $fx->get_result();
                        while($fr = mysqli_fetch_array($rfx) ){
                            $funding_source_c = $fr['funding_source'];
                        }
            
                        foreach ($rincr_c as $iid_c):
            
                        $de_c = $db -> prepare('SELECT * FROM charges WHERE id=?');
                        $de_c -> bind_param('i', $iid_c['cid']);
                        $de_c -> execute();
                        $rde_c = $de_c->get_result();
                        while($dee_c = mysqli_fetch_array($rde_c) ){
                        //Call Charge Amount
                        $trnsss_amount = $transfer_amount;
                        $chid = $iid_c['cid'];
                        include('../../charges.php');
                        //End Call Charge Amount
                        $charge_name_c = $dee_c['name'];
                        $charge_option_c = $dee_c['charge_option'];
                        $triggertype_c = $dee_c['triggertype'];
                        }
                        $charge_amount_c = $charge_amount;//deliberate from charges.php

                        $set = $db -> prepare('SELECT income_acc FROM income_account_map WHERE product_id=? AND fee=?');
                        $set -> bind_param('ss', $product5, $iid_c['cid']);
                        $set -> execute();
                        $rset = $set->get_result();
                        while($rrt = mysqli_fetch_array($rset) ){
                            $income_acc_c = $rrt['income_acc'];
                        }
            
                            $cb_c = $db -> prepare('SELECT * FROM accounts WHERE account_number=?');
                            $cb_c -> bind_param('s', $to_account);
                            $cb_c -> execute();
                            $rcb_c = $cb_c->get_result();
            
                            while($rbb_c = mysqli_fetch_assoc($rcb_c) ){
                            $cleared_bal_c = $rbb_c["cleared_balance"];
                            }
            
                        if ($charge_option_c != "Flat") {
                            $charge_amount_c = $transfer_amount * ($charge_amount_c/100);
                        }

                        if ($triggertype_c == "Per Transaction") {
            
                            
                            //$value_date_c = date("Y-m-d H:i:s");
                            $num_c = mt_rand(100000, 999999);
                            $stamp_c = date("Yhis");
                            $orderId_c = $stamp_c . $num_c;
            
            
                            $new_amount_c_c = $cleared_bal_c - $charge_amount_c;
            
                            $description_c_c = "$charge_name_c";
                            $type_c_c = "Debit";
            
                            $debit_comment_c = "$charge_name";
            
                            $transaction_id_c_c = "D$rc_character" . "$orderId_c";
            
                            //INSERT CHARGES INTO TRANSACTION TABLE
                            $wc = $db->prepare("INSERT INTO transactions (transaction_id, account_number, customer_id, previous_balance, current_balance, transaction_amount, transaction_type, transaction_description, transaction_date, value_date, comment, is_disbursement, branch_id, relationship_manager, channel, created_by, tr_group, status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $wc->bind_param("ssidddsssssiiiiiss", $transaction_id_c_c, $to_account, $receiver_id, $cleared_bal_c, $new_amount_c_c, $charge_amount_c, $type_c_c, $description_c_c, $transaction_date, $value_date, $debit_comment_c, $onee, $receiver_branch, $receiver_rm, $channel_log, $aid, $stamp_c, $rev);
                            $wc->execute();
                            $last_id_c_c = mysqli_insert_id($db);
            
                            $entity_id_c_c = "TRR$last_id_c_c";
            
                            //INSERT INTO ACTIVITY TABLE
                            $act_dsc_c = "$charge_name_c debit from customer account";
                            $act_type_c = "Debit";
                            $wwc = $db->prepare("INSERT INTO activities (activity_description, action_type, entity_id, activity_by, branch, channel) VALUES (?,?,?,?,?,?)");
                            $wwc->bind_param("sssiii", $act_dsc_c, $act_type_c, $entity_id_c_c, $aid, $usbrn, $channel_log);
                            $wwc->execute();
            
                            $crd_gl1_c = -$charge_amount_c;
                            $journal_description = "$charge_name_c";
                            $jn = $db->prepare("INSERT INTO journals (transaction_id, credit, debit, credit_account, debit_account, created_by, branch, type, description, date, currency) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            $jn->bind_param("iddiiiissss", $last_id_c_c, $crd_gl1_c, $charge_amount_c, $income_acc_c, $saving_control_r, $aid, $receiver_branch, $journal_type, $journal_description, $journal_date, $currency);
                            $jn->execute();
            
                            $upd = $db->prepare("UPDATE accounts SET cleared_balance=? WHERE account_number=?");
                            $upd->bind_param('ds', $new_amount_c_c, $to_account);
                            $upd->execute();

                            } else {
                                //INSERT CHARGE INTO TEM CHARGES TABLE
                                $inch = $db->prepare("INSERT INTO temp_charge (account_number, charge_amount, charge_name, frequency) VALUES (?,?,?,?)");
                                $inch->bind_param("sdss", $to_account, $charge_amount_c, $charge_name_c, $triggertype_c);
                                $inch->execute();
                            }

                            //DO SMS INTEGRATION
                            if ($sms_alert == "Yes") {
                                $biz_rule = "Charge Deducted";
                                $brn = $receiver_branch;
                                $rm = $receiver_rm;
                                $pg = $productGroup_r;
                                $account_id = $account_id_r;
                                $account_no = $to_account;
                                $vdate = $value_date;
                                $tdate = $transaction_date;
                                $tamount = $charge_amount_c;
                                $cb = $new_amount_c_c;

                                include_once("sms_int.php");
                            }
            
                            endforeach;
                        }
                }
        
        
                    } else if ($transfer_type == "Outbound") {
                        //LIVE INTEGRATION HERE
                                $live_description = "Fund Transfer from $account_number to $beneficiary_acc_bank Account no: $to_account";
                                $pk_description = strtoupper($customer_name)." " . strtoupper($customer_mname)." " . strtoupper($customer_lname)."/".$transfer_comment;
                                //$total_debit = $total_deduct;
                                $track_id = $transaction_id;
                                $type_tr = "Fund Transfer";
                                //$transfer_amount = $transfer_amount;
                                //$transfer_fee = $transfer_fee;
        
                                //GET PAYMENT RECIPIENT
        
                                $gac = $db -> prepare("SELECT recipient_code FROM egis_transfer_accounts WHERE customer_id=? AND account_no=?");
                                $gac->bind_param("is", $customer_id, $to_account);
                                $gac->execute();
                                $rgac = $gac->get_result();
                                while($ri = mysqli_fetch_assoc($rgac) ){
                                    $recipient_code = $ri['recipient_code'];
                                }
        
                                $postdata2 =  array('organization_code' => $org_code, 'branch_id' => $branch, 'recipient_code' => $recipient_code, 'live_description' => $live_description, 'pk_description' => $pk_description, 'total_debit' => $total_deduct, 'track_id' => $track_id, 'transfer_amount' => $transfer_amount, 'transfer_fee' => $transfer_fee, 'type' => $type_tr);
        
                                $ch2 = curl_init();
                                curl_setopt($ch2, CURLOPT_URL,"$egis_api_root/transfer.php");
                                curl_setopt($ch2, CURLOPT_POST, 1);
                                curl_setopt($ch2, CURLOPT_POSTFIELDS,json_encode($postdata2));  //Post Fields
                                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                                //Set your auth headers
                                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $token
                                ));
        
                                // get stringified data/output. See CURLOPT_RETURNTRANSFER
                                $data1 = curl_exec($ch2);
        
                                //$decode1 = json_decode($data1);
                                }
        



                //UPDATE WORK QUEUE STATUS
                //UPDATE WORKFLOW TRANSACTION
                $update = "Approved";

                $io = $db->prepare("UPDATE verify_transactions SET status=? WHERE id=?");
                $io->bind_param('si', $update, $verify_id);
                $io->execute();
                $io->close();


                if ($transfer_type == "Inbound") {
                    $act_id = 41;
                } else {
                    $act_id = 42;
                }
                $ent_id = 41;
                
                $wfcheck = $db -> prepare('SELECT * FROM work_queue WHERE main_area_id=? AND entity_id=? AND action_id=?');
                $wfcheck -> bind_param('iii', $verify_id, $ent_id, $act_id);
                $wfcheck -> execute();
                $rwfcheck = $wfcheck->get_result();

                if ($rwfcheck->num_rows > 0) {

                    $new_status = "Treated";

                    $updwk = $db->prepare("UPDATE work_queue SET status=?, $by=? WHERE main_area_id=? AND entity_id=? AND action_id=?");
                    $updwk->bind_param('siiii', $new_status, $aid, $verify_id, $ent_id, $act_id);
                    $updwk->execute(); 

                    }
                }
            }
        }   
    }

}//END TRANSFER



?>