<?php
include('../serv/accsecu/confs/config.php');
include('welcome_user.php');

$actionid_cc = 1;
$authorize_cc = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
$authorize_cc->bind_param("ii", $actionid_cc, $user_role);
$authorize_cc->execute();
$rauthorize_cc = $authorize_cc->get_result();
                
    if ($rauthorize_cc->num_rows == 0) {
        $_SESSION['msg1'] = "You are not authorized to create customers.";
    header("location: $site_domain/main");
    } else {
		//$createCustomer = 2;

		while($gu_cc = mysqli_fetch_assoc($rauthorize_cc) ){
			$right_id_cc = $gu_cc['id'];
			$apply_to_branch_cc = $gu_cc['apply_to_branch'];
			$apply_to_channel_cc = $gu_cc['apply_to_channel'];
			$apply_to_customertype_cc = $gu_cc['apply_to_customertype'];
		}
	
		//GET CUSTOMER CREATION POLICY
		$active = "Active";
		$tyn = "ID Validation";
		$pty = "Customer";
		$crpnd = $db -> prepare('SELECT * FROM policies WHERE product_type=? AND name=? AND status=?');
		$crpnd->bind_param("sss", $pty, $tyn, $active);
		$crpnd -> execute();
		$rcrpnd = $crpnd->get_result();
		if ($rcrpnd->num_rows > 0) {
			//$proceed = 0;
			while($jvx = mysqli_fetch_assoc($rcrpnd) ){ 
				$validate_identity= $jvx["validate_identity"];
				$id_type= $jvx["id_type"];
			}

			if($validate_identity == "Yes") {
				$validateIid = 1;

				//CHECK IF BVN TEMPLATE IS SET
				$iden = "Identification";
				$yes = "Yes";
				$ctmp = $db -> prepare('SELECT * FROM template WHERE type=? AND status=? AND is_bvn=?');
				$ctmp->bind_param("sss", $iden, $active, $yes);
				$ctmp -> execute();
				$rctmp = $ctmp->get_result();

				if($rctmp->num_rows >0) {
					$temp = 1;
					while($fro = mysqli_fetch_assoc($rctmp) ){ 
						$tid= $fro["id"];
						$character_type= $fro["character_type"];
						$character_length= $fro["character_length"];
					}
				} else {
					$temp = 0;
				}

			} else {
				$validateIid = 0;
			}

		} else {
			$validateIid = 0;
		}

		//GET PROFILE PHOTO POLICY
		$tyn2 = "Require Profile Photo";
		$forcePhoto = 0;
		$grnd = $db -> prepare('SELECT channels FROM policies WHERE product_type=? AND name=? AND status=?');
		$grnd->bind_param("sss", $pty, $tyn2, $active);
		$grnd -> execute();
		$rgrnd = $grnd->get_result();
		if ($rgrnd->num_rows > 0) {
			
			//$forcePhoto = 1;
			while($bxa = mysqli_fetch_assoc($rgrnd) ){ 
			if(strpos($bxa['channels'], ' , ') !== false) {
                // explodable
                $enchallens = explode(' , ',$bxa['channels']);
    
              } else {
                // not explodable
                $enchallens = array($bxa['channels']);
              }
			}

			if (in_array($channel_log, $enchallens)) {
                        
                $forcePhoto = 1;
              }
		}

		//GET SIGNATURE POLICY
		$tyn3 = "Require Signature";
		$forceSignature = 0;
		$rsgt = $db -> prepare('SELECT channels FROM policies WHERE product_type=? AND name=? AND status=?');
		$rsgt->bind_param("sss", $pty, $tyn3, $active);
		$rsgt -> execute();
		$rrsgt = $rsgt->get_result();
		if ($rrsgt->num_rows > 0) {
			
			//$forcePhoto = 1;
			while($bxa1 = mysqli_fetch_assoc($rrsgt) ){ 
			if(strpos($bxa1['channels'], ' , ') !== false) {
                // explodable
                $enchallens1 = explode(' , ',$bxa1['channels']);
    
              } else {
                // not explodable
                $enchallens1 = array($bxa1['channels']);
              }
			}

			if (in_array($channel_log, $enchallens1)) {
                        
                $forceSignature = 1;
              }
		}

		//GET ADDRESS POLICY
		$tyn4 = "Require Address";
		$forceAddress = 0;
		$grnd_adr = $db -> prepare('SELECT channels FROM policies WHERE product_type=? AND name=? AND status=?');
		$grnd_adr->bind_param("sss", $pty, $tyn4, $active);
		$grnd_adr -> execute();
		$rgrnd_adr = $grnd_adr->get_result();
		if ($rgrnd_adr->num_rows > 0) {
			
			//$forcePhoto = 1;
			while($nxa_adr = mysqli_fetch_assoc($rgrnd_adr) ){ 
			if(strpos($nxa_adr['channels'], ' , ') !== false) {
                // explodable
                $enchallens_adr = explode(' , ',$nxa_adr['channels']);
    
              } else {
                // not explodable
                $enchallens_adr = array($nxa_adr['channels']);
              }
			}

			if (in_array($channel_log, $enchallens_adr)) {
                        
                $forceAddress = 1;
              }
		}
		
		//GET PHONE POLICY
		$tyn5 = "Require Phone";
		$forcePhone = 0;
		$grnd_phn = $db -> prepare('SELECT channels FROM policies WHERE product_type=? AND name=? AND status=?');
		$grnd_phn->bind_param("sss", $pty, $tyn5, $active);
		$grnd_phn -> execute();
		$rgrnd_phn = $grnd_phn->get_result();
		if ($rgrnd_phn->num_rows > 0) {
			
			//$forcePhoto = 1;
			while($nxa_phn = mysqli_fetch_assoc($rgrnd_phn) ){ 
			if(strpos($nxa_phn['channels'], ' , ') !== false) {
                // explodable
                $enchallens_phn = explode(' , ',$nxa_phn['channels']);
    
              } else {
                // not explodable
                $enchallens_phn = array($nxa_phn['channels']);
              }
			}

			if (in_array($channel_log, $enchallens_phn)) {
                        
                $forcePhone = 1;
              }
		}

		//GET EMAIL POLICY
		$tyn6 = "Require Email";
		$forceEmail = 0;
		$grnd_eml = $db -> prepare('SELECT channels FROM policies WHERE product_type=? AND name=? AND status=?');
		$grnd_eml->bind_param("sss", $pty, $tyn6, $active);
		$grnd_eml -> execute();
		$rgrnd_eml = $grnd_eml->get_result();
		if ($rgrnd_eml->num_rows > 0) {
			
			//$forcePhoto = 1;
			while($nxa_eml = mysqli_fetch_assoc($rgrnd_eml) ){ 
			if(strpos($nxa_eml['channels'], ' , ') !== false) {
                // explodable
                $enchallens_eml = explode(' , ',$nxa_eml['channels']);
    
              } else {
                // not explodable
                $enchallens_eml = array($nxa_eml['channels']);
              }
			}

			if (in_array($channel_log, $enchallens_eml)) {
                        
                $forceEmail = 1;
              }
		}


?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Create Customer</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
		<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
        <link rel="icon" type="image/x-icon" href="../favicon.ico">

<style>
.form-control {
    border-radius: 0;
    box-shadow: none;
    border-color: #d2d6de
}

.select2-hidden-accessible {
    border: 0 !important;
    clip: rect(0 0 0 0) !important;
    height: 1px !important;
    margin: -1px !important;
    overflow: hidden !important;
    padding: 0 !important;
    position: absolute !important;
    width: 1px !important
}

.form-control {
    display: block;
    width: 100%;
    height: 34px;
    padding: 6px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0;
    padding: 6px 12px;
    height: 34px
}

.select2-container--default .select2-selection--single {
    background-color: #fff;
    border: 1px solid #aaa;
    border-radius: 4px
}

.select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 28px;
    user-select: none;
    -webkit-user-select: none
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-right: 10px
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-left: 0;
    padding-right: 0;
    height: auto;
    margin-top: -3px
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 28px
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0 !important;
    padding: 6px 12px;
    height: 40px !important
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 6px !important;
    right: 1px;
    width: 20px
}
.select2-selection__clear{
   position: absolute;
   top: 6px !important;
   right: 15px;
   height: 26px;
   width: 20px;
   padding: 0 15px;
}

/* The switch - the box around the slider */
.switch, .switch1, .switch2, .switch3 {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

/* Hide default HTML checkbox */
.switch input, .switch1 input, .switch2 input, .switch3 input {
  opacity: 0;
  width: 0;
  height: 0;
}

/* The slider */
.slider, .slider1 , .slider2, .slider3 {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before, .slider1:before, .slider2:before, .slider3:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider, input:checked + .slider1, input:checked + .slider2, input:checked + .slider3  {
  background-color: #2196F3;
}

input:focus + .slider, input:focus + .slider1, input:focus + .slider2, input:focus + .slider3 {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before, input:checked + .slider1:before, input:checked + .slider2:before, input:checked + .slider3:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round, .slider1.round1, .slider2.round2, .slider3.round3  {
  border-radius: 34px;
}

.slider.round:before, .slider1.round1:before, .slider2.round2:before, .slider3.round3:before {
  border-radius: 50%;
}
.stylelabel {
  background-color: indigo;
  color: white;
  padding: 0.5rem;
  font-family: sans-serif;
  border-radius: 0.3rem;
  cursor: pointer;
  margin-top: 1rem;
}
.divider { margin-top: 50px; }

.box {
	padding: 0.5em;
	width: 100%;
	margin:0.5em;
}

.box-2 {
	padding: 0.5em;
	width: calc(100%/2 - 1em);
}

.options label,
.options input{
	width:4em;
	padding:0.5em 1em;
}
.options1 label,
.options1 input{
	width:4em;
	padding:0.5em 1em;
}

.hide, .hide1 {
	display: none;
}

img {
	max-width: 100%;
}

.stylelabel {
  background-color: indigo;
  color: white;
  padding: 0.5rem;
  font-family: sans-serif;
  border-radius: 0.3rem;
  cursor: pointer;
  margin-top: 1rem;
}

.errormes:focus {
  border: 3px solid #ff0000;
}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.css" integrity="sha512-C4k/QrN4udgZnXStNFS5osxdhVECWyhMsK1pnlk+LkC7yJGCqoYxW4mH3/ZXLweODyzolwdWSqmmadudSHMRLA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	</head>
	<body class="login">
    <div id="app">		
<?php include('include/sidebar.php');?>
			<div class="app-content">
			
					<?php include('include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
						<section id="page-title">
							<div class="row">
								<div class="col-sm-8">
									<h1 class="mainTitle"><?php echo $site_name; ?>  | Create Customer</h1>
								</div>
								<ol class="breadcrumb">
									<li>
										<span><?php echo $site_name; ?> </span>
									</li>
									<li class="active">
										<span>Create Customer</span>
									</li>
								</ol>
							</div>
						</section>
			<div class="container-fluid container-fullw bg-white">
						
                <div class="box-register">

					<?php if ($allow_process == 1) { ?>
					<h4 class="text-center text-danger">You cannot create customer. Branch processing date not set</h4>
					<?php } else { ?>
					<form method="post" id="createCust" action="customer/process_create_customer"  enctype="multipart/form-data">
					
					<?php if ($validateIid == 1) {
						if($id_type == "BVN" && $temp == 1) { ?>

									<div class="form-group">
                                    	<label for="bvn">Bank Verification Number <span class='text-danger'>*</span></label>
                                        <input type="number" class="form-control bvn" name="bvn" id="bvn" data-maxlength="<?php echo $character_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" placeholder="Enter BVN" onBlur="validateBvn(this);">
									</div>
									<input type="hidden" name="template_id" value="<?php echo $tid; ?>">
						<?php
							//VALIDATE BVN HERE
						} else if($id_type == "BVN" && $temp == 0) { ?>
							<h3 class="text-center text-danger">No BVN template yet. Kindly create one under Templates</h3>
						<?php
							//VALIDATE NIN HERE
						} else if($id_type == "NIN") {
							//VALIDATE NIN HERE
						} ?>

					<div id="validate_result">

						<div class='col-md-6'>
							<p class='bvnName text-success'></p>
							<p class='bvnDob text-success'></p>
							<p class='bvnMobile text-success'></p>
							<p class='genderBVN text-success'></p>
							<p class='disBVN text-success'></p>
						</div>
						<div class='col-md-6'>
							<div class='photoBVN'></div>
						</div>
				
						<div class='col-md-12'>
							<div class='inuse'></div>
						</div>
					</div>

					<?php
					}
					 ?>
					 <div class="divider"></div>
					 <hr class="mt-2 mb-3"/>
					<div id="main_area" <?php if ($validateIid == 1) { ?> style="display:none" <?php } ?>>
						<fieldset>
							<legend>
								<h3>Create Customer</h3>
							</legend>
							<p>
							<span class="text-danger"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></span>
							</p>
							<div class="form-group">
								<label for="ctype">Select Customer Type <span class='text-danger'>*</span></label>
								<select name="ctype" class="ctype form-control select2 select2-hidden-accessible" id="ctype" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
										<option></option>
                                        <?php
										$status_all = "Active";
											
															if ($apply_to_customertype_cc == "All Customer Types") {
																$qb1 = $db -> prepare('SELECT * FROM customertype WHERE status=?');
																$qb1->bind_param("s", $status_all);
																$qb1->execute();
																$retw1 = $qb1->get_result();
															} else if ($apply_to_customertype_cc == "Selected Customer Types") {
																$qb1 = $db -> prepare('SELECT * FROM customertype WHERE status=? AND id IN (SELECT customer_type_id FROM privilege_customer_type WHERE right_id=?)');
																$qb1->bind_param("si", $status_all, $right_id_cc);
																$qb1->execute();
																$retw1 = $qb1->get_result();
															}
															?>
															<option value=""></option>
																<?php
																while($rog1 = mysqli_fetch_array($retw1) ){
																	$tyid = $rog1['id'];
																	$tyname = $rog1['name'];
																?>
																	<option value="<?php echo $tyid; ?>"><?php echo $tyname; ?></option>
																<?php } ?>
									</select>


							</div>
							
                            <div class="form-group">
                            	<label for="fname">First Name <span class='text-danger'>*</span></label>
								<input type="text" class="form-control fn enable_all" name="fn" id="fn" placeholder="Enter First Name" onBlur="checkName()">
							</div>
							<input type="hidden" name="fname" class="fname">
							<div class="form-group">
                            	<label for="mname">Middle Name</label>
								<input type="text" class="form-control mn enable_all" name="mn" id="mn" placeholder="Enter Middle Name" onBlur="checkName()">
							</div>
							<input type="hidden" name="mname" class="mname">
                            <div class="form-group">
                            	<label for="lname">Last Name <span class='text-danger'>*</span></label>
								<input type="text" class="form-control ln enable_all" name="ln" id="ln" placeholder="Enter Last Name" onBlur="checkName()">
								<span id="check_name" class="font12;"></span>
							</div>
							<input type="hidden" name="lname" class="lname">

							<div id="companydetails" style="display:none">
                                <div class="form-group">
                                <label for="company_name">Company Name <span class='text-danger'>*</span></label>
                                    <input type="text" class="form-control company_name" name="company_name" id="company_name" placeholder="Enter Company Name">
                                </div>
                                <div class="form-group">
                                <label for="comp_reg">Company Registration Number <span class='text-danger'>*</span></label>
                                    <input type="text" class="form-control company_reg_no" name="company_reg_no" id="company_reg_no" placeholder="Enter Company Registration">
                                </div>
							</div>
							<div class="form-group">
                            	<label for="dob"><span id="doblabel">Date of Birth <span class='text-danger'>*</span></span></label>
                                <input type="text" class="form-control dob enable_all datepicker" autocomplete="off" name="dob" id="dob" placeholder="Date of Birth">
                            </div>
							<input type="hidden" name="date_of_birth" class="date_of_birth">

                            <div class="form-group">
                            	<label for="creation_date">Creation Date</label>
                                <input type="text" class="form-control creation_date_time" name="creation_date_time" id="creation_date_time" value="<?php echo $br_start_date; ?>" readonly>
                            </div>

                            <div class="form-group">
								<label for="gnd">Gender <span class='text-danger'>*</span></label>
								<select class="gnd form-control select2 select2-hidden-accessible enable_all" name="gnd" id="gnd" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
										<option></option>
										<option value="Male">Male</option>
                                        <option value="Female">Female</option>
									</select>

							</div>
							<input type="hidden" name="gender" class="gender">

                            <div class="form-group">
								<label for="marital_status">Marital Status <span class='text-danger'>*</span></label>
								<select name="marital_status" class="marital_status form-control select2 select2-hidden-accessible" id="marital_status" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select">
										<option></option>
										<option value="Single">Single</option>
                                        <option value="Married">Married</option>
                                        <option value="Divorced">Divorced</option>
                                        <option value="Widowed">Widowed</option>
                                        <option value="Widower">Widower</option>
									</select>

							</div>
                        </fieldset>
                        <fieldset>
							<p>Internal Information</p>

								<div class="form-group">
									<label for="branch">Select Branch <span class='text-danger'>*</span></label>
									<select name="branch" class="branch form-control select2 select2-hidden-accessible" id="branch" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Branch">
									<?php
																//$status = "Active";
																$org_id = 1;
																if($org_structure ==1) {
																	if ($apply_to_branch_cc == "All Branches") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE status=? AND id!=? AND (id NOT IN(SELECT id FROM branch WHERE parent=?) AND  id NOT IN(SELECT id FROM branch WHERE parent IN(SELECT id FROM branch WHERE parent=?)))');
																		$qb->bind_param("siii", $status_all, $org_id, $org_id, $org_id);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else if ($apply_to_branch_cc == "Own Branch") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE id=? AND (id NOT IN(SELECT id FROM branch WHERE parent=?) AND  id NOT IN(SELECT id FROM branch WHERE parent IN(SELECT id FROM branch WHERE parent=?)))');
																		$qb->bind_param("iii", $usbrn, $org_id, $org_id);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else if ($apply_to_branch_cc == "Selected Branches") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE status=? AND id IN (SELECT branch_id FROM privilege_branches WHERE right_id=?) AND (id NOT IN(SELECT id FROM branch WHERE parent=?) AND  id NOT IN(SELECT id FROM branch WHERE parent IN(SELECT id FROM branch WHERE parent=?)))');
																		$qb->bind_param("siii", $status_all, $right_id_cc, $org_id, $org_id);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else {
																		$default = 0;
																	}
																} else {
																	if ($apply_to_branch_cc == "All Branches") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE status=? AND id!=?');
																		$qb->bind_param("si", $status_all, $org_id);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else if ($apply_to_branch_cc == "Own Branch") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE id=?');
																		$qb->bind_param("i", $usbrn);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else if ($apply_to_branch_cc == "Selected Branches") {
																		$qb = $db -> prepare('SELECT * FROM branch WHERE status=? AND id IN (SELECT branch_id FROM privilege_branches WHERE right_id=?)');
																		$qb->bind_param("si", $status_all, $right_id_cc);
																		$qb->execute();
																		$retw = $qb->get_result();
																		$default = 1;
																	} else {
																		$default = 0;
																	}
																}
																
																?>
																<option value=""></option>
																	<?php
																	while($rog = mysqli_fetch_array($retw) ){
																		$branchid = $rog['id'];
																		$branchname = $rog['name'];
																	?>
																		<option value="<?php echo $branchid; ?>" <?php if($apply_to_branch_cc == "Own Branch") { echo "selected"; } ?>><?php echo $branchname; ?></option>
																	<?php } ?>
									</select>
								</div>                          
								

								<div class="form-group">
									<label for="primary_relationship_manager">Primary Relationship Manager <span class='text-danger'>*</span></label>
										<select name="primary_relationship_manager" data-placeholder="Select" class="bm form-control select2 select2-hidden-accessible" id="primary_relationship_manager" style="width: 100%;" tabindex="-1" aria-hidden="true">
										<option></option>

										</select>
								</div>

								<div class="form-group">
									<label for="secondary_relationship_manager">Secondary Relationship Manager <span class='text-danger'>*</span></label>
										<select name="secondary_relationship_manager" data-placeholder="Select" class="bm1 ggrp form-control select2 select2-hidden-accessible" id="secondary_relationship_manager" style="width: 100%;" tabindex="-1" aria-hidden="true">
										<option></option>
											
										</select>
								</div>

								<div class="form-group">
									<label for="group_id">Group</label>
										<select name="group_id" class="group_id form-control select2 select2-hidden-accessible" id="group_id" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Select Group">
											<option></option>
										</select>
								</div>
                            </fieldset>

                            <fieldset>
								<p>Business Information</p>

								<div class="form-group">
									<label for="main_sector">Main Sector <span class='text-danger'>*</span></label>
									<select name="main_sector" data-placeholder="Select" class="main_sector form-control select2 select2-hidden-accessible" id="main_sector" style="width: 100%;" tabindex="-1" aria-hidden="true">
															<?php
																$qbr = $db -> prepare('SELECT * FROM sectors');
																$qbr->execute();
																$retwr = $qbr->get_result();
															?>
															<option></option>
																<?php
																while($rogr = mysqli_fetch_array($retwr) ){
																	$secid = $rogr['id'];
																	$secname = $rogr['name'];
																?>
																	<option value="<?php echo $secid; ?>"><?php echo $secname; ?></option>
																<?php } ?>
									</select>
								</div>

								<div class="form-group">
									<label for="sub_sector">Sub Sector <span class='text-danger'>*</span></label>
										<select name="sub_sector" data-placeholder="Select" class="bm3 form-control select2 select2-hidden-accessible" id="sub_sector" style="width: 100%;" tabindex="-1" aria-hidden="true">
											<option></option>
										</select>
								</div>

								<div class="form-group">
									<label for="business_scale">Business Scale <span class='text-danger'>*</span></label>
									<select name="business_scale" data-placeholder="Select" class="business_scale form-control select2 select2-hidden-accessible" id="business_scale" style="width: 100%;" tabindex="-1" aria-hidden="true">
															<?php
																$qbrd = $db -> prepare('SELECT * FROM business_scale');
																$qbrd->execute();
																$retwrd = $qbrd->get_result();
															?>
															<option></option>
																<?php
																while($rogrd = mysqli_fetch_array($retwrd) ){
																	$bname = $rogrd['name'];
																	$buid = $rogrd['id'];
																?>
																	<option value="<?php echo $buid; ?>"><?php echo $bname; ?></option>
																<?php } ?>
									</select>
								</div>
							<div id="sc" style="display:none">
								<div class="form-group">
									<label for="social_class">Social Class <span class='text-danger'>*</span></label>
									<select name="social_class"  data-placeholder="Select" class="social_class form-control select2 select2-hidden-accessible" id="social_class" style="width: 100%;" tabindex="-1" aria-hidden="true">
															<?php
																$qbrds = $db -> prepare('SELECT * FROM social_class');
																$qbrds->execute();
																$retwrds = $qbrds->get_result();
															?>
															<option></option>
																<?php
																while($rogrds = mysqli_fetch_array($retwrds) ){
																	$clname = $rogrds['name'];
																	$clid = $rogrds['id'];
																?>
																	<option value="<?php echo $clid; ?>"><?php echo $clname; ?></option>
																<?php } ?>
									</select>
								</div>
							</div>

								<div class="form-group">
									<label for="referrer">How did you know about us? <span class='text-danger'>*</span></label>
									<select name="referrer"  data-placeholder="Select" class="referrer form-control select2 select2-hidden-accessible" id="referrer" style="width: 100%;" tabindex="-1" aria-hidden="true">
															<?php
																$qbrds1 = $db -> prepare('SELECT * FROM referrer');
																$qbrds1->execute();
																$retwrds1 = $qbrds1->get_result();
															?>
															<option></option>
																<?php
																while($rogrds1 = mysqli_fetch_array($retwrds1) ){
																	$rname = $rogrds1['name'];
																	$rid = $rogrds1['id'];
																?>
																	<option value="<?php echo $rid; ?>"><?php echo $rname; ?></option>
																<?php } ?>
									</select>
								</div>
						</fieldset>
						<fieldset>
							<!--<div class="form-group col-md-6 center">
								<p>Upload Passport Photo</p>
								<input type="file" accept="image/*" name="file" id="file" onchange="loadFile(event)" style="display: none;" class="text-center center-block file-upload prup">
								<label for="file" style="cursor: pointer;"><img src="customer/avatar.png" class="avatar img-circle img-thumbnail noup" alt="avatar"><img class="up avatar img-circle img-thumbnail" style="display: none;" id="output" width="200" /></label>
								<p>Maximum Size: 200kb</p>
                            </div>-->
						<div class="form-group col-md-6">
							<p>Upload Passport Photo <span class='text-danger'>*</span></p>
							<!-- input file -->
							<label for="file-input" style="cursor: pointer;"><img src="customer/avatar.png" class="avatar img-circle img-thumbnail noup" alt="avatar"> <img class="cropped img-result hide" src="" alt=""></label>
							<div class="box fnl">
								<input type="file" accept="image/*" id="file-input" style="display:none">
							</div>
							<!-- leftbox -->
							<div class="box-2">
								<div class="result"></div>
							</div>
							<!--rightbox-->
							
							<!-- input file -->
							<div class="box">
								<div class="options" style="display:none">
									<label> Width</label>
									<input type="number" class="img-w" value="300" min="300" max="300"/>
									<input type="hidden" name="passport" class="passport">
								</div>
								<!-- save btn -->
								<button class="btn save hide btn-warning">Save</button>
							</div>
						</div>

						<div class="form-group col-md-6">
							<p>Upload Signature <span class='text-danger'>*</span></p>
							<!-- input file -->
							<label for="file-input1" style="cursor: pointer;"><img src="customer/sign.jpg" class="avatar img-circle img-thumbnail noup1" alt="avatar"> <img class="cropped1 img-result1 hide1" src="" alt=""></label>
							<div class="box fnl1">
								<input type="file" accept="image/*" id="file-input1" style="display:none">
							</div>
							<!-- leftbox -->
							<div class="box-2">
								<div class="result1"></div>
							</div>
							<!--rightbox-->
							
							<!-- input file -->
							<div class="box">
								<div class="options1" style="display:none">
									<label> Width</label>
									<input type="number" class="img-w1" value="300" min="300" max="300"/>
									<input type="hidden" name="sign" class="passport1">
								</div>
								<!-- save btn -->
								<button class="btn save1 hide1 btn-warning">Save</button>
							</div>
						</div>
							
							<!--<div class="form-group col-md-6 center">
								<p>Upload Signature</p>
								<input type="file" accept="image/*" name="sign" id="sign" onchange="loadFile1(event)" style="display: none;" class="text-center center-block">
								<label for="sign" style="cursor: pointer;"><img src="customer/sign.jpg" class="avatar img-circle img-thumbnail noup1" alt="avatar"><img class="up1 avatar img-circle img-thumbnail" style="display: none;" id="output1" width="200" /></label>
								<p>Maximum Size: 200kb</p>
                            </div>-->
                        </fieldset>
                        <fieldset>
                        <p>Additional Info</p>
                        <label class="switch">
                            <input type="checkbox" name="additional_info" id="additional_info" value="OK" onclick="addInfoFunction()">
                            <span class="slider round"></span>
                        </label>


								<div id="addinfo1" style="display:none">
										<div class="form-group">
										<label for="phone_no">Primary Phone Number <span class='text-danger'>*</span></label>
											<input type="number" class="form-control phone_no" name="phone_no" id="phone_no" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" onBlur="userAvailability4()" placeholder="Enter Phone Number">
											<span id="user-availability-status4" class="font12;"></span>
										</div>
										<div class="form-group">
										<label for="phone_no_sec">Secondary Phone Number</label>
											<input type="number" class="form-control phone_no_sec" name="phone_no_sec" id="phone_no_sec" data-maxlength="<?php echo $phone_length; ?>" oninput="this.value=this.value.slice(0,this.dataset.maxlength)" placeholder="Enter Secondary Phone Number">
										</div>
										<div class="form-group">
											<label for="email">Email Address</label>
											<input type="email" class="form-control email" name="email" id="email" placeholder="Enter Email Address">
										</div>

										<div class="form-group">
											<label for="address" class="control-label">Address <span class='text-danger'>*</span></label>							
											<textarea class="form-control address" rows="5" id="address" name="address"></textarea>							
										</div>

										<div class="form-group">
											<label for="address_type">Address Type <span class='text-danger'>*</span></label>
											<select name="address_type" data-placeholder="Select" class="address_type form-control select2 select2-hidden-accessible" id="address_type" style="width: 100%;" tabindex="-1" aria-hidden="true">
													<option></option>
													<option value="Home">Home</option>
													<option value="Office">Office</option>
												</select>
										</div>

								<div class="form-group">
									<label for="country">Country <span class='text-danger'>*</span></label>
									<select name="country" data-placeholder="Select" class="country form-control select2 select2-hidden-accessible" id="country" style="width: 100%;" tabindex="-1" aria-hidden="true">
															<?php
																$qbrdg = $db -> prepare('SELECT * FROM country');
																$qbrdg->execute();
																$retwrdg = $qbrdg->get_result();
															?>
															<option></option>
																<?php
																while($rogrdg = mysqli_fetch_array($retwrdg) ){
																	$country_id = $rogrdg['id'];
																	$country_name = $rogrdg['name'];
																?>
																	<option value="<?php echo $country_id; ?>"><?php echo $country_name; ?></option>
																<?php } ?>
									</select>
								</div>
								<div class="form-group">
									<label for="state">State <span class='text-danger'>*</span></label>
										<select name="state" data-placeholder="Select" class="bm4 form-control select2 select2-hidden-accessible" id="state" style="width: 100%;" tabindex="-1" aria-hidden="true">
											<option></option>
										</select>
								</div>
								<div class="form-group">
									<label for="city">City <span class='text-danger'>*</span></label>
										<select name="city" data-placeholder="Select" class="bm5 form-control select2 select2-hidden-accessible" id="city" style="width: 100%;" tabindex="-1" aria-hidden="true">
											<option></option>
										</select>
								</div>

							</div>
						</fieldset>

                        <fieldset>

							<div class="form-group center text-danger" id="error_mess"></div>
                        
							
							<div class="form-actions">
								<button type="submit" class="btn btn-primary pull-right sub_form" id="sub_form" name="create_customer">
									Create Customer <i class="fa fa-arrow-circle-right"></i>
								</button>
								</form>
                                <a id="backbt" href="#" class="btn btn-default">
                                <i class="fa fa-arrow-circle-left"></i> Back
								</a>
							</div>
                        </fieldset>
					</div>
					
					<?php } ?>
							</div>
						</div>
										
					</div>
				</div>
			</div>
			<!-- start: FOOTER -->
	<?php include('include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="vendor/switchery/switchery.min.js"></script>
        
		<!-- end: MAIN JAVASCRIPTS -->
		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="vendor/autosize/autosize.min.js"></script>
		<script src="vendor/selectFx/classie.js"></script>
		<script src="vendor/selectFx/selectFx.js"></script>
		<script src="vendor/select2/select2.min.js"></script>
		<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
				FormElements.init();
			});
		</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js" integrity="sha512-6lplKUSl86rUVprDIjiW8DuOniNX8UDoRATqZSds/7t6zCQZfaCe3e5zcGaQwxa8Kpn5RTM9Fvl3X2lLV4grPQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
let result = document.querySelector('.result'),
img_result = document.querySelector('.img-result'),
img_w = document.querySelector('.img-w'),
img_h = document.querySelector('.img-h'),
options = document.querySelector('.options'),
save = document.querySelector('.save'),
cropped = document.querySelector('.cropped'),
dwn = document.querySelector('.download'),
upload = document.querySelector('#file-input'),
cropper = '';

// on change show image with crop options
upload.addEventListener('change', (e) => {
  if (e.target.files.length) {
	$(".result").show();
	$(".noup").show();
	$(".save").show();
	$(".fnl").show();
		// start file reader
    const reader = new FileReader();
    reader.onload = (e)=> {
      if(e.target.result){
		$('.sub_form').prop('disabled',true);
				// create new image
				let img = document.createElement('img');
				img.id = 'image';
				img.src = e.target.result
				// clean result before
				result.innerHTML = '';
				// append new image
        result.appendChild(img);
				// show save btn and options
				save.classList.remove('hide');
				options.classList.remove('hide');
				// init cropper
				//cropper = new Cropper(img);
				 cropper = new Cropper(img, {
                    viewMode: 1,
					aspectRatio: 1,
					movable: false,
					zoomable: false,
                    modal: true,
                    cropBoxResizable: false,
                    ready: function () {
                        cropper.setCropBoxData({
							width: 300,
							height: 300,
                        });
                    },
                });
      }
    };
    reader.readAsDataURL(e.target.files[0]);
  }
});

// save on click
save.addEventListener('click',(e)=>{
  e.preventDefault();
  // get result to data uri
  let imgSrc = cropper.getCroppedCanvas({
		width: 300 // input value
	}).toDataURL();
  // remove hide class of img
  cropped.classList.remove('hide');
	img_result.classList.remove('hide');
	// show image cropped
  cropped.src = imgSrc;
  $(".result").hide();
  $(".noup").hide();
  $(".passport").val(imgSrc);
  $(".save").hide();
  $(".fnl").hide();
  $('.sub_form').prop('disabled',false);
  $("#file-input").val("");
  //console.log(imgSrc);
});

let result1 = document.querySelector('.result1'),
img_result1 = document.querySelector('.img-result1'),
img_w1 = document.querySelector('.img-w1'),
img_h1 = document.querySelector('.img-h1'),
options1 = document.querySelector('.options1'),
save1 = document.querySelector('.save1'),
cropped1 = document.querySelector('.cropped1'),
upload1 = document.querySelector('#file-input1'),
cropper1 = '';

// on change show image with crop options
upload1.addEventListener('change', (e) => {
  if (e.target.files.length) {
	$('.sub_form').prop('disabled',true);
	$(".result1").show();
	$(".noup1").show();
	$(".save1").show();
	$(".fnl1").show();
		// start file reader
    const reader = new FileReader();
    reader.onload = (e)=> {
      if(e.target.result){
				// create new image
				let img = document.createElement('img');
				img.id = 'image';
				img.src = e.target.result
				// clean result before
				result1.innerHTML = '';
				// append new image
        result1.appendChild(img);
				// show save btn and options
				save1.classList.remove('hide1');
				options1.classList.remove('hide1');
				// init cropper
				//cropper1 = new Cropper(img);
				cropper1 = new Cropper(img, {
                    viewMode: 1,
					aspectRatio: 1,
					movable: false,
					zoomable: false,
                    modal: true,
                    cropBoxResizable: false,
                    ready: function () {
                        cropper1.setCropBoxData({
                            width: 300,
                            height: 300,
                        });
                    },
                });
      }
    };
    reader.readAsDataURL(e.target.files[0]);
  }
});

// save on click
save1.addEventListener('click',(e)=>{
  e.preventDefault();
  // get result to data uri
  let imgSrc = cropper1.getCroppedCanvas({
		width: 300 // input value
	}).toDataURL();
  // remove hide class of img
  cropped1.classList.remove('hide1');
	img_result1.classList.remove('hide1');
	// show image cropped
  cropped1.src = imgSrc;
  $(".result1").hide();
  $(".noup1").hide();
  $(".passport1").val(imgSrc);
  $(".save1").hide();
  $(".fnl1").hide();
  $('.sub_form').prop('disabled',false);
  $("#file-input1").val("");
  //console.log(imgSrc);
});

$(document).ready(function(){

	
	$(document).on("keydown", ":input:not(textarea)", function(event) {
    if (event.key == "Enter") {
        event.preventDefault();
    	}
	});

	var is_userbranch = "<?php echo $apply_to_branch_cc ?>";
	var usbrn = "<?php echo $usbrn ?>";
	if (is_userbranch == "Own Branch") {

		var bnnn = usbrn.replace(/\s+/g,'_');
		
		$(".bm").load("customer/get_staff.php?parent=" + bnnn+"&c=1");
        $(".bm1").load("customer/get_staff.php?parent=" + bnnn+"&c=1");
		//$(".group_id").load("customer/get_group.php?parent=" + bnnn);
	}

    $("select.ctype").change(function(){
        var prx = $(".ctype option:selected").val();

        if (prx == 3) {
			// $("#fname").attr('required');
			// $("#lname").attr('required');
			// $("#company_name").attr('required');
			// $("#company_reg_no").attr('required');
			$("#doblabel").html("Business Registration Date");
			$("#companydetails").show();
            $("#sc").hide();
        }
        else if (prx == 4) {
			// $("#fname").attr('required');
			// $("#lname").attr('required');
            // $("#company_name").removeAttr('required');
            // $("#company_reg_no").removeAttr('required');
			$("#doblabel").html("Date of Birth");
			$("#companydetails").hide();
            $("#sc").show();
		}
		else {
			$("#companydetails").hide();
            $("#sc").hide();
		}
    });


	
    $(".branch").change(function(){
		$(".bm").val("").trigger('change.select2');
        $(".bm1").val("").trigger('change.select2');
        var branch = $(".branch option:selected").val();

		var branch2 = branch.replace(/\s+/g,'_');

		
		$(".bm").load("customer/get_staff.php?parent=" + branch2+"&c=1");
        $(".bm1").load("customer/get_staff.php?parent=" + branch2+"&c=1");
		$(".group_id").load("customer/get_group.php?parent=" + branch2);

	  });

	  $(".ggrp").change(function(){
        $(".group_id").val("").trigger('change.select2');
        var ggid = $(".ggrp option:selected").val();

		var ggid2 = ggid.replace(/\s+/g,'_');

		$(".group_id").load("customer/get_group.php?parent=" + ggid2);

	  });

      $(".main_sector").change(function(){
		$(".bm3").val("").trigger('change.select2');
        var ms = $(".main_sector option:selected").val();

		//var ms2 = ms.replace(/\s+/g,'_');

		
		$(".bm3").load("customer/get_subsectors.php?ms=" + ms);

	  });

	  const options_1 = []

        document.querySelectorAll('.slic_1 > option').forEach((option) => {
            if (options_1.includes(option.value)) option.remove()
            else options_1.push(option.value)
        })

		const options_2 = []

        document.querySelectorAll('.slic_2 > option').forEach((option) => {
            if (options_2.includes(option.value)) option.remove()
            else options_2.push(option.value)
        })

      $(".country").change(function(){
		$(".bm4").val("").trigger('change.select2');
        var ss = $(".country option:selected").val();

		//var ss2 = ss.replace(/\s+/g,'_');

	
		$(".bm4").load("customer/get_states.php?ss=" + ss);
	  });

      $("#state").change(function(){
		$(".bm5").val("").trigger('change.select2');
        var ci = $("#state option:selected").val();

		//var ci2 = ci.replace(/\s+/g,'_');

	
		$(".bm5").load("customer/get_cities.php?ci=" + ci);
	  });
	  $('.select2').select2({
	closeOnSelect: true,
	allowClear: true
	});

    $('#backbt').click(function() { 
				document.location = "<?php echo $site_domain; ?>/main/customer";
			} );

	/*
	document.onkeydown=function(evt){
    var keyCode = evt ? (evt.which ? evt.which : evt.keyCode) : event.keyCode;
        if(keyCode == 13)
        {
            document.getElementById("sub_form").click();
        }
    }
	*/
	$('#createCust').submit(function(e){
		//$('#sub_form').prop('disabled',true);
		e.preventDefault();
		var forcePhoto = <?php echo $forcePhoto; ?>;
		var forceSignature = <?php echo $forceSignature; ?>;
		var forceAddress = <?php echo $forceAddress; ?>;
		var forcePhone = <?php echo $forcePhone; ?>;
		var forceEmail = <?php echo $forceEmail; ?>;
		var passport = $(".passport").val();
		var passport1 = $(".passport1").val();
		var ctype = $(".ctype").val();
		var fname = $(".fname").val();
		var mname = $(".mname").val();
		var lname = $(".lname").val();
		var company_name = $(".company_name").val();
		var company_reg_no = $(".company_reg_no").val();
		var creation_date_time = $(".creation_date_time").val();
		var date_of_birth = $(".date_of_birth").val();
		var gender = $(".gender").val();
		var marital_status = $(".marital_status").val();
		var branch = $(".branch").val();
		var channel = $(".channel").val();
		var prm = $(".bm").val();
		var srm = $(".bm1").val();
		var main_sector = $(".main_sector").val();
		var sub_sector = $(".bm3").val();
		var business_scale = $(".business_scale").val();
		var social_class = $(".social_class").val();
		var referrer = $(".referrer").val();

		var phone_no = $(".phone_no").val();
		var email = $(".email").val();
		var address = $(".address").val();
		var address_type = $(".address_type").val();
		var country = $(".country").val();
		var state = $(".bm4").val();
		var city = $(".bm5").val();
		var oh_limit = <?php echo $phone_length; ?>;

		if (ctype=="") {
			$("#error_mess").html("Please select customer type");
		} else if($(".fname").val() == "" && $(".fn").val() == "") {
			$("#error_mess").html("Please enter first name");
		} else if($(".lname").val() == "" && $(".ln").val() == "") {
			$("#error_mess").html("Please enter last name");
		} else if($(".date_of_birth").val() == "" && $(".dob").val() == "") {
			$("#error_mess").html("Please enter date of birth");
		} else if($(".gender").val() == "" && $(".gnd").val() == "") {
			$("#error_mess").html("Please select gender");
		} else if (ctype=="Corporate" && company_name=="") {
			$("#error_mess").html("Please enter company name");
		} else if (ctype=="Corporate" && company_reg_no=="") {
			$("#error_mess").html("Please enter company registration number");
		} else if (marital_status=="") {
			$("#error_mess").html("Please select marital status");
		} else if (branch=="") {
			$("#error_mess").html("Please select customer branch");
		} else if (prm=="") {
			$("#error_mess").html("Please choose a primary relationship manager");
		} else if (srm=="") {
			$("#error_mess").html("Please choose a secondary relationship manager");
		} else if (main_sector=="") {
			$("#error_mess").html("Please select main sector");
		} else if (sub_sector=="") {
			$("#error_mess").html("Please select sub-sector");
		} else if (business_scale=="") {
			$("#error_mess").html("Please select business scale");
		} else if (ctype=="Individual" && social_class=="") {
			$("#error_mess").html("Please select social class");
		} else if (referrer=="") {
			$("#error_mess").html("Please select a referral from the list");
		} else if (forcePhoto==1 && passport == "") {
			$("#error_mess").html("Profile photo upload is required");
		} else if (forceSignature==1 && passport1 == "") {
			$("#error_mess").html("Signature upload is required");
		} else if (forceAddress==1 && address == "") {
		$("#error_mess").html("Address 1 is required");
		} else if (forceAddress==1 && address_type == "") {
			$("#error_mess").html("Please Select Address Type");
		} else if (forceAddress==1 && country == "") {
			$("#error_mess").html("Country is required");
		} else if (forceAddress==1 && state == "") {
			$("#error_mess").html("State is required");
		} else if (forceAddress==1 && city == "") {
			$("#error_mess").html("City is required");
		} else if (forcePhone==1 && phone_no == "") {
			$("#error_mess").html("Primary Phone number is required");
		} else if (forcePhone==1 && phone_no.length < oh_limit) {
			$("#error_mess").html("Primary Phone number must be "+ oh_limit);
		} else if (forceEmail==1 && email == "") {
			$("#error_mess").html("Email address is required");
		} else if (country!="" && state == "") {
			$("#error_mess").html("State is required");
		} else if (state!="" && city == "") {
			$("#error_mess").html("City is required");
		} else {
			$('#sub_form').prop('disabled',true);
			$(this).unbind('submit').submit();
		}
  });
});

function validateBvn(_this) {
        var bvn = $(_this).val();
        if(bvn.length == 11) {
        jQuery.ajax({
        url: "customer/bvn_verify_customer_creation",
        data: {'bvn': bvn},
        dataType: "json",
        type: "POST",
        success:function(data){
            if (data =="Unable to verify BVN") {
                            $('.bvnName').html("<span class='text-danger'>Unable to verify BVN</span>");
                                setTimeout(function(){
                                $('.bvnName').html("");
                                $('.bvnDob').html("");
                                $('.bvnMobile').html("");
                                $('.genderBVN').html("");
                                $('.photoBVN').html("");
                                $('.disBVN').html("");
                                $('#main_area').hide();
								$('.inuse').html("");
                            }, 4000);
                        } else if (data =="This BVN is already in use") {
                            $('.bvnName').html("<span class='text-danger'>This BVN is already in use</span>");
                                setTimeout(function(){
                                $('.bvnName').html("");
                                $('.bvnDob').html("");
                                $('.bvnMobile').html("");
                                $('.genderBVN').html("");
                                $('.photoBVN').html("");
                                $('.disBVN').html("");
                                $('#main_area').hide();
								$('.inuse').html("");
								//$('.enable_all').removeAttr('disabled');
								$('.enable_all').prop('disabled', false);
								$(".enable_all").removeAttr('readonly');
                            }, 4000);
                        } else if (data =="Insufficient Credit") {
                            $('.bvnName').html("<span class='text-danger'>Insufficient Credit. fund your Egis Balance</span>");
                                setTimeout(function(){
                                    $('.bvnName').html("");
                                $('.bvnDob').html("");
                                $('.bvnMobile').html("");
                                $('.genderBVN').html("");
                                $('.photoBVN').html("");
                                $('.disBVN').html("");
                                $('#main_area').hide();
								$('.inuse').html("");
                            }, 4000);
                        } else if (data.dbstatus =="Re-verification Successful") {

							if (data.gender == "m") {
                                var gender = "Male";
                            } else if (data.gender == "f") {
                                var gender = "Female";
                            } else if (data.gender == "M") {
                                var gender = "Male";
                            } else if (data.gender == "F") {
                                var gender = "Female";
                            } else {
                                var gender = data.gender;
                            }
                            
                            $('.bvnName').html("Name: "+data.fullname_bvn);
                            $('.bvnDob').html("DOB: "+data.dob);
                            $('.bvnMobile').html("Mobile No.: "+data.mobile);
                            $('.genderBVN').html("Gender.: "+gender);
                            $('.disBVN').html("BVN.: "+data.bvn);
                            $('.gender').val(gender);
                            $('.gnd').val(data.gender).trigger('change.select2');
                            $('.fn').val(data.bvn_fname);
                            $('.fname').val(data.bvn_fname);
                            $('.mn').val(data.bvn_mname);
                            $('.mname').val(data.bvn_mname);
                            $('.ln').val(data.bvn_lname);
                            $('.lname').val(data.bvn_lname);
                            $('.dob').val(data.dob);
                            $('.date_of_birth').val(data.dob);

							if(data.mobile==null || data.gender==null || data.dob==null || data.bvn_fname==null || data.bvn_lname==null) {

							} else {

									$('.enable_all').prop('disabled', true);
									$(".enable_all").attr('readonly');
							}

							if(data.photo !="") {
                            //$('.photoBVN').setAttribute('src', "data:image/png;base64,"+ data.photo);
                            var src = data.photo;
                            var newImage = document.createElement('img');
                            newImage.src = src;
                            newImage.width = newImage.height = "150";
                            document.querySelector('.photoBVN').innerHTML = newImage.outerHTML;
                            $('.photoBVN').find('img').addClass('avatar img-circle img-thumbnail');
							}
							$('#main_area').show();
							$('.inuse').html("");
                        } else if (data.dbstatus =="Verification Successful") {
                            if (data.gender == "m") {
                                var gender = "Male";
                            } else if (data.gender == "f") {
                                var gender = "Female";
                            } else if (data.gender == "M") {
                                var gender = "Male";
                            } else if (data.gender == "F") {
                                var gender = "Female";
                            } else {
                                var gender = data.gender;
                            }
                            $('.bvnName').html("Name: "+data.fullname_bvn);
                            $('.bvnDob').html("DOB: "+data.dob);
                            $('.bvnMobile').html("Mobile No.: "+data.mobile);
                            $('.genderBVN').html("Gender.: "+gender);
                            $('.disBVN').html("BVN.: "+data.bvn);
                            $('.gender').val(gender);
                            $('.gnd').val(gender).trigger('change.select2');
                            $('.fn').val(data.bvn_fname);
                            $('.fname').val(data.bvn_fname);
                            $('.mn').val(data.bvn_mname);
                            $('.mname').val(data.bvn_mname);
                            $('.ln').val(data.bvn_lname);
                            $('.lname').val(data.bvn_lname);
                            $('.dob').val(data.dob);
                            $('.date_of_birth').val(data.dob);

							if(data.mobile==null || data.gender==null || data.dob==null || data.bvn_fname==null || data.bvn_lname==null) {

							} else {

									$('.enable_all').prop('disabled', true);
									$(".enable_all").attr('readonly');
							}

                            //$('.photoBVN').setAttribute('src', "data:image/png;base64,"+ data.photo);
                            var src = "data:image/png;base64,";
                            src += data.photo;
                            var newImage = document.createElement('img');
                            newImage.src = src;
                            newImage.width = newImage.height = "150";
                            document.querySelector('.photoBVN').innerHTML = newImage.outerHTML;
                            $('.photoBVN').find('img').addClass('avatar img-circle img-thumbnail');
							$('#main_area').show();
							$('.inuse').html("");
                        } else {
							$('.inuse').html(data);
						}
                    }
                });
            }
        }

function addInfoFunction() {
  // Get the checkbox
  var checkBox = document.getElementById("additional_info");
  // Get the output text
  var text = document.getElementById("addinfo1");

  // If the checkbox is checked, display the output text
  if (checkBox.checked == true){
    text.style.display = "block";
  } else {
    text.style.display = "none";
  }
}

function documentFunction() {
  // Get the checkbox
  var checkBox = document.getElementById("documents");
  // Get the output text
  var text = document.getElementById("addinfo2");

  // If the checkbox is checked, display the output text
  if (checkBox.checked == true){
    text.style.display = "block";
  } else {
    text.style.display = "none";
  }
}

function documentFunction1() {
  // Get the checkbox
  var checkBox = document.getElementById("companydouments");
  // Get the output text
  var text = document.getElementById("addinfo3");

  // If the checkbox is checked, display the output text
  if (checkBox.checked == true){
    text.style.display = "block";
  } else {
    text.style.display = "none";
  }
}

function documentFunction2() {
  // Get the checkbox
  var checkBox = document.getElementById("directorinfo");
  // Get the output text
  var text = document.getElementById("addinfo4");

  // If the checkbox is checked, display the output text
  if (checkBox.checked == true){
    text.style.display = "block";
  } else {
    text.style.display = "none";
  }
}

function userAvailability4() {
$("#loaderIcon").show();
$('#sub_form').prop('disabled',false);
jQuery.ajax({
url: "check_phone",
data:'phone='+$(".phone_no").val(),
type: "POST",
success:function(data){
$("#user-availability-status4").html(data);
$("#loaderIcon").hide();
},
error:function (){}
});
}

function checkName() {
$("#loaderIcon").show();
var fname = $(".fname").val();
var mname = $(".mname").val();
var lname = $(".lname").val();
if (fname != "" && lname !="") {
jQuery.ajax({
url: "check_name_customer",
data:{'fname':fname, 'lname': lname, 'mname': mname},
type: "POST",
success:function(data){
$("#check_name").html(data);
$("#loaderIcon").hide();
},
error:function (){}
});
}
}


</script>

<script>
        var loadFile = function(event) {
            var image = document.getElementById('output');
            image.src = URL.createObjectURL(event.target.files[0]);
            $('.noup').hide();
            $('.up').show();
        };

		var loadFile1 = function(event) {
            var image1 = document.getElementById('output1');
            image1.src = URL.createObjectURL(event.target.files[0]);
            $('.noup1').hide();
            $('.up1').show();
        };
        </script>

		<!-- end: JavaScript Event Handlers for this page -->
		<!-- end: CLIP-TWO JAVASCRIPTS -->
	</body>
</html>
<?php } ?>