<?php
include('../../../serv/accsecu/confs/config.php');
include('../../welcome_user.php');
$actionid_vaccht = 102;
$authorize_vaccht = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
$authorize_vaccht->bind_param("ii", $actionid_vaccht, $user_role);
$authorize_vaccht->execute();
$rauthorize_vaccht = $authorize_vaccht->get_result();
                
    if ($rauthorize_vaccht->num_rows == 0 && $user_role !=1) {
        $_SESSION['msg1'] = "<h3 class='text-danger'>You are not authorized to view chart of accounts.</h3>";
    header("location: $site_domain/main");
    } else {

		$actionid_addaccht = 99;
		$authorize_addaccht = $db -> prepare('SELECT * FROM privilege_rights WHERE action_id=? AND privilege_id IN (SELECT id FROM privileges WHERE role_id=?)');
		$authorize_addaccht->bind_param("ii", $actionid_addaccht, $user_role);
		$authorize_addaccht->execute();
		$rauthorize_addaccht = $authorize_addaccht->get_result();
						
		if ($rauthorize_addaccht->num_rows > 0) {
			$createChart = 2;
		} else {
			$createChart = 1;
		}
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $site_name; ?> | Charts of Accounts</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta content="" name="description" />
		<meta content="" name="author" />
		<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
		<link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="../../vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="../../vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../../vendor/themify-icons/themify-icons.min.css">
		<link href="../../vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="../../vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="../../assets/css/styles.css">
		<link rel="stylesheet" href="../../assets/css/plugins.css">
		<link rel="stylesheet" href="../../assets/css/themes/theme-1.css" id="skin_color" />
		<link rel="icon" type="image/x-icon" href="../../../favicon.ico">		
		<link rel="stylesheet" type="text/css" href="../../vendor/bootstrap/css/datatables.min.css" />


<style>
.table-striped td {
  text-align: center;
}
.checkbox input[type=checkbox],
.checkbox-inline input[type=checkbox],
.radio input[type=radio],
.radio-inline input[type=radio] {
  margin: 0;
}

.checkbox,
.radio {
  position: relative;
  display: block;
  margin-top: 10px;
  margin-bottom: 10px;
  display: table;
  width: 100%;
}

.checkbox input,
.radio input {
  vertical-align: middle;
  height: 100%;
}

	.modal-body {
    max-height: calc(100vh - 210px);
    overflow-y: auto;
}
.modal-open {
    overflow: hidden;
    overflow-y: scroll;
    padding-right: 0 !important;
}
.form-control {
    border-radius: 0;
    box-shadow: none;
    border-color: #d2d6de
}

.select2-hidden-accessible {
    border: 0 !important;
    clip: rect(0 0 0 0) !important;
    height: 1px !important;
    margin: -1px !important;
    overflow: hidden !important;
    padding: 0 !important;
    position: absolute !important;
    width: 1px !important
}

.form-control {
    display: block;
    width: 100%;
    height: 34px;
    padding: 6px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
    -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0;
    padding: 6px 12px;
    height: 34px
}

.select2-container--default .select2-selection--single {
    background-color: #fff;
    border: 1px solid #aaa;
    border-radius: 4px
}

.select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 28px;
    user-select: none;
    -webkit-user-select: none
}
.select2-dropdown {
    z-index:99999;
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-right: 10px
}

.select2-container .select2-selection--single .select2-selection__rendered {
    padding-left: 0;
    padding-right: 0;
    height: auto;
    margin-top: -3px
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 28px
}

.select2-container--default .select2-selection--single,
.select2-selection .select2-selection--single {
    border: 1px solid #d2d6de;
    border-radius: 0 !important;
    padding: 6px 12px;
    height: 40px !important
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 6px !important;
    right: 1px;
    width: 20px
}
.select2-selection__clear{
   position: absolute;
   top: 6px !important;
   right: 15px;
   height: 26px;
   width: 20px;
   padding: 0 15px;
}
</style>
	</head>
	<body>
		<div id="app">		
<?php include('../../include/sidebar.php');?>
			<div class="app-content">
			
			<script src="../../assets/js/jquery.dataTables.min.js"></script>
			<script src="../../assets/js/dataTables.bootstrap.min.js"></script>
					<?php include('../../include/header.php');?>
				<!-- end: TOP NAVBAR -->
				<div class="main-content" >
					<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
						<section id="page-title">
							<div class="row">
								<div class="col-sm-8">
									<h1 class="mainTitle"><?php echo $site_name; ?>  | Charts of Accounts</h1>
								</div>
								<ol class="breadcrumb">
									<li>
										<span><?php echo $site_name; ?> </span>
									</li>
									<li class="active">
										<span>Charts of Accounts</span>
									</li>
								</ol>
							</div>
						</section>
						<!-- end: PAGE TITLE -->
						<!-- start: BASIC EXAMPLE -->
						<div class="container-fluid container-fullw bg-white">
						

							<div class="row">
								<div class="col-md-12">

								<p class="color-red2-light center-text"><?php if(isset($_SESSION['msg1'])){ echo $_SESSION['msg1'];?><?php echo $_SESSION['msg1']=""; }?></p>
										
								<div class = "form-inline">														
									<h1> 
									<button class="btn btn-primary" data-toggle="modal" data-target="#chatModal" <?php if ($createChart == 1 && $user_role !=1) { echo "disabled"; } ?>><i class="fa fa-plus"></i> Add Account</button>
									</h1>
									
								</div>

								<table class="table table-bordered dt-responsive">
								<tr>
									<td>
									<div class="form-group">
									<select class="form-control select2 select2-hidden-accessible atype" id="atype" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Filter By Type">
									<option></option>
									<option value="ASSET">ASSET</option>
									<option value="LIABILITY">LIABILITY</option>
									<option value="EQUITY">EQUITY</option>
									<option value="INCOME">INCOME</option>
									<option value="EXPENSE">EXPENSE</option>
									<option value="CONTRA">CONTRA</option>
									<option value="SUSPENSE">SUSPENSE</option>
									</select>

									</div>
								
														
									</td>
									<td>
									<div class="form-group">

									<select class="glg form-control select2 select2-hidden-accessible" id="glg" style="width: 100%;" tabindex="-1" aria-hidden="true" data-placeholder="Filter By Group">
															<?php
															$glg = "GL Group";
																$qb = $db -> prepare('SELECT * FROM account_charts WHERE account_usage=?');
																$qb -> bind_param('s', $glg);
																$qb->execute();
																$retw = $qb->get_result();
															?>
															<option></option>
																<?php
																while($rog = mysqli_fetch_array($retw) ){
																	$brid = $rog['id'];
																	$branchname = $rog['name'];
																?>
																	<option value="<?php echo $brid; ?>"><?php echo $branchname; ?></option>
																<?php } ?>
														</select>
													</div>
									</div>
									</td>
								</tr>
							</table>
											<table id="user_info" class="reload_up table table-bordered table-striped" style="width:100%">
												<thead>
													<tr>
														<th>GL Code</th>
														<th>Account Name</th>
														<th>Account Type</th>
														<th>Balance</th>
														<th>Unreconciled Balance</th>
														<th>Status</th>
														<th></th>
														</tr>
												</thead>
												<tbody>
													
												</tbody>
											</table>
    
								</div>
							</div>
							
					</div>
					

					<div id="chatModal" class="modal fade">
									<div class="modal-dialog">
										<form method="post" id="chatForm">
											<div class="modal-content">
												<div class="modal-header">
													<button type="button" class="close" data-dismiss="modal">&times;</button>
													<h4 class="modal-title"><i class="fa fa-plus fa-2x"></i> Add Account</h4>
												</div>
												<div class="modal-body">
													<div class="form-group">
														<label for="name" class="control-label">Account Name *</label>
														<input type="text" class="form-control" id="templateName" name="templateName" placeholder="Account Name" required>
													</div>

													<div class="form-group" id="gcode" style="display:none">
														<label for="glcode" class="control-label">GL Code *</label>
														<input type="text" class="form-control" id="glcode" name="glcode" placeholder="GL Code" readonly>
													</div>

													<div class="form-group">
														<label for="type">Account Type</label>
															<select name="type" class="type form-control select2 select2-hidden-accessible" id="type" style="width: 100%;" tabindex="-1" aria-hidden="true"  data-placeholder="Select Account Type" id="account_usage" required>
																<option></option>
																<option value="ASSET">ASSET</option>
																<option value="LIABILITY">LIABILITY</option>
																<option value="EQUITY">EQUITY</option>
																<option value="INCOME">INCOME</option>
																<option value="EXPENSE">EXPENSE</option>
																<option value="CONTRA">CONTRA</option>
																<option value="SUSPENSE">SUSPENSE</option>
															</select>
													</div>
													<div class="form-group">
														<label for="account_usage">Account Usage</label>
															<select name="account_usage" class="account_usage form-control select2 select2-hidden-accessible" style="width: 100%;" tabindex="-1" aria-hidden="true"  data-placeholder="Select Usage" id="account_usage" required>
																<option></option>
																<option value="GL Group">GL Group</option>
																<option value="GL Account">GL Account</option>
															</select>
													</div>

													<div class="form-group" id="gl_group_show">
														<label for="gl_group">GL Group</label>
															<select name="gl_group" class="gl_group form-control select2 select2-hidden-accessible" style="width: 100%;" tabindex="-1" aria-hidden="true"  data-placeholder="Select GL Group" id="gl_group">
															<option></option>
															<span id="hidemanager" style="display:none">
															<?php
															$rff = "GL Group";
																$brm = $db -> prepare('SELECT * FROM account_charts WHERE account_usage=?');
																$brm -> bind_param('s', $rff);
																$brm->execute();
																$rbrm = $brm->get_result();
															?>
															<option></option>
																<?php
																while($frf = mysqli_fetch_array($rbrm) ){
																	$rm_id = $frf['id'];
																	$rmname = $frf['name'];
																?>
																	<option value="<?php echo $rm_id; ?>"><?php echo $rmname; ?></option>
																<?php } ?>
															</select>
													</div>

													<div class="form-inline" id="hid_manual_entry">
														<label class="control-label" for="manual_entries">
														Manual Entries Allowed
														</label>
															<input type="checkbox" class="form-control manual_entries" name="manual_entries" id="manual_entries" value="Yes">
													</div>
														
													<div class="form-group">
														<label for="description" class="control-label">Description</label>							
														<textarea class="form-control description" rows="5" id="description" name="description"></textarea>							
													</div>

													<div class="form-inline" id="disable_acc" style="display:none">
														<label class="control-label" for="disable_account">
														Disable Account
														</label>
															<input type="checkbox" class="form-control disable_account" name="disable_account" id="disable_account" value="Yes">
													</div>
										</div>
												<div class="modal-footer">
													<input type="hidden" name="action" id="action" value="addTemplate" />
													<input type="submit" name="save" id="save" class="btn btn-primary" value="Add" />
													<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
												</div>
											</div>
										</form>
									</div>
								</div>

								<div id="templateEditModal" class="modal fade">
									<div class="modal-dialog">
										<form method="post" id="templateEditForm">
											<div class="modal-content">
												<div class="modal-header">
													<button type="button" class="close" data-dismiss="modal">&times;</button>
													<h4 class="modal-title"><i class="fa fa-plus fa-2x"></i> Edit Charts of Accounts</h4>
												</div>
												<div class="modal-body">

												    <div id="gp_edit"></div>

                                                </div>

                                                <div class="modal-footer">
													<input type="hidden" name="tid" id="tid" />
													<input type="hidden" name="action" value="updateTemplate" />
													<input type="submit" name="save_gp" id="save_gp" class="btn btn-primary" value="Save" />
													<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
												</div>
										</form>
									</div>
								</div>
								

								
						</div>

						<!-- end: BASIC EXAMPLE -->
						<!-- end: SELECT BOXES -->
						
					</div>
				</div>
			</div>
			<!-- start: FOOTER -->
	<?php include('../../include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->
		<script src="../../vendor/jquery/jquery.min.js"></script>
		<script src="../../vendor/modernizr/modernizr.js"></script>
		<script src="../../vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="../../vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="../../vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->


		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="../../vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="../../vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="../../vendor/autosize/autosize.min.js"></script>
		<script src="../../vendor/selectFx/classie.js"></script>
		<script src="../../vendor/selectFx/selectFx.js"></script>
		
		<script src="../../vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="../../vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="../../assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="../../assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
				FormElements.init();
			});
		</script>

  <!-- Bootstrap core JavaScript -->
<script type="text/javascript" src="../../assets/js/datatables.min.js"></script>

			<script src="data.js"></script>
<script type="text/javascript" language="javascript">
	var dataTable;
    $(document).ready(function() {

		dataTable = $('#user_info').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "data_template.php",
                type: "POST",
				'data': function(data){
                        // Read values
                        var gl_group = $('#glg').val();
                        var atype = $('#atype').val();

                        // Append to data
                        data.gl_group = gl_group;
                        data.atype = atype;
                    }
            },
			dom: 'lBfrtip',
            buttons: [
                'excel', 'csv', 'pdf', 'copy', 'print'
            ],
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, 100, 200, 500]
            ]
		});

		$('#glg').change(function(){
                dataTable.draw();
            });

            $('#atype').change(function(){
                dataTable.draw();
            });
	
    });


//$.fn.dataTable.ext.errMode = 'none';
//$.fn.dataTableExt.sErrMode = 'throw';

$(document).ready(function(){
    $('.select2').select2({
			closeOnSelect: true,
			allowClear: true
			});

			$("select.type").change(function(){
                $(".gl_group").val("").trigger('change.select2');
        		var type = $(".type option:selected").val();
		
				$(".gl_group").load("get_glgroup.php?type=" + type);
			});

			$("select.account_usage").change(function(){
                var ptype = $(".account_usage option:selected").val();
                if (ptype == "GL Account") {
                $("#gl_group_show").show();
				$("#hid_manual_entry").show();
				}else {
					$("#gl_group_show").hide();
					$("#hid_manual_entry").hide();
				}
			});
});
</script>
<script src="../../vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="../../vendor/select2/select2.min.js"></script>
		<!-- end: JavaScript Event Handlers for this page -->
		<!-- end: CLIP-TWO JAVASCRIPTS -->
	</body>
</html>
<?php } ?>