/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter.gui;

import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.util.JRLoader;

public class ParameterPanel
extends JPanel {
    private final JTextField paramValue = new JTextField();
    private AtomicBoolean valid;
    private int textFieldHeight;
    UIDefaults uiDefaults = UIManager.getDefaults();
    private static PrintStream configSink = System.err;
    private static PrintStream debugSink = System.err;

    public ParameterPanel(JRParameter jrParameter, Map<String, Object> params, AtomicBoolean valid) {
        boolean hasStringConstructor;
        this.valid = valid;
        this.textFieldHeight = 25;
        if ("gnome".equals(System.getProperty("sun.desktop"))) {
            this.textFieldHeight = 30;
        }
        this.setLayout(new BorderLayout(10, 5));
        this.setMaximumSize(new Dimension(800, 60));
        this.add("North", new JSeparator());
        try {
            Constructor c = jrParameter.getValueClass().getConstructor(String.class);
            hasStringConstructor = true;
        }
        catch (NoSuchMethodException ex) {
            hasStringConstructor = false;
        }
        catch (SecurityException ex) {
            hasStringConstructor = false;
            Logger.getLogger(ParameterPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        JLabel paramName = new JLabel(jrParameter.getName() + " :");
        paramName.setPreferredSize(new Dimension(180, 25));
        paramName.setMaximumSize(new Dimension(180, 25));
        JLabel paramType = new JLabel(jrParameter.getValueClassName());
        paramType.setMinimumSize(new Dimension(20, 25));
        paramType.setMaximumSize(new Dimension(20, 25));
        this.paramValue.setPreferredSize(new Dimension(30, this.textFieldHeight));
        JButton valueButton = new JButton("...");
        valueButton.setPreferredSize(new Dimension(this.textFieldHeight, this.textFieldHeight));
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BorderLayout(0, 0));
        valuePanel.setMaximumSize(new Dimension(30, this.textFieldHeight));
        valuePanel.add("Center", this.paramValue);
        this.paramValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JComponent)e.getSource()).transferFocus();
            }
        });
        if (Date.class.equals((Object)jrParameter.getValueClass())) {
            this.paramValue.setInputVerifier(new DateInputVerifier(jrParameter, params));
            if (params.get(jrParameter.getName()) != null) {
                Date d = (Date)params.get(jrParameter.getName());
                this.paramValue.setText(DateFormat.getDateInstance().format(d));
            }
            this.paramValue.setToolTipText("Format: " + ((SimpleDateFormat)DateFormat.getDateInstance(2)).toPattern());
            valueButton.addActionListener(new DateActionListener());
            valuePanel.add("East", valueButton);
        } else if (Image.class.equals((Object)jrParameter.getValueClass())) {
            this.paramValue.setInputVerifier(new ImageInputVerifier(jrParameter, params));
            if (params.get(jrParameter.getName()) != null) {
                Image image = (Image)params.get(jrParameter.getName());
                this.paramValue.setText(image.toString());
            }
            this.paramValue.setToolTipText("Relative or full path to image.");
            valueButton.addActionListener(new FileActionListener());
            valuePanel.add("East", valueButton);
        } else if (hasStringConstructor) {
            this.paramValue.setInputVerifier(new GenericInputVerifier(jrParameter, params));
            this.paramValue.setText((String)params.get(jrParameter.getName()));
        } else {
            this.paramValue.setText("<non supported type>");
            this.paramValue.setEnabled(false);
        }
        JLabel description = new JLabel();
        if (jrParameter.getDescription() != null) {
            description.setText(jrParameter.getDescription());
            description.setMaximumSize(new Dimension(180, 25));
            description.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        }
        this.add("West", paramName);
        this.add("Center", valuePanel);
        this.add("East", paramType);
        this.add("South", description);
    }

    private class DateActionListener
    implements ActionListener {
        JLabel selectedDate;

        private DateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCalendar cal;
            if (!ParameterPanel.this.paramValue.getText().equals("")) {
                Date date;
                try {
                    date = DateFormat.getDateInstance().parse(ParameterPanel.this.paramValue.getText());
                }
                catch (ParseException ex) {
                    date = new Date();
                }
                cal = new JCalendar(date);
            } else {
                cal = new JCalendar();
            }
            cal.setDecorationBackgroundColor(Color.LIGHT_GRAY);
            cal.setBorder(BorderFactory.createEtchedBorder());
            JPanel calpanel = new JPanel(new BorderLayout(0, 5));
            JPanel buttonpanel = new JPanel(new BorderLayout(0, 0));
            buttonpanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JButton prev = new JButton("<");
            JButton next = new JButton(">");
            JButton today = new JButton(DateFormat.getDateInstance(2).format(new Date()));
            prev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cal.getMonthChooser().getMonth() == 0) {
                        cal.getYearChooser().setYear(cal.getYearChooser().getYear() - 1);
                        cal.getMonthChooser().setMonth(11);
                    } else {
                        cal.getMonthChooser().setMonth(cal.getMonthChooser().getMonth() - 1);
                    }
                }
            });
            next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cal.getMonthChooser().getMonth() == 11) {
                        cal.getYearChooser().setYear(cal.getYearChooser().getYear() + 1);
                        cal.getMonthChooser().setMonth(0);
                    } else {
                        cal.getMonthChooser().setMonth(cal.getMonthChooser().getMonth() + 1);
                    }
                }
            });
            today.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cal.setDate(new Date());
                }
            });
            this.selectedDate = new JLabel();
            this.selectedDate.setHorizontalAlignment(0);
            this.selectedDate.setFont(new Font("sansserif", 1, 16));
            cal.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DateActionListener.this.selectedDate.setText(DateFormat.getDateInstance(2).format(cal.getDate()));
                }
            });
            buttonpanel.add("West", prev);
            buttonpanel.add("Center", today);
            buttonpanel.add("East", next);
            calpanel.add("North", this.selectedDate);
            calpanel.add("Center", cal);
            calpanel.add("South", buttonpanel);
            int retval = JOptionPane.showConfirmDialog((Component)e.getSource(), calpanel, "JasperStarter - Date Picker ", 2, -1);
            if (retval == 0) {
                ParameterPanel.this.paramValue.setText(DateFormat.getDateInstance().format(cal.getDate()));
                ParameterPanel.this.paramValue.requestFocusInWindow();
                ((JComponent)e.getSource()).requestFocusInWindow();
                ((JComponent)e.getSource()).transferFocus();
            }
        }
    }

    private class FileActionListener
    implements ActionListener {
        private FileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            File file = new File(ParameterPanel.this.paramValue.getText());
            if (file.isFile()) {
                fc.setSelectedFile(file);
            }
            if ((returnVal = fc.showOpenDialog((Component)e.getSource())) == 0) {
                file = fc.getSelectedFile();
                ParameterPanel.this.paramValue.setText(file.getAbsolutePath());
                ParameterPanel.this.paramValue.requestFocusInWindow();
                ((JComponent)e.getSource()).requestFocusInWindow();
                ((JComponent)e.getSource()).transferFocus();
            }
        }
    }

    private abstract class ParameterInputVerifier
    extends InputVerifier {
        JRParameter jrParameter;
        Map<String, Object> params;

        ParameterInputVerifier(JRParameter jrParameter, Map<String, Object> params) {
            this.jrParameter = jrParameter;
            this.params = params;
        }

        @Override
        public abstract boolean verify(JComponent var1);
    }

    private class GenericInputVerifier
    extends ParameterInputVerifier {
        GenericInputVerifier(JRParameter jrParameter, Map<String, Object> params) {
            super(jrParameter, params);
        }

        @Override
        public boolean verify(JComponent input) {
            String text = ((JTextField)input).getText();
            try {
                Object o = null;
                if (!text.equals("")) {
                    o = this.jrParameter.getValueClass().getConstructor(String.class).newInstance(text);
                    ((JTextField)input).setText(o.toString());
                }
                this.params.put(this.jrParameter.getName(), o);
                input.setBackground(ParameterPanel.this.uiDefaults.getColor("TextField.background"));
                ParameterPanel.this.valid.set(true);
                return true;
            }
            catch (Exception e) {
                input.setBackground(Color.RED);
                ((JTextField)input).selectAll();
                Toolkit.getDefaultToolkit().beep();
                ParameterPanel.this.valid.set(false);
                return false;
            }
        }
    }

    private class ImageInputVerifier
    extends ParameterInputVerifier {
        ImageInputVerifier(JRParameter jrParameter, Map<String, Object> params) {
            super(jrParameter, params);
        }

        @Override
        public boolean verify(JComponent input) {
            String text = ((JTextField)input).getText();
            try {
                Image o = null;
                Image imageParam = (Image)this.params.get(this.jrParameter.getName());
                String imageName = "";
                if (imageParam != null) {
                    imageName = imageParam.toString();
                }
                if (!text.equals("") && !text.equals(imageName)) {
                    File imageFile = new File(text);
                    if (!imageFile.isFile()) {
                        throw new IllegalArgumentException(imageFile.getName() + "is not a valid file.");
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(JRLoader.loadBytes((File)imageFile));
                    MediaTracker traker = new MediaTracker(new Panel());
                    traker.addImage(image, 0);
                    try {
                        traker.waitForID(0);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Image tracker error: " + e.getMessage(), e);
                    }
                    o = image;
                    ((JTextField)input).setText(imageFile.getAbsolutePath());
                }
                if (!text.equals(imageName)) {
                    this.params.put(this.jrParameter.getName(), o);
                }
                input.setBackground(ParameterPanel.this.uiDefaults.getColor("TextField.background"));
                ParameterPanel.this.valid.set(true);
                return true;
            }
            catch (Exception e) {
                input.setBackground(Color.RED);
                ((JTextField)input).selectAll();
                Toolkit.getDefaultToolkit().beep();
                ParameterPanel.this.valid.set(false);
                return false;
            }
        }
    }

    private class DateInputVerifier
    extends ParameterInputVerifier {
        DateInputVerifier(JRParameter jrParameter, Map<String, Object> params) {
            super(jrParameter, params);
        }

        @Override
        public boolean verify(JComponent input) {
            String text = ((JTextField)input).getText();
            try {
                Date o = null;
                if (!text.equals("")) {
                    o = DateFormat.getDateInstance().parse(text);
                    ((JTextField)input).setText(DateFormat.getDateInstance().format(o));
                }
                this.params.put(this.jrParameter.getName(), o);
                input.setBackground(ParameterPanel.this.uiDefaults.getColor("TextField.background"));
                ParameterPanel.this.valid.set(true);
                return true;
            }
            catch (ParseException e) {
                input.setBackground(Color.RED);
                ((JTextField)input).selectAll();
                Toolkit.getDefaultToolkit().beep();
                ParameterPanel.this.valid.set(false);
                return false;
            }
        }
    }
}

